/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.Control;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.FocusModel;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeItem$TreeModificationEvent;
import javafx.scene.control.TreeUtil;
import javafx.scene.control.TreeView$1;
import javafx.scene.control.TreeView$2;
import javafx.scene.control.TreeView$3;
import javafx.scene.control.TreeView$4;
import javafx.scene.control.TreeView$5;
import javafx.scene.control.TreeView$6;
import javafx.scene.control.TreeView$7;
import javafx.scene.control.TreeView$8;
import javafx.scene.control.TreeView$EditEvent;
import javafx.scene.control.TreeView$StyleableProperties;
import javafx.scene.control.TreeView$TreeViewBitSetSelectionModel;
import javafx.scene.control.TreeView$TreeViewFocusModel;
import javafx.scene.control.skin.TreeViewSkin;
import javafx.util.Callback;

@DefaultProperty(value="root")
public class TreeView<T>
extends Control {
    private static final EventType<?> EDIT_ANY_EVENT = new EventType<Event>(Event.ANY, "TREE_VIEW_EDIT");
    private static final EventType<?> EDIT_START_EVENT = new EventType(TreeView.editAnyEvent(), "EDIT_START");
    private static final EventType<?> EDIT_CANCEL_EVENT = new EventType(TreeView.editAnyEvent(), "EDIT_CANCEL");
    private static final EventType<?> EDIT_COMMIT_EVENT = new EventType(TreeView.editAnyEvent(), "EDIT_COMMIT");
    private boolean expandedItemCountDirty = true;
    private Map<Integer, SoftReference<TreeItem<T>>> treeItemCacheMap = new HashMap<Integer, SoftReference<TreeItem<T>>>();
    private final EventHandler<TreeItem$TreeModificationEvent<T>> rootEvent = serializable -> {
        boolean bl2 = false;
        for (serializable = ((Event)serializable).getEventType(); serializable != null; serializable = ((EventType)((Object)serializable)).getSuperType()) {
            if (!serializable.equals(TreeItem.expandedItemCountChangeEvent())) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            this.expandedItemCountDirty = true;
            this.requestLayout();
        }
    };
    private WeakEventHandler<TreeItem$TreeModificationEvent<T>> weakRootEventListener;
    private ObjectProperty<Callback<TreeView<T>, TreeCell<T>>> cellFactory;
    private ObjectProperty<TreeItem<T>> root;
    private BooleanProperty showRoot;
    private ObjectProperty<MultipleSelectionModel<TreeItem<T>>> selectionModel;
    private ObjectProperty<FocusModel<TreeItem<T>>> focusModel;
    private ReadOnlyIntegerWrapper expandedItemCount;
    private DoubleProperty fixedCellSize;
    private BooleanProperty editable;
    private ReadOnlyObjectWrapper<TreeItem<T>> editingItem;
    private ObjectProperty<EventHandler<TreeView$EditEvent<T>>> onEditStart;
    private ObjectProperty<EventHandler<TreeView$EditEvent<T>>> onEditCommit;
    private EventHandler<TreeView$EditEvent<T>> DEFAULT_EDIT_COMMIT_HANDLER;
    private ObjectProperty<EventHandler<TreeView$EditEvent<T>>> onEditCancel;
    private ObjectProperty<EventHandler<ScrollToEvent<Integer>>> onScrollTo;
    private static final String DEFAULT_STYLE_CLASS = "tree-view";

    public static <T> EventType<TreeView$EditEvent<T>> editAnyEvent() {
        return EDIT_ANY_EVENT;
    }

    public static <T> EventType<TreeView$EditEvent<T>> editStartEvent() {
        return EDIT_START_EVENT;
    }

    public static <T> EventType<TreeView$EditEvent<T>> editCancelEvent() {
        return EDIT_CANCEL_EVENT;
    }

    public static <T> EventType<TreeView$EditEvent<T>> editCommitEvent() {
        return EDIT_COMMIT_EVENT;
    }

    @Deprecated(since="8u20")
    public static int getNodeLevel(TreeItem<?> treeItem) {
        if (treeItem == null) {
            return -1;
        }
        int n2 = 0;
        for (treeItem = treeItem.getParent(); treeItem != null; treeItem = treeItem.getParent()) {
            ++n2;
        }
        return n2;
    }

    public TreeView() {
        this(null);
    }

    public TreeView(TreeItem<T> object) {
        TreeView treeView = this;
        this.root = new TreeView$1(treeView, treeView, "root");
        this.expandedItemCount = new ReadOnlyIntegerWrapper(this, "expandedItemCount", 0);
        this.DEFAULT_EDIT_COMMIT_HANDLER = treeView$EditEvent -> {
            TreeItem treeItem = treeView$EditEvent.getTreeItem();
            if (treeItem == null) {
                return;
            }
            treeItem.setValue(treeView$EditEvent.getNewValue());
        };
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TREE_VIEW);
        this.setRoot((TreeItem<T>)object);
        this.updateExpandedItemCount((TreeItem<T>)object);
        object = new TreeView$TreeViewBitSetSelectionModel(this);
        this.setSelectionModel((MultipleSelectionModel<TreeItem<T>>)object);
        this.setFocusModel(new TreeView$TreeViewFocusModel(this));
        TreeView treeView2 = this;
        treeView2.setOnEditCommit(treeView2.DEFAULT_EDIT_COMMIT_HANDLER);
    }

    public final void setCellFactory(Callback<TreeView<T>, TreeCell<T>> callback) {
        this.cellFactoryProperty().set(callback);
    }

    public final Callback<TreeView<T>, TreeCell<T>> getCellFactory() {
        if (this.cellFactory == null) {
            return null;
        }
        return (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<TreeView<T>, TreeCell<T>>> cellFactoryProperty() {
        if (this.cellFactory == null) {
            this.cellFactory = new SimpleObjectProperty<Callback<TreeView<T>, TreeCell<T>>>(this, "cellFactory");
        }
        return this.cellFactory;
    }

    public final void setRoot(TreeItem<T> treeItem) {
        this.rootProperty().set(treeItem);
    }

    public final TreeItem<T> getRoot() {
        if (this.root == null) {
            return null;
        }
        return (TreeItem)this.root.get();
    }

    public final ObjectProperty<TreeItem<T>> rootProperty() {
        return this.root;
    }

    public final void setShowRoot(boolean bl2) {
        this.showRootProperty().set(bl2);
    }

    public final boolean isShowRoot() {
        if (this.showRoot == null) {
            return true;
        }
        return this.showRoot.get();
    }

    public final BooleanProperty showRootProperty() {
        if (this.showRoot == null) {
            TreeView treeView = this;
            this.showRoot = new TreeView$2(treeView, treeView, "showRoot", true);
        }
        return this.showRoot;
    }

    public final void setSelectionModel(MultipleSelectionModel<TreeItem<T>> multipleSelectionModel) {
        this.selectionModelProperty().set(multipleSelectionModel);
    }

    public final MultipleSelectionModel<TreeItem<T>> getSelectionModel() {
        if (this.selectionModel == null) {
            return null;
        }
        return (MultipleSelectionModel)this.selectionModel.get();
    }

    public final ObjectProperty<MultipleSelectionModel<TreeItem<T>>> selectionModelProperty() {
        if (this.selectionModel == null) {
            this.selectionModel = new SimpleObjectProperty<MultipleSelectionModel<TreeItem<T>>>(this, "selectionModel");
        }
        return this.selectionModel;
    }

    public final void setFocusModel(FocusModel<TreeItem<T>> focusModel) {
        this.focusModelProperty().set(focusModel);
    }

    public final FocusModel<TreeItem<T>> getFocusModel() {
        if (this.focusModel == null) {
            return null;
        }
        return (FocusModel)this.focusModel.get();
    }

    public final ObjectProperty<FocusModel<TreeItem<T>>> focusModelProperty() {
        if (this.focusModel == null) {
            this.focusModel = new SimpleObjectProperty<FocusModel<TreeItem<T>>>(this, "focusModel");
        }
        return this.focusModel;
    }

    public final ReadOnlyIntegerProperty expandedItemCountProperty() {
        return this.expandedItemCount.getReadOnlyProperty();
    }

    private void setExpandedItemCount(int n2) {
        this.expandedItemCount.set(n2);
    }

    public final int getExpandedItemCount() {
        if (this.expandedItemCountDirty) {
            TreeView treeView = this;
            treeView.updateExpandedItemCount(treeView.getRoot());
        }
        return this.expandedItemCount.get();
    }

    public final void setFixedCellSize(double d2) {
        this.fixedCellSizeProperty().set(d2);
    }

    public final double getFixedCellSize() {
        if (this.fixedCellSize == null) {
            return -1.0;
        }
        return this.fixedCellSize.get();
    }

    public final DoubleProperty fixedCellSizeProperty() {
        if (this.fixedCellSize == null) {
            this.fixedCellSize = new TreeView$3(this, -1.0);
        }
        return this.fixedCellSize;
    }

    public final void setEditable(boolean bl2) {
        this.editableProperty().set(bl2);
    }

    public final boolean isEditable() {
        if (this.editable == null) {
            return false;
        }
        return this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        if (this.editable == null) {
            this.editable = new SimpleBooleanProperty(this, "editable", false);
        }
        return this.editable;
    }

    private void setEditingItem(TreeItem<T> treeItem) {
        this.editingItemPropertyImpl().set(treeItem);
    }

    public final TreeItem<T> getEditingItem() {
        if (this.editingItem == null) {
            return null;
        }
        return (TreeItem)this.editingItem.get();
    }

    public final ReadOnlyObjectProperty<TreeItem<T>> editingItemProperty() {
        return this.editingItemPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TreeItem<T>> editingItemPropertyImpl() {
        if (this.editingItem == null) {
            this.editingItem = new ReadOnlyObjectWrapper(this, "editingItem");
        }
        return this.editingItem;
    }

    public final void setOnEditStart(EventHandler<TreeView$EditEvent<T>> eventHandler) {
        this.onEditStartProperty().set(eventHandler);
    }

    public final EventHandler<TreeView$EditEvent<T>> getOnEditStart() {
        if (this.onEditStart == null) {
            return null;
        }
        return (EventHandler)this.onEditStart.get();
    }

    public final ObjectProperty<EventHandler<TreeView$EditEvent<T>>> onEditStartProperty() {
        if (this.onEditStart == null) {
            TreeView treeView = this;
            this.onEditStart = new TreeView$4(treeView, treeView, "onEditStart");
        }
        return this.onEditStart;
    }

    public final void setOnEditCommit(EventHandler<TreeView$EditEvent<T>> eventHandler) {
        this.onEditCommitProperty().set(eventHandler);
    }

    public final EventHandler<TreeView$EditEvent<T>> getOnEditCommit() {
        if (this.onEditCommit == null) {
            return null;
        }
        return (EventHandler)this.onEditCommit.get();
    }

    public final ObjectProperty<EventHandler<TreeView$EditEvent<T>>> onEditCommitProperty() {
        if (this.onEditCommit == null) {
            TreeView treeView = this;
            this.onEditCommit = new TreeView$5(treeView, treeView, "onEditCommit");
        }
        return this.onEditCommit;
    }

    public final void setOnEditCancel(EventHandler<TreeView$EditEvent<T>> eventHandler) {
        this.onEditCancelProperty().set(eventHandler);
    }

    public final EventHandler<TreeView$EditEvent<T>> getOnEditCancel() {
        if (this.onEditCancel == null) {
            return null;
        }
        return (EventHandler)this.onEditCancel.get();
    }

    public final ObjectProperty<EventHandler<TreeView$EditEvent<T>>> onEditCancelProperty() {
        if (this.onEditCancel == null) {
            TreeView treeView = this;
            this.onEditCancel = new TreeView$6(treeView, treeView, "onEditCancel");
        }
        return this.onEditCancel;
    }

    @Override
    protected void layoutChildren() {
        if (this.expandedItemCountDirty) {
            TreeView treeView = this;
            treeView.updateExpandedItemCount(treeView.getRoot());
        }
        super.layoutChildren();
    }

    public void edit(TreeItem<T> treeItem) {
        if (!this.isEditable()) {
            return;
        }
        this.setEditingItem(treeItem);
    }

    public void scrollTo(int n2) {
        ControlUtils.scrollToIndex(this, n2);
    }

    public void setOnScrollTo(EventHandler<ScrollToEvent<Integer>> eventHandler) {
        this.onScrollToProperty().set(eventHandler);
    }

    public EventHandler<ScrollToEvent<Integer>> getOnScrollTo() {
        if (this.onScrollTo != null) {
            return (EventHandler)this.onScrollTo.get();
        }
        return null;
    }

    public ObjectProperty<EventHandler<ScrollToEvent<Integer>>> onScrollToProperty() {
        if (this.onScrollTo == null) {
            this.onScrollTo = new TreeView$7(this);
        }
        return this.onScrollTo;
    }

    public int getRow(TreeItem<T> treeItem) {
        return TreeUtil.getRow(treeItem, this.getRoot(), this.expandedItemCountDirty, this.isShowRoot());
    }

    public TreeItem<T> getTreeItem(int n2) {
        TreeItem<T> treeItem;
        if (n2 < 0) {
            return null;
        }
        int n3 = n2 = this.isShowRoot() ? n2 : n2 + 1;
        if (this.expandedItemCountDirty) {
            TreeView treeView = this;
            treeView.updateExpandedItemCount(treeView.getRoot());
        } else if (this.treeItemCacheMap.containsKey(n2)) {
            treeItem = this.treeItemCacheMap.get(n2);
            if ((treeItem = ((SoftReference)((Object)treeItem)).get()) != null) {
                return treeItem;
            }
        }
        treeItem = TreeUtil.getItem(this.getRoot(), n2, this.expandedItemCountDirty);
        this.treeItemCacheMap.put(n2, new SoftReference<TreeItem<T>>(treeItem));
        return treeItem;
    }

    public int getTreeItemLevel(TreeItem<?> treeItem) {
        TreeItem<T> treeItem2 = this.getRoot();
        if (treeItem == null) {
            return -1;
        }
        if (treeItem == treeItem2) {
            return 0;
        }
        int n2 = 0;
        for (treeItem = treeItem.getParent(); treeItem != null; treeItem = treeItem.getParent()) {
            ++n2;
            if (treeItem == treeItem2) break;
        }
        return n2;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TreeViewSkin(this);
    }

    public void refresh() {
        this.getProperties().put("recreateKey", Boolean.TRUE);
    }

    private void updateExpandedItemCount(TreeItem<T> treeItem) {
        this.setExpandedItemCount(TreeUtil.updateExpandedItemCount(treeItem, this.expandedItemCountDirty, this.isShowRoot()));
        if (this.expandedItemCountDirty) {
            this.treeItemCacheMap.clear();
        }
        this.expandedItemCountDirty = false;
    }

    private void updateRootExpanded() {
        if (!this.isShowRoot() && this.getRoot() != null && !this.getRoot().isExpanded()) {
            this.getRoot().setExpanded(true);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return TreeView$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return TreeView.getClassCssMetaData();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute object, Object ... objectArray) {
        switch (TreeView$8.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                object = this.getSelectionModel();
                return object != null && ((MultipleSelectionModel)object).getSelectionMode() == SelectionMode.MULTIPLE;
            }
            case 2: {
                return this.getExpandedItemCount();
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray);
    }

    static /* synthetic */ void access$000(TreeView treeView, EventType eventType, EventHandler eventHandler) {
        treeView.setEventHandler(eventType, eventHandler);
    }

    static /* synthetic */ void access$100(TreeView treeView, EventType eventType, EventHandler eventHandler) {
        treeView.setEventHandler(eventType, eventHandler);
    }

    static /* synthetic */ void access$200(TreeView treeView, EventType eventType, EventHandler eventHandler) {
        treeView.setEventHandler(eventType, eventHandler);
    }

    static /* synthetic */ void access$300(TreeView treeView, EventType eventType, EventHandler eventHandler) {
        treeView.setEventHandler(eventType, eventHandler);
    }
}

