/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.control.CustomColorDialog;
import com.sun.javafx.scene.control.Properties;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Separator;
import javafx.scene.control.skin.ColorPalette$1;
import javafx.scene.control.skin.ColorPalette$2;
import javafx.scene.control.skin.ColorPalette$3;
import javafx.scene.control.skin.ColorPalette$ColorPickerGrid;
import javafx.scene.control.skin.ColorPalette$ColorSquare;
import javafx.scene.control.skin.ColorPalette$ColorType;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;

class ColorPalette
extends Region {
    private static final int SQUARE_SIZE = 15;
    ColorPalette$ColorPickerGrid colorPickerGrid;
    final Hyperlink customColorLink = new Hyperlink(Properties.getColorPickerString("customColorLink"));
    CustomColorDialog customColorDialog = null;
    private ColorPicker colorPicker;
    private final GridPane standardColorGrid = new GridPane();
    private final GridPane customColorGrid = new GridPane();
    private final Separator separator = new Separator();
    private final Label customColorLabel = new Label(Properties.getColorPickerString("customColorLabel"));
    private PopupControl popupControl;
    private ColorPalette$ColorSquare focusedSquare;
    private ContextMenu contextMenu = null;
    private Color mouseDragColor = null;
    private boolean dragDetected = false;
    private int customColorNumber = 0;
    private int customColorRows = 0;
    private int customColorLastRowLength = 0;
    private final ColorPalette$ColorSquare hoverSquare = new ColorPalette$ColorSquare(this);
    private static final int NUM_OF_COLUMNS = 12;
    private static double[] RAW_VALUES = new double[]{255.0, 255.0, 255.0, 242.0, 242.0, 242.0, 230.0, 230.0, 230.0, 204.0, 204.0, 204.0, 179.0, 179.0, 179.0, 153.0, 153.0, 153.0, 128.0, 128.0, 128.0, 102.0, 102.0, 102.0, 77.0, 77.0, 77.0, 51.0, 51.0, 51.0, 26.0, 26.0, 26.0, 0.0, 0.0, 0.0, 0.0, 51.0, 51.0, 0.0, 26.0, 128.0, 26.0, 0.0, 104.0, 51.0, 0.0, 51.0, 77.0, 0.0, 26.0, 153.0, 0.0, 0.0, 153.0, 51.0, 0.0, 153.0, 77.0, 0.0, 153.0, 102.0, 0.0, 153.0, 153.0, 0.0, 102.0, 102.0, 0.0, 0.0, 51.0, 0.0, 26.0, 77.0, 77.0, 26.0, 51.0, 153.0, 51.0, 26.0, 128.0, 77.0, 26.0, 77.0, 102.0, 26.0, 51.0, 179.0, 26.0, 26.0, 179.0, 77.0, 26.0, 179.0, 102.0, 26.0, 179.0, 128.0, 26.0, 179.0, 179.0, 26.0, 128.0, 128.0, 26.0, 26.0, 77.0, 26.0, 51.0, 102.0, 102.0, 51.0, 77.0, 179.0, 77.0, 51.0, 153.0, 102.0, 51.0, 102.0, 128.0, 51.0, 77.0, 204.0, 51.0, 51.0, 204.0, 102.0, 51.0, 204.0, 128.0, 51.0, 204.0, 153.0, 51.0, 204.0, 204.0, 51.0, 153.0, 153.0, 51.0, 51.0, 102.0, 51.0, 77.0, 128.0, 128.0, 77.0, 102.0, 204.0, 102.0, 77.0, 179.0, 128.0, 77.0, 128.0, 153.0, 77.0, 102.0, 230.0, 77.0, 77.0, 230.0, 128.0, 77.0, 230.0, 153.0, 77.0, 230.0, 179.0, 77.0, 230.0, 230.0, 77.0, 179.0, 179.0, 77.0, 77.0, 128.0, 77.0, 102.0, 153.0, 153.0, 102.0, 128.0, 230.0, 128.0, 102.0, 204.0, 153.0, 102.0, 153.0, 179.0, 102.0, 128.0, 255.0, 102.0, 102.0, 255.0, 153.0, 102.0, 255.0, 179.0, 102.0, 255.0, 204.0, 102.0, 255.0, 255.0, 77.0, 204.0, 204.0, 102.0, 102.0, 153.0, 102.0, 128.0, 179.0, 179.0, 128.0, 153.0, 255.0, 153.0, 128.0, 230.0, 179.0, 128.0, 179.0, 204.0, 128.0, 153.0, 255.0, 128.0, 128.0, 255.0, 153.0, 128.0, 255.0, 204.0, 128.0, 255.0, 230.0, 102.0, 255.0, 255.0, 102.0, 230.0, 230.0, 128.0, 128.0, 179.0, 128.0, 153.0, 204.0, 204.0, 153.0, 179.0, 255.0, 179.0, 153.0, 255.0, 204.0, 153.0, 204.0, 230.0, 153.0, 179.0, 255.0, 153.0, 153.0, 255.0, 179.0, 128.0, 255.0, 204.0, 153.0, 255.0, 230.0, 128.0, 255.0, 255.0, 128.0, 230.0, 230.0, 153.0, 153.0, 204.0, 153.0, 179.0, 230.0, 230.0, 179.0, 204.0, 255.0, 204.0, 179.0, 255.0, 230.0, 179.0, 230.0, 230.0, 179.0, 204.0, 255.0, 179.0, 179.0, 255.0, 179.0, 153.0, 255.0, 230.0, 179.0, 255.0, 230.0, 153.0, 255.0, 255.0, 153.0, 230.0, 230.0, 179.0, 179.0, 230.0, 179.0, 204.0, 255.0, 255.0, 204.0, 230.0, 255.0, 230.0, 204.0, 255.0, 255.0, 204.0, 255.0, 255.0, 204.0, 230.0, 255.0, 204.0, 204.0, 255.0, 204.0, 179.0, 255.0, 230.0, 204.0, 255.0, 255.0, 179.0, 255.0, 255.0, 204.0, 230.0, 230.0, 204.0, 204.0, 255.0, 204.0};
    private static final int NUM_OF_COLORS = RAW_VALUES.length / 3;
    private static final int NUM_OF_ROWS = NUM_OF_COLORS / 12;

    public ColorPalette(ColorPicker region) {
        this.getStyleClass().add("color-palette-region");
        this.colorPicker = region;
        this.colorPickerGrid = new ColorPalette$ColorPickerGrid(this);
        ((Node)this.colorPickerGrid.getChildren().get(0)).requestFocus();
        this.customColorLabel.setAlignment(Pos.CENTER_LEFT);
        this.customColorLink.setPrefWidth(((Node)this.colorPickerGrid).prefWidth(-1.0));
        this.customColorLink.setAlignment(Pos.CENTER);
        this.customColorLink.setFocusTraversable(true);
        this.customColorLink.setVisited(true);
        this.customColorLink.setOnAction(new ColorPalette$1(this, (ColorPicker)region));
        this.initNavigation();
        this.buildStandardColors();
        this.standardColorGrid.getStyleClass().add("color-picker-grid");
        this.standardColorGrid.setVisible(true);
        this.customColorGrid.getStyleClass().add("color-picker-grid");
        this.customColorGrid.setVisible(false);
        this.buildCustomColors();
        ((ColorPicker)region).getCustomColors().addListener(new ColorPalette$2(this));
        region = new VBox();
        region.getStyleClass().add("color-palette");
        ((Pane)region).getChildren().addAll((Node[])new Node[]{this.standardColorGrid, this.colorPickerGrid, this.customColorLabel, this.customColorGrid, this.separator, this.customColorLink});
        this.hoverSquare.setMouseTransparent(true);
        this.hoverSquare.getStyleClass().addAll((String[])new String[]{"hover-square"});
        this.setFocusedSquare(null);
        this.getChildren().addAll((Node[])new Node[]{region, this.hoverSquare});
    }

    private void setFocusedSquare(ColorPalette$ColorSquare object) {
        double d2;
        double d3;
        if (object == this.focusedSquare) {
            return;
        }
        this.focusedSquare = object;
        this.hoverSquare.setVisible(this.focusedSquare != null);
        if (this.focusedSquare == null) {
            return;
        }
        if (!this.focusedSquare.isFocused()) {
            this.focusedSquare.requestFocus();
        }
        this.hoverSquare.rectangle.setFill(this.focusedSquare.rectangle.getFill());
        ColorPalette$ColorSquare colorPalette$ColorSquare = object;
        object = colorPalette$ColorSquare.localToScene(colorPalette$ColorSquare.getLayoutBounds());
        double d4 = ((Bounds)object).getMinX();
        double d5 = ((Bounds)object).getMinY();
        double d6 = d3 = this.hoverSquare.getScaleX() == 1.0 ? 0.0 : this.hoverSquare.getWidth() / 4.0;
        if (this.colorPicker.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
            d4 = this.focusedSquare.getLayoutX();
            d2 = -this.focusedSquare.getWidth() + d3;
        } else {
            d2 = this.focusedSquare.getWidth() / 2.0 + d3;
        }
        this.hoverSquare.setLayoutX(this.snapPositionX(d4) - d2);
        this.hoverSquare.setLayoutY(this.snapPositionY(d5) - this.focusedSquare.getHeight() / 2.0 + (this.hoverSquare.getScaleY() == 1.0 ? 0.0 : this.focusedSquare.getHeight() / 4.0));
    }

    private void buildStandardColors() {
        Color[] colorArray = new Color[]{Color.AQUA, Color.TEAL, Color.BLUE, Color.NAVY, Color.FUCHSIA, Color.PURPLE, Color.RED, Color.MAROON, Color.YELLOW, Color.OLIVE, Color.GREEN, Color.LIME};
        this.standardColorGrid.getChildren().clear();
        for (int i2 = 0; i2 < 12; ++i2) {
            this.standardColorGrid.add(new ColorPalette$ColorSquare(this, colorArray[i2], i2, ColorPalette$ColorType.STANDARD), i2, 0);
        }
    }

    private void buildCustomColors() {
        Object object2;
        ObservableList<Color> observableList = this.colorPicker.getCustomColors();
        this.customColorNumber = observableList.size();
        this.customColorGrid.getChildren().clear();
        if (observableList.isEmpty()) {
            this.customColorLabel.setVisible(false);
            this.customColorLabel.setManaged(false);
            this.customColorGrid.setVisible(false);
            this.customColorGrid.setManaged(false);
            return;
        }
        this.customColorLabel.setVisible(true);
        this.customColorLabel.setManaged(true);
        this.customColorGrid.setVisible(true);
        this.customColorGrid.setManaged(true);
        if (this.contextMenu == null) {
            MenuItem menuItem = new MenuItem(Properties.getColorPickerString("removeColor"));
            menuItem.setOnAction(object -> {
                object = (ColorPalette$ColorSquare)this.contextMenu.getOwnerNode();
                observableList.remove(((ColorPalette$ColorSquare)object).rectangle.getFill());
                this.buildCustomColors();
            });
            this.contextMenu = new ContextMenu(menuItem);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = observableList.size() % 12;
        int n5 = n4 == 0 ? 0 : 12 - n4;
        this.customColorLastRowLength = n4 == 0 ? 12 : n4;
        for (n4 = 0; n4 < observableList.size(); ++n4) {
            object2 = (Color)observableList.get(n4);
            object2 = new ColorPalette$ColorSquare(this, (Color)object2, n4, ColorPalette$ColorType.CUSTOM);
            ((Node)object2).addEventHandler(KeyEvent.KEY_PRESSED, arg_0 -> this.lambda$buildCustomColors$1(observableList, (ColorPalette$ColorSquare)object2, arg_0));
            this.customColorGrid.add((Node)object2, n2, n3);
            if (++n2 != 12) continue;
            n2 = 0;
            ++n3;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            object2 = new ColorPalette$ColorSquare(this);
            ((Node)object2).setDisable(true);
            this.customColorGrid.add((Node)object2, n2, n3);
            ++n2;
        }
        this.customColorRows = n3 + 1;
        this.requestLayout();
    }

    private void initNavigation() {
        ColorPalette colorPalette = this;
        colorPalette.setOnKeyPressed(keyEvent -> {
            switch (keyEvent.getCode()) {
                case SPACE: 
                case ENTER: {
                    this.processSelectKey((KeyEvent)keyEvent);
                    keyEvent.consume();
                }
            }
        });
        ParentHelper.setTraversalEngine(this, new ParentTraversalEngine(this, new ColorPalette$3(this)));
    }

    private void processSelectKey(KeyEvent keyEvent) {
        if (this.focusedSquare != null) {
            this.focusedSquare.selectColor(keyEvent);
        }
    }

    public void setPopupControl(PopupControl popupControl) {
        this.popupControl = popupControl;
    }

    public ColorPalette$ColorPickerGrid getColorGrid() {
        return this.colorPickerGrid;
    }

    public boolean isCustomColorDialogShowing() {
        if (this.customColorDialog != null) {
            return this.customColorDialog.isVisible();
        }
        return false;
    }

    public void updateSelection(Color color) {
        this.setFocusedSquare(null);
        Object object = List.of(this.standardColorGrid, this.colorPickerGrid, this.customColorGrid);
        object = object.iterator();
        while (object.hasNext()) {
            Pane pane = (GridPane)object.next();
            if ((pane = this.findColorSquare((GridPane)pane, color)) == null) continue;
            this.setFocusedSquare((ColorPalette$ColorSquare)pane);
            return;
        }
    }

    private ColorPalette$ColorSquare findColorSquare(GridPane object, Color color) {
        for (Node node : ((Pane)object).getChildren()) {
            node = (ColorPalette$ColorSquare)node;
            if (!((ColorPalette$ColorSquare)node).rectangle.getFill().equals(color)) continue;
            return node;
        }
        return null;
    }

    private /* synthetic */ void lambda$buildCustomColors$1(ObservableList observableList, ColorPalette$ColorSquare colorPalette$ColorSquare, KeyEvent keyEvent) {
        if (keyEvent.getCode() == KeyCode.DELETE) {
            observableList.remove(colorPalette$ColorSquare.rectangle.getFill());
            this.buildCustomColors();
        }
    }
}

