/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.control.FakeFocusTextField;
import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.util.Utils;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.PopupControl;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.ComboBoxBaseSkin;
import javafx.scene.control.skin.ComboBoxPopupControl$1;
import javafx.scene.control.skin.ComboBoxPopupControl$2;
import javafx.scene.control.skin.ComboBoxPopupControl$3;
import javafx.scene.input.DragEvent;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.StringConverter;

public abstract class ComboBoxPopupControl<T>
extends ComboBoxBaseSkin<T> {
    PopupControl popup;
    private boolean popupNeedsReconfiguring = true;
    private final ComboBoxBase<T> comboBoxBase;
    private TextField textField;
    private String initialTextFieldValue = null;
    private EventHandler<MouseEvent> textFieldMouseEventHandler = mouseEvent -> {
        ComboBoxBase comboBoxBase = (ComboBoxBase)this.getSkinnable();
        if (!mouseEvent.getTarget().equals(comboBoxBase)) {
            ComboBoxBase comboBoxBase2 = comboBoxBase;
            comboBoxBase.fireEvent(mouseEvent.copyFor(comboBoxBase2, comboBoxBase2));
            mouseEvent.consume();
        }
    };
    private EventHandler<DragEvent> textFieldDragEventHandler = dragEvent -> {
        ComboBoxBase comboBoxBase = (ComboBoxBase)this.getSkinnable();
        if (!dragEvent.getTarget().equals(comboBoxBase)) {
            ComboBoxBase comboBoxBase2 = comboBoxBase;
            comboBoxBase.fireEvent(dragEvent.copyFor(comboBoxBase2, comboBoxBase2));
            dragEvent.consume();
        }
    };
    private EventHandler<? super InputMethodEvent> inputMethodTextChangedHandler;

    public ComboBoxPopupControl(ComboBoxBase<T> object) {
        super(object);
        this.comboBoxBase = object;
        TextField textField = this.textField = this.getEditor() != null ? this.getEditableInputNode() : null;
        if (this.textField != null) {
            this.getChildren().add(this.textField);
        }
        object = ListenerHelper.get(this);
        ((ListenerHelper)object).addChangeListener(this.comboBoxBase.focusedProperty(), (observableValue, bl2, bl3) -> {
            if (this.getEditor() != null) {
                ((FakeFocusTextField)this.textField).setFakeFocus((boolean)bl3);
            }
        });
        ((ListenerHelper)object).addEventFilter(this.comboBoxBase, KeyEvent.ANY, keyEvent -> {
            if (this.textField == null || this.getEditor() == null) {
                this.handleKeyEvent((KeyEvent)keyEvent, false);
                return;
            }
            if (keyEvent.getTarget().equals(this.textField)) {
                return;
            }
            switch (keyEvent.getCode()) {
                case ESCAPE: 
                case F10: {
                    return;
                }
                case ENTER: {
                    this.handleKeyEvent((KeyEvent)keyEvent, true);
                    return;
                }
            }
            this.textField.fireEvent(keyEvent.copyFor(this.textField, this.textField));
            keyEvent.consume();
        });
    }

    @Override
    public void install() {
        if (this.comboBoxBase.getOnInputMethodTextChanged() == null) {
            this.inputMethodTextChangedHandler = inputMethodEvent -> {
                if (this.textField != null && this.getEditor() != null && this.comboBoxBase.getScene().getFocusOwner() == this.comboBoxBase && this.textField.getOnInputMethodTextChanged() != null) {
                    this.textField.getOnInputMethodTextChanged().handle((InputMethodEvent)inputMethodEvent);
                }
            };
            this.comboBoxBase.setOnInputMethodTextChanged(this.inputMethodTextChangedHandler);
        }
        ParentHelper.setTraversalEngine(this.comboBoxBase, new ParentTraversalEngine(this.comboBoxBase, new ComboBoxPopupControl$1(this)));
        this.updateEditable();
    }

    @Override
    public void dispose() {
        this.removeTextFieldEventFilters();
        if (this.inputMethodTextChangedHandler != null && this.comboBoxBase.getOnInputMethodTextChanged() == this.inputMethodTextChangedHandler) {
            this.comboBoxBase.setOnInputMethodTextChanged(null);
        }
        super.dispose();
    }

    protected abstract Node getPopupContent();

    protected abstract TextField getEditor();

    protected abstract StringConverter<T> getConverter();

    @Override
    public void show() {
        if (this.getSkinnable() == null) {
            throw new IllegalStateException("ComboBox is null");
        }
        Node node = this.getPopupContent();
        if (node == null) {
            throw new IllegalStateException("Popup node is null");
        }
        if (this.getPopup().isShowing()) {
            return;
        }
        this.positionAndShowPopup();
    }

    @Override
    public void hide() {
        if (this.popup != null && this.popup.isShowing()) {
            ((Window)this.popup).hide();
        }
    }

    PopupControl getPopup() {
        if (this.popup == null) {
            this.createPopup();
        }
        return this.popup;
    }

    TextField getEditableInputNode() {
        if (this.textField == null && this.getEditor() != null) {
            this.textField = this.getEditor();
            this.textField.setFocusTraversable(false);
            this.textField.promptTextProperty().bind(this.comboBoxBase.promptTextProperty());
            this.textField.tooltipProperty().bind(this.comboBoxBase.tooltipProperty());
            this.textField.getProperties().put("TextInputControlBehavior.disableForwardToParent", Boolean.TRUE);
            this.initialTextFieldValue = this.textField.getText();
        }
        return this.textField;
    }

    void setTextFromTextFieldIntoComboBoxValue() {
        StringConverter<T> stringConverter;
        if (this.getEditor() != null && (stringConverter = this.getConverter()) != null) {
            T t2;
            T t3 = t2 = this.comboBoxBase.getValue();
            String string = this.textField.getText();
            if (t2 == null && (string == null || string.isEmpty())) {
                t3 = null;
            } else {
                try {
                    t3 = stringConverter.fromString(string);
                }
                catch (Exception exception) {}
            }
            if (!(t3 == null && t2 == null || t3 != null && t3.equals(t2))) {
                this.comboBoxBase.setValue(t3);
            }
            this.updateDisplayNode();
        }
    }

    void updateDisplayNode() {
        if (this.textField != null && this.getEditor() != null) {
            T t2 = this.comboBoxBase.getValue();
            Object object = this.getConverter();
            if (this.initialTextFieldValue != null && !this.initialTextFieldValue.isEmpty()) {
                this.textField.setText(this.initialTextFieldValue);
                this.initialTextFieldValue = null;
                return;
            }
            object = ((StringConverter)object).toString(t2);
            if (t2 == null || object == null) {
                this.textField.setText("");
                return;
            }
            if (!((String)object).equals(this.textField.getText())) {
                this.textField.setText((String)object);
            }
        }
    }

    private void removeTextFieldEventFilters() {
        if (this.textField != null) {
            this.textField.removeEventFilter(MouseEvent.DRAG_DETECTED, this.textFieldMouseEventHandler);
            this.textField.removeEventFilter(DragEvent.ANY, this.textFieldDragEventHandler);
            this.comboBoxBase.setInputMethodRequests(null);
        }
    }

    void updateEditable() {
        TextField textField = this.getEditor();
        if (this.getEditor() == null) {
            this.removeTextFieldEventFilters();
        } else if (textField != null) {
            textField.addEventFilter(MouseEvent.DRAG_DETECTED, this.textFieldMouseEventHandler);
            textField.addEventFilter(DragEvent.ANY, this.textFieldDragEventHandler);
            this.comboBoxBase.setInputMethodRequests(new ComboBoxPopupControl$2(this, textField));
        }
        this.textField = textField;
    }

    private Point2D getPrefPopupPosition() {
        return Utils.pointRelativeTo((Node)((Object)this.getSkinnable()), this.getPopupContent(), HPos.CENTER, VPos.BOTTOM, 0.0, 0.0, true);
    }

    private void positionAndShowPopup() {
        ComboBoxBase comboBoxBase = (ComboBoxBase)this.getSkinnable();
        if (comboBoxBase.getScene() == null) {
            return;
        }
        PopupControl popupControl = this.getPopup();
        popupControl.getScene().setNodeOrientation(((ComboBoxBase)this.getSkinnable()).getEffectiveNodeOrientation());
        Node node = this.getPopupContent();
        this.sizePopup();
        Point2D point2D = this.getPrefPopupPosition();
        this.popupNeedsReconfiguring = true;
        this.reconfigurePopup();
        popupControl.show(comboBoxBase.getScene().getWindow(), this.snapPositionX(point2D.getX()), this.snapPositionY(point2D.getY()));
        node.requestFocus();
        this.sizePopup();
    }

    private void sizePopup() {
        Node node = this.getPopupContent();
        if (node instanceof Region) {
            Region region = (Region)node;
            double d2 = this.snapSizeY(((Node)region).prefHeight(0.0));
            double d3 = this.snapSizeY(((Node)region).minHeight(0.0));
            double d4 = this.snapSizeY(((Node)region).maxHeight(0.0));
            double d5 = this.snapSizeY(Math.min(Math.max(d2, d3), Math.max(d3, d4)));
            double d6 = this.snapSizeX(((Node)region).prefWidth(d5));
            double d7 = this.snapSizeX(((Node)region).minWidth(d5));
            double d8 = this.snapSizeX(((Node)region).maxWidth(d5));
            double d9 = this.snapSizeX(Math.min(Math.max(d6, d7), Math.max(d7, d8)));
            node.resize(d9, d5);
            return;
        }
        node.autosize();
    }

    private void createPopup() {
        this.popup = new ComboBoxPopupControl$3(this);
        this.popup.getStyleClass().add("combo-box-popup");
        this.popup.setConsumeAutoHidingEvents(false);
        this.popup.setAutoHide(true);
        this.popup.setAutoFix(true);
        this.popup.setHideOnEscape(true);
        this.popup.setOnAutoHide(event -> this.getBehavior().onAutoHide(this.popup));
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        listenerHelper.addEventHandler(this.popup, MouseEvent.MOUSE_CLICKED, mouseEvent -> this.getBehavior().onAutoHide(this.popup));
        listenerHelper.addEventHandler(this.popup, WindowEvent.WINDOW_HIDDEN, windowEvent -> ((ComboBoxBase)this.getSkinnable()).notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_NODE));
        listenerHelper.addInvalidationListener(() -> {
            this.popupNeedsReconfiguring = true;
            this.reconfigurePopup();
        }, ((ComboBoxBase)this.getSkinnable()).layoutXProperty(), ((ComboBoxBase)this.getSkinnable()).layoutYProperty(), ((ComboBoxBase)this.getSkinnable()).widthProperty(), ((ComboBoxBase)this.getSkinnable()).heightProperty());
        listenerHelper.addInvalidationListener(((ComboBoxBase)this.getSkinnable()).sceneProperty(), observable -> {
            if (((ObservableValue)observable).getValue() == null) {
                ((ComboBoxBaseSkin)this).hide();
                return;
            }
            if (((ComboBoxBase)this.getSkinnable()).isShowing()) {
                ((ComboBoxBaseSkin)this).show();
            }
        });
    }

    void reconfigurePopup() {
        double d2;
        if (this.popup == null) {
            return;
        }
        boolean bl2 = this.popup.isShowing();
        if (!bl2) {
            return;
        }
        if (!this.popupNeedsReconfiguring) {
            return;
        }
        this.popupNeedsReconfiguring = false;
        Object object = this.getPrefPopupPosition();
        Node node = this.getPopupContent();
        double d3 = node.prefWidth(-1.0);
        double d4 = node.prefHeight(-1.0);
        if (((Point2D)object).getX() > -1.0) {
            this.popup.setAnchorX(((Point2D)object).getX());
        }
        if (((Point2D)object).getY() > -1.0) {
            this.popup.setAnchorY(((Point2D)object).getY());
        }
        if (d3 > -1.0) {
            this.popup.setMinWidth(d3);
        }
        if (d4 > -1.0) {
            this.popup.setMinHeight(d4);
        }
        object = node.getLayoutBounds();
        double d5 = ((Bounds)object).getWidth();
        double d6 = ((Bounds)object).getHeight();
        double d7 = d5 < d3 ? d3 : d5;
        double d8 = d2 = d6 < d4 ? d4 : d6;
        if (d7 != d5 || d2 != d6) {
            node.resize(d7, d2);
            if (node instanceof Region) {
                ((Region)node).setMinSize(d7, d2);
                ((Region)node).setPrefSize(d7, d2);
            }
        }
    }

    private void handleKeyEvent(KeyEvent keyEvent, boolean bl2) {
        if (keyEvent.getCode() == KeyCode.ENTER) {
            if (keyEvent.isConsumed() || ((Event)keyEvent).getEventType() != KeyEvent.KEY_RELEASED) {
                return;
            }
            this.setTextFromTextFieldIntoComboBoxValue();
            if (bl2 && this.comboBoxBase.getOnAction() != null) {
                keyEvent.consume();
                return;
            }
            if (this.textField != null) {
                this.textField.fireEvent(keyEvent);
                return;
            }
        } else if ((keyEvent.getCode() == KeyCode.F10 || keyEvent.getCode() == KeyCode.ESCAPE) && bl2) {
            keyEvent.consume();
        }
    }
}

