/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.DatePickerContent;
import com.sun.javafx.scene.control.DatePickerHijrahContent;
import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.behavior.DatePickerBehavior;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.chrono.HijrahChronology;
import java.time.temporal.TemporalAccessor;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.ComboBoxBaseSkin;
import javafx.scene.control.skin.ComboBoxPopupControl;
import javafx.scene.control.skin.DatePickerSkin$1;
import javafx.util.StringConverter;

public class DatePickerSkin
extends ComboBoxPopupControl<LocalDate> {
    private final DatePicker datePicker;
    private TextField displayNode;
    private DatePickerContent datePickerContent;
    private final DatePickerBehavior behavior;

    public DatePickerSkin(DatePicker datePicker) {
        super(datePicker);
        this.datePicker = datePicker;
        this.behavior = new DatePickerBehavior(datePicker);
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        listenerHelper.addInvalidationListener(this.arrow.paddingProperty(), new DatePickerSkin$1(this));
        listenerHelper.addChangeListener(datePicker.chronologyProperty(), chronology -> {
            this.updateDisplayNode();
            this.datePickerContent = null;
            this.popup = null;
        });
        listenerHelper.addChangeListener(datePicker.converterProperty(), stringConverter -> this.updateDisplayNode());
        listenerHelper.addChangeListener(datePicker.dayCellFactoryProperty(), callback -> {
            this.updateDisplayNode();
            this.datePickerContent = null;
            this.popup = null;
        });
        listenerHelper.addChangeListener(datePicker.showWeekNumbersProperty(), bl2 -> {
            if (this.datePickerContent != null) {
                this.datePickerContent.updateGrid();
                this.datePickerContent.updateWeeknumberDateCells();
            }
        });
        listenerHelper.addChangeListener(datePicker.valueProperty(), localDate -> {
            this.updateDisplayNode();
            if (this.datePickerContent != null) {
                localDate = (LocalDate)datePicker.getValue();
                this.datePickerContent.displayedYearMonthProperty().set(localDate != null ? YearMonth.from(localDate) : YearMonth.now());
                this.datePickerContent.updateValues();
            }
            datePicker.fireEvent(new ActionEvent());
        });
        listenerHelper.addChangeListener(datePicker.showingProperty(), bl2 -> {
            if (((ComboBoxBase)datePicker).isShowing()) {
                if (this.datePickerContent != null) {
                    datePicker = (LocalDate)((ComboBoxBase)datePicker).getValue();
                    this.datePickerContent.displayedYearMonthProperty().set(datePicker != null ? YearMonth.from((TemporalAccessor)((Object)datePicker)) : YearMonth.now());
                    this.datePickerContent.updateValues();
                }
                ((ComboBoxBaseSkin)this).show();
                return;
            }
            this.updateDisplayNode();
            ((ComboBoxBaseSkin)this).hide();
        });
        if (datePicker.isShowing()) {
            ((ComboBoxBaseSkin)this).show();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            ((BehaviorBase)this.behavior).dispose();
        }
    }

    @Override
    public Node getPopupContent() {
        if (this.datePickerContent == null) {
            this.datePickerContent = this.datePicker.getChronology() instanceof HijrahChronology ? new DatePickerHijrahContent(this.datePicker) : new DatePickerContent(this.datePicker);
        }
        return this.datePickerContent;
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        return 50.0;
    }

    @Override
    public void show() {
        super.show();
        this.datePickerContent.clearFocus();
    }

    @Override
    protected TextField getEditor() {
        return ((DatePicker)this.getSkinnable()).getEditor();
    }

    @Override
    protected StringConverter<LocalDate> getConverter() {
        return ((DatePicker)this.getSkinnable()).getConverter();
    }

    @Override
    public Node getDisplayNode() {
        if (this.displayNode == null) {
            this.displayNode = this.getEditableInputNode();
            this.displayNode.getStyleClass().add("date-picker-display-node");
            this.updateDisplayNode();
        }
        this.displayNode.setEditable(this.datePicker.isEditable());
        return this.displayNode;
    }

    @Override
    void focusLost() {
    }

    @Override
    ComboBoxBaseBehavior getBehavior() {
        return this.behavior;
    }
}

