/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.LabeledText;
import com.sun.javafx.scene.control.behavior.MnemonicInfo;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.event.EventTarget;
import javafx.geometry.HPos;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Skinnable;
import javafx.scene.control.skin.LabeledSkinBase$1;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.Mnemonic;
import javafx.scene.layout.Region;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;

public abstract class LabeledSkinBase<C extends Labeled>
extends SkinBase<C> {
    LabeledText text;
    boolean invalidText = true;
    Node graphic;
    double textWidth = Double.NEGATIVE_INFINITY;
    double ellipsisWidth = Double.NEGATIVE_INFINITY;
    final InvalidationListener graphicPropertyChangedListener = observable -> {
        this.invalidText = true;
        ((Labeled)this.getSkinnable()).requestLayout();
    };
    private Rectangle textClip;
    private double wrapWidth;
    private double wrapHeight;
    private MnemonicInfo mnemonicInfo;
    private Line mnemonic_underscore;
    private boolean containsMnemonic = false;
    private Scene mnemonicScene = null;
    private KeyCombination mnemonicCode;
    private Node labeledNode = null;

    public LabeledSkinBase(C c2) {
        super(c2);
        this.text = new LabeledText((Labeled)c2);
        this.updateChildren();
        this.registerChangeListener(((Labeled)c2).ellipsisStringProperty(), observableValue -> {
            this.textMetricsChanged();
            this.invalidateWidths();
            this.ellipsisWidth = Double.NEGATIVE_INFINITY;
        });
        this.registerChangeListener(((Region)c2).widthProperty(), observableValue -> {
            this.updateWrappingWidth();
            this.invalidText = true;
        });
        this.registerChangeListener(((Region)c2).heightProperty(), observableValue -> {
            this.invalidText = true;
        });
        this.registerChangeListener(((Labeled)c2).fontProperty(), observableValue -> {
            this.textMetricsChanged();
            this.invalidateWidths();
            this.ellipsisWidth = Double.NEGATIVE_INFINITY;
        });
        this.registerChangeListener(((Labeled)c2).graphicProperty(), observableValue -> {
            this.updateChildren();
            this.textMetricsChanged();
        });
        this.registerChangeListener(((Labeled)c2).contentDisplayProperty(), observableValue -> {
            this.updateChildren();
            this.textMetricsChanged();
        });
        this.registerChangeListener(((Labeled)c2).labelPaddingProperty(), observableValue -> this.textMetricsChanged());
        this.registerChangeListener(((Labeled)c2).graphicTextGapProperty(), observableValue -> this.textMetricsChanged());
        this.registerChangeListener(((Labeled)c2).alignmentProperty(), observableValue -> ((Labeled)this.getSkinnable()).requestLayout());
        this.registerChangeListener(((Labeled)c2).mnemonicParsingProperty(), observableValue -> {
            this.containsMnemonic = false;
            this.textMetricsChanged();
        });
        this.registerChangeListener(((Labeled)c2).textProperty(), observableValue -> {
            this.updateChildren();
            this.textMetricsChanged();
            this.invalidateWidths();
        });
        this.registerChangeListener(((Labeled)c2).textAlignmentProperty(), observableValue -> {});
        this.registerChangeListener(((Labeled)c2).textOverrunProperty(), observableValue -> this.textMetricsChanged());
        this.registerChangeListener(((Labeled)c2).wrapTextProperty(), observableValue -> {
            this.updateWrappingWidth();
            this.textMetricsChanged();
        });
        this.registerChangeListener(((Labeled)c2).underlineProperty(), observableValue -> this.textMetricsChanged());
        this.registerChangeListener(((Labeled)c2).lineSpacingProperty(), observableValue -> this.textMetricsChanged());
        this.registerChangeListener(((Node)c2).sceneProperty(), observableValue -> this.sceneChanged());
    }

    @Override
    public void dispose() {
        if (this.graphic != null) {
            this.graphic.layoutBoundsProperty().removeListener(this.graphicPropertyChangedListener);
            this.graphic = null;
        }
        super.dispose();
    }

    protected void updateChildren() {
        Labeled labeled = (Labeled)this.getSkinnable();
        if (this.graphic != null) {
            this.graphic.layoutBoundsProperty().removeListener(this.graphicPropertyChangedListener);
        }
        this.graphic = labeled.getGraphic();
        if (this.graphic instanceof ImageView) {
            this.graphic.setMouseTransparent(true);
        }
        if (this.isIgnoreGraphic()) {
            if (labeled.getContentDisplay() == ContentDisplay.GRAPHIC_ONLY) {
                this.getChildren().clear();
                return;
            }
            this.getChildren().setAll((Node[])new Node[]{this.text});
            return;
        }
        this.graphic.layoutBoundsProperty().addListener(this.graphicPropertyChangedListener);
        if (this.isIgnoreText()) {
            this.getChildren().setAll((Node[])new Node[]{this.graphic});
            return;
        }
        this.getChildren().setAll((Node[])new Node[]{this.graphic, this.text});
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        return this.computeMinLabeledPartWidth(d2, d3, d4, d5, d6);
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        return this.computeMinLabeledPartHeight(d2, d3, d4, d5, d6);
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        Labeled labeled = (Labeled)this.getSkinnable();
        boolean bl2 = this.isIgnoreText();
        double d9 = d6 + d4;
        if (bl2) {
            v0 = 0.0;
        } else {
            d9 += this.leftLabelPadding() + this.rightLabelPadding();
            String string = this.getCleanText();
            boolean bl3 = string == null || string.isEmpty();
            v0 = d8 = bl3 ? 0.0 : Utils.computeTextWidth(this.text.getFont(), string, 0.0);
        }
        if (this.isIgnoreGraphic()) {
            d7 = d8;
        } else {
            ContentDisplay contentDisplay;
            double d10;
            double d11 = d10 = this.graphic == null ? 0.0 : Utils.boundedSize(this.graphic.prefWidth(-1.0), this.graphic.minWidth(-1.0), this.graphic.maxWidth(-1.0));
            d7 = bl2 ? d10 : ((contentDisplay = labeled.getContentDisplay()) == ContentDisplay.LEFT || contentDisplay == ContentDisplay.RIGHT ? d8 + labeled.getGraphicTextGap() + d10 : Math.max(d8, d10));
        }
        return d7 + d9;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7;
        String string;
        Labeled labeled = (Labeled)this.getSkinnable();
        Font font = this.text.getFont();
        ContentDisplay contentDisplay = labeled.getContentDisplay();
        double d8 = labeled.getGraphicTextGap();
        boolean bl2 = this.isIgnoreText();
        boolean bl3 = this.isIgnoreGraphic();
        d2 -= d6 + d4;
        double d9 = d3 + d5;
        if (!bl2) {
            d2 -= this.leftLabelPadding() + this.rightLabelPadding();
            d9 += this.topLabelPadding() + this.bottomLabelPadding();
        }
        if ((string = this.getCleanText()) != null && string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        double d10 = d2;
        if (!(bl3 || contentDisplay != ContentDisplay.LEFT && contentDisplay != ContentDisplay.RIGHT)) {
            d10 -= this.graphic.prefWidth(-1.0) + d8;
        }
        double d11 = Utils.computeTextHeight(font, string, labeled.isWrapText() ? d10 : 0.0, labeled.getLineSpacing(), this.text.getBoundsType());
        if (bl3) {
            d7 = d11;
        } else {
            double d12;
            double d13 = d12 = this.graphic == null ? 0.0 : Utils.boundedSize(this.graphic.prefHeight(d2), this.graphic.minHeight(d2), this.graphic.maxHeight(d2));
            d7 = bl2 ? d12 : (contentDisplay == ContentDisplay.TOP || contentDisplay == ContentDisplay.BOTTOM ? d12 + d8 + d11 : Math.max(d11, d12));
        }
        return d7 + d9;
    }

    @Override
    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        return ((Node)((Labeled)this.getSkinnable())).prefWidth(d2);
    }

    @Override
    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return ((Node)((Labeled)this.getSkinnable())).prefHeight(d2);
    }

    @Override
    public double computeBaselineOffset(double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        double d8 = d7 = ((Node)this.text).getBaselineOffset();
        Labeled labeled = (Labeled)this.getSkinnable();
        Object object = labeled.getGraphic();
        if (!this.isIgnoreGraphic()) {
            d6 = object.prefHeight(-1.0);
            double d9 = this.text.prefHeight(-1.0);
            object = labeled.getContentDisplay();
            if (object == ContentDisplay.TOP) {
                d8 = d6 + labeled.getGraphicTextGap() + d7;
            } else if ((object == ContentDisplay.LEFT || object == ContentDisplay.RIGHT) && d6 > d9) {
                d8 = d7 + (d6 - d9) / 2.0;
            }
        }
        d6 = d2 + d8;
        if (!this.isIgnoreText()) {
            d6 += this.topLabelPadding();
        }
        return d6;
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        this.layoutLabelInArea(d2, d3, d4, d5);
    }

    protected void layoutLabelInArea(double d2, double d3, double d4, double d5) {
        this.layoutLabelInArea(d2, d3, d4, d5, null);
    }

    protected void layoutLabelInArea(double d2, double d3, double d4, double d5, Pos enum_) {
        double d6;
        double d7;
        double d8;
        double d9;
        Labeled labeled = (Labeled)this.getSkinnable();
        ContentDisplay contentDisplay = labeled.getContentDisplay();
        if (enum_ == null) {
            enum_ = labeled.getAlignment();
        }
        HPos hPos = enum_ == null ? HPos.LEFT : ((Pos)enum_).getHpos();
        enum_ = enum_ == null ? VPos.CENTER : ((Pos)enum_).getVpos();
        boolean bl2 = this.isIgnoreGraphic();
        boolean bl3 = this.isIgnoreText();
        if (!bl3) {
            d2 += this.leftLabelPadding();
            d3 += this.topLabelPadding();
            d4 -= this.leftLabelPadding() + this.rightLabelPadding();
            d5 -= this.topLabelPadding() + this.bottomLabelPadding();
        }
        if (bl2) {
            d9 = 0.0;
            d8 = 0.0;
        } else if (bl3) {
            if (this.graphic.isResizable()) {
                Orientation orientation = this.graphic.getContentBias();
                if (orientation == Orientation.HORIZONTAL) {
                    d8 = Utils.boundedSize(d4, this.graphic.minWidth(-1.0), this.graphic.maxWidth(-1.0));
                    d9 = Utils.boundedSize(d5, this.graphic.minHeight(d8), this.graphic.maxHeight(d8));
                } else if (orientation == Orientation.VERTICAL) {
                    d9 = Utils.boundedSize(d5, this.graphic.minHeight(-1.0), this.graphic.maxHeight(-1.0));
                    d8 = Utils.boundedSize(d4, this.graphic.minWidth(d9), this.graphic.maxWidth(d9));
                } else {
                    d8 = Utils.boundedSize(d4, this.graphic.minWidth(-1.0), this.graphic.maxWidth(-1.0));
                    d9 = Utils.boundedSize(d5, this.graphic.minHeight(-1.0), this.graphic.maxHeight(-1.0));
                }
                this.graphic.resize(d8, d9);
            } else {
                d8 = this.graphic.getLayoutBounds().getWidth();
                d9 = this.graphic.getLayoutBounds().getHeight();
            }
        } else {
            this.graphic.autosize();
            d8 = this.graphic.getLayoutBounds().getWidth();
            d9 = this.graphic.getLayoutBounds().getHeight();
        }
        if (bl3) {
            d7 = 0.0;
            d6 = 0.0;
            this.text.setText("");
        } else {
            this.updateDisplayedText(d4, d5);
            LabeledSkinBase labeledSkinBase = this;
            d6 = labeledSkinBase.snapSizeX(Math.min(labeledSkinBase.text.getLayoutBounds().getWidth(), this.wrapWidth));
            LabeledSkinBase labeledSkinBase2 = this;
            d7 = labeledSkinBase2.snapSizeY(Math.min(labeledSkinBase2.text.getLayoutBounds().getHeight(), this.wrapHeight));
        }
        double d10 = bl3 || bl2 ? 0.0 : labeled.getGraphicTextGap();
        double d11 = Math.max(d8, d6);
        double d12 = Math.max(d9, d7);
        if (contentDisplay == ContentDisplay.TOP || contentDisplay == ContentDisplay.BOTTOM) {
            d12 = d9 + d10 + d7;
        } else if (contentDisplay == ContentDisplay.LEFT || contentDisplay == ContentDisplay.RIGHT) {
            d11 = d8 + d10 + d6;
        }
        double d13 = hPos == HPos.LEFT ? d2 : (hPos == HPos.RIGHT ? d2 + (d4 - d11) : d2 + (d4 - d11) / 2.0);
        double d14 = enum_ == VPos.TOP ? d3 : (enum_ == VPos.BOTTOM ? d3 + (d5 - d12) : d3 + (d5 - d12) / 2.0);
        Point2D point2D = null;
        double d15 = 0.0;
        double d16 = 0.0;
        if (this.containsMnemonic) {
            Font font = this.text.getFont();
            String string = this.mnemonicInfo.getText();
            boolean bl4 = this.labeledNode.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
            point2D = Utils.computeMnemonicPosition(font, string, this.mnemonicInfo.getMnemonicIndex(), this.wrapWidth, labeled.getLineSpacing(), bl4);
            d15 = Utils.computeTextWidth(font, string.substring(this.mnemonicInfo.getMnemonicIndex(), this.mnemonicInfo.getMnemonicIndex() + 1), 0.0);
            d16 = Utils.computeTextHeight(font, "_", 0.0, this.text.getBoundsType());
        }
        if (!(bl2 && bl3 || this.text.isManaged())) {
            this.text.setManaged(true);
        }
        if (bl2 && bl3) {
            if (this.text.isManaged()) {
                this.text.setManaged(false);
            }
            this.text.relocate(this.snapPositionX(d13), this.snapPositionY(d14));
        } else if (bl2) {
            this.text.relocate(this.snapPositionX(d13), this.snapPositionY(d14));
            if (this.containsMnemonic && point2D != null) {
                this.mnemonic_underscore.setEndX(d15 - 2.0);
                this.mnemonic_underscore.relocate(this.snapPositionX(d13 + point2D.getX()), this.snapPositionY(d14 + point2D.getY()));
            }
        } else if (bl3) {
            this.text.relocate(this.snapPositionX(d13), this.snapPositionY(d14));
            this.graphic.relocate(this.snapPositionX(d13), this.snapPositionY(d14));
            if (this.containsMnemonic && point2D != null) {
                this.mnemonic_underscore.setEndX(d15);
                this.mnemonic_underscore.setStrokeWidth(d16 / 10.0);
                this.mnemonic_underscore.relocate(this.snapPositionX(d13 + point2D.getX()), this.snapPositionY(d14 + point2D.getY()));
            }
        } else {
            double d17 = 0.0;
            double d18 = 0.0;
            double d19 = 0.0;
            double d20 = 0.0;
            if (contentDisplay == ContentDisplay.TOP) {
                d17 = d13 + (d11 - d8) / 2.0;
                d19 = d13 + (d11 - d6) / 2.0;
                d18 = d14;
                d20 = d18 + d9 + d10;
            } else if (contentDisplay == ContentDisplay.RIGHT) {
                d19 = d13;
                d17 = d19 + d6 + d10;
                d18 = d14 + (d12 - d9) / 2.0;
                d20 = d14 + (d12 - d7) / 2.0;
            } else if (contentDisplay == ContentDisplay.BOTTOM) {
                d17 = d13 + (d11 - d8) / 2.0;
                d19 = d13 + (d11 - d6) / 2.0;
                d20 = d14;
                d18 = d20 + d7 + d10;
            } else if (contentDisplay == ContentDisplay.LEFT) {
                d17 = d13;
                d19 = d17 + d8 + d10;
                d18 = d14 + (d12 - d9) / 2.0;
                d20 = d14 + (d12 - d7) / 2.0;
            } else if (contentDisplay == ContentDisplay.CENTER) {
                d17 = d13 + (d11 - d8) / 2.0;
                d19 = d13 + (d11 - d6) / 2.0;
                d18 = d14 + (d12 - d9) / 2.0;
                d20 = d14 + (d12 - d7) / 2.0;
            }
            this.text.relocate(this.snapPositionX(d19), this.snapPositionY(d20));
            if (this.containsMnemonic && point2D != null) {
                this.mnemonic_underscore.setEndX(d15);
                this.mnemonic_underscore.setStrokeWidth(d16 / 10.0);
                this.mnemonic_underscore.relocate(this.snapPositionX(d19 + point2D.getX()), this.snapPositionY(d20 + point2D.getY()));
            }
            this.graphic.relocate(this.snapPositionX(d17), this.snapPositionY(d18));
        }
        if (this.text != null && (this.text.getLayoutBounds().getHeight() > this.wrapHeight || this.text.getLayoutBounds().getWidth() > this.wrapWidth)) {
            if (this.textClip == null) {
                this.textClip = new Rectangle();
            }
            if (labeled.getEffectiveNodeOrientation() == NodeOrientation.LEFT_TO_RIGHT) {
                this.textClip.setX(this.text.getLayoutBounds().getMinX());
            } else {
                this.textClip.setX(this.text.getLayoutBounds().getMaxX() - this.wrapWidth);
            }
            this.textClip.setY(this.text.getLayoutBounds().getMinY());
            this.textClip.setWidth(this.wrapWidth);
            this.textClip.setHeight(this.wrapHeight);
            if (this.text.getClip() == null) {
                this.text.setClip(this.textClip);
                return;
            }
        } else if (this.text.getClip() != null) {
            this.text.setClip(null);
        }
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute object, Object ... objectArray) {
        switch (LabeledSkinBase$1.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                object = (Labeled)this.getSkinnable();
                object = ((Node)object).getAccessibleText();
                if (object != null && !((String)object).isEmpty()) {
                    return object;
                }
                object = this.getCleanText();
                if (object != null && !((String)object).isEmpty()) {
                    return object;
                }
                if (this.graphic != null && (object = this.graphic.queryAccessibleAttribute(AccessibleAttribute.TEXT, new Object[0])) != null) {
                    return object;
                }
                return null;
            }
            case 2: {
                if (this.mnemonicInfo != null) {
                    return this.mnemonicInfo.getMnemonic();
                }
                return null;
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray);
    }

    private double computeMinLabeledPartWidth(double d2, double d3, double d4, double d5, double d6) {
        Node node = (Labeled)this.getSkinnable();
        ContentDisplay contentDisplay = ((Labeled)node).getContentDisplay();
        double d7 = ((Labeled)node).getGraphicTextGap();
        double d8 = 0.0;
        Font font = this.text.getFont();
        OverrunStyle overrunStyle = ((Labeled)node).getTextOverrun();
        String string = ((Labeled)node).getEllipsisString();
        String string2 = this.getCleanText();
        boolean bl2 = string2 == null || string2.isEmpty();
        if (!bl2) {
            if (overrunStyle == OverrunStyle.CLIP) {
                if (this.textWidth == Double.NEGATIVE_INFINITY) {
                    this.textWidth = Utils.computeTextWidth(font, string2.substring(0, 1), 0.0);
                }
                d8 = this.textWidth;
            } else {
                if (this.textWidth == Double.NEGATIVE_INFINITY) {
                    this.textWidth = Utils.computeTextWidth(font, string2, 0.0);
                }
                if (this.ellipsisWidth == Double.NEGATIVE_INFINITY) {
                    this.ellipsisWidth = Utils.computeTextWidth(font, string, 0.0);
                }
                d8 = Math.min(this.textWidth, this.ellipsisWidth);
            }
        }
        node = ((Labeled)node).getGraphic();
        double d9 = this.isIgnoreGraphic() ? d8 : (this.isIgnoreText() ? node.minWidth(-1.0) : (contentDisplay == ContentDisplay.LEFT || contentDisplay == ContentDisplay.RIGHT ? d8 + node.minWidth(-1.0) + d7 : Math.max(d8, node.minWidth(-1.0))));
        double d10 = d6 + d4;
        if (!this.isIgnoreText()) {
            d10 += this.leftLabelPadding() + this.rightLabelPadding();
        }
        return d9 + d10;
    }

    private double computeMinLabeledPartHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7;
        int n2;
        Labeled labeled = (Labeled)this.getSkinnable();
        Font font = this.text.getFont();
        String string = this.getCleanText();
        if (string != null && string.length() > 0 && (n2 = string.indexOf(10)) >= 0) {
            string = string.substring(0, n2);
        }
        double d8 = labeled.getLineSpacing();
        double d9 = d7 = Utils.computeTextHeight(font, string, 0.0, d8, this.text.getBoundsType());
        if (!this.isIgnoreGraphic()) {
            Node node = labeled.getGraphic();
            d9 = labeled.getContentDisplay() == ContentDisplay.TOP || labeled.getContentDisplay() == ContentDisplay.BOTTOM ? node.minHeight(d2) + labeled.getGraphicTextGap() + d7 : Math.max(d7, node.minHeight(d2));
        }
        double d10 = d3 + d5;
        if (!this.isIgnoreText()) {
            d10 += this.topLabelPadding() - this.bottomLabelPadding();
        }
        return d9 + d10;
    }

    double topLabelPadding() {
        LabeledSkinBase labeledSkinBase = this;
        return labeledSkinBase.snapSizeY(((Labeled)labeledSkinBase.getSkinnable()).getLabelPadding().getTop());
    }

    double bottomLabelPadding() {
        LabeledSkinBase labeledSkinBase = this;
        return labeledSkinBase.snapSizeY(((Labeled)labeledSkinBase.getSkinnable()).getLabelPadding().getBottom());
    }

    double leftLabelPadding() {
        LabeledSkinBase labeledSkinBase = this;
        return labeledSkinBase.snapSizeX(((Labeled)labeledSkinBase.getSkinnable()).getLabelPadding().getLeft());
    }

    double rightLabelPadding() {
        LabeledSkinBase labeledSkinBase = this;
        return labeledSkinBase.snapSizeX(((Labeled)labeledSkinBase.getSkinnable()).getLabelPadding().getRight());
    }

    private void textMetricsChanged() {
        this.invalidText = true;
        ((Labeled)this.getSkinnable()).requestLayout();
    }

    void mnemonicTargetChanged() {
        if (this.containsMnemonic) {
            this.removeMnemonic();
            Skinnable skinnable = this.getSkinnable();
            if (skinnable instanceof Label) {
                this.labeledNode = ((Label)skinnable).getLabelFor();
                this.addMnemonic();
                return;
            }
            this.labeledNode = null;
        }
    }

    private void sceneChanged() {
        EventTarget eventTarget = (Labeled)this.getSkinnable();
        if ((eventTarget = eventTarget.getScene()) != null && this.containsMnemonic) {
            this.addMnemonic();
        }
    }

    private void invalidateWidths() {
        this.textWidth = Double.NEGATIVE_INFINITY;
    }

    void updateDisplayedText() {
        this.updateDisplayedText(-1.0, -1.0);
    }

    private void updateDisplayedText(double d2, double d3) {
        if (this.invalidText) {
            String string;
            int n2;
            Labeled labeled = (Labeled)this.getSkinnable();
            String string2 = this.getCleanText();
            int n3 = -1;
            if (string2 != null && string2.length() > 0 && this.mnemonicInfo != null && !PlatformUtil.isMac() && ((Labeled)this.getSkinnable()).isMnemonicParsing()) {
                this.labeledNode = labeled instanceof Label ? ((Label)labeled).getLabelFor() : labeled;
                if (this.labeledNode == null) {
                    this.labeledNode = labeled;
                }
                n3 = this.mnemonicInfo.getMnemonicIndex();
            }
            if (this.containsMnemonic) {
                if (this.mnemonicScene != null && (n3 == -1 || this.mnemonicInfo != null && !this.mnemonicInfo.getMnemonicKeyCombination().equals(this.mnemonicCode))) {
                    this.removeMnemonic();
                    this.containsMnemonic = false;
                }
            } else {
                this.removeMnemonic();
            }
            if (string2 != null && string2.length() > 0 && n3 >= 0 && !this.containsMnemonic) {
                this.containsMnemonic = true;
                this.mnemonicCode = this.mnemonicInfo.getMnemonicKeyCombination();
                this.addMnemonic();
            }
            if (this.containsMnemonic) {
                if (this.mnemonic_underscore == null) {
                    this.mnemonic_underscore = new Line();
                    this.mnemonic_underscore.setStartX(0.0);
                    this.mnemonic_underscore.setStartY(0.0);
                    this.mnemonic_underscore.setEndY(0.0);
                    this.mnemonic_underscore.getStyleClass().clear();
                    this.mnemonic_underscore.getStyleClass().setAll((String[])new String[]{"mnemonic-underline"});
                }
                if (!this.getChildren().contains(this.mnemonic_underscore)) {
                    this.getChildren().add(this.mnemonic_underscore);
                }
            } else if (this.mnemonic_underscore != null && this.getChildren().contains(this.mnemonic_underscore)) {
                Platform.runLater(() -> {
                    this.getChildren().remove(this.mnemonic_underscore);
                    this.mnemonic_underscore = null;
                });
            }
            n3 = string2 != null ? string2.length() : 0;
            boolean bl2 = false;
            if (string2 != null && n3 > 0 && (n2 = string2.indexOf(10)) >= 0 && n2 < n3 - 1) {
                bl2 = true;
            }
            n3 = labeled.getContentDisplay() == ContentDisplay.LEFT || labeled.getContentDisplay() == ContentDisplay.RIGHT ? 1 : 0;
            double d4 = labeled.getWidth() - this.snappedLeftInset() - this.snappedRightInset();
            if (!this.isIgnoreText()) {
                d4 -= this.leftLabelPadding() + this.rightLabelPadding();
            }
            d4 = Math.max(d4, 0.0);
            if (d2 == -1.0) {
                d2 = d4;
            }
            double d5 = Math.min(this.computeMinLabeledPartWidth(-1.0, this.snappedTopInset(), this.snappedRightInset(), this.snappedBottomInset(), this.snappedLeftInset()), d4);
            if (n3 != 0 && !this.isIgnoreGraphic()) {
                double d6 = labeled.getGraphic().getLayoutBounds().getWidth() + labeled.getGraphicTextGap();
                d2 -= d6;
                d5 -= d6;
            }
            this.wrapWidth = Math.max(d5, d2);
            boolean bl3 = labeled.getContentDisplay() == ContentDisplay.TOP || labeled.getContentDisplay() == ContentDisplay.BOTTOM;
            double d7 = labeled.getHeight() - this.snappedTopInset() - this.snappedBottomInset();
            if (!this.isIgnoreText()) {
                d7 -= this.topLabelPadding() + this.bottomLabelPadding();
            }
            d7 = Math.max(d7, 0.0);
            if (d3 == -1.0) {
                d3 = d7;
            }
            LabeledSkinBase labeledSkinBase = this;
            double d8 = Math.min(labeledSkinBase.computeMinLabeledPartHeight(labeledSkinBase.wrapWidth, this.snappedTopInset(), this.snappedRightInset(), this.snappedBottomInset(), this.snappedLeftInset()), d7);
            if (bl3 && labeled.getGraphic() != null) {
                double d9 = labeled.getGraphic().getLayoutBounds().getHeight() + labeled.getGraphicTextGap();
                d3 -= d9;
                d8 -= d9;
            }
            this.wrapHeight = Math.max(d8, d3);
            this.updateWrappingWidth();
            Font font = this.text.getFont();
            OverrunStyle overrunStyle = labeled.getTextOverrun();
            String string3 = labeled.getEllipsisString();
            if (labeled.isWrapText()) {
                string = Utils.computeClippedWrappedText(font, string2, this.wrapWidth, this.wrapHeight, labeled.getLineSpacing(), overrunStyle, string3, this.text.getBoundsType());
            } else if (bl2) {
                StringBuilder stringBuilder = new StringBuilder();
                String[] stringArray = string2.split("\n");
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    stringBuilder.append(Utils.computeClippedText(font, stringArray[i2], this.wrapWidth, overrunStyle, string3));
                    if (i2 >= stringArray.length - 1) continue;
                    stringBuilder.append('\n');
                }
                string = stringBuilder.toString();
            } else {
                string = Utils.computeClippedText(font, string2, this.wrapWidth, overrunStyle, string3);
            }
            if (string != null && string.endsWith("\n")) {
                string = string.substring(0, string.length() - 1);
            }
            this.text.setText(string);
            this.updateWrappingWidth();
            this.invalidText = false;
        }
    }

    private String getCleanText() {
        Labeled labeled = (Labeled)this.getSkinnable();
        String string = labeled.getText();
        if (string != null && labeled.isMnemonicParsing()) {
            if (this.mnemonicInfo == null) {
                this.mnemonicInfo = new MnemonicInfo(string);
            } else {
                this.mnemonicInfo.update(string);
            }
            return this.mnemonicInfo.getText();
        }
        return string;
    }

    private void addMnemonic() {
        if (this.labeledNode != null) {
            this.mnemonicScene = this.labeledNode.getScene();
            if (this.mnemonicScene != null) {
                this.mnemonicScene.addMnemonic(new Mnemonic(this.labeledNode, this.mnemonicCode));
            }
        }
    }

    private void removeMnemonic() {
        if (this.mnemonicScene != null && this.labeledNode != null) {
            this.mnemonicScene.removeMnemonic(new Mnemonic(this.labeledNode, this.mnemonicCode));
            this.mnemonicScene = null;
        }
    }

    private void updateWrappingWidth() {
        Labeled labeled = (Labeled)this.getSkinnable();
        this.text.setWrappingWidth(0.0);
        if (labeled.isWrapText()) {
            double d2 = Math.min(this.text.prefWidth(-1.0), this.wrapWidth);
            this.text.setWrappingWidth(d2);
        }
    }

    boolean isIgnoreGraphic() {
        return this.graphic == null || !this.graphic.isManaged() || ((Labeled)this.getSkinnable()).getContentDisplay() == ContentDisplay.TEXT_ONLY;
    }

    boolean isIgnoreText() {
        Labeled labeled = (Labeled)this.getSkinnable();
        String string = this.getCleanText();
        return string == null || string.equals("") || labeled.getContentDisplay() == ContentDisplay.GRAPHIC_ONLY;
    }
}

