/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.FXPermissions;
import com.sun.javafx.menu.MenuBase;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.scene.control.GlobalMenuAdapter;
import com.sun.javafx.scene.control.IDisconnectable;
import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.MenuBarButton;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.SizeConverter;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SkinBase;
import javafx.scene.control.skin.MenuBarSkin$1;
import javafx.scene.control.skin.MenuBarSkin$2;
import javafx.scene.control.skin.MenuBarSkin$3;
import javafx.scene.control.skin.MenuBarSkin$4;
import javafx.scene.control.skin.MenuBarSkin$5;
import javafx.scene.control.skin.MenuButtonSkinBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Pair;

public class MenuBarSkin
extends SkinBase<MenuBar> {
    private static final ObservableList<Window> stages;
    private final HBox container;
    private Menu openMenu;
    private MenuBarButton openMenuButton;
    private Menu focusedMenu;
    private int focusedMenuIndex = -1;
    private static WeakHashMap<Stage, Reference<MenuBarSkin>> systemMenuMap;
    private static List<MenuBase> wrappedDefaultMenus;
    private static Stage currentMenuBarStage;
    private List<MenuBase> wrappedMenus;
    private ChangeListener<Boolean> menuBarFocusedPropertyListener;
    private WeakChangeListener<Boolean> weakMenuBarFocusedPropertyListener;
    private ChangeListener<Scene> sceneChangeListener;
    private ChangeListener<Boolean> menuVisibilityChangeListener;
    private WeakChangeListener<Boolean> weakMenuVisibilityChangeListener;
    private ListenerHelper sceneListenerHelper;
    private IDisconnectable windowFocusHelper;
    private boolean pendingDismiss = false;
    private boolean altKeyPressed = false;
    private EventHandler<ActionEvent> menuActionEventHandler = object -> {
        if (((EventObject)object).getSource() instanceof CustomMenuItem && !((CustomMenuItem)(object = (CustomMenuItem)((EventObject)object).getSource())).isHideOnClick()) {
            return;
        }
        this.unSelectMenus();
    };
    private ListChangeListener<MenuItem> menuItemListener = listChangeListener$Change -> {
        while (listChangeListener$Change.next()) {
            for (MenuItem menuItem : listChangeListener$Change.getAddedSubList()) {
                this.updateActionListeners(menuItem, true);
            }
            for (MenuItem menuItem : listChangeListener$Change.getRemoved()) {
                this.updateActionListeners(menuItem, false);
            }
        }
    };
    Runnable firstMenuRunnable = new MenuBarSkin$1(this);
    private DoubleProperty spacing;
    private ObjectProperty<Pos> containerAlignment;
    private static final CssMetaData<MenuBar, Number> SPACING;
    private static final CssMetaData<MenuBar, Pos> ALIGNMENT;
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public MenuBarSkin(MenuBar menuBar) {
        super(menuBar);
        this.container = new HBox();
        this.container.getStyleClass().add("container");
        this.getChildren().add(this.container);
        this.menuBarFocusedPropertyListener = (observableValue, bl2, bl3) -> {
            this.unSelectMenus();
            if (bl3.booleanValue() && !this.container.getChildren().isEmpty()) {
                this.menuModeStart(0);
                this.openMenuButton = (MenuBarButton)this.container.getChildren().get(0);
                this.setFocusedMenuIndex(0);
                this.openMenuButton.setHover();
            }
        };
        this.weakMenuBarFocusedPropertyListener = new WeakChangeListener<Boolean>(this.menuBarFocusedPropertyListener);
        this.menuVisibilityChangeListener = (observableValue, bl2, bl3) -> this.rebuildUI();
        this.weakMenuVisibilityChangeListener = new WeakChangeListener<Boolean>(this.menuVisibilityChangeListener);
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        this.rebuildUI();
        listenerHelper.addListChangeListener(menuBar.getMenus(), listChangeListener$Change -> this.rebuildUI());
        if (Toolkit.getToolkit().getSystemMenu().isSupported()) {
            listenerHelper.addInvalidationListener(menuBar.useSystemMenuBarProperty(), observable -> this.rebuildUI());
        }
        KeyCombination keyCombination = Utils.isMac() ? KeyCombination.keyCombination("ctrl+F10") : KeyCombination.keyCombination("F10");
        ParentTraversalEngine parentTraversalEngine = new ParentTraversalEngine((Parent)((Object)this.getSkinnable()));
        parentTraversalEngine.addTraverseListener((node, bounds) -> {
            if (this.openMenu != null) {
                this.openMenu.hide();
            }
            this.setFocusedMenuIndex(0);
        });
        ParentHelper.setTraversalEngine((Parent)((Object)this.getSkinnable()), parentTraversalEngine);
        listenerHelper.addChangeListener(menuBar.sceneProperty(), true, scene -> {
            if (this.sceneListenerHelper != null) {
                this.sceneListenerHelper.disconnect();
                this.sceneListenerHelper = null;
            }
            if (scene != null) {
                this.sceneListenerHelper = new ListenerHelper();
                this.sceneListenerHelper.addEventFilter(scene, KeyEvent.KEY_PRESSED, keyEvent -> {
                    if (this.focusedMenu != null) {
                        switch (keyEvent.getCode()) {
                            case LEFT: {
                                boolean bl2;
                                boolean bl3 = bl2 = menuBar.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
                                if (menuBar.getScene().getWindow().isFocused()) {
                                    if (this.openMenu != null && !this.openMenu.isShowing()) {
                                        if (bl2) {
                                            this.moveToMenu(Direction.NEXT, false);
                                        } else {
                                            this.moveToMenu(Direction.PREVIOUS, false);
                                        }
                                        keyEvent.consume();
                                        return;
                                    }
                                    if (bl2) {
                                        this.moveToMenu(Direction.NEXT, true);
                                    } else {
                                        this.moveToMenu(Direction.PREVIOUS, true);
                                    }
                                }
                                keyEvent.consume();
                                return;
                            }
                            case RIGHT: {
                                boolean bl4;
                                boolean bl5 = bl4 = menuBar.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
                                if (menuBar.getScene().getWindow().isFocused()) {
                                    if (this.openMenu != null && !this.openMenu.isShowing()) {
                                        if (bl4) {
                                            this.moveToMenu(Direction.PREVIOUS, false);
                                        } else {
                                            this.moveToMenu(Direction.NEXT, false);
                                        }
                                        keyEvent.consume();
                                        return;
                                    }
                                    if (bl4) {
                                        this.moveToMenu(Direction.PREVIOUS, true);
                                    } else {
                                        this.moveToMenu(Direction.NEXT, true);
                                    }
                                }
                                keyEvent.consume();
                                return;
                            }
                            case DOWN: {
                                if (!menuBar.getScene().getWindow().isFocused() || this.focusedMenuIndex == -1) break;
                                Menu menu = (Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex);
                                this.showMenu(menu, true);
                                keyEvent.consume();
                                return;
                            }
                            case ESCAPE: {
                                this.unSelectMenus();
                                keyEvent.consume();
                            }
                        }
                    }
                });
                this.sceneListenerHelper.addEventFilter(scene, MouseEvent.MOUSE_CLICKED, mouseEvent -> {
                    Bounds bounds = this.container.localToScreen(this.container.getLayoutBounds());
                    if (bounds == null || !bounds.contains(mouseEvent.getScreenX(), mouseEvent.getScreenY())) {
                        this.unSelectMenus();
                    }
                });
                this.sceneListenerHelper.addChangeListener(scene.windowProperty(), true, window -> {
                    if (this.windowFocusHelper != null) {
                        this.windowFocusHelper.disconnect();
                        this.windowFocusHelper = null;
                    }
                    if (window != null) {
                        this.windowFocusHelper = this.sceneListenerHelper.addChangeListener(window.focusedProperty(), true, bl2 -> {
                            if (!bl2.booleanValue()) {
                                this.unSelectMenus();
                            }
                        });
                    }
                });
                this.sceneListenerHelper.addEventFilter(scene, KeyEvent.ANY, keyEvent -> {
                    if (((Event)keyEvent).getEventType() == KeyEvent.KEY_PRESSED) {
                        this.altKeyPressed = false;
                        if (keyEvent.getCode() == KeyCode.ALT && !keyEvent.isConsumed()) {
                            if (this.focusedMenuIndex == -1) {
                                this.altKeyPressed = true;
                            }
                            this.unSelectMenus();
                            return;
                        }
                    } else if (((Event)keyEvent).getEventType() == KeyEvent.KEY_RELEASED) {
                        if (this.altKeyPressed && keyEvent.getCode() == KeyCode.ALT && !keyEvent.isConsumed()) {
                            this.firstMenuRunnable.run();
                        }
                        this.altKeyPressed = false;
                    }
                });
                scene.getAccelerators().put(keyCombination, this.firstMenuRunnable);
                this.sceneListenerHelper.addDisconnectable(() -> scene.getAccelerators().remove(keyCombination));
            }
        });
    }

    private void showMenu(Menu menu) {
        this.showMenu(menu, false);
    }

    private void showMenu(Menu object, boolean bl2) {
        if (this.openMenu == object) {
            return;
        }
        if (this.openMenu != null) {
            this.openMenu.hide();
        }
        this.openMenu = object;
        if (!((Menu)object).isShowing() && !this.isMenuEmpty((Menu)object)) {
            if (bl2) {
                MenuBarSkin menuBarSkin = this;
                object = menuBarSkin.getNodeForMenu(menuBarSkin.focusedMenuIndex);
                if ((object = ((Control)object).getSkin()) instanceof MenuButtonSkinBase) {
                    ((MenuButtonSkinBase)object).requestFocusOnFirstMenuItem();
                }
            }
            this.openMenu.show();
        }
    }

    void setFocusedMenuIndex(int n2) {
        this.focusedMenuIndex = n2 >= -1 && n2 < ((MenuBar)this.getSkinnable()).getMenus().size() ? n2 : -1;
        Menu menu = this.focusedMenu = this.focusedMenuIndex != -1 ? (Menu)((MenuBar)this.getSkinnable()).getMenus().get(n2) : null;
        if (this.focusedMenuIndex != -1) {
            this.openMenuButton = (MenuBarButton)this.container.getChildren().get(this.focusedMenuIndex);
            this.openMenuButton.setHover();
        }
    }

    public static void setDefaultSystemMenuBar(MenuBar menuBar) {
        if (Toolkit.getToolkit().getSystemMenu().isSupported()) {
            wrappedDefaultMenus.clear();
            for (Menu menu : menuBar.getMenus()) {
                wrappedDefaultMenus.add(GlobalMenuAdapter.adapt(menu));
            }
            menuBar.getMenus().addListener(object22 -> {
                wrappedDefaultMenus.clear();
                for (Menu menu : ((MenuBar)((Object)menuBar)).getMenus()) {
                    wrappedDefaultMenus.add(GlobalMenuAdapter.adapt(menu));
                }
            });
        }
    }

    private static MenuBarSkin getMenuBarSkin(Stage object) {
        if (systemMenuMap == null) {
            return null;
        }
        if ((object = systemMenuMap.get(object)) == null) {
            return null;
        }
        return (MenuBarSkin)((Reference)object).get();
    }

    private static void setSystemMenu(Stage stage) {
        List<MenuBase> list;
        if (stage != null && stage.isFocused()) {
            while (stage != null && stage.getOwner() instanceof Stage && ((list = MenuBarSkin.getMenuBarSkin(stage)) == null || ((MenuBarSkin)((Object)list)).wrappedMenus == null)) {
                stage = (Stage)stage.getOwner();
            }
        } else {
            stage = null;
        }
        if (stage != currentMenuBarStage) {
            MenuBarSkin menuBarSkin;
            list = null;
            if (stage != null && (menuBarSkin = MenuBarSkin.getMenuBarSkin(stage)) != null) {
                list = menuBarSkin.wrappedMenus;
            }
            if (list == null) {
                list = wrappedDefaultMenus;
            }
            Toolkit.getToolkit().getSystemMenu().setMenus(list);
            currentMenuBarStage = stage;
        }
    }

    private static void initSystemMenuBar() {
        systemMenuMap = new WeakHashMap();
        InvalidationListener invalidationListener = observable -> MenuBarSkin.setSystemMenu((Stage)((ReadOnlyProperty)observable).getBean());
        for (Window window : stages) {
            window.focusedProperty().addListener(invalidationListener);
        }
        stages.addListener(listChangeListener$Change -> {
            while (listChangeListener$Change.next()) {
                for (Window window : listChangeListener$Change.getRemoved()) {
                    window.focusedProperty().removeListener(invalidationListener);
                }
                for (Window window : listChangeListener$Change.getAddedSubList()) {
                    window.focusedProperty().addListener(invalidationListener);
                    MenuBarSkin.setSystemMenu((Stage)window);
                }
            }
        });
    }

    public final void setSpacing(double d2) {
        this.spacingProperty().set(this.snapSpaceX(d2));
    }

    public final double getSpacing() {
        if (this.spacing == null) {
            return 0.0;
        }
        MenuBarSkin menuBarSkin = this;
        return menuBarSkin.snapSpaceX(menuBarSkin.spacing.get());
    }

    public final DoubleProperty spacingProperty() {
        if (this.spacing == null) {
            this.spacing = new MenuBarSkin$2(this);
        }
        return this.spacing;
    }

    public final void setContainerAlignment(Pos pos) {
        this.containerAlignmentProperty().set(pos);
    }

    public final Pos getContainerAlignment() {
        if (this.containerAlignment == null) {
            return Pos.TOP_LEFT;
        }
        return (Pos)((Object)this.containerAlignment.get());
    }

    public final ObjectProperty<Pos> containerAlignmentProperty() {
        if (this.containerAlignment == null) {
            this.containerAlignment = new MenuBarSkin$3(this, Pos.TOP_LEFT);
        }
        return this.containerAlignment;
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        if (this.sceneListenerHelper != null) {
            this.sceneListenerHelper.disconnect();
            this.sceneListenerHelper = null;
        }
        this.cleanUpListeners();
        this.cleanUpSystemMenu();
        this.getChildren().remove(this.container);
        super.dispose();
    }

    @Override
    protected double snappedTopInset() {
        if (this.container.getChildren().isEmpty()) {
            return 0.0;
        }
        return super.snappedTopInset();
    }

    @Override
    protected double snappedBottomInset() {
        if (this.container.getChildren().isEmpty()) {
            return 0.0;
        }
        return super.snappedBottomInset();
    }

    @Override
    protected double snappedLeftInset() {
        if (this.container.getChildren().isEmpty()) {
            return 0.0;
        }
        return super.snappedLeftInset();
    }

    @Override
    protected double snappedRightInset() {
        if (this.container.getChildren().isEmpty()) {
            return 0.0;
        }
        return super.snappedRightInset();
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        this.container.resizeRelocate(d2, d3, d4, d5);
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        return ((Node)this.container).minWidth(d2) + this.snappedLeftInset() + this.snappedRightInset();
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        return ((Node)this.container).prefWidth(d2) + this.snappedLeftInset() + this.snappedRightInset();
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        return ((Node)this.container).minHeight(d2) + this.snappedTopInset() + this.snappedBottomInset();
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return ((Node)this.container).prefHeight(d2) + this.snappedTopInset() + this.snappedBottomInset();
    }

    @Override
    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return ((Node)((MenuBar)this.getSkinnable())).prefHeight(-1.0);
    }

    MenuButton getNodeForMenu(int n2) {
        if (n2 < this.container.getChildren().size()) {
            return (MenuBarButton)this.container.getChildren().get(n2);
        }
        return null;
    }

    int getFocusedMenuIndex() {
        return this.focusedMenuIndex;
    }

    private boolean menusContainCustomMenuItem() {
        for (Menu menu : ((MenuBar)this.getSkinnable()).getMenus()) {
            if (!this.menuContainsCustomMenuItem(menu)) continue;
            System.err.println("Warning: MenuBar ignored property useSystemMenuBar because menus contain CustomMenuItem");
            return true;
        }
        return false;
    }

    private boolean menuContainsCustomMenuItem(Menu object) {
        for (MenuItem menuItem : ((Menu)object).getItems()) {
            if (menuItem instanceof CustomMenuItem && !(menuItem instanceof SeparatorMenuItem)) {
                return true;
            }
            if (!(menuItem instanceof Menu) || !this.menuContainsCustomMenuItem((Menu)menuItem)) continue;
            return true;
        }
        return false;
    }

    private int getMenuBarButtonIndex(MenuBarButton menuBarButton) {
        for (int i2 = 0; i2 < this.container.getChildren().size(); ++i2) {
            MenuBarButton menuBarButton2 = (MenuBarButton)this.container.getChildren().get(i2);
            if (menuBarButton != menuBarButton2) continue;
            return i2;
        }
        return -1;
    }

    private void updateActionListeners(MenuItem object, boolean bl2) {
        if (object instanceof Menu) {
            object = (Menu)object;
            if (bl2) {
                ((Menu)object).getItems().addListener(this.menuItemListener);
            } else {
                ((Menu)object).getItems().removeListener(this.menuItemListener);
            }
            for (MenuItem menuItem : ((Menu)object).getItems()) {
                this.updateActionListeners(menuItem, bl2);
            }
            return;
        }
        if (bl2) {
            ((MenuItem)object).addEventHandler(ActionEvent.ACTION, this.menuActionEventHandler);
            return;
        }
        ((MenuItem)object).removeEventHandler(ActionEvent.ACTION, this.menuActionEventHandler);
    }

    private void cleanUpListeners() {
        ((MenuBar)this.getSkinnable()).focusedProperty().removeListener(this.weakMenuBarFocusedPropertyListener);
        for (Menu eventTarget : ((MenuBar)this.getSkinnable()).getMenus()) {
            this.updateActionListeners(eventTarget, false);
            eventTarget.visibleProperty().removeListener(this.weakMenuVisibilityChangeListener);
        }
        for (Node node : this.container.getChildren()) {
            MenuBarButton menuBarButton = (MenuBarButton)node;
            menuBarButton.hide();
            menuBarButton.menu.showingProperty().removeListener(menuBarButton.menuListener);
            menuBarButton.disableProperty().unbind();
            menuBarButton.textProperty().unbind();
            menuBarButton.graphicProperty().unbind();
            menuBarButton.styleProperty().unbind();
            menuBarButton.dispose();
            menuBarButton.setSkin(null);
        }
        this.container.getChildren().clear();
    }

    private void rebuildUI() {
        this.cleanUpListeners();
        if (Toolkit.getToolkit().getSystemMenu().isSupported()) {
            MenuBarSkin object2;
            Scene scene = ((MenuBar)this.getSkinnable()).getScene();
            if (scene != null) {
                if (this.sceneChangeListener == null) {
                    this.sceneChangeListener = (object, iterator, eventTarget2) -> {
                        if (iterator != null && ((Scene)((Object)iterator)).getWindow() instanceof Stage) {
                            object = (Stage)((Scene)((Object)iterator)).getWindow();
                            if ((iterator = MenuBarSkin.getMenuBarSkin((Stage)((Object)object))) == this) {
                                ((MenuBarSkin)((Object)iterator)).wrappedMenus = null;
                                systemMenuMap.remove(object);
                                if (currentMenuBarStage == object) {
                                    currentMenuBarStage = null;
                                    MenuBarSkin.setSystemMenu((Stage)((Object)object));
                                }
                            } else if (((MenuBar)this.getSkinnable()).isUseSystemMenuBar() && iterator != null && ((SkinBase)((Object)iterator)).getSkinnable() != null && ((MenuBar)((SkinBase)((Object)iterator)).getSkinnable()).isUseSystemMenuBar()) {
                                ((MenuBar)((SkinBase)((Object)iterator)).getSkinnable()).setUseSystemMenuBar(false);
                            }
                        }
                        if (eventTarget2 != null && ((MenuBar)this.getSkinnable()).isUseSystemMenuBar() && !this.menusContainCustomMenuItem() && ((Scene)eventTarget2).getWindow() instanceof Stage) {
                            object = (Stage)((Scene)eventTarget2).getWindow();
                            if (systemMenuMap == null) {
                                MenuBarSkin.initSystemMenuBar();
                            }
                            this.wrappedMenus = new ArrayList<MenuBase>();
                            systemMenuMap.put((Stage)((Object)object), new WeakReference<MenuBarSkin>(this));
                            for (Menu menu : ((MenuBar)this.getSkinnable()).getMenus()) {
                                this.wrappedMenus.add(GlobalMenuAdapter.adapt(menu));
                            }
                            currentMenuBarStage = null;
                            MenuBarSkin.setSystemMenu((Stage)((Object)object));
                            ((MenuBar)this.getSkinnable()).requestLayout();
                            Platform.runLater(() -> ((MenuBar)this.getSkinnable()).requestLayout());
                        }
                    };
                    ((MenuBar)this.getSkinnable()).sceneProperty().addListener(this.sceneChangeListener);
                }
                Scene scene2 = scene;
                this.sceneChangeListener.changed(((MenuBar)this.getSkinnable()).sceneProperty(), scene2, scene2);
                if (currentMenuBarStage != null ? MenuBarSkin.getMenuBarSkin(currentMenuBarStage) == this : ((MenuBar)this.getSkinnable()).isUseSystemMenuBar()) {
                    return;
                }
            } else if (currentMenuBarStage != null && (object2 = MenuBarSkin.getMenuBarSkin(currentMenuBarStage)) == this) {
                MenuBarSkin.setSystemMenu(null);
            }
        }
        ((MenuBar)this.getSkinnable()).focusedProperty().addListener(this.weakMenuBarFocusedPropertyListener);
        for (Menu menu : ((MenuBar)this.getSkinnable()).getMenus()) {
            menu.visibleProperty().addListener(this.weakMenuVisibilityChangeListener);
            if (!menu.isVisible()) continue;
            MenuBarButton menuBarButton = new MenuBarButton(this, menu);
            menuBarButton.setFocusTraversable(false);
            menuBarButton.getStyleClass().add("menu");
            menuBarButton.setStyle(menu.getStyle());
            menuBarButton.getItems().setAll((Collection<MenuItem>)menu.getItems());
            this.container.getChildren().add(menuBarButton);
            menuBarButton.menuListener = (observableValue, bl2, bl3) -> {
                if (menu.isShowing()) {
                    menuBarButton.show();
                    MenuBarSkin menuBarSkin = this;
                    menuBarSkin.menuModeStart(menuBarSkin.container.getChildren().indexOf(menuBarButton));
                    return;
                }
                menuBarButton.hide();
            };
            menuBarButton.menu = menu;
            menu.showingProperty().addListener(menuBarButton.menuListener);
            menuBarButton.disableProperty().bindBidirectional(menu.disableProperty());
            menuBarButton.textProperty().bind(menu.textProperty());
            menuBarButton.graphicProperty().bind(menu.graphicProperty());
            menuBarButton.styleProperty().bind(menu.styleProperty());
            menuBarButton.getProperties().addListener(mapChangeListener$Change -> {
                if (mapChangeListener$Change.wasAdded() && "autoHide".equals(mapChangeListener$Change.getKey())) {
                    menuBarButton.getProperties().remove("autoHide");
                    menu.hide();
                }
            });
            menuBarButton.showingProperty().addListener((observableValue, bl2, bl3) -> {
                if (bl3.booleanValue()) {
                    if (this.openMenuButton == null && this.focusedMenuIndex != -1) {
                        this.openMenuButton = (MenuBarButton)this.container.getChildren().get(this.focusedMenuIndex);
                    }
                    if (this.openMenuButton != null && this.openMenuButton != menuBarButton) {
                        this.openMenuButton.clearHover();
                    }
                    this.openMenuButton = menuBarButton;
                    this.showMenu(menu);
                    return;
                }
                this.openMenu = null;
                this.openMenuButton = null;
            });
            menuBarButton.setOnMousePressed(mouseEvent -> {
                this.pendingDismiss = menuBarButton.isShowing();
                if (menuBarButton.getScene().getWindow().isFocused()) {
                    this.showMenu(menu);
                    MenuBarSkin menuBarSkin = this;
                    menuBarSkin.menuModeStart(menuBarSkin.getMenuBarButtonIndex(menuBarButton));
                }
            });
            menuBarButton.setOnMouseReleased(mouseEvent -> {
                if (menuBarButton.getScene().getWindow().isFocused() && this.pendingDismiss) {
                    this.resetOpenMenu();
                }
                this.pendingDismiss = false;
            });
            menuBarButton.setOnMouseEntered(mouseEvent -> {
                if (menuBarButton.getScene() != null && menuBarButton.getScene().getWindow() != null && menuBarButton.getScene().getWindow().isFocused()) {
                    if (this.openMenuButton != null && this.openMenuButton != menuBarButton) {
                        this.openMenuButton.clearHover();
                        this.openMenuButton = null;
                        this.openMenuButton = menuBarButton;
                    }
                    this.updateFocusedIndex();
                    if (this.openMenu != null && this.openMenu != menu) {
                        this.showMenu(menu);
                    }
                }
            });
            this.updateActionListeners(menu, true);
        }
        ((MenuBar)this.getSkinnable()).requestLayout();
    }

    private void cleanUpSystemMenu() {
        if (this.sceneChangeListener != null && this.getSkinnable() != null) {
            ((MenuBar)this.getSkinnable()).sceneProperty().removeListener(this.sceneChangeListener);
            this.sceneChangeListener = null;
        }
        if (currentMenuBarStage != null && MenuBarSkin.getMenuBarSkin(currentMenuBarStage) == this) {
            MenuBarSkin.setSystemMenu(null);
        }
        if (systemMenuMap != null) {
            Iterator<Map.Entry<Stage, Reference<MenuBarSkin>>> iterator = systemMenuMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if ((object = (object = object.getValue()) != null ? (MenuBarSkin)((Reference)object).get() : null) != null && object != this) continue;
                iterator.remove();
            }
        }
    }

    private boolean isMenuEmpty(Menu object) {
        boolean bl2 = true;
        if (object != null) {
            for (MenuItem menuItem : ((Menu)object).getItems()) {
                if (menuItem == null || !menuItem.isVisible()) continue;
                bl2 = false;
            }
        }
        return bl2;
    }

    private void resetOpenMenu() {
        if (this.openMenu != null) {
            this.openMenu.hide();
            this.openMenu = null;
        }
    }

    private void unSelectMenus() {
        this.clearMenuButtonHover();
        if (this.focusedMenuIndex == -1) {
            return;
        }
        if (this.openMenu != null) {
            this.openMenu.hide();
            this.openMenu = null;
        }
        if (this.openMenuButton != null) {
            this.openMenuButton.clearHover();
            this.openMenuButton = null;
        }
        this.menuModeEnd();
    }

    private void menuModeStart(int n2) {
        if (this.focusedMenuIndex == -1) {
            SceneHelper.getSceneAccessor().setTransientFocusContainer(((MenuBar)this.getSkinnable()).getScene(), (Node)((Object)this.getSkinnable()));
        }
        this.setFocusedMenuIndex(n2);
    }

    private void menuModeEnd() {
        if (this.focusedMenuIndex != -1) {
            SceneHelper.getSceneAccessor().setTransientFocusContainer(((MenuBar)this.getSkinnable()).getScene(), null);
            ((MenuBar)this.getSkinnable()).notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_NODE);
        }
        this.setFocusedMenuIndex(-1);
    }

    private void moveToMenu(Direction direction, boolean bl2) {
        bl2 = bl2 && this.focusedMenu.isShowing();
        this.findSibling(direction, this.focusedMenuIndex).ifPresent(pair -> {
            this.setFocusedMenuIndex((Integer)pair.getValue());
            if (bl2) {
                this.showMenu((Menu)pair.getKey(), false);
            }
        });
    }

    private Optional<Pair<Menu, Integer>> findSibling(Direction direction, int n2) {
        if (n2 == -1) {
            return Optional.empty();
        }
        List list = ((MenuBar)this.getSkinnable()).getMenus().stream().filter(MenuItem::isVisible).collect(Collectors.toList());
        int n3 = list.size();
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            ++n4;
            n5 = (n2 + (direction.isForward() ? 1 : -1)) % n3;
            if (n5 == -1) {
                n5 = n3 - 1;
            }
            if (!((Menu)list.get(n5)).isDisable()) break;
            n2 = n5;
        }
        this.clearMenuButtonHover();
        return Optional.of(new Pair<Menu, Integer>((Menu)list.get(n5), n5));
    }

    private void updateFocusedIndex() {
        int n2 = 0;
        for (Node node : this.container.getChildren()) {
            if (node.isHover()) {
                this.setFocusedMenuIndex(n2);
                return;
            }
            ++n2;
        }
        this.menuModeEnd();
    }

    private void clearMenuButtonHover() {
        for (Node node : this.container.getChildren()) {
            if (!node.isHover()) continue;
            ((MenuBarButton)node).clearHover();
            ((MenuBarButton)node).disarm();
            return;
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return MenuBarSkin.getClassCssMetaData();
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case FOCUS_NODE: {
                return this.openMenuButton;
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    static {
        Object object = window -> window instanceof Stage;
        Object object2 = AccessController.doPrivileged(() -> Window.getWindows(), null, FXPermissions.ACCESS_WINDOW_LIST_PERMISSION);
        stages = object2.filtered(object);
        wrappedDefaultMenus = new ArrayList<MenuBase>();
        SPACING = new MenuBarSkin$4("-fx-spacing", SizeConverter.getInstance(), 0.0);
        ALIGNMENT = new MenuBarSkin$5("-fx-alignment", new EnumConverter<Pos>(Pos.class), Pos.TOP_LEFT);
        object = new ArrayList(SkinBase.getClassCssMetaData());
        object2 = ALIGNMENT.getProperty();
        int n2 = object.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CssMetaData cssMetaData = (CssMetaData)object.get(i2);
            if (!((String)object2).equals(cssMetaData.getProperty())) continue;
            object.remove(cssMetaData);
        }
        object.add(SPACING);
        object.add(ALIGNMENT);
        STYLEABLES = Collections.unmodifiableList(object);
    }
}

