/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.NodeOrientation;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.skin.TableColumnHeader;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TableSkinUtils;
import javafx.scene.control.skin.TableViewSkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;

public class NestedTableColumnHeader
extends TableColumnHeader {
    static final String DEFAULT_STYLE_CLASS = "nested-column-header";
    private static final int DRAG_RECT_WIDTH = 4;
    private static final String TABLE_COLUMN_KEY = "TableColumn";
    private static final String TABLE_COLUMN_HEADER_KEY = "TableColumnHeader";
    private ObservableList<? extends TableColumnBase> columns;
    private TableColumnHeader label;
    private ObservableList<TableColumnHeader> columnHeaders;
    private ObservableList<TableColumnHeader> unmodifiableColumnHeaders;
    private double lastX = 0.0;
    private double dragAnchorX = 0.0;
    private Map<TableColumnBase<?, ?>, Rectangle> dragRects = new WeakHashMap();
    boolean updateColumns = true;
    private final ListChangeListener<TableColumnBase> columnsListener = listChangeListener$Change -> this.setHeadersNeedUpdate();
    private final WeakListChangeListener weakColumnsListener = new WeakListChangeListener<TableColumnBase>(this.columnsListener);
    private static final EventHandler<MouseEvent> rectMousePressed = mouseEvent -> {
        Rectangle rectangle;
        Node node = (Rectangle)mouseEvent.getSource();
        TableColumnBase tableColumnBase = (TableColumnBase)node.getProperties().get(TABLE_COLUMN_KEY);
        if (!((NestedTableColumnHeader)(node = (NestedTableColumnHeader)node.getProperties().get(TABLE_COLUMN_HEADER_KEY))).isColumnResizingEnabled()) {
            return;
        }
        if (((TableColumnHeader)node).getTableHeaderRow().columnDragLock) {
            return;
        }
        if (mouseEvent.isConsumed()) {
            return;
        }
        mouseEvent.consume();
        if (mouseEvent.getClickCount() == 2 && mouseEvent.isPrimaryButtonDown()) {
            TableHeaderRow tableHeaderRow = ((TableColumnHeader)node).getTableHeaderRow();
            TableColumnHeader tableColumnHeader = tableHeaderRow.getColumnHeaderFor(tableColumnBase);
            if (tableColumnHeader != null) {
                tableColumnHeader.resizeColumnToFitContent(-1);
            }
            return;
        }
        Rectangle rectangle2 = rectangle = (Rectangle)mouseEvent.getSource();
        double d2 = ((TableColumnHeader)node).getTableHeaderRow().sceneToLocal(rectangle2.localToScene(rectangle2.getBoundsInLocal())).getMinX() + 2.0;
        ((NestedTableColumnHeader)node).dragAnchorX = mouseEvent.getSceneX();
        ((NestedTableColumnHeader)node).columnResizingStarted(d2);
    };
    private static final EventHandler<MouseEvent> rectMouseDragged = mouseEvent -> {
        Node node = (Rectangle)mouseEvent.getSource();
        TableColumnBase tableColumnBase = (TableColumnBase)node.getProperties().get(TABLE_COLUMN_KEY);
        if (!((NestedTableColumnHeader)(node = (NestedTableColumnHeader)node.getProperties().get(TABLE_COLUMN_HEADER_KEY))).isColumnResizingEnabled()) {
            return;
        }
        if (((TableColumnHeader)node).getTableHeaderRow().columnDragLock) {
            return;
        }
        if (mouseEvent.isConsumed()) {
            return;
        }
        mouseEvent.consume();
        ((NestedTableColumnHeader)node).columnResizing(tableColumnBase, (MouseEvent)mouseEvent);
    };
    private static final EventHandler<MouseEvent> rectMouseReleased = mouseEvent -> {
        Node node = (Rectangle)mouseEvent.getSource();
        TableColumnBase tableColumnBase = (TableColumnBase)node.getProperties().get(TABLE_COLUMN_KEY);
        if (!((NestedTableColumnHeader)(node = (NestedTableColumnHeader)node.getProperties().get(TABLE_COLUMN_HEADER_KEY))).isColumnResizingEnabled()) {
            return;
        }
        if (((TableColumnHeader)node).getTableHeaderRow().columnDragLock) {
            return;
        }
        if (mouseEvent.isConsumed()) {
            return;
        }
        mouseEvent.consume();
        ((NestedTableColumnHeader)node).columnResizingComplete(tableColumnBase, (MouseEvent)mouseEvent);
    };
    private static final EventHandler<MouseEvent> rectCursorChangeListener = object -> {
        object = (Rectangle)((EventObject)object).getSource();
        TableColumnBase tableColumnBase = (TableColumnBase)((Node)((Object)object)).getProperties().get(TABLE_COLUMN_KEY);
        NestedTableColumnHeader nestedTableColumnHeader = (NestedTableColumnHeader)((Node)((Object)object)).getProperties().get(TABLE_COLUMN_HEADER_KEY);
        if (nestedTableColumnHeader.getTableHeaderRow().columnDragLock) {
            return;
        }
        if (nestedTableColumnHeader.getCursor() == null) {
            ((Node)((Object)object)).setCursor(nestedTableColumnHeader.isColumnResizingEnabled() && ((Node)((Object)object)).isHover() && tableColumnBase.isResizable() ? Cursor.H_RESIZE : null);
        }
    };

    public NestedTableColumnHeader(TableColumnBase tableColumnBase) {
        super(tableColumnBase);
        this.setFocusTraversable(false);
        this.label = this.createTableColumnHeader(this.getTableColumn());
        this.label.setTableHeaderRow(this.getTableHeaderRow());
        this.label.setParentHeader(this.getParentHeader());
        this.label.setNestedColumnHeader(this);
        if (this.getTableColumn() != null) {
            this.changeListenerHandler.registerChangeListener(this.getTableColumn().textProperty(), observableValue -> this.label.setVisible(this.getTableColumn().getText() != null && !this.getTableColumn().getText().isEmpty()));
        }
    }

    @Override
    void dispose() {
        super.dispose();
        if (this.label != null) {
            this.label.dispose();
        }
        if (this.getColumns() != null) {
            this.getColumns().removeListener(this.weakColumnsListener);
        }
        for (int i2 = 0; i2 < this.getColumnHeaders().size(); ++i2) {
            TableColumnHeader node = (TableColumnHeader)this.getColumnHeaders().get(i2);
            node.dispose();
        }
        for (Rectangle rectangle : this.dragRects.values()) {
            if (rectangle == null) continue;
            rectangle.visibleProperty().unbind();
        }
        this.dragRects.clear();
        this.getChildren().clear();
        this.changeListenerHandler.dispose();
    }

    public final ObservableList<TableColumnHeader> getColumnHeaders() {
        if (this.columnHeaders == null) {
            this.columnHeaders = FXCollections.observableArrayList();
            this.unmodifiableColumnHeaders = FXCollections.unmodifiableObservableList(this.columnHeaders);
        }
        return this.unmodifiableColumnHeaders;
    }

    @Override
    protected void layoutChildren() {
        double d2 = this.getWidth() - this.snappedLeftInset() - this.snappedRightInset();
        double d3 = this.getHeight() - this.snappedTopInset() - this.snappedBottomInset();
        int n2 = 0;
        if (this.label.isVisible() && this.getTableColumn() != null) {
            n2 = (int)((Node)this.label).prefHeight(-1.0);
            ((Node)this.label).resize(d2, n2);
            this.label.relocate(this.snappedLeftInset(), this.snappedTopInset());
        }
        double d4 = this.snappedLeftInset();
        double d5 = this.snapSizeY(d3 - (double)n2);
        int n3 = this.getColumnHeaders().size();
        for (int i2 = 0; i2 < n3; ++i2) {
            TableColumnHeader tableColumnHeader = (TableColumnHeader)this.getColumnHeaders().get(i2);
            if (!tableColumnHeader.isVisible()) continue;
            double d6 = ((Node)tableColumnHeader).prefWidth(d5);
            ((Node)tableColumnHeader).resize(d6, d5);
            tableColumnHeader.relocate(d4, (double)n2 + this.snappedTopInset());
            d4 += d6;
            Rectangle rectangle = this.dragRects.get(tableColumnHeader.getTableColumn());
            if (rectangle == null) continue;
            rectangle.setHeight(tableColumnHeader.getDragRectHeight());
            rectangle.relocate(d4 - 2.0, this.snappedTopInset() + (double)n2);
        }
    }

    @Override
    protected double computePrefWidth(double d2) {
        this.checkState();
        double d3 = 0.0;
        if (this.getColumns() != null) {
            for (TableColumnHeader tableColumnHeader : this.getColumnHeaders()) {
                if (!tableColumnHeader.isVisible()) continue;
                d3 += tableColumnHeader.computePrefWidth(d2);
            }
        }
        return d3;
    }

    @Override
    protected double computePrefHeight(double d2) {
        this.checkState();
        double d3 = 0.0;
        if (this.getColumnHeaders() != null) {
            for (TableColumnHeader tableColumnHeader : this.getColumnHeaders()) {
                d3 = Math.max(d3, ((Node)tableColumnHeader).prefHeight(-1.0));
            }
        }
        double d4 = 0.0;
        if (this.label.isVisible() && this.getTableColumn() != null) {
            d4 = ((Node)this.label).prefHeight(-1.0);
        }
        return d3 + d4 + this.snappedTopInset() + this.snappedBottomInset();
    }

    protected TableColumnHeader createTableColumnHeader(TableColumnBase tableColumnBase) {
        if (tableColumnBase == null || tableColumnBase.getColumns().isEmpty() || tableColumnBase == this.getTableColumn()) {
            return new TableColumnHeader(tableColumnBase);
        }
        return new NestedTableColumnHeader(tableColumnBase);
    }

    @Override
    void initStyleClasses() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.installTableColumnStyleClassListener();
    }

    @Override
    void setTableHeaderRow(TableHeaderRow tableHeaderRow) {
        super.setTableHeaderRow(tableHeaderRow);
        if (this.getTableSkin() != null) {
            this.changeListenerHandler.registerChangeListener(TableSkinUtils.columnResizePolicyProperty(this.getTableSkin()), observableValue -> this.updateContent());
        }
        this.label.setTableHeaderRow(tableHeaderRow);
        for (TableColumnHeader tableColumnHeader : this.getColumnHeaders()) {
            tableColumnHeader.setTableHeaderRow(tableHeaderRow);
        }
    }

    @Override
    void setParentHeader(NestedTableColumnHeader nestedTableColumnHeader) {
        super.setParentHeader(nestedTableColumnHeader);
        this.label.setParentHeader(nestedTableColumnHeader);
    }

    ObservableList<? extends TableColumnBase> getColumns() {
        return this.columns;
    }

    void setColumns(ObservableList<? extends TableColumnBase> observableList) {
        if (this.columns != null) {
            this.columns.removeListener(this.weakColumnsListener);
        }
        this.columns = observableList;
        if (this.columns != null) {
            this.columns.addListener(this.weakColumnsListener);
        }
    }

    void updateTableColumnHeaders() {
        if (this.getTableColumn() == null && this.getTableSkin() != null) {
            NestedTableColumnHeader nestedTableColumnHeader = this;
            nestedTableColumnHeader.setColumns(TableSkinUtils.getColumns(nestedTableColumnHeader.getTableSkin()));
        } else if (this.getTableColumn() != null) {
            NestedTableColumnHeader nestedTableColumnHeader = this;
            nestedTableColumnHeader.setColumns(nestedTableColumnHeader.getTableColumn().getColumns());
        }
        if (this.getColumns().isEmpty()) {
            for (int i2 = 0; i2 < this.getColumnHeaders().size(); ++i2) {
                TableColumnHeader observableList = (TableColumnHeader)this.getColumnHeaders().get(i2);
                observableList.dispose();
            }
            var1_2 = this.getParentHeader();
            if (var1_2 != null) {
                ObservableList<TableColumnHeader> observableList = ((NestedTableColumnHeader)var1_2).getColumnHeaders();
                var3_9 = observableList.indexOf(this);
                if (var3_9 >= 0 && var3_9 < observableList.size()) {
                    NestedTableColumnHeader nestedTableColumnHeader = this;
                    observableList.set(var3_9, nestedTableColumnHeader.createColumnHeader(nestedTableColumnHeader.getTableColumn()));
                }
            } else {
                this.columnHeaders.clear();
            }
        } else {
            var1_2 = new ArrayList<TableColumnHeader>(this.getColumnHeaders());
            ArrayList<TableColumnHeader> arrayList = new ArrayList<TableColumnHeader>();
            for (var3_9 = 0; var3_9 < this.getColumns().size(); ++var3_9) {
                TableColumnBase tableColumnBase = (TableColumnBase)this.getColumns().get(var3_9);
                if (tableColumnBase == null || !tableColumnBase.isVisible()) continue;
                boolean bl2 = false;
                for (int i2 = 0; i2 < var1_2.size(); ++i2) {
                    TableColumnHeader tableColumnHeader = (TableColumnHeader)var1_2.get(i2);
                    if (!tableColumnHeader.represents(tableColumnBase)) continue;
                    arrayList.add(tableColumnHeader);
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                arrayList.add(this.createColumnHeader(tableColumnBase));
            }
            this.columnHeaders.setAll((Collection<TableColumnHeader>)arrayList);
            var1_2.removeAll(arrayList);
            for (var3_9 = 0; var3_9 < var1_2.size(); ++var3_9) {
                ((TableColumnHeader)var1_2.get(var3_9)).dispose();
            }
        }
        this.updateContent();
        for (TableColumnHeader tableColumnHeader : this.getColumnHeaders()) {
            tableColumnHeader.applyCss();
        }
    }

    @Override
    boolean represents(TableColumnBase<?, ?> tableColumnBase) {
        int n2;
        if (tableColumnBase.getColumns().isEmpty()) {
            return false;
        }
        if (tableColumnBase != this.getTableColumn()) {
            return false;
        }
        int n3 = tableColumnBase.getColumns().size();
        if (n3 != (n2 = this.getColumnHeaders().size())) {
            return false;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            TableColumnBase tableColumnBase2 = (TableColumnBase)tableColumnBase.getColumns().get(n2);
            TableColumnHeader tableColumnHeader = (TableColumnHeader)this.getColumnHeaders().get(n2);
            if (tableColumnHeader.represents(tableColumnBase2)) continue;
            return false;
        }
        return true;
    }

    @Override
    double getDragRectHeight() {
        return ((Node)this.label).prefHeight(-1.0);
    }

    void setHeadersNeedUpdate() {
        this.updateColumns = true;
        for (int i2 = 0; i2 < this.getColumnHeaders().size(); ++i2) {
            TableColumnHeader tableColumnHeader = (TableColumnHeader)this.getColumnHeaders().get(i2);
            if (!(tableColumnHeader instanceof NestedTableColumnHeader)) continue;
            ((NestedTableColumnHeader)tableColumnHeader).setHeadersNeedUpdate();
        }
        this.requestLayout();
    }

    private void updateContent() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(this.label);
        arrayList.addAll(this.getColumnHeaders());
        if (this.isColumnResizingEnabled()) {
            this.rebuildDragRects();
            arrayList.addAll(this.dragRects.values());
        }
        this.getChildren().setAll((Collection<Node>)arrayList);
    }

    /*
     * WARNING - void declaration
     */
    private void rebuildDragRects() {
        void var2_5;
        if (!this.isColumnResizingEnabled()) {
            return;
        }
        this.getChildren().removeAll(this.dragRects.values());
        for (Rectangle tableViewSkinBase2 : this.dragRects.values()) {
            tableViewSkinBase2.visibleProperty().unbind();
        }
        this.dragRects.clear();
        ObservableList<? extends TableColumnBase> observableList = this.getColumns();
        if (observableList == null) {
            return;
        }
        TableViewSkinBase<?, ?, ?, ?, ?> i2 = this.getTableSkin();
        Callback callback = (Callback)TableSkinUtils.columnResizePolicyProperty(i2).get();
        boolean bl2 = TableSkinUtils.isConstrainedResizePolicy(callback);
        if (bl2 && TableSkinUtils.getVisibleLeafColumns(i2).size() == 1) {
            return;
        }
        boolean bl3 = false;
        while (!(var2_5 >= observableList.size() || bl2 && var2_5 == this.getColumns().size() - 1)) {
            TableColumnBase tableColumnBase = (TableColumnBase)observableList.get((int)var2_5);
            Rectangle rectangle = new Rectangle();
            rectangle.getProperties().put(TABLE_COLUMN_KEY, tableColumnBase);
            rectangle.getProperties().put(TABLE_COLUMN_HEADER_KEY, this);
            rectangle.setWidth(4.0);
            rectangle.setHeight(this.getHeight() - this.label.getHeight());
            rectangle.setFill(Color.TRANSPARENT);
            rectangle.visibleProperty().bind(tableColumnBase.visibleProperty().and(tableColumnBase.resizableProperty()));
            rectangle.setOnMousePressed(rectMousePressed);
            rectangle.setOnMouseDragged(rectMouseDragged);
            rectangle.setOnMouseReleased(rectMouseReleased);
            rectangle.setOnMouseEntered(rectCursorChangeListener);
            rectangle.setOnMouseExited(rectCursorChangeListener);
            this.dragRects.put(tableColumnBase, rectangle);
            ++var2_5;
        }
    }

    private void checkState() {
        if (this.updateColumns) {
            this.updateTableColumnHeaders();
            this.updateColumns = false;
        }
    }

    private TableColumnHeader createColumnHeader(TableColumnBase eventTarget) {
        eventTarget = this.createTableColumnHeader((TableColumnBase)eventTarget);
        ((TableColumnHeader)eventTarget).setTableHeaderRow(this.getTableHeaderRow());
        ((TableColumnHeader)eventTarget).setParentHeader(this);
        return eventTarget;
    }

    private boolean isColumnResizingEnabled() {
        return true;
    }

    private void columnResizingStarted(double d2) {
        this.setCursor(Cursor.H_RESIZE);
        this.columnReorderLine.setLayoutX(d2);
    }

    private void columnResizing(TableColumnBase tableColumnBase, MouseEvent mouseEvent) {
        double d2 = mouseEvent.getSceneX() - this.dragAnchorX;
        if (this.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
            d2 = -d2;
        }
        double d3 = d2 - this.lastX;
        boolean bl2 = TableSkinUtils.resizeColumn(this.getTableSkin(), tableColumnBase, d3);
        if (bl2) {
            this.lastX = d2;
        }
    }

    private void columnResizingComplete(TableColumnBase tableColumnBase, MouseEvent mouseEvent) {
        this.setCursor(null);
        this.columnReorderLine.setTranslateX(0.0);
        this.columnReorderLine.setLayoutX(0.0);
        this.lastX = 0.0;
    }
}

