/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Pagination;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.skin.PaginationSkin;
import javafx.scene.control.skin.PaginationSkin$IndicatorButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;

class PaginationSkin$NavigationControl
extends StackPane {
    private HBox controlBox;
    private Button leftArrowButton;
    private StackPane leftArrow;
    private Button rightArrowButton;
    private StackPane rightArrow;
    private ToggleGroup indicatorButtons;
    private Label pageInformation;
    private double minButtonSize = -1.0;
    private int previousIndicatorCount = 0;
    final /* synthetic */ PaginationSkin this$0;

    public PaginationSkin$NavigationControl(PaginationSkin paginationSkin) {
        this.this$0 = paginationSkin;
        this.getStyleClass().setAll((String[])new String[]{"pagination-control"});
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, paginationSkin.behavior::mousePressed);
        this.controlBox = new HBox();
        this.controlBox.getStyleClass().add("control-box");
        this.leftArrowButton = new Button();
        this.leftArrowButton.setAccessibleText(ControlResources.getString("Accessibility.title.Pagination.PreviousButton"));
        this.minButtonSize = this.leftArrowButton.getFont().getSize() * 2.0;
        this.leftArrowButton.fontProperty().addListener((object, object22, font) -> {
            void var3_5;
            this.minButtonSize = var3_5.getSize() * 2.0;
            for (Node node : this.controlBox.getChildren()) {
                ((Control)node).setMinSize(this.minButtonSize, this.minButtonSize);
            }
            ((Parent)this).requestLayout();
        });
        this.leftArrowButton.setMinSize(this.minButtonSize, this.minButtonSize);
        this.leftArrowButton.prefWidthProperty().bind(this.leftArrowButton.minWidthProperty());
        this.leftArrowButton.prefHeightProperty().bind(this.leftArrowButton.minHeightProperty());
        this.leftArrowButton.getStyleClass().add("left-arrow-button");
        this.leftArrowButton.setFocusTraversable(false);
        HBox.setMargin(this.leftArrowButton, new Insets(0.0, this.snapSizeX(paginationSkin.arrowButtonGap.get()), 0.0, 0.0));
        this.leftArrow = new StackPane();
        this.leftArrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.leftArrowButton.setGraphic(this.leftArrow);
        this.leftArrow.getStyleClass().add("left-arrow");
        this.rightArrowButton = new Button();
        this.rightArrowButton.setAccessibleText(ControlResources.getString("Accessibility.title.Pagination.NextButton"));
        this.rightArrowButton.setMinSize(this.minButtonSize, this.minButtonSize);
        this.rightArrowButton.prefWidthProperty().bind(this.rightArrowButton.minWidthProperty());
        this.rightArrowButton.prefHeightProperty().bind(this.rightArrowButton.minHeightProperty());
        this.rightArrowButton.getStyleClass().add("right-arrow-button");
        this.rightArrowButton.setFocusTraversable(false);
        HBox.setMargin(this.rightArrowButton, new Insets(0.0, 0.0, 0.0, this.snapSizeX(paginationSkin.arrowButtonGap.get())));
        this.rightArrow = new StackPane();
        this.rightArrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.rightArrowButton.setGraphic(this.rightArrow);
        this.rightArrow.getStyleClass().add("right-arrow");
        this.indicatorButtons = new ToggleGroup();
        this.pageInformation = new Label();
        this.pageInformation.getStyleClass().add("page-information");
        this.getChildren().addAll((Node[])new Node[]{this.controlBox, this.pageInformation});
        this.initializeNavigationHandlers();
        this.initializePageIndicators();
        this.updatePageIndex();
        paginationSkin.arrowButtonGap.addListener((observableValue, number, number2) -> {
            if (number2.doubleValue() == 0.0) {
                HBox.setMargin(this.leftArrowButton, null);
                HBox.setMargin(this.rightArrowButton, null);
                return;
            }
            HBox.setMargin(this.leftArrowButton, new Insets(0.0, this.snapSizeX(number2.doubleValue()), 0.0, 0.0));
            HBox.setMargin(this.rightArrowButton, new Insets(0.0, 0.0, 0.0, this.snapSizeX(number2.doubleValue())));
        });
    }

    private void initializeNavigationHandlers() {
        this.leftArrowButton.setOnAction(actionEvent -> {
            this.this$0.getNode().requestFocus();
            this.this$0.selectPrevious();
            ((Parent)this).requestLayout();
        });
        this.rightArrowButton.setOnAction(actionEvent -> {
            this.this$0.getNode().requestFocus();
            this.this$0.selectNext();
            ((Parent)this).requestLayout();
        });
        ListenerHelper.get(this.this$0).addChangeListener(((Pagination)this.this$0.getSkinnable()).currentPageIndexProperty(), (observableValue, number, number2) -> {
            this.this$0.previousIndex = number.intValue();
            this.this$0.currentIndex = number2.intValue();
            this.updatePageIndex();
            if (this.this$0.animate) {
                this.this$0.currentAnimatedIndex = this.this$0.currentIndex;
                this.this$0.animateSwitchPage();
                return;
            }
            this.this$0.createPage(this.this$0.currentStackPane, this.this$0.currentIndex);
        });
    }

    private void initializePageIndicators() {
        this.previousIndicatorCount = 0;
        this.controlBox.getChildren().clear();
        this.clearIndicatorButtons();
        this.controlBox.getChildren().add(this.leftArrowButton);
        for (int i2 = this.this$0.fromIndex; i2 <= this.this$0.toIndex; ++i2) {
            PaginationSkin$IndicatorButton paginationSkin$IndicatorButton = new PaginationSkin$IndicatorButton(this.this$0, i2);
            paginationSkin$IndicatorButton.setMinSize(this.minButtonSize, this.minButtonSize);
            paginationSkin$IndicatorButton.setToggleGroup(this.indicatorButtons);
            this.controlBox.getChildren().add(paginationSkin$IndicatorButton);
        }
        this.controlBox.getChildren().add(this.rightArrowButton);
    }

    private void clearIndicatorButtons() {
        this.indicatorButtons.getToggles().clear();
    }

    private void updatePageIndicators() {
        for (int i2 = 0; i2 < this.indicatorButtons.getToggles().size(); ++i2) {
            PaginationSkin$IndicatorButton paginationSkin$IndicatorButton = (PaginationSkin$IndicatorButton)this.indicatorButtons.getToggles().get(i2);
            if (paginationSkin$IndicatorButton.getPageNumber() != this.this$0.currentIndex) continue;
            paginationSkin$IndicatorButton.setSelected(true);
            this.updatePageInformation();
            break;
        }
        ((Pagination)this.this$0.getSkinnable()).notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_ITEM);
    }

    private void updatePageIndex() {
        if (this.this$0.pageCount == this.this$0.maxPageIndicatorCount && this.changePageSet()) {
            this.initializePageIndicators();
        }
        this.updatePageIndicators();
        ((Parent)this).requestLayout();
    }

    private void updatePageInformation() {
        String string = Integer.toString(this.this$0.currentIndex + 1);
        String string2 = this.this$0.getPageCount() == Integer.MAX_VALUE ? "..." : Integer.toString(this.this$0.getPageCount());
        this.pageInformation.setText(string + "/" + string2);
    }

    private void layoutPageIndicators() {
        int n2;
        double d2 = this.snappedLeftInset();
        double d3 = this.snappedRightInset();
        PaginationSkin$NavigationControl paginationSkin$NavigationControl = this;
        double d4 = paginationSkin$NavigationControl.snapSizeX(paginationSkin$NavigationControl.getWidth()) - (d2 + d3);
        double d5 = this.controlBox.snappedLeftInset();
        double d6 = this.controlBox.snappedRightInset();
        PaginationSkin$NavigationControl paginationSkin$NavigationControl2 = this;
        double d7 = paginationSkin$NavigationControl2.snapSizeX(Utils.boundedSize(((Node)paginationSkin$NavigationControl2.leftArrowButton).prefWidth(-1.0), ((Node)this.leftArrowButton).minWidth(-1.0), ((Node)this.leftArrowButton).maxWidth(-1.0)));
        PaginationSkin$NavigationControl paginationSkin$NavigationControl3 = this;
        double d8 = paginationSkin$NavigationControl3.snapSizeX(Utils.boundedSize(((Node)paginationSkin$NavigationControl3.rightArrowButton).prefWidth(-1.0), ((Node)this.rightArrowButton).minWidth(-1.0), ((Node)this.rightArrowButton).maxWidth(-1.0)));
        PaginationSkin$NavigationControl paginationSkin$NavigationControl4 = this;
        double d9 = paginationSkin$NavigationControl4.snapSizeX(paginationSkin$NavigationControl4.controlBox.getSpacing());
        double d10 = d4 - (d5 + d7 + 2.0 * this.this$0.arrowButtonGap.get() + d9 + d8 + d6);
        if (this.this$0.isPageInformationVisible() && (Side.LEFT.equals((Object)this.this$0.getPageInformationAlignment()) || Side.RIGHT.equals((Object)this.this$0.getPageInformationAlignment()))) {
            PaginationSkin$NavigationControl paginationSkin$NavigationControl5 = this;
            d10 -= paginationSkin$NavigationControl5.snapSizeX(((Node)paginationSkin$NavigationControl5.pageInformation).prefWidth(-1.0));
        }
        double d11 = 0.0;
        int n3 = 0;
        for (n2 = 0; n2 < this.this$0.getMaxPageIndicatorCount(); ++n2) {
            int n4 = n2 < this.indicatorButtons.getToggles().size() ? n2 : this.indicatorButtons.getToggles().size() - 1;
            double d12 = this.minButtonSize;
            if (n4 != -1) {
                PaginationSkin$IndicatorButton paginationSkin$IndicatorButton = (PaginationSkin$IndicatorButton)this.indicatorButtons.getToggles().get(n4);
                d12 = this.snapSizeX(Utils.boundedSize(((Node)paginationSkin$IndicatorButton).prefWidth(-1.0), ((Node)paginationSkin$IndicatorButton).minWidth(-1.0), ((Node)paginationSkin$IndicatorButton).maxWidth(-1.0)));
            }
            if ((d11 += d12 + d9) > d10) break;
            ++n3;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        if (n3 != this.previousIndicatorCount) {
            this.this$0.maxPageIndicatorCount = n3 < this.this$0.getMaxPageIndicatorCount() ? n3 : this.this$0.getMaxPageIndicatorCount();
            if (this.this$0.pageCount > this.this$0.maxPageIndicatorCount) {
                this.this$0.pageCount = this.this$0.maxPageIndicatorCount;
                n2 = this.this$0.maxPageIndicatorCount - 1;
            } else if (n3 > this.this$0.getPageCount()) {
                this.this$0.pageCount = this.this$0.getPageCount();
                n2 = this.this$0.getPageCount() - 1;
            } else {
                this.this$0.pageCount = n3;
                n2 = n3 - 1;
            }
            if (this.this$0.currentIndex >= this.this$0.toIndex) {
                this.this$0.toIndex = this.this$0.currentIndex;
                this.this$0.fromIndex = this.this$0.toIndex - n2;
            } else {
                if (this.this$0.currentIndex <= this.this$0.fromIndex) {
                    this.this$0.fromIndex = this.this$0.currentIndex;
                }
                this.this$0.toIndex = this.this$0.fromIndex + n2;
            }
            if (this.this$0.toIndex > this.this$0.getPageCount() - 1) {
                this.this$0.toIndex = this.this$0.getPageCount() - 1;
            }
            if (this.this$0.fromIndex < 0) {
                this.this$0.fromIndex = 0;
                this.this$0.toIndex = this.this$0.fromIndex + n2;
            }
            this.initializePageIndicators();
            this.updatePageIndicators();
            this.previousIndicatorCount = n3;
        }
    }

    private boolean changePageSet() {
        PaginationSkin$NavigationControl paginationSkin$NavigationControl = this;
        int n2 = paginationSkin$NavigationControl.indexToIndicatorButtonsIndex(paginationSkin$NavigationControl.this$0.currentIndex);
        int n3 = this.this$0.maxPageIndicatorCount - 1;
        if (this.this$0.previousIndex < this.this$0.currentIndex && n2 == 0 && n3 != 0 && n2 % n3 == 0) {
            this.this$0.fromIndex = this.this$0.currentIndex;
            this.this$0.toIndex = this.this$0.fromIndex + n3;
        } else if (this.this$0.currentIndex < this.this$0.previousIndex && n2 == n3 && n3 != 0 && n2 % n3 == 0) {
            this.this$0.toIndex = this.this$0.currentIndex;
            this.this$0.fromIndex = this.this$0.toIndex - n3;
        } else if (this.this$0.currentIndex < this.this$0.fromIndex || this.this$0.currentIndex > this.this$0.toIndex) {
            this.this$0.fromIndex = this.this$0.currentIndex - n2;
            this.this$0.toIndex = this.this$0.fromIndex + n3;
        } else {
            return false;
        }
        if (this.this$0.toIndex > this.this$0.getPageCount() - 1) {
            if (this.this$0.fromIndex > this.this$0.getPageCount() - 1) {
                return false;
            }
            this.this$0.toIndex = this.this$0.getPageCount() - 1;
        }
        if (this.this$0.fromIndex < 0) {
            this.this$0.fromIndex = 0;
            this.this$0.toIndex = this.this$0.fromIndex + n3;
        }
        return true;
    }

    private int indexToIndicatorButtonsIndex(int n2) {
        if (n2 >= this.this$0.fromIndex && n2 <= this.this$0.toIndex) {
            return n2 - this.this$0.fromIndex;
        }
        int n3 = 0;
        int n4 = this.this$0.fromIndex;
        int n5 = this.this$0.toIndex;
        if (this.this$0.currentIndex > this.this$0.previousIndex) {
            while (n4 < this.this$0.getPageCount() && n5 < this.this$0.getPageCount()) {
                if (n2 >= (n4 += n3) && n2 <= (n5 += n3)) {
                    if (n2 == n4) {
                        return 0;
                    }
                    if (n2 == n5) {
                        return this.this$0.maxPageIndicatorCount - 1;
                    }
                    return n2 - n4;
                }
                n3 += this.this$0.maxPageIndicatorCount;
            }
        } else {
            while (n4 > 0 && n5 > 0) {
                if (n2 >= (n4 -= n3) && n2 <= (n5 -= n3)) {
                    if (n2 == n4) {
                        return 0;
                    }
                    if (n2 == n5) {
                        return this.this$0.maxPageIndicatorCount - 1;
                    }
                    return n2 - n4;
                }
                n3 += this.this$0.maxPageIndicatorCount;
            }
        }
        return this.this$0.maxPageIndicatorCount - 1;
    }

    private Pos sideToPos(Side side) {
        if (Side.TOP.equals((Object)side)) {
            return Pos.TOP_CENTER;
        }
        if (Side.RIGHT.equals((Object)side)) {
            return Pos.CENTER_RIGHT;
        }
        if (Side.BOTTOM.equals((Object)side)) {
            return Pos.BOTTOM_CENTER;
        }
        return Pos.CENTER_LEFT;
    }

    @Override
    protected double computeMinWidth(double d2) {
        double d3 = this.snappedLeftInset();
        double d4 = this.snappedRightInset();
        PaginationSkin$NavigationControl paginationSkin$NavigationControl = this;
        double d5 = paginationSkin$NavigationControl.snapSizeX(Utils.boundedSize(((Node)paginationSkin$NavigationControl.leftArrowButton).prefWidth(-1.0), ((Node)this.leftArrowButton).minWidth(-1.0), ((Node)this.leftArrowButton).maxWidth(-1.0)));
        PaginationSkin$NavigationControl paginationSkin$NavigationControl2 = this;
        double d6 = paginationSkin$NavigationControl2.snapSizeX(Utils.boundedSize(((Node)paginationSkin$NavigationControl2.rightArrowButton).prefWidth(-1.0), ((Node)this.rightArrowButton).minWidth(-1.0), ((Node)this.rightArrowButton).maxWidth(-1.0)));
        PaginationSkin$NavigationControl paginationSkin$NavigationControl3 = this;
        double d7 = paginationSkin$NavigationControl3.snapSizeX(paginationSkin$NavigationControl3.controlBox.getSpacing());
        double d8 = 0.0;
        Side side = this.this$0.getPageInformationAlignment();
        if (Side.LEFT.equals((Object)side) || Side.RIGHT.equals((Object)side)) {
            PaginationSkin$NavigationControl paginationSkin$NavigationControl4 = this;
            d8 = paginationSkin$NavigationControl4.snapSizeX(((Node)paginationSkin$NavigationControl4.pageInformation).prefWidth(-1.0));
        }
        double d9 = this.this$0.arrowButtonGap.get();
        return d3 + d5 + d9 * 2.0 + this.minButtonSize + d7 * 2.0 + d6 + d4 + d8;
    }

    @Override
    protected double computeMinHeight(double d2) {
        return this.computePrefHeight(d2);
    }

    @Override
    protected double computePrefWidth(double d2) {
        double d3 = this.snappedLeftInset();
        double d4 = this.snappedRightInset();
        PaginationSkin$NavigationControl paginationSkin$NavigationControl = this;
        double d5 = paginationSkin$NavigationControl.snapSizeX(((Node)paginationSkin$NavigationControl.controlBox).prefWidth(d2));
        double d6 = 0.0;
        Side side = this.this$0.getPageInformationAlignment();
        if (Side.LEFT.equals((Object)side) || Side.RIGHT.equals((Object)side)) {
            PaginationSkin$NavigationControl paginationSkin$NavigationControl2 = this;
            d6 = paginationSkin$NavigationControl2.snapSizeX(((Node)paginationSkin$NavigationControl2.pageInformation).prefWidth(-1.0));
        }
        return d3 + d5 + d4 + d6;
    }

    @Override
    protected double computePrefHeight(double d2) {
        double d3 = this.snappedTopInset();
        double d4 = this.snappedBottomInset();
        PaginationSkin$NavigationControl paginationSkin$NavigationControl = this;
        double d5 = paginationSkin$NavigationControl.snapSizeY(((Node)paginationSkin$NavigationControl.controlBox).prefHeight(d2));
        double d6 = 0.0;
        Side side = this.this$0.getPageInformationAlignment();
        if (Side.TOP.equals((Object)side) || Side.BOTTOM.equals((Object)side)) {
            PaginationSkin$NavigationControl paginationSkin$NavigationControl2 = this;
            d6 = paginationSkin$NavigationControl2.snapSizeY(((Node)paginationSkin$NavigationControl2.pageInformation).prefHeight(-1.0));
        }
        return d3 + d5 + d6 + d4;
    }

    @Override
    protected void layoutChildren() {
        double d2 = this.snappedTopInset();
        double d3 = this.snappedBottomInset();
        double d4 = this.snappedLeftInset();
        double d5 = this.snappedRightInset();
        PaginationSkin$NavigationControl paginationSkin$NavigationControl = this;
        double d6 = paginationSkin$NavigationControl.snapSizeX(paginationSkin$NavigationControl.getWidth()) - (d4 + d5);
        PaginationSkin$NavigationControl paginationSkin$NavigationControl2 = this;
        double d7 = paginationSkin$NavigationControl2.snapSizeY(paginationSkin$NavigationControl2.getHeight()) - (d2 + d3);
        PaginationSkin$NavigationControl paginationSkin$NavigationControl3 = this;
        double d8 = paginationSkin$NavigationControl3.snapSizeX(((Node)paginationSkin$NavigationControl3.controlBox).prefWidth(-1.0));
        PaginationSkin$NavigationControl paginationSkin$NavigationControl4 = this;
        double d9 = paginationSkin$NavigationControl4.snapSizeY(((Node)paginationSkin$NavigationControl4.controlBox).prefHeight(-1.0));
        PaginationSkin$NavigationControl paginationSkin$NavigationControl5 = this;
        double d10 = paginationSkin$NavigationControl5.snapSizeX(((Node)paginationSkin$NavigationControl5.pageInformation).prefWidth(-1.0));
        PaginationSkin$NavigationControl paginationSkin$NavigationControl6 = this;
        double d11 = paginationSkin$NavigationControl6.snapSizeY(((Node)paginationSkin$NavigationControl6.pageInformation).prefHeight(-1.0));
        this.leftArrowButton.setDisable(false);
        this.rightArrowButton.setDisable(false);
        if (this.this$0.currentIndex == 0) {
            this.leftArrowButton.setDisable(true);
        }
        if (this.this$0.currentIndex == this.this$0.getPageCount() - 1) {
            this.rightArrowButton.setDisable(true);
        }
        this.applyCss();
        this.leftArrowButton.setVisible(this.this$0.isArrowsVisible());
        this.rightArrowButton.setVisible(this.this$0.isArrowsVisible());
        this.pageInformation.setVisible(this.this$0.isPageInformationVisible());
        this.layoutPageIndicators();
        HPos hPos = this.controlBox.getAlignment().getHpos();
        VPos vPos = this.controlBox.getAlignment().getVpos();
        double d12 = d4 + Utils.computeXOffset(d6, d8, hPos);
        double d13 = d2 + Utils.computeYOffset(d7, d9, vPos);
        if (this.this$0.isPageInformationVisible()) {
            PaginationSkin$NavigationControl paginationSkin$NavigationControl7 = this;
            Enum enum_ = paginationSkin$NavigationControl7.sideToPos(paginationSkin$NavigationControl7.this$0.getPageInformationAlignment());
            HPos hPos2 = ((Pos)enum_).getHpos();
            enum_ = ((Pos)enum_).getVpos();
            double d14 = d4 + Utils.computeXOffset(d6, d10, hPos2);
            double d15 = d2 + Utils.computeYOffset(d7, d11, (VPos)enum_);
            if (Side.TOP.equals((Object)this.this$0.getPageInformationAlignment())) {
                d15 = d2;
                d13 = d2 + d11;
            } else if (Side.RIGHT.equals((Object)this.this$0.getPageInformationAlignment())) {
                d14 = d6 - d5 - d10;
            } else if (Side.BOTTOM.equals((Object)this.this$0.getPageInformationAlignment())) {
                d13 = d2;
                d15 = d2 + d9;
            } else if (Side.LEFT.equals((Object)this.this$0.getPageInformationAlignment())) {
                d14 = d4;
            }
            PaginationSkin$NavigationControl paginationSkin$NavigationControl8 = this;
            paginationSkin$NavigationControl8.layoutInArea(paginationSkin$NavigationControl8.pageInformation, d14, d15, d10, d11, 0.0, hPos2, (VPos)enum_);
        }
        PaginationSkin$NavigationControl paginationSkin$NavigationControl9 = this;
        paginationSkin$NavigationControl9.layoutInArea(paginationSkin$NavigationControl9.controlBox, d12, d13, d8, d9, 0.0, hPos, vPos);
    }
}

