/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.behavior.PaginationBehavior;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.Pagination;
import javafx.scene.control.SkinBase;
import javafx.scene.control.skin.PaginationSkin$1;
import javafx.scene.control.skin.PaginationSkin$2;
import javafx.scene.control.skin.PaginationSkin$3;
import javafx.scene.control.skin.PaginationSkin$4;
import javafx.scene.control.skin.PaginationSkin$5;
import javafx.scene.control.skin.PaginationSkin$6;
import javafx.scene.control.skin.PaginationSkin$7;
import javafx.scene.control.skin.PaginationSkin$8;
import javafx.scene.control.skin.PaginationSkin$NavigationControl;
import javafx.scene.control.skin.PaginationSkin$StyleableProperties;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class PaginationSkin
extends SkinBase<Pagination> {
    private static final Duration DURATION = new Duration(125.0);
    private static final double SWIPE_THRESHOLD = 0.3;
    private static final double TOUCH_THRESHOLD = 15.0;
    private static final Interpolator interpolator = Interpolator.SPLINE(0.4829, 0.5709, 0.6803, 0.9928);
    private StackPane currentStackPane;
    private StackPane nextStackPane;
    private Timeline timeline;
    private Rectangle clipRect;
    private PaginationSkin$NavigationControl navigation;
    private int fromIndex;
    private int previousIndex;
    private int currentIndex;
    private int toIndex;
    private int pageCount;
    private int maxPageIndicatorCount;
    private double startTouchPos;
    private double lastTouchPos;
    private long startTouchTime;
    private long lastTouchTime;
    private double touchVelocity;
    private boolean touchThresholdBroken;
    private int touchEventId = -1;
    private boolean nextPageReached = false;
    private boolean setInitialDirection = false;
    private int direction;
    private int currentAnimatedIndex;
    private boolean hasPendingAnimation = false;
    private boolean animate = true;
    private final PaginationBehavior behavior;
    private EventHandler<ActionEvent> swipeAnimationEndEventHandler = new PaginationSkin$1(this);
    private EventHandler<ActionEvent> clampAnimationEndEventHandler = new PaginationSkin$2(this);
    private final DoubleProperty arrowButtonGap = new PaginationSkin$3(this, 60.0);
    private BooleanProperty arrowsVisible;
    private BooleanProperty pageInformationVisible;
    private ObjectProperty<Side> pageInformationAlignment;
    private BooleanProperty tooltipVisible;
    private static final Boolean DEFAULT_ARROW_VISIBLE = Boolean.FALSE;
    private static final Boolean DEFAULT_PAGE_INFORMATION_VISIBLE = Boolean.FALSE;
    private static final Side DEFAULT_PAGE_INFORMATION_ALIGNMENT = Side.BOTTOM;
    private static final Boolean DEFAULT_TOOLTIP_VISIBLE = Boolean.FALSE;

    public PaginationSkin(Pagination pagination) {
        super(pagination);
        this.behavior = new PaginationBehavior(pagination);
        this.clipRect = new Rectangle();
        this.currentStackPane = new StackPane();
        this.currentStackPane.getStyleClass().add("page");
        this.nextStackPane = new StackPane();
        this.nextStackPane.getStyleClass().add("page");
        this.nextStackPane.setVisible(false);
        this.resetIndexes(true);
        this.navigation = new PaginationSkin$NavigationControl(this);
        this.getChildren().addAll((Node[])new Node[]{this.currentStackPane, this.nextStackPane, this.navigation});
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        listenerHelper.addInvalidationListener(pagination.maxPageIndicatorCountProperty(), observable -> this.resetIndiciesAndNav());
        listenerHelper.addChangeListener(pagination.widthProperty(), true, number -> this.clipRect.setWidth(pagination.getWidth()));
        listenerHelper.addChangeListener(pagination.heightProperty(), true, number -> this.clipRect.setHeight(pagination.getHeight()));
        listenerHelper.addChangeListener(pagination.pageCountProperty(), number -> this.resetIndiciesAndNav());
        listenerHelper.addChangeListener(pagination.pageFactoryProperty(), callback -> {
            if (this.animate && this.timeline != null) {
                this.timeline.setRate(8.0);
                this.timeline.setOnFinished(actionEvent -> this.resetIndiciesAndNav());
                return;
            }
            this.resetIndiciesAndNav();
        });
        this.initializeSwipeAndTouchHandlers();
    }

    @Override
    public void install() {
        ((Pagination)this.getSkinnable()).setClip(this.clipRect);
    }

    private final DoubleProperty arrowButtonGapProperty() {
        return this.arrowButtonGap;
    }

    private final double getArrowButtonGap() {
        return this.arrowButtonGap.get();
    }

    private final void setArrowButtonGap(double d2) {
        this.arrowButtonGap.set(d2);
    }

    private final void setArrowsVisible(boolean bl2) {
        this.arrowsVisibleProperty().set(bl2);
    }

    private final boolean isArrowsVisible() {
        if (this.arrowsVisible == null) {
            return DEFAULT_ARROW_VISIBLE;
        }
        return this.arrowsVisible.get();
    }

    private final BooleanProperty arrowsVisibleProperty() {
        if (this.arrowsVisible == null) {
            this.arrowsVisible = new PaginationSkin$4(this, DEFAULT_ARROW_VISIBLE);
        }
        return this.arrowsVisible;
    }

    private final void setPageInformationVisible(boolean bl2) {
        this.pageInformationVisibleProperty().set(bl2);
    }

    private final boolean isPageInformationVisible() {
        if (this.pageInformationVisible == null) {
            return DEFAULT_PAGE_INFORMATION_VISIBLE;
        }
        return this.pageInformationVisible.get();
    }

    private final BooleanProperty pageInformationVisibleProperty() {
        if (this.pageInformationVisible == null) {
            this.pageInformationVisible = new PaginationSkin$5(this, DEFAULT_PAGE_INFORMATION_VISIBLE);
        }
        return this.pageInformationVisible;
    }

    private final void setPageInformationAlignment(Side side) {
        this.pageInformationAlignmentProperty().set(side);
    }

    private final Side getPageInformationAlignment() {
        if (this.pageInformationAlignment == null) {
            return DEFAULT_PAGE_INFORMATION_ALIGNMENT;
        }
        return (Side)((Object)this.pageInformationAlignment.get());
    }

    private final ObjectProperty<Side> pageInformationAlignmentProperty() {
        if (this.pageInformationAlignment == null) {
            this.pageInformationAlignment = new PaginationSkin$6(this, Side.BOTTOM);
        }
        return this.pageInformationAlignment;
    }

    private final void setTooltipVisible(boolean bl2) {
        this.tooltipVisibleProperty().set(bl2);
    }

    private final boolean isTooltipVisible() {
        if (this.tooltipVisible == null) {
            return DEFAULT_TOOLTIP_VISIBLE;
        }
        return this.tooltipVisible.get();
    }

    private final BooleanProperty tooltipVisibleProperty() {
        if (this.tooltipVisible == null) {
            this.tooltipVisible = new PaginationSkin$7(this, DEFAULT_TOOLTIP_VISIBLE);
        }
        return this.tooltipVisible;
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        ((Pagination)this.getSkinnable()).setClip(null);
        this.getChildren().removeAll((Node[])new Node[]{this.currentStackPane, this.nextStackPane, this.navigation});
        if (this.behavior != null) {
            this.behavior.dispose();
        }
        super.dispose();
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7;
        if (this.navigation.isVisible()) {
            PaginationSkin paginationSkin = this;
            d7 = paginationSkin.snapSizeX(((Node)paginationSkin.navigation).minWidth(d2));
        } else {
            d7 = 0.0;
        }
        double d8 = d7;
        return d6 + Math.max(((Node)this.currentStackPane).minWidth(d2), d8) + d4;
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7;
        if (this.navigation.isVisible()) {
            PaginationSkin paginationSkin = this;
            d7 = paginationSkin.snapSizeY(((Node)paginationSkin.navigation).minHeight(d2));
        } else {
            d7 = 0.0;
        }
        double d8 = d7;
        return d3 + ((Node)this.currentStackPane).minHeight(d2) + d8 + d5;
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7;
        if (this.navigation.isVisible()) {
            PaginationSkin paginationSkin = this;
            d7 = paginationSkin.snapSizeX(((Node)paginationSkin.navigation).prefWidth(d2));
        } else {
            d7 = 0.0;
        }
        double d8 = d7;
        return d6 + Math.max(((Node)this.currentStackPane).prefWidth(d2), d8) + d4;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7;
        if (this.navigation.isVisible()) {
            PaginationSkin paginationSkin = this;
            d7 = paginationSkin.snapSizeY(((Node)paginationSkin.navigation).prefHeight(d2));
        } else {
            d7 = 0.0;
        }
        double d8 = d7;
        return d3 + ((Node)this.currentStackPane).prefHeight(d2) + d8 + d5;
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6;
        if (this.navigation.isVisible()) {
            PaginationSkin paginationSkin = this;
            d6 = paginationSkin.snapSizeY(((Node)paginationSkin.navigation).prefHeight(-1.0));
        } else {
            d6 = 0.0;
        }
        double d7 = d6;
        double d8 = this.snapSizeY(d5 - d7);
        PaginationSkin paginationSkin = this;
        paginationSkin.layoutInArea(paginationSkin.currentStackPane, d2, d3, d4, d8, 0.0, HPos.CENTER, VPos.CENTER);
        PaginationSkin paginationSkin2 = this;
        paginationSkin2.layoutInArea(paginationSkin2.nextStackPane, d2, d3, d4, d8, 0.0, HPos.CENTER, VPos.CENTER);
        PaginationSkin paginationSkin3 = this;
        paginationSkin3.layoutInArea(paginationSkin3.navigation, d2, d8, d4, d7, 0.0, HPos.CENTER, VPos.CENTER);
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute object, Object ... objectArray) {
        switch (PaginationSkin$8.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                return this.navigation.indicatorButtons.getSelectedToggle();
            }
            case 2: {
                return this.navigation.indicatorButtons.getToggles().size();
            }
            case 3: {
                object = (Integer)objectArray[0];
                if (object == null) {
                    return null;
                }
                return this.navigation.indicatorButtons.getToggles().get((Integer)object);
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray);
    }

    private void selectNext() {
        if (this.getCurrentPageIndex() < this.getPageCount() - 1) {
            ((Pagination)this.getSkinnable()).setCurrentPageIndex(this.getCurrentPageIndex() + 1);
        }
    }

    private void selectPrevious() {
        if (this.getCurrentPageIndex() > 0) {
            ((Pagination)this.getSkinnable()).setCurrentPageIndex(this.getCurrentPageIndex() - 1);
        }
    }

    private void resetIndiciesAndNav() {
        this.resetIndexes(false);
        this.navigation.initializePageIndicators();
        this.navigation.updatePageIndicators();
    }

    private void initializeSwipeAndTouchHandlers() {
        Pagination pagination = (Pagination)this.getSkinnable();
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        listenerHelper.addEventHandler(pagination, TouchEvent.TOUCH_PRESSED, touchEvent -> {
            if (this.touchEventId == -1) {
                this.touchEventId = touchEvent.getTouchPoint().getId();
            }
            if (this.touchEventId != touchEvent.getTouchPoint().getId()) {
                return;
            }
            PaginationSkin paginationSkin = this;
            paginationSkin.lastTouchPos = paginationSkin.startTouchPos = touchEvent.getTouchPoint().getX();
            PaginationSkin paginationSkin2 = this;
            paginationSkin2.lastTouchTime = paginationSkin2.startTouchTime = System.currentTimeMillis();
            this.touchThresholdBroken = false;
            touchEvent.consume();
        });
        listenerHelper.addEventHandler(pagination, TouchEvent.TOUCH_MOVED, touchEvent -> {
            if (this.touchEventId != touchEvent.getTouchPoint().getId()) {
                return;
            }
            double d2 = touchEvent.getTouchPoint().getX() - this.lastTouchPos;
            long l2 = System.currentTimeMillis() - this.lastTouchTime;
            this.touchVelocity = d2 / (double)l2;
            this.lastTouchPos = touchEvent.getTouchPoint().getX();
            this.lastTouchTime = System.currentTimeMillis();
            double d3 = touchEvent.getTouchPoint().getX() - this.startTouchPos;
            if (!this.touchThresholdBroken && Math.abs(d3) > 15.0) {
                this.touchThresholdBroken = true;
            }
            if (this.touchThresholdBroken) {
                double d4 = pagination.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
                if (!this.setInitialDirection) {
                    this.setInitialDirection = true;
                    int n2 = this.direction = d3 < 0.0 ? 1 : -1;
                }
                if (d3 < 0.0) {
                    double d5;
                    double d6;
                    if (this.direction == -1) {
                        this.nextStackPane.getChildren().clear();
                        this.direction = 1;
                    }
                    if (Math.abs(d3) <= d4) {
                        d6 = d3;
                        d5 = d4 + d3;
                        this.nextPageReached = false;
                    } else {
                        d6 = -d4;
                        d5 = 0.0;
                        this.nextPageReached = true;
                    }
                    this.currentStackPane.setTranslateX(d6);
                    if (this.getCurrentPageIndex() < this.getPageCount() - 1) {
                        PaginationSkin paginationSkin = this;
                        paginationSkin.createPage(paginationSkin.nextStackPane, this.currentIndex + 1);
                        this.nextStackPane.setVisible(true);
                        this.nextStackPane.setTranslateX(d5);
                    } else {
                        this.currentStackPane.setTranslateX(0.0);
                    }
                } else {
                    double d7;
                    double d8;
                    if (this.direction == 1) {
                        this.nextStackPane.getChildren().clear();
                        this.direction = -1;
                    }
                    if (Math.abs(d3) <= d4) {
                        d8 = d3;
                        d7 = -d4 + d3;
                        this.nextPageReached = false;
                    } else {
                        d8 = d4;
                        d7 = 0.0;
                        this.nextPageReached = true;
                    }
                    this.currentStackPane.setTranslateX(d8);
                    if (this.getCurrentPageIndex() != 0) {
                        PaginationSkin paginationSkin = this;
                        paginationSkin.createPage(paginationSkin.nextStackPane, this.currentIndex - 1);
                        this.nextStackPane.setVisible(true);
                        this.nextStackPane.setTranslateX(d7);
                    } else {
                        this.currentStackPane.setTranslateX(0.0);
                    }
                }
            }
            touchEvent.consume();
        });
        listenerHelper.addEventHandler(pagination, TouchEvent.TOUCH_RELEASED, touchEvent -> {
            if (this.touchEventId != touchEvent.getTouchPoint().getId()) {
                return;
            }
            this.touchEventId = -1;
            this.setInitialDirection = false;
            if (this.touchThresholdBroken) {
                double d2 = touchEvent.getTouchPoint().getX() - this.startTouchPos;
                long l2 = System.currentTimeMillis() - this.startTouchTime;
                boolean bl2 = l2 < 300L;
                double d3 = bl2 ? d2 / (double)l2 : this.touchVelocity;
                double d4 = d3 * 500.0;
                double d5 = pagination.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
                double d6 = Math.abs(d4 / d5);
                double d7 = Math.abs(d2 / d5);
                if (d6 > 0.3 || d7 > 0.3) {
                    if (this.startTouchPos > touchEvent.getTouchPoint().getX()) {
                        this.selectNext();
                    } else {
                        this.selectPrevious();
                    }
                } else {
                    PaginationSkin paginationSkin = this;
                    paginationSkin.animateClamping(paginationSkin.startTouchPos > touchEvent.getTouchPoint().getSceneX());
                }
            }
            touchEvent.consume();
        });
    }

    private void resetIndexes(boolean bl2) {
        this.maxPageIndicatorCount = this.getMaxPageIndicatorCount();
        this.pageCount = this.getPageCount();
        if (this.pageCount > this.maxPageIndicatorCount) {
            this.pageCount = this.maxPageIndicatorCount;
        }
        this.fromIndex = 0;
        this.previousIndex = 0;
        this.currentIndex = bl2 ? this.getCurrentPageIndex() : 0;
        this.toIndex = this.pageCount - 1;
        if (this.pageCount == Integer.MAX_VALUE && this.maxPageIndicatorCount == Integer.MAX_VALUE) {
            this.toIndex = 0;
        }
        if (bl2 = this.animate) {
            this.animate = false;
        }
        this.currentStackPane.getChildren().clear();
        this.nextStackPane.getChildren().clear();
        ((Pagination)this.getSkinnable()).setCurrentPageIndex(this.currentIndex);
        PaginationSkin paginationSkin = this;
        paginationSkin.createPage(paginationSkin.currentStackPane, this.currentIndex);
        if (bl2) {
            this.animate = true;
        }
    }

    private boolean createPage(StackPane stackPane, int n2) {
        if (((Pagination)this.getSkinnable()).getPageFactory() != null && stackPane.getChildren().isEmpty()) {
            Node node = ((Pagination)this.getSkinnable()).getPageFactory().call(n2);
            if (node != null) {
                stackPane.getChildren().setAll((Node[])new Node[]{node});
                return true;
            }
            boolean bl2 = this.animate;
            if (bl2) {
                this.animate = false;
            }
            if (((Pagination)this.getSkinnable()).getPageFactory().call(this.previousIndex) != null) {
                ((Pagination)this.getSkinnable()).setCurrentPageIndex(this.previousIndex);
            } else {
                ((Pagination)this.getSkinnable()).setCurrentPageIndex(0);
            }
            if (bl2) {
                this.animate = true;
            }
            return false;
        }
        return false;
    }

    private int getPageCount() {
        if (((Pagination)this.getSkinnable()).getPageCount() <= 0) {
            return 1;
        }
        return ((Pagination)this.getSkinnable()).getPageCount();
    }

    private int getMaxPageIndicatorCount() {
        return ((Pagination)this.getSkinnable()).getMaxPageIndicatorCount();
    }

    private int getCurrentPageIndex() {
        return ((Pagination)this.getSkinnable()).getCurrentPageIndex();
    }

    private void animateSwitchPage() {
        if (this.timeline != null) {
            this.timeline.setRate(8.0);
            this.hasPendingAnimation = true;
            return;
        }
        if (!this.nextStackPane.isVisible()) {
            PaginationSkin paginationSkin = this;
            if (!paginationSkin.createPage(paginationSkin.nextStackPane, this.currentAnimatedIndex)) {
                return;
            }
        }
        if (this.nextPageReached) {
            this.swapPanes();
            this.nextPageReached = false;
            return;
        }
        this.nextStackPane.setCache(true);
        this.currentStackPane.setCache(true);
        Platform.runLater(() -> {
            boolean bl2;
            boolean bl3 = bl2 = this.nextStackPane.getTranslateX() != 0.0;
            if (this.currentAnimatedIndex > this.previousIndex) {
                if (!bl2) {
                    this.nextStackPane.setTranslateX(this.currentStackPane.getWidth());
                }
                this.nextStackPane.setVisible(true);
                this.timeline = new Timeline();
                KeyFrame keyFrame = new KeyFrame(Duration.millis(0.0), new KeyValue(this.currentStackPane.translateXProperty(), bl2 ? this.currentStackPane.getTranslateX() : 0.0, interpolator), new KeyValue(this.nextStackPane.translateXProperty(), bl2 ? this.nextStackPane.getTranslateX() : this.currentStackPane.getWidth(), interpolator));
                KeyFrame keyFrame2 = new KeyFrame(DURATION, this.swipeAnimationEndEventHandler, new KeyValue(this.currentStackPane.translateXProperty(), -this.currentStackPane.getWidth(), interpolator), new KeyValue(this.nextStackPane.translateXProperty(), 0, interpolator));
                this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{keyFrame, keyFrame2});
                this.timeline.play();
                return;
            }
            if (!bl2) {
                this.nextStackPane.setTranslateX(-this.currentStackPane.getWidth());
            }
            this.nextStackPane.setVisible(true);
            this.timeline = new Timeline();
            KeyFrame keyFrame = new KeyFrame(Duration.millis(0.0), new KeyValue(this.currentStackPane.translateXProperty(), bl2 ? this.currentStackPane.getTranslateX() : 0.0, interpolator), new KeyValue(this.nextStackPane.translateXProperty(), bl2 ? this.nextStackPane.getTranslateX() : -this.currentStackPane.getWidth(), interpolator));
            KeyFrame keyFrame3 = new KeyFrame(DURATION, this.swipeAnimationEndEventHandler, new KeyValue(this.currentStackPane.translateXProperty(), this.currentStackPane.getWidth(), interpolator), new KeyValue(this.nextStackPane.translateXProperty(), 0, interpolator));
            this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{keyFrame, keyFrame3});
            this.timeline.play();
        });
    }

    private void swapPanes() {
        StackPane stackPane = this.currentStackPane;
        this.currentStackPane = this.nextStackPane;
        this.nextStackPane = stackPane;
        this.currentStackPane.setTranslateX(0.0);
        this.currentStackPane.setCache(false);
        this.nextStackPane.setTranslateX(0.0);
        this.nextStackPane.setCache(false);
        this.nextStackPane.setVisible(false);
        this.nextStackPane.getChildren().clear();
    }

    private void animateClamping(boolean bl2) {
        if (bl2) {
            this.timeline = new Timeline();
            KeyFrame keyFrame = new KeyFrame(Duration.millis(0.0), new KeyValue(this.currentStackPane.translateXProperty(), this.currentStackPane.getTranslateX(), interpolator), new KeyValue(this.nextStackPane.translateXProperty(), this.nextStackPane.getTranslateX(), interpolator));
            KeyFrame keyFrame2 = new KeyFrame(DURATION, this.clampAnimationEndEventHandler, new KeyValue(this.currentStackPane.translateXProperty(), 0, interpolator), new KeyValue(this.nextStackPane.translateXProperty(), this.currentStackPane.getWidth(), interpolator));
            this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{keyFrame, keyFrame2});
            this.timeline.play();
            return;
        }
        this.timeline = new Timeline();
        KeyFrame keyFrame = new KeyFrame(Duration.millis(0.0), new KeyValue(this.currentStackPane.translateXProperty(), this.currentStackPane.getTranslateX(), interpolator), new KeyValue(this.nextStackPane.translateXProperty(), this.nextStackPane.getTranslateX(), interpolator));
        KeyFrame keyFrame3 = new KeyFrame(DURATION, this.clampAnimationEndEventHandler, new KeyValue(this.currentStackPane.translateXProperty(), 0, interpolator), new KeyValue(this.nextStackPane.translateXProperty(), -this.currentStackPane.getWidth(), interpolator));
        this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{keyFrame, keyFrame3});
        this.timeline.play();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return PaginationSkin$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return PaginationSkin.getClassCssMetaData();
    }
}

