/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.NodeHelper;
import java.util.List;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.When;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.skin.ProgressBarSkin$1;
import javafx.scene.control.skin.ProgressBarSkin$2;
import javafx.scene.control.skin.ProgressBarSkin$3;
import javafx.scene.control.skin.ProgressBarSkin$4;
import javafx.scene.control.skin.ProgressBarSkin$IndeterminateTransition;
import javafx.scene.control.skin.ProgressBarSkin$StyleableProperties;
import javafx.scene.control.skin.ProgressIndicatorSkin;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;

public class ProgressBarSkin
extends ProgressIndicatorSkin {
    private StackPane bar;
    private StackPane track;
    private Region clipRegion;
    private double barWidth;
    private DoubleProperty indeterminateBarLength = null;
    private BooleanProperty indeterminateBarEscape = null;
    private BooleanProperty indeterminateBarFlip = null;
    private DoubleProperty indeterminateBarAnimationTime = null;
    boolean wasIndeterminate = false;

    public ProgressBarSkin(ProgressBar progressBar) {
        super(progressBar);
        this.barWidth = (double)((int)(progressBar.getWidth() - this.snappedLeftInset() - this.snappedRightInset()) << 1) * Math.min(1.0, Math.max(0.0, progressBar.getProgress())) / 2.0;
        this.registerChangeListener(progressBar.widthProperty(), observableValue -> this.updateProgress());
        this.initialize();
        ((ProgressIndicator)this.getSkinnable()).requestLayout();
    }

    private DoubleProperty indeterminateBarLengthProperty() {
        if (this.indeterminateBarLength == null) {
            this.indeterminateBarLength = new ProgressBarSkin$1(this, 60.0);
        }
        return this.indeterminateBarLength;
    }

    private Double getIndeterminateBarLength() {
        return this.indeterminateBarLength == null ? 60.0 : this.indeterminateBarLength.get();
    }

    private BooleanProperty indeterminateBarEscapeProperty() {
        if (this.indeterminateBarEscape == null) {
            this.indeterminateBarEscape = new ProgressBarSkin$2(this, true);
        }
        return this.indeterminateBarEscape;
    }

    private Boolean getIndeterminateBarEscape() {
        return this.indeterminateBarEscape == null ? true : this.indeterminateBarEscape.get();
    }

    private BooleanProperty indeterminateBarFlipProperty() {
        if (this.indeterminateBarFlip == null) {
            this.indeterminateBarFlip = new ProgressBarSkin$3(this, true);
        }
        return this.indeterminateBarFlip;
    }

    private Boolean getIndeterminateBarFlip() {
        return this.indeterminateBarFlip == null ? true : this.indeterminateBarFlip.get();
    }

    private DoubleProperty indeterminateBarAnimationTimeProperty() {
        if (this.indeterminateBarAnimationTime == null) {
            this.indeterminateBarAnimationTime = new ProgressBarSkin$4(this, 2.0);
        }
        return this.indeterminateBarAnimationTime;
    }

    private double getIndeterminateBarAnimationTime() {
        if (this.indeterminateBarAnimationTime == null) {
            return 2.0;
        }
        return this.indeterminateBarAnimationTime.get();
    }

    @Override
    public double computeBaselineOffset(double d2, double d3, double d4, double d5) {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        return Math.max(100.0, d6 + ((Node)this.bar).prefWidth(((ProgressIndicator)this.getSkinnable()).getWidth()) + d4);
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return d3 + ((Node)this.bar).prefHeight(d2) + d5;
    }

    @Override
    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        return ((Node)((ProgressIndicator)this.getSkinnable())).prefWidth(d2);
    }

    @Override
    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return ((Node)((ProgressIndicator)this.getSkinnable())).prefHeight(d2);
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        ProgressIndicator progressIndicator = (ProgressIndicator)this.getSkinnable();
        boolean bl2 = progressIndicator.isIndeterminate();
        this.clipRegion.resizeRelocate(0.0, 0.0, d4, d5);
        this.track.resizeRelocate(d2, d3, d4, d5);
        this.bar.resizeRelocate(d2, d3, bl2 ? this.getIndeterminateBarLength() : this.barWidth, d5);
        this.track.setVisible(true);
        if (bl2) {
            this.createIndeterminateTimeline();
            if (NodeHelper.isTreeShowing((Node)((Object)this.getSkinnable()))) {
                this.indeterminateTransition.play();
            }
            this.bar.setClip(this.clipRegion);
            return;
        }
        if (this.indeterminateTransition != null) {
            this.indeterminateTransition.stop();
            this.indeterminateTransition = null;
            this.bar.setClip(null);
            this.bar.setScaleX(1.0);
            this.bar.setTranslateX(0.0);
            this.clipRegion.translateXProperty().unbind();
        }
    }

    @Override
    void initialize() {
        this.track = new StackPane();
        this.track.getStyleClass().setAll((String[])new String[]{"track"});
        this.bar = new StackPane();
        this.bar.getStyleClass().setAll((String[])new String[]{"bar"});
        this.getChildren().setAll((Node[])new Node[]{this.track, this.bar});
        this.clipRegion = new Region();
        this.bar.backgroundProperty().addListener((backgroundFillArray, background, background2) -> {
            if (background2 != null && !background2.getFills().isEmpty()) {
                backgroundFillArray = new BackgroundFill[background2.getFills().size()];
                for (int i2 = 0; i2 < background2.getFills().size(); ++i2) {
                    BackgroundFill backgroundFill = background2.getFills().get(i2);
                    backgroundFillArray[i2] = new BackgroundFill(Color.BLACK, backgroundFill.getRadii(), backgroundFill.getInsets());
                }
                this.clipRegion.setBackground(new Background((BackgroundFill)((Object)backgroundFillArray)));
            }
        });
    }

    @Override
    void createIndeterminateTimeline() {
        if (this.indeterminateTransition != null) {
            this.indeterminateTransition.stop();
        }
        ProgressIndicator progressIndicator = (ProgressIndicator)this.getSkinnable();
        double d2 = progressIndicator.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
        double d3 = this.getIndeterminateBarEscape() != false ? -this.getIndeterminateBarLength().doubleValue() : 0.0;
        double d4 = this.getIndeterminateBarEscape() != false ? d2 : d2 - this.getIndeterminateBarLength();
        this.indeterminateTransition = new ProgressBarSkin$IndeterminateTransition(d3, d4, this);
        this.indeterminateTransition.setCycleCount(-1);
        this.clipRegion.translateXProperty().bind(new When(this.bar.scaleXProperty().isEqualTo(-1.0, 1.0E-100)).then(((DoubleExpression)this.bar.translateXProperty().subtract(d2)).add(this.indeterminateBarLengthProperty())).otherwise(this.bar.translateXProperty().negate()));
    }

    @Override
    void updateProgress() {
        ProgressIndicator progressIndicator = (ProgressIndicator)this.getSkinnable();
        boolean bl2 = progressIndicator.isIndeterminate();
        if (!bl2 || !this.wasIndeterminate) {
            this.barWidth = (double)((int)(progressIndicator.getWidth() - this.snappedLeftInset() - this.snappedRightInset()) << 1) * Math.min(1.0, Math.max(0.0, progressIndicator.getProgress())) / 2.0;
            ((ProgressIndicator)this.getSkinnable()).requestLayout();
        }
        this.wasIndeterminate = bl2;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return ProgressBarSkin$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ProgressBarSkin.getClassCssMetaData();
    }
}

