/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.skin.Utils;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.skin.ProgressIndicatorSkin;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.scene.text.TextBoundsType;

final class ProgressIndicatorSkin$DeterminateIndicator
extends Region {
    private double textGap = 2.0;
    private int intProgress;
    private int degProgress;
    private Text text;
    private StackPane indicator;
    private StackPane progress;
    private StackPane tick;
    private Arc arcShape;
    private Circle indicatorCircle;
    private double doneTextWidth;
    private double doneTextHeight;
    final /* synthetic */ ProgressIndicatorSkin this$0;

    public ProgressIndicatorSkin$DeterminateIndicator(ProgressIndicatorSkin progressIndicatorSkin, ProgressIndicator progressIndicator, ProgressIndicatorSkin progressIndicatorSkin2, Paint paint) {
        this.this$0 = progressIndicatorSkin;
        this.getStyleClass().add("determinate-indicator");
        this.intProgress = (int)Math.round(progressIndicator.getProgress() * 100.0);
        this.degProgress = (int)(360.0 * progressIndicator.getProgress());
        this.getChildren().clear();
        this.text = new Text((String)(progressIndicator.getProgress() >= 1.0 ? progressIndicatorSkin.DONE : this.intProgress + "%"));
        this.text.setTextOrigin(VPos.TOP);
        this.text.getStyleClass().setAll((String[])new String[]{"text", "percentage"});
        ProgressIndicatorSkin.access$000(progressIndicatorSkin, this.text.fontProperty(), observableValue -> {
            this.doneTextWidth = Utils.computeTextWidth(this.text.getFont(), this.this$0.DONE, 0.0);
            this.doneTextHeight = Utils.computeTextHeight(this.text.getFont(), this.this$0.DONE, 0.0, TextBoundsType.LOGICAL_VERTICAL_CENTER);
        });
        this.indicator = new StackPane();
        this.indicator.setScaleShape(false);
        this.indicator.setCenterShape(false);
        this.indicator.getStyleClass().setAll((String[])new String[]{"indicator"});
        this.indicatorCircle = new Circle();
        this.indicator.setShape(this.indicatorCircle);
        this.arcShape = new Arc();
        this.arcShape.setType(ArcType.ROUND);
        this.arcShape.setStartAngle(90.0);
        this.progress = new StackPane();
        this.progress.getStyleClass().setAll((String[])new String[]{"progress"});
        this.progress.setScaleShape(false);
        this.progress.setCenterShape(false);
        this.progress.setShape(this.arcShape);
        this.progress.getChildren().clear();
        this.setFillOverride(paint);
        this.tick = new StackPane();
        this.tick.getStyleClass().setAll((String[])new String[]{"tick"});
        this.getChildren().setAll((Node[])new Node[]{this.indicator, this.progress, this.text, this.tick});
        this.updateProgress(progressIndicator.getProgress());
    }

    private void unregisterListener() {
        ProgressIndicatorSkin.access$100(this.this$0, this.text.fontProperty());
    }

    private void setFillOverride(Paint paint) {
        if (paint instanceof Color) {
            paint = (Color)paint;
            this.progress.setStyle("-fx-background-color: rgba(" + (int)(255.0 * ((Color)paint).getRed()) + "," + (int)(255.0 * ((Color)paint).getGreen()) + "," + (int)(255.0 * ((Color)paint).getBlue()) + "," + ((Color)paint).getOpacity() + ");");
            return;
        }
        this.progress.setStyle(null);
    }

    @Override
    public final boolean usesMirroring() {
        return false;
    }

    private void updateProgress(double d2) {
        this.intProgress = (int)Math.round(d2 * 100.0);
        this.text.setText((String)(d2 >= 1.0 ? this.this$0.DONE : this.intProgress + "%"));
        this.degProgress = (int)(d2 * 360.0);
        this.arcShape.setLength(-this.degProgress);
        this.requestLayout();
    }

    @Override
    protected final void layoutChildren() {
        double d2 = this.this$0.control.snappedLeftInset();
        double d3 = this.this$0.control.snappedRightInset();
        double d4 = this.this$0.control.snappedTopInset();
        double d5 = this.this$0.control.snappedBottomInset();
        double d6 = this.this$0.control.getWidth() - d2 - d3;
        double d7 = this.this$0.control.getHeight() - d4 - d5 - this.textGap - this.doneTextHeight;
        double d8 = d6 / 2.0;
        double d9 = d7 / 2.0;
        double d10 = Math.floor(Math.min(d8, d9));
        double d11 = this.snapPositionX(d2 + d8);
        double d12 = this.snapPositionY(d4 + d10);
        double d13 = this.indicator.snappedLeftInset();
        double d14 = this.indicator.snappedRightInset();
        double d15 = this.indicator.snappedTopInset();
        double d16 = this.indicator.snappedBottomInset();
        double d17 = this.snapSizeX(Math.min(Math.min(d10 - d13, d10 - d14), Math.min(d10 - d15, d10 - d16)));
        this.indicatorCircle.setRadius(d10);
        this.indicator.setLayoutX(d11);
        this.indicator.setLayoutY(d12);
        this.arcShape.setRadiusX(d17);
        this.arcShape.setRadiusY(d17);
        this.progress.setLayoutX(d11);
        this.progress.setLayoutY(d12);
        double d18 = this.progress.snappedLeftInset();
        double d19 = this.progress.snappedRightInset();
        double d20 = this.progress.snappedTopInset();
        double d21 = this.progress.snappedBottomInset();
        double d22 = this.snapSizeX(Math.min(Math.min(d17 - d18, d17 - d19), Math.min(d17 - d20, d17 - d21)));
        double d23 = Math.ceil(Math.sqrt(d22 * d22 / 2.0));
        this.tick.setLayoutX(d11 - d23);
        this.tick.setLayoutY(d12 - d23);
        double d24 = d23;
        double d25 = d23;
        ((Node)this.tick).resize(d24 + d24, d25 + d25);
        this.tick.setVisible(this.this$0.control.getProgress() >= 1.0);
        double d26 = this.text.getLayoutBounds().getWidth();
        double d27 = this.text.getLayoutBounds().getHeight();
        if (this.this$0.control.getWidth() >= d26 && this.this$0.control.getHeight() >= d27) {
            if (!this.text.isVisible()) {
                this.text.setVisible(true);
            }
            this.text.setLayoutY(this.snapPositionY(d12 + d10 + this.textGap));
            this.text.setLayoutX(this.snapPositionX(d11 - d26 / 2.0));
            return;
        }
        if (this.text.isVisible()) {
            this.text.setVisible(false);
        }
    }

    @Override
    protected final double computePrefWidth(double d2) {
        double d3 = this.this$0.control.snappedLeftInset();
        double d4 = this.this$0.control.snappedRightInset();
        double d5 = this.indicator.snappedLeftInset();
        double d6 = this.indicator.snappedRightInset();
        double d7 = this.indicator.snappedTopInset();
        double d8 = this.indicator.snappedBottomInset();
        double d9 = this.snapSizeX(Math.max(Math.max(d5, d6), Math.max(d7, d8)));
        double d10 = this.progress.snappedLeftInset();
        double d11 = this.progress.snappedRightInset();
        double d12 = this.progress.snappedTopInset();
        double d13 = this.progress.snappedBottomInset();
        double d14 = this.snapSizeX(Math.max(Math.max(d10, d11), Math.max(d12, d13)));
        double d15 = this.tick.snappedLeftInset();
        double d16 = this.tick.snappedRightInset();
        double d17 = d9 + d14 + d15 + d16 + d14 + d9;
        return d3 + Math.max(d17, this.doneTextWidth) + d4;
    }

    @Override
    protected final double computePrefHeight(double d2) {
        double d3 = this.this$0.control.snappedTopInset();
        double d4 = this.this$0.control.snappedBottomInset();
        double d5 = this.indicator.snappedLeftInset();
        double d6 = this.indicator.snappedRightInset();
        double d7 = this.indicator.snappedTopInset();
        double d8 = this.indicator.snappedBottomInset();
        double d9 = this.snapSizeY(Math.max(Math.max(d5, d6), Math.max(d7, d8)));
        double d10 = this.progress.snappedLeftInset();
        double d11 = this.progress.snappedRightInset();
        double d12 = this.progress.snappedTopInset();
        double d13 = this.progress.snappedBottomInset();
        double d14 = this.snapSizeY(Math.max(Math.max(d10, d11), Math.max(d12, d13)));
        double d15 = this.tick.snappedTopInset();
        double d16 = this.tick.snappedBottomInset();
        double d17 = d9 + d14 + d15 + d16 + d14 + d9;
        return d3 + d17 + this.textGap + this.doneTextHeight + d4;
    }

    @Override
    protected final double computeMaxWidth(double d2) {
        return this.computePrefWidth(d2);
    }

    @Override
    protected final double computeMaxHeight(double d2) {
        return this.computePrefHeight(d2);
    }
}

