/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.NodeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.skin.ProgressIndicatorSkin;
import javafx.scene.control.skin.ProgressIndicatorSkin$IndeterminateSpinner$IndicatorPaths;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

final class ProgressIndicatorSkin$IndeterminateSpinner
extends Region {
    private ProgressIndicatorSkin$IndeterminateSpinner$IndicatorPaths pathsG;
    private final List<Double> opacities = new ArrayList<Double>();
    private boolean spinEnabled = false;
    private Paint fillOverride = null;
    final /* synthetic */ ProgressIndicatorSkin this$0;

    private ProgressIndicatorSkin$IndeterminateSpinner(ProgressIndicatorSkin progressIndicatorSkin, boolean bl2, Paint paint) {
        this.this$0 = progressIndicatorSkin;
        this.spinEnabled = bl2;
        this.fillOverride = paint;
        this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        this.getStyleClass().setAll((String[])new String[]{"spinner"});
        this.pathsG = new ProgressIndicatorSkin$IndeterminateSpinner$IndicatorPaths(this);
        this.getChildren().add(this.pathsG);
        this.rebuild();
        this.rebuildTimeline();
    }

    public final void setFillOverride(Paint paint) {
        this.fillOverride = paint;
        this.rebuild();
    }

    public final void setSpinEnabled(boolean bl2) {
        this.spinEnabled = bl2;
        this.rebuildTimeline();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void rebuildTimeline() {
        if (!this.spinEnabled) {
            if (this.this$0.indeterminateTransition == null) return;
            this.this$0.indeterminateTransition.stop();
            ((Timeline)this.this$0.indeterminateTransition).getKeyFrames().clear();
            this.this$0.indeterminateTransition = null;
            return;
        }
        if (this.this$0.indeterminateTransition == null) {
            this.this$0.indeterminateTransition = new Timeline();
            this.this$0.indeterminateTransition.setCycleCount(-1);
            this.this$0.indeterminateTransition.setDelay(this.this$0.UNCLIPPED_DELAY);
        } else {
            this.this$0.indeterminateTransition.stop();
            ((Timeline)this.this$0.indeterminateTransition).getKeyFrames().clear();
        }
        ObservableList<KeyFrame> observableList = FXCollections.observableArrayList();
        observableList.add(new KeyFrame(Duration.millis(1.0), new KeyValue(this.pathsG.rotateProperty(), 360)));
        observableList.add(new KeyFrame(Duration.millis(3900.0), new KeyValue(this.pathsG.rotateProperty(), 0)));
        for (int i2 = 100; i2 <= 3900; i2 += 100) {
            observableList.add(new KeyFrame(Duration.millis(i2), actionEvent -> this.shiftColors(), new KeyValue[0]));
        }
        ((Timeline)this.this$0.indeterminateTransition).getKeyFrames().setAll((Collection<KeyFrame>)observableList);
        if (NodeHelper.isTreeShowing(this.this$0.control)) {
            this.this$0.indeterminateTransition.playFromStart();
            return;
        }
        this.this$0.indeterminateTransition.jumpTo(Duration.ZERO);
    }

    @Override
    protected final void layoutChildren() {
        double d2;
        double d3 = this.this$0.control.getWidth() - this.this$0.control.snappedLeftInset() - this.this$0.control.snappedRightInset();
        double d4 = this.this$0.control.getHeight() - this.this$0.control.snappedTopInset() - this.this$0.control.snappedBottomInset();
        double d5 = ((Node)this.pathsG).prefWidth(-1.0);
        double d6 = ((Node)this.pathsG).prefHeight(-1.0);
        double d7 = d2 = d3 / d5;
        if (d2 * d6 > d4) {
            d7 = d4 / d6;
        }
        double d8 = d5 * d7;
        double d9 = d6 * d7;
        this.pathsG.resizeRelocate((d3 - d8) / 2.0, (d4 - d9) / 2.0, d8, d9);
    }

    private void rebuild() {
        int n2 = this.this$0.indeterminateSegmentCount.get();
        this.opacities.clear();
        this.pathsG.getChildren().clear();
        double d2 = 0.8 / (double)(n2 - 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            Region region = new Region();
            region.setScaleShape(false);
            region.setCenterShape(false);
            region.getStyleClass().addAll((String[])new String[]{"segment", "segment" + i2});
            if (this.fillOverride instanceof Color) {
                Color color = (Color)this.fillOverride;
                region.setStyle("-fx-background-color: rgba(" + (int)(255.0 * color.getRed()) + "," + (int)(255.0 * color.getGreen()) + "," + (int)(255.0 * color.getBlue()) + "," + color.getOpacity() + ");");
            } else {
                region.setStyle(null);
            }
            this.pathsG.getChildren().add(region);
            this.opacities.add(Math.max(0.1, 1.0 - d2 * (double)i2));
        }
    }

    private void shiftColors() {
        if (this.opacities.size() <= 0) {
            return;
        }
        int n2 = this.this$0.indeterminateSegmentCount.get();
        Collections.rotate(this.opacities, -1);
        for (int i2 = 0; i2 < n2; ++i2) {
            ((Node)this.pathsG.getChildren().get(i2)).setOpacity(this.opacities.get(i2));
        }
    }
}

