/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Separator;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Region;

public class SeparatorSkin
extends SkinBase<Separator> {
    private static final double DEFAULT_LENGTH = 10.0;
    private final Region line = new Region();

    public SeparatorSkin(Separator separator) {
        super(separator);
        this.line.getStyleClass().setAll((String[])new String[]{"line"});
        this.getChildren().add(this.line);
        this.registerChangeListener(separator.orientationProperty(), observableValue -> ((Separator)this.getSkinnable()).requestLayout());
        this.registerChangeListener(separator.halignmentProperty(), observableValue -> ((Separator)this.getSkinnable()).requestLayout());
        this.registerChangeListener(separator.valignmentProperty(), observableValue -> ((Separator)this.getSkinnable()).requestLayout());
    }

    @Override
    public void dispose() {
        this.getChildren().remove(this.line);
        super.dispose();
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        Separator separator = (Separator)this.getSkinnable();
        if (separator.getOrientation() == Orientation.HORIZONTAL) {
            ((Node)this.line).resize(d4, ((Node)this.line).prefHeight(-1.0));
        } else {
            ((Node)this.line).resize(((Node)this.line).prefWidth(-1.0), d5);
        }
        SeparatorSkin separatorSkin = this;
        separatorSkin.positionInArea(separatorSkin.line, d2, d3, d4, d5, 0.0, separator.getHalignment(), separator.getValignment());
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        return this.computePrefWidth(d2, d3, d4, d5, d6);
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        return this.computePrefHeight(d2, d3, d4, d5, d6);
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        Separator separator = (Separator)this.getSkinnable();
        double d7 = separator.getOrientation() == Orientation.VERTICAL ? ((Node)this.line).prefWidth(-1.0) : 10.0;
        return d7 + d6 + d4;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        Separator separator = (Separator)this.getSkinnable();
        double d7 = separator.getOrientation() == Orientation.VERTICAL ? 10.0 : ((Node)this.line).prefHeight(-1.0);
        return d7 + d3 + d5;
    }

    @Override
    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        Separator separator = (Separator)this.getSkinnable();
        if (separator.getOrientation() == Orientation.VERTICAL) {
            return ((Node)separator).prefWidth(d2);
        }
        return Double.MAX_VALUE;
    }

    @Override
    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        Separator separator = (Separator)this.getSkinnable();
        if (separator.getOrientation() == Orientation.VERTICAL) {
            return Double.MAX_VALUE;
        }
        return ((Node)separator).prefHeight(d2);
    }
}

