/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.SliderBehavior;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.chart.NumberAxis;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Slider;
import javafx.scene.control.skin.SliderSkin$1;
import javafx.scene.control.skin.SliderSkin$2;
import javafx.scene.control.skin.SliderSkin$3;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.stage.PopupWindow;
import javafx.util.StringConverter;

public class SliderSkin
extends SkinBase<Slider> {
    private NumberAxis tickLine = null;
    private double trackToTickGap = 2.0;
    private boolean showTickMarks;
    private boolean tooltipConsumeAutoHidingEvents;
    private double thumbWidth;
    private double thumbHeight;
    private double trackStart;
    private double trackLength;
    private double thumbTop;
    private double thumbLeft;
    private double preDragThumbPos;
    private Point2D dragStart;
    private StackPane thumb;
    private StackPane track;
    private boolean trackClicked = false;
    private final SliderBehavior behavior;
    StringConverter<Number> stringConverterWrapper = new SliderSkin$1(this);

    public SliderSkin(Slider slider) {
        super(slider);
        this.behavior = new SliderBehavior(slider);
        this.initialize();
        slider.requestLayout();
        this.registerChangeListener(slider.minProperty(), observableValue -> {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setLowerBound(slider.getMin());
            }
            ((Slider)this.getSkinnable()).requestLayout();
        });
        this.registerChangeListener(slider.maxProperty(), observableValue -> {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setUpperBound(slider.getMax());
            }
            ((Slider)this.getSkinnable()).requestLayout();
        });
        this.registerChangeListener(slider.valueProperty(), observableValue -> {
            SliderSkin sliderSkin = this;
            sliderSkin.positionThumb(sliderSkin.trackClicked);
        });
        this.registerChangeListener(slider.orientationProperty(), observableValue -> {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setSide(slider.getOrientation() == Orientation.VERTICAL ? Side.RIGHT : (slider.getOrientation() == null ? Side.RIGHT : Side.BOTTOM));
            }
            ((Slider)this.getSkinnable()).requestLayout();
        });
        this.registerChangeListener(slider.showTickMarksProperty(), observableValue -> this.setShowTickMarks(slider.isShowTickMarks(), slider.isShowTickLabels()));
        this.registerChangeListener(slider.showTickLabelsProperty(), observableValue -> this.setShowTickMarks(slider.isShowTickMarks(), slider.isShowTickLabels()));
        this.registerChangeListener(slider.majorTickUnitProperty(), observableValue -> {
            if (this.tickLine != null) {
                this.tickLine.setTickUnit(slider.getMajorTickUnit());
                ((Slider)this.getSkinnable()).requestLayout();
            }
        });
        this.registerChangeListener(slider.minorTickCountProperty(), observableValue -> {
            if (this.tickLine != null) {
                this.tickLine.setMinorTickCount(Math.max(slider.getMinorTickCount(), 0) + 1);
                ((Slider)this.getSkinnable()).requestLayout();
            }
        });
        this.registerChangeListener(slider.labelFormatterProperty(), observableValue -> {
            if (this.tickLine != null) {
                if (slider.getLabelFormatter() == null) {
                    this.tickLine.setTickLabelFormatter(null);
                    return;
                }
                this.tickLine.setTickLabelFormatter(this.stringConverterWrapper);
                this.tickLine.requestAxisLayout();
            }
        });
        this.registerChangeListener(slider.snapToTicksProperty(), observableValue -> {
            Slider slider2 = slider;
            slider2.adjustValue(slider2.getValue());
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            ((BehaviorBase)this.behavior).dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6;
        this.thumbWidth = this.snapSizeX(((Node)this.thumb).prefWidth(-1.0));
        this.thumbHeight = this.snapSizeY(((Node)this.thumb).prefHeight(-1.0));
        ((Node)this.thumb).resize(this.thumbWidth, this.thumbHeight);
        double d7 = d6 = this.track.getBackground() != null && this.track.getBackground().getFills().size() > 0 ? this.track.getBackground().getFills().get(0).getRadii().getTopLeftHorizontalRadius() : 0.0;
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            double d8 = this.showTickMarks ? ((Node)this.tickLine).prefHeight(-1.0) : 0.0;
            SliderSkin sliderSkin = this;
            double d9 = sliderSkin.snapSizeY(((Node)sliderSkin.track).prefHeight(-1.0));
            double d10 = Math.max(d9, this.thumbHeight);
            double d11 = d10 + (this.showTickMarks ? this.trackToTickGap + d8 : 0.0);
            double d12 = d3 + (d5 - d11) / 2.0;
            this.trackLength = this.snapSizeX(d4 - this.thumbWidth);
            this.trackStart = this.snapPositionX(d2 + this.thumbWidth / 2.0);
            double d13 = (int)(d12 + (d10 - d9) / 2.0);
            this.thumbTop = (int)(d12 + (d10 - this.thumbHeight) / 2.0);
            this.positionThumb(false);
            this.track.resizeRelocate((int)(this.trackStart - d6), d13, (int)(this.trackLength + d6 + d6), d9);
            if (this.showTickMarks) {
                this.tickLine.setLayoutX(this.trackStart);
                this.tickLine.setLayoutY(d13 + d9 + this.trackToTickGap);
                ((Node)this.tickLine).resize(this.trackLength, d8);
                this.tickLine.requestAxisLayout();
                return;
            }
            if (this.tickLine != null) {
                ((Node)this.tickLine).resize(0.0, 0.0);
                this.tickLine.requestAxisLayout();
            }
            this.tickLine = null;
            return;
        }
        double d14 = this.showTickMarks ? ((Node)this.tickLine).prefWidth(-1.0) : 0.0;
        SliderSkin sliderSkin = this;
        double d15 = sliderSkin.snapSizeX(((Node)sliderSkin.track).prefWidth(-1.0));
        double d16 = Math.max(d15, this.thumbWidth);
        double d17 = d16 + (this.showTickMarks ? this.trackToTickGap + d14 : 0.0);
        double d18 = d2 + (d4 - d17) / 2.0;
        this.trackLength = this.snapSizeY(d5 - this.thumbHeight);
        this.trackStart = this.snapPositionY(d3 + this.thumbHeight / 2.0);
        double d19 = (int)(d18 + (d16 - d15) / 2.0);
        this.thumbLeft = (int)(d18 + (d16 - this.thumbWidth) / 2.0);
        this.positionThumb(false);
        this.track.resizeRelocate(d19, (int)(this.trackStart - d6), d15, (int)(this.trackLength + d6 + d6));
        if (this.showTickMarks) {
            this.tickLine.setLayoutX(d19 + d15 + this.trackToTickGap);
            this.tickLine.setLayoutY(this.trackStart);
            ((Node)this.tickLine).resize(d14, this.trackLength);
            this.tickLine.requestAxisLayout();
            return;
        }
        if (this.tickLine != null) {
            ((Node)this.tickLine).resize(0.0, 0.0);
            this.tickLine.requestAxisLayout();
        }
        this.tickLine = null;
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        Slider slider = (Slider)this.getSkinnable();
        if (slider.getOrientation() == Orientation.HORIZONTAL) {
            return d6 + this.minTrackLength() + ((Node)this.thumb).minWidth(-1.0) + d4;
        }
        return d6 + ((Node)this.thumb).prefWidth(-1.0) + d4;
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        Slider slider = (Slider)this.getSkinnable();
        if (slider.getOrientation() == Orientation.HORIZONTAL) {
            double d7 = this.showTickMarks ? ((Node)this.tickLine).prefHeight(-1.0) + this.trackToTickGap : 0.0;
            return d3 + ((Node)this.thumb).prefHeight(-1.0) + d7 + d5;
        }
        return d3 + this.minTrackLength() + ((Node)this.thumb).prefHeight(-1.0) + d5;
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        Slider slider = (Slider)this.getSkinnable();
        if (slider.getOrientation() == Orientation.HORIZONTAL) {
            if (this.showTickMarks) {
                return Math.max(140.0, ((Node)this.tickLine).prefWidth(-1.0));
            }
            return 140.0;
        }
        double d7 = this.showTickMarks ? ((Node)this.tickLine).prefWidth(-1.0) + this.trackToTickGap : 0.0;
        return d6 + Math.max(((Node)this.thumb).prefWidth(-1.0), ((Node)this.track).prefWidth(-1.0)) + d7 + d4;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        Slider slider = (Slider)this.getSkinnable();
        if (slider.getOrientation() == Orientation.HORIZONTAL) {
            return d3 + Math.max(((Node)this.thumb).prefHeight(-1.0), ((Node)this.track).prefHeight(-1.0)) + (this.showTickMarks ? this.trackToTickGap + ((Node)this.tickLine).prefHeight(-1.0) : 0.0) + d5;
        }
        if (this.showTickMarks) {
            return Math.max(140.0, ((Node)this.tickLine).prefHeight(-1.0));
        }
        return 140.0;
    }

    @Override
    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            return Double.MAX_VALUE;
        }
        return ((Node)((Slider)this.getSkinnable())).prefWidth(-1.0);
    }

    @Override
    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            return ((Node)((Slider)this.getSkinnable())).prefHeight(d2);
        }
        return Double.MAX_VALUE;
    }

    private void initialize() {
        this.thumb = new SliderSkin$2(this);
        this.thumb.getStyleClass().setAll((String[])new String[]{"thumb"});
        this.thumb.setAccessibleRole(AccessibleRole.THUMB);
        this.track = new StackPane();
        this.track.getStyleClass().setAll((String[])new String[]{"track"});
        this.getChildren().clear();
        this.getChildren().addAll((Node[])new Node[]{this.track, this.thumb});
        SliderSkin sliderSkin = this;
        sliderSkin.setShowTickMarks(((Slider)sliderSkin.getSkinnable()).isShowTickMarks(), ((Slider)this.getSkinnable()).isShowTickLabels());
        this.track.setOnMousePressed(mouseEvent -> {
            if (!this.thumb.isPressed()) {
                this.trackClicked = true;
                if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
                    MouseEvent mouseEvent2 = mouseEvent;
                    this.behavior.trackPress(mouseEvent2, mouseEvent2.getX() / this.trackLength);
                } else {
                    MouseEvent mouseEvent3 = mouseEvent;
                    this.behavior.trackPress(mouseEvent3, mouseEvent3.getY() / this.trackLength);
                }
                this.trackClicked = false;
            }
        });
        this.track.setOnMouseDragged(mouseEvent -> {
            if (!this.thumb.isPressed()) {
                if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
                    MouseEvent mouseEvent2 = mouseEvent;
                    this.behavior.trackPress(mouseEvent2, mouseEvent2.getX() / this.trackLength);
                    return;
                }
                MouseEvent mouseEvent3 = mouseEvent;
                this.behavior.trackPress(mouseEvent3, mouseEvent3.getY() / this.trackLength);
            }
        });
        this.thumb.setOnMousePressed(mouseEvent -> {
            this.behavior.thumbPressed((MouseEvent)mouseEvent, 0.0);
            this.dragStart = this.thumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
            this.preDragThumbPos = (((Slider)this.getSkinnable()).getValue() - ((Slider)this.getSkinnable()).getMin()) / (((Slider)this.getSkinnable()).getMax() - ((Slider)this.getSkinnable()).getMin());
        });
        this.thumb.setOnMouseReleased(mouseEvent -> this.behavior.thumbReleased((MouseEvent)mouseEvent));
        this.thumb.setOnMouseDragged(mouseEvent -> {
            Point2D point2D = this.thumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
            double d2 = ((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL ? point2D.getX() - this.dragStart.getX() : -(point2D.getY() - this.dragStart.getY());
            this.behavior.thumbDragged((MouseEvent)mouseEvent, this.preDragThumbPos + d2 / this.trackLength);
        });
        this.thumb.setOnMouseEntered(object -> {
            object = ((Slider)this.getSkinnable()).getTooltip();
            if (object != null && ((PopupWindow)((Object)object)).isAutoHide() && !((PopupWindow)((Object)object)).consumeAutoHidingEventsProperty().isBound()) {
                this.tooltipConsumeAutoHidingEvents = ((PopupWindow)((Object)object)).getConsumeAutoHidingEvents();
                ((PopupWindow)((Object)object)).setConsumeAutoHidingEvents(false);
            }
        });
        this.thumb.setOnMouseExited(object -> {
            object = ((Slider)this.getSkinnable()).getTooltip();
            if (object != null && ((PopupWindow)((Object)object)).isAutoHide() && !((PopupWindow)((Object)object)).consumeAutoHidingEventsProperty().isBound()) {
                ((PopupWindow)((Object)object)).setConsumeAutoHidingEvents(this.tooltipConsumeAutoHidingEvents);
            }
        });
    }

    private void setShowTickMarks(boolean bl2, boolean bl3) {
        this.showTickMarks = bl2 || bl3;
        Slider slider = (Slider)this.getSkinnable();
        if (this.showTickMarks) {
            if (this.tickLine == null) {
                this.tickLine = new NumberAxis();
                this.tickLine.setAutoRanging(false);
                this.tickLine.setSide(slider.getOrientation() == Orientation.VERTICAL ? Side.RIGHT : (slider.getOrientation() == null ? Side.RIGHT : Side.BOTTOM));
                this.tickLine.setUpperBound(slider.getMax());
                this.tickLine.setLowerBound(slider.getMin());
                this.tickLine.setTickUnit(slider.getMajorTickUnit());
                this.tickLine.setTickMarkVisible(bl2);
                this.tickLine.setTickLabelsVisible(bl3);
                this.tickLine.setMinorTickVisible(bl2);
                this.tickLine.setMinorTickCount(Math.max(slider.getMinorTickCount(), 0) + 1);
                if (slider.getLabelFormatter() != null) {
                    this.tickLine.setTickLabelFormatter(this.stringConverterWrapper);
                }
                this.getChildren().clear();
                this.getChildren().addAll((Node[])new Node[]{this.tickLine, this.track, this.thumb});
            } else {
                this.tickLine.setTickLabelsVisible(bl3);
                this.tickLine.setTickMarkVisible(bl2);
                this.tickLine.setMinorTickVisible(bl2);
            }
        } else {
            this.getChildren().clear();
            this.getChildren().addAll((Node[])new Node[]{this.track, this.thumb});
        }
        ((Slider)this.getSkinnable()).requestLayout();
    }

    void positionThumb(boolean bl2) {
        double d2;
        Slider slider;
        Slider slider2 = (Slider)this.getSkinnable();
        if (slider.getValue() > slider2.getMax()) {
            return;
        }
        boolean bl3 = slider2.getOrientation() == Orientation.HORIZONTAL;
        double d3 = bl3 ? this.trackStart + (this.trackLength * ((slider2.getValue() - slider2.getMin()) / (slider2.getMax() - slider2.getMin())) - this.thumbWidth / 2.0) : this.thumbLeft;
        double d4 = d2 = bl3 ? this.thumbTop : this.snappedTopInset() + this.trackLength - this.trackLength * ((slider2.getValue() - slider2.getMin()) / (slider2.getMax() - slider2.getMin()));
        if (bl2) {
            double d5 = this.thumb.getLayoutX();
            double d6 = this.thumb.getLayoutY();
            SliderSkin$3 sliderSkin$3 = new SliderSkin$3(this, d5, d3, d6, d2);
            sliderSkin$3.play();
            return;
        }
        this.thumb.setLayoutX(d3);
        this.thumb.setLayoutY(d2);
    }

    double minTrackLength() {
        return 2.0 * ((Node)this.thumb).prefWidth(-1.0);
    }
}

