/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.control.FakeFocusTextField;
import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.behavior.SpinnerBehavior;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.SpinnerSkin$1;
import javafx.scene.control.skin.SpinnerSkin$2;
import javafx.scene.control.skin.SpinnerSkin$3;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class SpinnerSkin<T>
extends SkinBase<Spinner<T>> {
    private TextField textField;
    private Region incrementArrow;
    private StackPane incrementArrowButton;
    private Region decrementArrow;
    private StackPane decrementArrowButton;
    private static final int ARROWS_ON_RIGHT_VERTICAL = 0;
    private static final int ARROWS_ON_LEFT_VERTICAL = 1;
    private static final int ARROWS_ON_RIGHT_HORIZONTAL = 2;
    private static final int ARROWS_ON_LEFT_HORIZONTAL = 3;
    private static final int SPLIT_ARROWS_VERTICAL = 4;
    private static final int SPLIT_ARROWS_HORIZONTAL = 5;
    private int layoutMode = 0;
    final SpinnerBehavior behavior;
    private static PseudoClass CONTAINS_FOCUS_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("contains-focus");

    public SpinnerSkin(Spinner<T> spinner) {
        super(spinner);
        this.behavior = new SpinnerBehavior<T>(spinner);
        this.textField = spinner.getEditor();
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        this.updateStyleClass();
        listenerHelper.addListChangeListener(spinner.getStyleClass(), listChangeListener$Change -> this.updateStyleClass());
        this.incrementArrow = new Region();
        this.incrementArrow.setFocusTraversable(false);
        this.incrementArrow.getStyleClass().setAll((String[])new String[]{"increment-arrow"});
        this.incrementArrow.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.incrementArrow.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.incrementArrow.setMouseTransparent(true);
        this.incrementArrowButton = new SpinnerSkin$1(this);
        this.incrementArrowButton.setAccessibleRole(AccessibleRole.INCREMENT_BUTTON);
        this.incrementArrowButton.setFocusTraversable(false);
        this.incrementArrowButton.getStyleClass().setAll((String[])new String[]{"increment-arrow-button"});
        this.incrementArrowButton.getChildren().add(this.incrementArrow);
        this.incrementArrowButton.setOnMousePressed(mouseEvent -> {
            ((Spinner)this.getSkinnable()).requestFocus();
            this.behavior.startSpinning(true);
        });
        this.incrementArrowButton.setOnMouseReleased(mouseEvent -> this.behavior.stopSpinning());
        this.decrementArrow = new Region();
        this.decrementArrow.setFocusTraversable(false);
        this.decrementArrow.getStyleClass().setAll((String[])new String[]{"decrement-arrow"});
        this.decrementArrow.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.decrementArrow.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.decrementArrow.setMouseTransparent(true);
        this.decrementArrowButton = new SpinnerSkin$2(this);
        this.decrementArrowButton.setAccessibleRole(AccessibleRole.DECREMENT_BUTTON);
        this.decrementArrowButton.setFocusTraversable(false);
        this.decrementArrowButton.getStyleClass().setAll((String[])new String[]{"decrement-arrow-button"});
        this.decrementArrowButton.getChildren().add(this.decrementArrow);
        this.decrementArrowButton.setOnMousePressed(mouseEvent -> {
            ((Spinner)this.getSkinnable()).requestFocus();
            this.behavior.startSpinning(false);
        });
        this.decrementArrowButton.setOnMouseReleased(mouseEvent -> this.behavior.stopSpinning());
        this.getChildren().addAll((Node[])new Node[]{this.incrementArrowButton, this.decrementArrowButton});
        listenerHelper.addChangeListener(spinner.focusedProperty(), bl2 -> ((FakeFocusTextField)this.textField).setFakeFocus(spinner.isFocused()));
        listenerHelper.addEventFilter(spinner, KeyEvent.ANY, keyEvent -> {
            if (spinner.isEditable()) {
                if (keyEvent.getTarget().equals(this.textField)) {
                    return;
                }
                if (keyEvent.getCode() == KeyCode.ESCAPE) {
                    return;
                }
                if (this.isIncDecKeyEvent((KeyEvent)keyEvent)) {
                    return;
                }
                this.textField.fireEvent(keyEvent.copyFor(this.textField, this.textField));
                if (keyEvent.getCode() == KeyCode.ENTER) {
                    return;
                }
                keyEvent.consume();
            }
        });
        listenerHelper.addEventFilter(this.textField, KeyEvent.ANY, keyEvent -> {
            if (!spinner.isEditable() || this.isIncDecKeyEvent((KeyEvent)keyEvent)) {
                Spinner spinner2 = spinner;
                spinner.fireEvent(keyEvent.copyFor(spinner2, spinner2));
                keyEvent.consume();
            }
        });
        listenerHelper.addChangeListener(this.textField.focusedProperty(), bl2 -> {
            boolean bl3 = this.textField.isFocused();
            spinner.getProperties().put("FOCUSED", bl3);
            if (!bl3) {
                this.pseudoClassStateChanged(CONTAINS_FOCUS_PSEUDOCLASS_STATE, false);
                return;
            }
            this.pseudoClassStateChanged(CONTAINS_FOCUS_PSEUDOCLASS_STATE, true);
        });
        this.textField.focusTraversableProperty().bind(spinner.editableProperty());
        ParentHelper.setTraversalEngine(spinner, new ParentTraversalEngine(spinner, new SpinnerSkin$3(this)));
        listenerHelper.addChangeListener(spinner.sceneProperty(), scene -> this.behavior.stopSpinning());
    }

    private boolean isIncDecKeyEvent(KeyEvent object) {
        return ((object = object.getCode()) == KeyCode.UP || object == KeyCode.DOWN) && this.behavior.arrowsAreVertical();
    }

    @Override
    public void install() {
        this.getChildren().add(this.textField);
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        this.getChildren().removeAll((Node[])new Node[]{this.textField, this.incrementArrowButton, this.decrementArrowButton});
        if (this.behavior != null) {
            this.behavior.dispose();
        }
        super.dispose();
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        SpinnerSkin spinnerSkin = this;
        double d6 = this.incrementArrowButton.snappedLeftInset() + spinnerSkin.snapSizeX(((Node)spinnerSkin.incrementArrow).prefWidth(-1.0)) + this.incrementArrowButton.snappedRightInset();
        SpinnerSkin spinnerSkin2 = this;
        double d7 = this.decrementArrowButton.snappedLeftInset() + spinnerSkin2.snapSizeX(((Node)spinnerSkin2.decrementArrow).prefWidth(-1.0)) + this.decrementArrowButton.snappedRightInset();
        double d8 = Math.max(d6, d7);
        if (this.layoutMode == 0 || this.layoutMode == 1) {
            double d9 = this.layoutMode == 0 ? d2 : d2 + d8;
            double d10 = this.layoutMode == 0 ? d2 + d4 - d8 : d2;
            double d11 = Math.floor(d5 / 2.0);
            this.textField.resizeRelocate(d9, d3, d4 - d8, d5);
            ((Node)this.incrementArrowButton).resize(d8, d11);
            SpinnerSkin spinnerSkin3 = this;
            spinnerSkin3.positionInArea(spinnerSkin3.incrementArrowButton, d10, d3, d8, d11, 0.0, HPos.CENTER, VPos.CENTER);
            ((Node)this.decrementArrowButton).resize(d8, d11);
            SpinnerSkin spinnerSkin4 = this;
            spinnerSkin4.positionInArea(spinnerSkin4.decrementArrowButton, d10, d3 + d11, d8, d5 - d11, 0.0, HPos.CENTER, VPos.BOTTOM);
            return;
        }
        if (this.layoutMode == 2 || this.layoutMode == 3) {
            double d12 = d6 + d7;
            double d13 = this.layoutMode == 2 ? d2 : d2 + d12;
            double d14 = this.layoutMode == 2 ? d2 + d4 - d12 : d2;
            this.textField.resizeRelocate(d13, d3, d4 - d12, d5);
            ((Node)this.decrementArrowButton).resize(d7, d5);
            SpinnerSkin spinnerSkin5 = this;
            spinnerSkin5.positionInArea(spinnerSkin5.decrementArrowButton, d14, d3, d7, d5, 0.0, HPos.CENTER, VPos.CENTER);
            ((Node)this.incrementArrowButton).resize(d6, d5);
            SpinnerSkin spinnerSkin6 = this;
            spinnerSkin6.positionInArea(spinnerSkin6.incrementArrowButton, d14 + d7, d3, d6, d5, 0.0, HPos.CENTER, VPos.CENTER);
            return;
        }
        if (this.layoutMode == 4) {
            SpinnerSkin spinnerSkin7 = this;
            double d15 = this.incrementArrowButton.snappedTopInset() + spinnerSkin7.snapSizeY(((Node)spinnerSkin7.incrementArrow).prefHeight(-1.0)) + this.incrementArrowButton.snappedBottomInset();
            SpinnerSkin spinnerSkin8 = this;
            double d16 = this.decrementArrowButton.snappedTopInset() + spinnerSkin8.snapSizeY(((Node)spinnerSkin8.decrementArrow).prefHeight(-1.0)) + this.decrementArrowButton.snappedBottomInset();
            double d17 = Math.max(d15, d16);
            ((Node)this.incrementArrowButton).resize(d4, d17);
            SpinnerSkin spinnerSkin9 = this;
            spinnerSkin9.positionInArea(spinnerSkin9.incrementArrowButton, d2, d3, d4, d17, 0.0, HPos.CENTER, VPos.CENTER);
            this.textField.resizeRelocate(d2, d3 + d17, d4, d5 - d17 * 2.0);
            ((Node)this.decrementArrowButton).resize(d4, d17);
            SpinnerSkin spinnerSkin10 = this;
            spinnerSkin10.positionInArea(spinnerSkin10.decrementArrowButton, d2, d3 + d5 - d17, d4, d17, 0.0, HPos.CENTER, VPos.CENTER);
            return;
        }
        if (this.layoutMode == 5) {
            ((Node)this.decrementArrowButton).resize(d8, d5);
            SpinnerSkin spinnerSkin11 = this;
            spinnerSkin11.positionInArea(spinnerSkin11.decrementArrowButton, d2, d3, d8, d5, 0.0, HPos.CENTER, VPos.CENTER);
            this.textField.resizeRelocate(d2 + d8, d3, d4 - d8 * 2.0, d5);
            ((Node)this.incrementArrowButton).resize(d8, d5);
            SpinnerSkin spinnerSkin12 = this;
            spinnerSkin12.positionInArea(spinnerSkin12.incrementArrowButton, d2 + d4 - d8, d3, d8, d5, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        return ((Node)this.textField).minWidth(d2);
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        return this.computePrefHeight(d2, d3, d4, d5, d6);
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = ((Node)this.textField).prefWidth(d2);
        return d6 + d7 + d4;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = ((Node)this.textField).prefHeight(d2);
        double d8 = this.layoutMode == 4 ? d3 + ((Node)this.incrementArrowButton).prefHeight(d2) + d7 + ((Node)this.decrementArrowButton).prefHeight(d2) + d5 : d3 + d7 + d5;
        return d8;
    }

    @Override
    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        return ((Node)((Spinner)this.getSkinnable())).prefWidth(d2);
    }

    @Override
    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return ((Node)((Spinner)this.getSkinnable())).prefHeight(d2);
    }

    @Override
    protected double computeBaselineOffset(double d2, double d3, double d4, double d5) {
        return this.textField.getLayoutBounds().getMinY() + this.textField.getLayoutY() + ((Node)this.textField).getBaselineOffset();
    }

    private void updateStyleClass() {
        ObservableList<String> observableList = ((Spinner)this.getSkinnable()).getStyleClass();
        if (observableList.contains("arrows-on-left-vertical")) {
            this.layoutMode = 1;
            return;
        }
        if (observableList.contains("arrows-on-left-horizontal")) {
            this.layoutMode = 3;
            return;
        }
        if (observableList.contains("arrows-on-right-horizontal")) {
            this.layoutMode = 2;
            return;
        }
        if (observableList.contains("split-arrows-vertical")) {
            this.layoutMode = 4;
            return;
        }
        if (observableList.contains("split-arrows-horizontal")) {
            this.layoutMode = 5;
            return;
        }
        this.layoutMode = 0;
    }
}

