/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.ListenerHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.control.SplitPane;
import javafx.scene.control.SplitPane$Divider;
import javafx.scene.control.skin.SplitPaneSkin$Content;
import javafx.scene.control.skin.SplitPaneSkin$ContentDivider;
import javafx.scene.control.skin.SplitPaneSkin$PosPropertyListener;
import javafx.scene.input.MouseEvent;

public class SplitPaneSkin
extends SkinBase<SplitPane> {
    private ObservableList<SplitPaneSkin$Content> contentRegions;
    private ObservableList<SplitPaneSkin$ContentDivider> contentDividers;
    private ListenerHelper contentDividerListenerHelper;
    private boolean horizontal = ((SplitPane)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
    private boolean duringLayout;
    private double previousSize = -1.0;
    private int lastDividerUpdate = 0;
    private boolean resize = false;
    private boolean checkDividerPos = true;

    public SplitPaneSkin(SplitPane splitPane) {
        super(splitPane);
        this.contentRegions = FXCollections.observableArrayList();
        this.contentDividers = FXCollections.observableArrayList();
        int n2 = 0;
        for (Node node : ((SplitPane)this.getSkinnable()).getItems()) {
            this.addContent(n2++, node);
        }
        this.initializeContentListener();
        this.addDividers();
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        listenerHelper.addChangeListener(splitPane.orientationProperty(), object -> {
            this.horizontal = ((SplitPane)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
            this.previousSize = -1.0;
            for (SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider : this.contentDividers) {
                splitPaneSkin$ContentDivider.setGrabberStyle(this.horizontal);
            }
            ((SplitPane)this.getSkinnable()).requestLayout();
        });
        listenerHelper.addChangeListener(splitPane.widthProperty(), number -> ((SplitPane)this.getSkinnable()).requestLayout());
        listenerHelper.addChangeListener(splitPane.heightProperty(), number -> ((SplitPane)this.getSkinnable()).requestLayout());
    }

    @Override
    public void dispose() {
        this.removeAllDividers();
        super.dispose();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6;
        int n2;
        double d7;
        block66: {
            double d8;
            double d9;
            block65: {
                int n3;
                int n4;
                boolean bl2;
                ArrayList<SplitPaneSkin$Content> arrayList;
                block58: {
                    block64: {
                        double d10;
                        SplitPane splitPane;
                        block63: {
                            block62: {
                                block61: {
                                    block60: {
                                        splitPane = (SplitPane)this.getSkinnable();
                                        d9 = splitPane.getWidth();
                                        d8 = splitPane.getHeight();
                                        if (!this.horizontal) break block60;
                                        if (d9 == 0.0) {
                                            return;
                                        }
                                        break block61;
                                    }
                                    if (d8 == 0.0) break block62;
                                }
                                if (!this.contentRegions.isEmpty()) break block63;
                            }
                            return;
                        }
                        double d11 = d7 = this.contentDividers.isEmpty() ? 0.0 : ((Node)((SplitPaneSkin$ContentDivider)this.contentDividers.get(0))).prefWidth(-1.0);
                        if (this.contentDividers.size() <= 0 || this.previousSize == -1.0 || this.previousSize == (this.horizontal ? d9 : d8)) break block64;
                        arrayList = new ArrayList<SplitPaneSkin$Content>();
                        for (SplitPaneSkin$Content splitPaneSkin$Content : this.contentRegions) {
                            if (!splitPaneSkin$Content.isResizableWithParent()) continue;
                            arrayList.add(splitPaneSkin$Content);
                        }
                        double d12 = (this.horizontal ? splitPane.getWidth() : splitPane.getHeight()) - this.previousSize;
                        bl2 = d10 > 0.0;
                        if ((d12 = Math.abs(d12)) == 0.0 || arrayList.isEmpty()) break block65;
                        n4 = (int)d12 / arrayList.size();
                        n2 = (int)d12 % arrayList.size();
                        if (n4 == 0) {
                            n4 = n2;
                            n3 = n2;
                            n2 = 0;
                            break block58;
                        } else {
                            n3 = n4 * arrayList.size();
                        }
                        break block58;
                    }
                    this.previousSize = this.horizontal ? d9 : d8;
                    break block66;
                }
                while (n3 > 0 && !arrayList.isEmpty()) {
                    double d13;
                    SplitPaneSkin$Content splitPaneSkin$Content;
                    block59: {
                        double d14;
                        int n5;
                        if (bl2) {
                            ++this.lastDividerUpdate;
                        } else {
                            --this.lastDividerUpdate;
                            if (this.lastDividerUpdate < 0) {
                                this.lastDividerUpdate = this.contentRegions.size() - 1;
                            }
                        }
                        if (!(splitPaneSkin$Content = (SplitPaneSkin$Content)this.contentRegions.get(n5 = this.lastDividerUpdate % this.contentRegions.size())).isResizableWithParent() || !arrayList.contains(splitPaneSkin$Content)) continue;
                        d13 = splitPaneSkin$Content.getArea();
                        if (bl2) {
                            double d15 = d14 = this.horizontal ? ((Node)splitPaneSkin$Content).maxWidth(-1.0) : ((Node)splitPaneSkin$Content).maxHeight(-1.0);
                            if (d13 + (double)n4 <= d14) {
                                d13 += (double)n4;
                                break block59;
                            } else {
                                arrayList.remove(splitPaneSkin$Content);
                                continue;
                            }
                        }
                        double d16 = d14 = this.horizontal ? ((Node)splitPaneSkin$Content).minWidth(-1.0) : ((Node)splitPaneSkin$Content).minHeight(-1.0);
                        if (d13 - (double)n4 >= d14) {
                            d13 -= (double)n4;
                        } else {
                            arrayList.remove(splitPaneSkin$Content);
                            continue;
                        }
                    }
                    splitPaneSkin$Content.setArea(d13);
                    if ((n3 -= n4) == 0 && n2 != 0) {
                        n4 = n2;
                        n3 = n2;
                        n2 = 0;
                        continue;
                    }
                    if (n3 != 0) continue;
                }
                for (SplitPaneSkin$Content splitPaneSkin$Content : this.contentRegions) {
                    splitPaneSkin$Content.setResizableWithParentArea(splitPaneSkin$Content.getArea());
                    splitPaneSkin$Content.setAvailable(0.0);
                }
                this.resize = true;
            }
            this.previousSize = this.horizontal ? d9 : d8;
        }
        this.duringLayout = true;
        double d17 = this.totalMinSize();
        if (!(d6 > (this.horizontal ? d4 : d5))) {
        } else {
            int n6 = 0;
            while (true) {
                if (n6 >= this.contentRegions.size()) {
                    this.setupContentAndDividerForLayout();
                    this.layoutDividersAndContent(d4, d5);
                    this.resize = false;
                    this.duringLayout = false;
                    return;
                }
                SplitPaneSkin$Content splitPaneSkin$Content = (SplitPaneSkin$Content)this.contentRegions.get(n6);
                double d18 = this.horizontal ? ((Node)splitPaneSkin$Content).minWidth(-1.0) : ((Node)splitPaneSkin$Content).minHeight(-1.0);
                double d19 = d18 / d17;
                if (this.horizontal) {
                    splitPaneSkin$Content.setArea(this.snapSpaceX(d19 * d4));
                } else {
                    splitPaneSkin$Content.setArea(this.snapSpaceY(d19 * d5));
                }
                splitPaneSkin$Content.setAvailable(0.0);
                ++n6;
            }
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider = null;
            SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider2 = null;
            for (n2 = 0; n2 < this.contentRegions.size(); ++n2) {
                double d20;
                block69: {
                    double d21;
                    double d22;
                    block70: {
                        block67: {
                            block68: {
                                d20 = 0.0;
                                if (n2 >= this.contentDividers.size()) break block67;
                                splitPaneSkin$ContentDivider2 = (SplitPaneSkin$ContentDivider)this.contentDividers.get(n2);
                                if (splitPaneSkin$ContentDivider2.posExplicit) {
                                    SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider3 = splitPaneSkin$ContentDivider2;
                                    this.checkDividerPosition(splitPaneSkin$ContentDivider2, this.posToDividerPos(splitPaneSkin$ContentDivider3, splitPaneSkin$ContentDivider3.d.getPosition()), splitPaneSkin$ContentDivider2.getDividerPos());
                                }
                                if (n2 != 0) break block68;
                                d20 = this.getAbsoluteDividerPos(splitPaneSkin$ContentDivider2);
                                break block69;
                            }
                            double d23 = this.getAbsoluteDividerPos(splitPaneSkin$ContentDivider) + d7;
                            if (this.getAbsoluteDividerPos(splitPaneSkin$ContentDivider2) <= this.getAbsoluteDividerPos(splitPaneSkin$ContentDivider)) {
                                this.setAndCheckAbsoluteDividerPos(splitPaneSkin$ContentDivider2, d23);
                            }
                            d22 = this.getAbsoluteDividerPos(splitPaneSkin$ContentDivider2);
                            d21 = d23;
                            break block70;
                        }
                        if (n2 != this.contentDividers.size()) break block69;
                        d22 = this.horizontal ? d4 : d5;
                        d21 = splitPaneSkin$ContentDivider != null ? this.getAbsoluteDividerPos(splitPaneSkin$ContentDivider) + d7 : 0.0;
                    }
                    d20 = d22 - d21;
                }
                if (!this.resize || splitPaneSkin$ContentDivider2.posExplicit) {
                    ((SplitPaneSkin$Content)this.contentRegions.get(n2)).setArea(d20);
                }
                splitPaneSkin$ContentDivider = splitPaneSkin$ContentDivider2;
            }
            double d24 = 0.0;
            double d25 = 0.0;
            for (SplitPaneSkin$Content splitPaneSkin$Content : this.contentRegions) {
                double d26;
                if (splitPaneSkin$Content == null) continue;
                double d27 = this.horizontal ? ((Node)splitPaneSkin$Content).maxWidth(-1.0) : ((Node)splitPaneSkin$Content).maxHeight(-1.0);
                double d28 = d26 = this.horizontal ? ((Node)splitPaneSkin$Content).minWidth(-1.0) : ((Node)splitPaneSkin$Content).minHeight(-1.0);
                if (splitPaneSkin$Content.getArea() >= d27) {
                    d25 += splitPaneSkin$Content.getArea() - d27;
                    splitPaneSkin$Content.setArea(d27);
                }
                SplitPaneSkin$Content splitPaneSkin$Content2 = splitPaneSkin$Content;
                splitPaneSkin$Content2.setAvailable(splitPaneSkin$Content2.getArea() - d26);
                if (!(splitPaneSkin$Content.getAvailable() < 0.0)) continue;
                d24 += splitPaneSkin$Content.getAvailable();
            }
            d24 = Math.abs(d24);
            ArrayList arrayList = new ArrayList();
            ArrayList<SplitPaneSkin$Content> arrayList2 = new ArrayList<SplitPaneSkin$Content>();
            ArrayList<SplitPaneSkin$Content> arrayList3 = new ArrayList<SplitPaneSkin$Content>();
            double d29 = 0.0;
            for (SplitPaneSkin$Content splitPaneSkin$Content : this.contentRegions) {
                SplitPaneSkin$Content splitPaneSkin$Content3;
                if (splitPaneSkin$Content3.getAvailable() >= 0.0) {
                    d29 += splitPaneSkin$Content.getAvailable();
                    arrayList.add(splitPaneSkin$Content);
                }
                if (this.resize && !splitPaneSkin$Content.isResizableWithParent()) {
                    if (splitPaneSkin$Content.getArea() >= splitPaneSkin$Content.getResizableWithParentArea()) {
                        d25 += splitPaneSkin$Content.getArea() - splitPaneSkin$Content.getResizableWithParentArea();
                    } else {
                        d24 += splitPaneSkin$Content.getResizableWithParentArea() - splitPaneSkin$Content.getArea();
                    }
                    splitPaneSkin$Content.setAvailable(0.0);
                }
                if (this.resize) {
                    if (splitPaneSkin$Content.isResizableWithParent()) {
                        arrayList2.add(splitPaneSkin$Content);
                    }
                } else {
                    arrayList2.add(splitPaneSkin$Content);
                }
                if (!(splitPaneSkin$Content.getAvailable() < 0.0)) continue;
                arrayList3.add(splitPaneSkin$Content);
            }
            if (d25 > 0.0) {
                d25 = this.distributeTo(arrayList2, d25);
                d24 = 0.0;
                arrayList3.clear();
                d29 = 0.0;
                arrayList.clear();
                for (SplitPaneSkin$Content splitPaneSkin$Content : this.contentRegions) {
                    SplitPaneSkin$Content splitPaneSkin$Content4;
                    if (splitPaneSkin$Content4.getAvailable() < 0.0) {
                        d24 += splitPaneSkin$Content.getAvailable();
                        arrayList3.add(splitPaneSkin$Content);
                        continue;
                    }
                    d29 += splitPaneSkin$Content.getAvailable();
                    arrayList.add(splitPaneSkin$Content);
                }
                d24 = Math.abs(d24);
            }
            if (d29 >= d24) {
                for (SplitPaneSkin$Content splitPaneSkin$Content : arrayList3) {
                    double d30 = this.horizontal ? ((Node)splitPaneSkin$Content).minWidth(-1.0) : ((Node)splitPaneSkin$Content).minHeight(-1.0);
                    splitPaneSkin$Content.setArea(d30);
                    splitPaneSkin$Content.setAvailable(0.0);
                }
                if (d24 > 0.0 && !arrayList3.isEmpty()) {
                    this.distributeFrom(d24, arrayList);
                }
                if (this.resize) {
                    double d31;
                    double d32 = 0.0;
                    for (SplitPaneSkin$Content splitPaneSkin$Content : this.contentRegions) {
                        if (splitPaneSkin$Content.isResizableWithParent()) {
                            d32 += splitPaneSkin$Content.getArea();
                            continue;
                        }
                        d32 += splitPaneSkin$Content.getResizableWithParentArea();
                    }
                    d32 += d7 * (double)this.contentDividers.size();
                    double d33 = this.horizontal ? d4 : d5;
                    if (d31 < d33) {
                        this.distributeTo(arrayList2, d25 += (this.horizontal ? d4 : d5) - d32);
                    } else {
                        this.distributeFrom(d24 += d32 - (this.horizontal ? d4 : d5), arrayList2);
                    }
                }
            }
            this.setupContentAndDividerForLayout();
            boolean bl3 = true;
            for (SplitPaneSkin$Content splitPaneSkin$Content : this.contentRegions) {
                double d34;
                double d35 = this.horizontal ? ((Node)splitPaneSkin$Content).maxWidth(-1.0) : ((Node)splitPaneSkin$Content).maxHeight(-1.0);
                double d36 = d34 = this.horizontal ? ((Node)splitPaneSkin$Content).minWidth(-1.0) : ((Node)splitPaneSkin$Content).minHeight(-1.0);
                if (!(splitPaneSkin$Content.getArea() < d34) && !(splitPaneSkin$Content.getArea() > d35)) continue;
                bl3 = false;
                break;
            }
            if (bl3) break;
        }
        this.layoutDividersAndContent(d4, d5);
        this.duringLayout = false;
        this.resize = false;
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        double d8 = 0.0;
        for (SplitPaneSkin$Content stackPane : this.contentRegions) {
            d7 += ((Node)stackPane).minWidth(-1.0);
            d8 = Math.max(d8, ((Node)stackPane).minWidth(-1.0));
        }
        for (SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider : this.contentDividers) {
            d7 += ((Node)splitPaneSkin$ContentDivider).prefWidth(-1.0);
        }
        if (this.horizontal) {
            return d7 + d6 + d4;
        }
        return d8 + d6 + d4;
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        double d8 = 0.0;
        for (SplitPaneSkin$Content stackPane : this.contentRegions) {
            d7 += ((Node)stackPane).minHeight(-1.0);
            d8 = Math.max(d8, ((Node)stackPane).minHeight(-1.0));
        }
        for (SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider : this.contentDividers) {
            d7 += ((Node)splitPaneSkin$ContentDivider).prefWidth(-1.0);
        }
        if (this.horizontal) {
            return d8 + d3 + d5;
        }
        return d7 + d3 + d5;
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        double d8 = 0.0;
        for (SplitPaneSkin$Content stackPane : this.contentRegions) {
            d7 += ((Node)stackPane).prefWidth(-1.0);
            d8 = Math.max(d8, ((Node)stackPane).prefWidth(-1.0));
        }
        for (SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider : this.contentDividers) {
            d7 += ((Node)splitPaneSkin$ContentDivider).prefWidth(-1.0);
        }
        if (this.horizontal) {
            return d7 + d6 + d4;
        }
        return d8 + d6 + d4;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        double d8 = 0.0;
        for (SplitPaneSkin$Content stackPane : this.contentRegions) {
            d7 += ((Node)stackPane).prefHeight(-1.0);
            d8 = Math.max(d8, ((Node)stackPane).prefHeight(-1.0));
        }
        for (SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider : this.contentDividers) {
            d7 += ((Node)splitPaneSkin$ContentDivider).prefWidth(-1.0);
        }
        if (this.horizontal) {
            return d8 + d3 + d5;
        }
        return d7 + d3 + d5;
    }

    private void addContent(int n2, Node node) {
        node = new SplitPaneSkin$Content(node);
        this.contentRegions.add(n2, (SplitPaneSkin$Content)node);
        this.getChildren().add(n2, node);
    }

    private void removeContent(Node node) {
        for (SplitPaneSkin$Content splitPaneSkin$Content : this.contentRegions) {
            if (!splitPaneSkin$Content.getContent().equals(node)) continue;
            splitPaneSkin$Content.dispose();
            this.getChildren().remove(splitPaneSkin$Content);
            this.contentRegions.remove(splitPaneSkin$Content);
            return;
        }
    }

    private void initializeContentListener() {
        ListenerHelper.get(this).addListChangeListener(((SplitPane)this.getSkinnable()).getItems(), listChangeListener$Change -> {
            while (listChangeListener$Change.next()) {
                Iterator iterator2;
                int n2;
                if (listChangeListener$Change.wasPermutated() || listChangeListener$Change.wasUpdated()) {
                    this.getChildren().clear();
                    this.contentRegions.clear();
                    n2 = 0;
                    for (Node node : listChangeListener$Change.getList()) {
                        this.addContent(n2++, node);
                    }
                    continue;
                }
                for (Iterator iterator2 : listChangeListener$Change.getRemoved()) {
                    this.removeContent((Node)((Object)iterator2));
                }
                n2 = listChangeListener$Change.getFrom();
                iterator2 = listChangeListener$Change.getAddedSubList().iterator();
                while (iterator2.hasNext()) {
                    Node node;
                    node = (Node)iterator2.next();
                    this.addContent(n2++, node);
                }
            }
            this.removeAllDividers();
            this.addDividers();
        });
    }

    private void checkDividerPosition(SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider, double d2, double d3) {
        double d4;
        double d5;
        double d6;
        double d7 = ((Node)splitPaneSkin$ContentDivider).prefWidth(-1.0);
        SplitPaneSkin$Content splitPaneSkin$Content = this.getLeft(splitPaneSkin$ContentDivider);
        SplitPaneSkin$Content splitPaneSkin$Content2 = this.getRight(splitPaneSkin$ContentDivider);
        double d8 = splitPaneSkin$Content == null ? 0.0 : (d6 = this.horizontal ? ((Node)splitPaneSkin$Content).minWidth(-1.0) : ((Node)splitPaneSkin$Content).minHeight(-1.0));
        double d9 = splitPaneSkin$Content2 == null ? 0.0 : (d5 = this.horizontal ? ((Node)splitPaneSkin$Content2).minWidth(-1.0) : ((Node)splitPaneSkin$Content2).minHeight(-1.0));
        double d10 = splitPaneSkin$Content != null && splitPaneSkin$Content.getContent() != null ? (this.horizontal ? splitPaneSkin$Content.getContent().maxWidth(-1.0) : splitPaneSkin$Content.getContent().maxHeight(-1.0)) : (d4 = 0.0);
        double d11 = splitPaneSkin$Content2 != null && splitPaneSkin$Content2.getContent() != null ? (this.horizontal ? splitPaneSkin$Content2.getContent().maxWidth(-1.0) : splitPaneSkin$Content2.getContent().maxHeight(-1.0)) : 0.0;
        double d12 = 0.0;
        double d13 = this.getSize();
        int n2 = this.contentDividers.indexOf(splitPaneSkin$ContentDivider);
        if (n2 - 1 >= 0 && (d12 = ((SplitPaneSkin$ContentDivider)this.contentDividers.get(n2 - 1)).getDividerPos()) == -1.0) {
            SplitPaneSkin splitPaneSkin = this;
            d12 = splitPaneSkin.getAbsoluteDividerPos((SplitPaneSkin$ContentDivider)splitPaneSkin.contentDividers.get(n2 - 1));
        }
        if (n2 + 1 < this.contentDividers.size() && (d13 = ((SplitPaneSkin$ContentDivider)this.contentDividers.get(n2 + 1)).getDividerPos()) == -1.0) {
            SplitPaneSkin splitPaneSkin = this;
            d13 = splitPaneSkin.getAbsoluteDividerPos((SplitPaneSkin$ContentDivider)splitPaneSkin.contentDividers.get(n2 + 1));
        }
        this.checkDividerPos = false;
        if (d2 > d3) {
            double d14;
            double d15 = d12 == 0.0 ? d4 : d12 + d7 + d4;
            double d16 = Math.min(d15, d14 = d13 - d5 - d7);
            if (d2 >= d16) {
                this.setAbsoluteDividerPos(splitPaneSkin$ContentDivider, d16);
            } else {
                double d17 = d13 - d11 - d7;
                if (d2 <= d17) {
                    this.setAbsoluteDividerPos(splitPaneSkin$ContentDivider, d17);
                } else {
                    this.setAbsoluteDividerPos(splitPaneSkin$ContentDivider, d2);
                }
            }
        } else {
            double d18 = d13 - d11 - d7;
            double d19 = d12 == 0.0 ? d6 : d12 + d6 + d7;
            double d20 = Math.max(d18, d19);
            if (d2 <= d20) {
                this.setAbsoluteDividerPos(splitPaneSkin$ContentDivider, d20);
            } else {
                double d21 = d12 + d4 + d7;
                if (d2 >= d21) {
                    this.setAbsoluteDividerPos(splitPaneSkin$ContentDivider, d21);
                } else {
                    this.setAbsoluteDividerPos(splitPaneSkin$ContentDivider, d2);
                }
            }
        }
        this.checkDividerPos = true;
    }

    private void addDividers() {
        this.contentDividerListenerHelper = new ListenerHelper();
        for (SplitPane$Divider splitPane$Divider : ((SplitPane)this.getSkinnable()).getDividers()) {
            SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider = new SplitPaneSkin$ContentDivider(this, splitPane$Divider);
            splitPaneSkin$ContentDivider.setInitialPos(splitPane$Divider.getPosition());
            splitPaneSkin$ContentDivider.setDividerPos(-1.0);
            SplitPaneSkin$PosPropertyListener splitPaneSkin$PosPropertyListener = new SplitPaneSkin$PosPropertyListener(this, splitPaneSkin$ContentDivider);
            this.contentDividerListenerHelper.addChangeListener(splitPane$Divider.positionProperty(), splitPaneSkin$PosPropertyListener);
            this.initializeDividerEventHandlers(splitPaneSkin$ContentDivider);
            this.contentDividers.add(splitPaneSkin$ContentDivider);
            this.getChildren().add(splitPaneSkin$ContentDivider);
        }
    }

    private void removeAllDividers() {
        ListIterator listIterator = this.contentDividers.listIterator();
        while (listIterator.hasNext()) {
            SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider = (SplitPaneSkin$ContentDivider)listIterator.next();
            this.getChildren().remove(splitPaneSkin$ContentDivider);
            listIterator.remove();
        }
        this.lastDividerUpdate = 0;
        if (this.contentDividerListenerHelper != null) {
            this.contentDividerListenerHelper.disconnect();
            this.contentDividerListenerHelper = null;
        }
    }

    private void initializeDividerEventHandlers(SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider) {
        splitPaneSkin$ContentDivider.addEventHandler(MouseEvent.ANY, mouseEvent -> mouseEvent.consume());
        splitPaneSkin$ContentDivider.setOnMousePressed(mouseEvent -> {
            if (this.horizontal) {
                SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider2 = splitPaneSkin$ContentDivider;
                splitPaneSkin$ContentDivider2.setInitialPos(splitPaneSkin$ContentDivider2.getDividerPos());
                splitPaneSkin$ContentDivider.setPressPos(mouseEvent.getSceneX());
                splitPaneSkin$ContentDivider.setPressPos(((SplitPane)this.getSkinnable()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT ? ((SplitPane)this.getSkinnable()).getWidth() - mouseEvent.getSceneX() : mouseEvent.getSceneX());
            } else {
                SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider3 = splitPaneSkin$ContentDivider;
                splitPaneSkin$ContentDivider3.setInitialPos(splitPaneSkin$ContentDivider3.getDividerPos());
                splitPaneSkin$ContentDivider.setPressPos(mouseEvent.getSceneY());
            }
            mouseEvent.consume();
        });
        splitPaneSkin$ContentDivider.setOnMouseDragged(mouseEvent -> {
            double d2 = this.horizontal ? (((SplitPane)this.getSkinnable()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT ? ((SplitPane)this.getSkinnable()).getWidth() - mouseEvent.getSceneX() : mouseEvent.getSceneX()) : mouseEvent.getSceneY();
            SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider2 = splitPaneSkin$ContentDivider;
            this.setAndCheckAbsoluteDividerPos(splitPaneSkin$ContentDivider2, Math.ceil(splitPaneSkin$ContentDivider2.getInitialPos() + (d2 -= splitPaneSkin$ContentDivider.getPressPos())));
            mouseEvent.consume();
        });
    }

    private SplitPaneSkin$Content getLeft(SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider) {
        int n2 = this.contentDividers.indexOf(splitPaneSkin$ContentDivider);
        if (n2 != -1) {
            return (SplitPaneSkin$Content)this.contentRegions.get(n2);
        }
        return null;
    }

    private SplitPaneSkin$Content getRight(SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider) {
        int n2 = this.contentDividers.indexOf(splitPaneSkin$ContentDivider);
        if (n2 != -1) {
            return (SplitPaneSkin$Content)this.contentRegions.get(n2 + 1);
        }
        return null;
    }

    private void setAbsoluteDividerPos(SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider, double d2) {
        if (((SplitPane)this.getSkinnable()).getWidth() > 0.0 && ((SplitPane)this.getSkinnable()).getHeight() > 0.0 && splitPaneSkin$ContentDivider != null) {
            SplitPane$Divider splitPane$Divider = splitPaneSkin$ContentDivider.getDivider();
            splitPaneSkin$ContentDivider.setDividerPos(d2);
            double d3 = this.getSize();
            if (d3 != 0.0) {
                double d4 = d2 + ((Node)splitPaneSkin$ContentDivider).prefWidth(-1.0) / 2.0;
                splitPane$Divider.setPosition(d4 / d3);
                return;
            }
            splitPane$Divider.setPosition(0.0);
        }
    }

    private double getAbsoluteDividerPos(SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider) {
        if (((SplitPane)this.getSkinnable()).getWidth() > 0.0 && ((SplitPane)this.getSkinnable()).getHeight() > 0.0 && splitPaneSkin$ContentDivider != null) {
            SplitPane$Divider splitPane$Divider = splitPaneSkin$ContentDivider.getDivider();
            double d2 = this.posToDividerPos(splitPaneSkin$ContentDivider, splitPane$Divider.getPosition());
            splitPaneSkin$ContentDivider.setDividerPos(d2);
            return d2;
        }
        return 0.0;
    }

    private double posToDividerPos(SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider, double d2) {
        double d3 = this.getSize() * d2;
        d3 = d2 == 1.0 ? (d3 -= ((Node)splitPaneSkin$ContentDivider).prefWidth(-1.0)) : (d3 -= ((Node)splitPaneSkin$ContentDivider).prefWidth(-1.0) / 2.0);
        return Math.round(d3);
    }

    private double totalMinSize() {
        double d2 = !this.contentDividers.isEmpty() ? (double)this.contentDividers.size() * ((Node)((SplitPaneSkin$ContentDivider)this.contentDividers.get(0))).prefWidth(-1.0) : 0.0;
        double d3 = 0.0;
        for (SplitPaneSkin$Content splitPaneSkin$Content : this.contentRegions) {
            if (this.horizontal) {
                d3 += ((Node)splitPaneSkin$Content).minWidth(-1.0);
                continue;
            }
            d3 += ((Node)splitPaneSkin$Content).minHeight(-1.0);
        }
        return d3 + d2;
    }

    private double getSize() {
        SplitPane splitPane = (SplitPane)this.getSkinnable();
        double d2 = this.totalMinSize();
        if (this.horizontal) {
            if (splitPane.getWidth() > d2) {
                d2 = splitPane.getWidth() - this.snappedLeftInset() - this.snappedRightInset();
            }
        } else if (splitPane.getHeight() > d2) {
            d2 = splitPane.getHeight() - this.snappedTopInset() - this.snappedBottomInset();
        }
        return d2;
    }

    private double distributeTo(List<SplitPaneSkin$Content> list, double d2) {
        if (list.isEmpty()) {
            return d2;
        }
        d2 = this.horizontal ? this.snapSizeX(d2) : this.snapSizeY(d2);
        int n2 = (int)d2 / list.size();
        while (d2 > 0.0 && !list.isEmpty()) {
            Iterator<SplitPaneSkin$Content> iterator = list.iterator();
            while (iterator.hasNext()) {
                double d3;
                SplitPaneSkin$Content splitPaneSkin$Content = iterator.next();
                double d4 = Math.min(this.horizontal ? ((Node)splitPaneSkin$Content).maxWidth(-1.0) : ((Node)splitPaneSkin$Content).maxHeight(-1.0), Double.MAX_VALUE);
                double d5 = d3 = this.horizontal ? ((Node)splitPaneSkin$Content).minWidth(-1.0) : ((Node)splitPaneSkin$Content).minHeight(-1.0);
                if (splitPaneSkin$Content.getArea() >= d4) {
                    SplitPaneSkin$Content splitPaneSkin$Content2 = splitPaneSkin$Content;
                    splitPaneSkin$Content2.setAvailable(splitPaneSkin$Content2.getArea() - d3);
                    iterator.remove();
                    continue;
                }
                if ((double)n2 >= d4 - splitPaneSkin$Content.getArea()) {
                    d2 -= d4 - splitPaneSkin$Content.getArea();
                    splitPaneSkin$Content.setArea(d4);
                    splitPaneSkin$Content.setAvailable(d4 - d3);
                    iterator.remove();
                } else {
                    SplitPaneSkin$Content splitPaneSkin$Content3 = splitPaneSkin$Content;
                    splitPaneSkin$Content3.setArea(splitPaneSkin$Content3.getArea() + (double)n2);
                    SplitPaneSkin$Content splitPaneSkin$Content4 = splitPaneSkin$Content;
                    splitPaneSkin$Content4.setAvailable(splitPaneSkin$Content4.getArea() - d3);
                    d2 -= (double)n2;
                }
                if ((int)d2 != 0) continue;
                return d2;
            }
            if (list.isEmpty()) {
                return d2;
            }
            n2 = (int)d2 / list.size();
            int n3 = (int)d2 % list.size();
            if (n2 != 0 || n3 == 0) continue;
            n2 = n3;
        }
        return d2;
    }

    private double distributeFrom(double d2, List<SplitPaneSkin$Content> list) {
        if (list.isEmpty()) {
            return d2;
        }
        d2 = this.horizontal ? this.snapSizeX(d2) : this.snapSizeY(d2);
        int n2 = (int)d2 / list.size();
        while (d2 > 0.0 && !list.isEmpty()) {
            Iterator<SplitPaneSkin$Content> iterator = list.iterator();
            while (iterator.hasNext()) {
                SplitPaneSkin$Content splitPaneSkin$Content = iterator.next();
                if ((double)n2 >= splitPaneSkin$Content.getAvailable()) {
                    SplitPaneSkin$Content splitPaneSkin$Content2 = splitPaneSkin$Content;
                    splitPaneSkin$Content2.setArea(splitPaneSkin$Content2.getArea() - splitPaneSkin$Content.getAvailable());
                    d2 -= splitPaneSkin$Content.getAvailable();
                    splitPaneSkin$Content.setAvailable(0.0);
                    iterator.remove();
                } else {
                    SplitPaneSkin$Content splitPaneSkin$Content3 = splitPaneSkin$Content;
                    splitPaneSkin$Content3.setArea(splitPaneSkin$Content3.getArea() - (double)n2);
                    SplitPaneSkin$Content splitPaneSkin$Content4 = splitPaneSkin$Content;
                    splitPaneSkin$Content4.setAvailable(splitPaneSkin$Content4.getAvailable() - (double)n2);
                    d2 -= (double)n2;
                }
                if ((int)d2 != 0) continue;
                return d2;
            }
            if (list.isEmpty()) {
                return d2;
            }
            n2 = (int)d2 / list.size();
            int n3 = (int)d2 % list.size();
            if (n2 != 0 || n3 == 0) continue;
            n2 = n3;
        }
        return d2;
    }

    private void setupContentAndDividerForLayout() {
        double d2 = this.contentDividers.isEmpty() ? 0.0 : ((Node)((SplitPaneSkin$ContentDivider)this.contentDividers.get(0))).prefWidth(-1.0);
        double d3 = 0.0;
        double d4 = 0.0;
        for (SplitPaneSkin$Content stackPane : this.contentRegions) {
            if (this.resize && !stackPane.isResizableWithParent()) {
                SplitPaneSkin$Content splitPaneSkin$Content = stackPane;
                splitPaneSkin$Content.setArea(splitPaneSkin$Content.getResizableWithParentArea());
            }
            stackPane.setX(d3);
            stackPane.setY(d4);
            if (this.horizontal) {
                d3 += stackPane.getArea() + d2;
                continue;
            }
            d4 += stackPane.getArea() + d2;
        }
        d3 = 0.0;
        d4 = 0.0;
        this.checkDividerPos = false;
        for (int i2 = 0; i2 < this.contentDividers.size(); ++i2) {
            SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider = (SplitPaneSkin$ContentDivider)this.contentDividers.get(i2);
            if (this.horizontal) {
                d3 += this.getLeft(splitPaneSkin$ContentDivider).getArea() + (i2 == 0 ? 0.0 : d2);
            } else {
                d4 += this.getLeft(splitPaneSkin$ContentDivider).getArea() + (i2 == 0 ? 0.0 : d2);
            }
            splitPaneSkin$ContentDivider.setX(d3);
            splitPaneSkin$ContentDivider.setY(d4);
            this.setAbsoluteDividerPos(splitPaneSkin$ContentDivider, this.horizontal ? splitPaneSkin$ContentDivider.getX() : splitPaneSkin$ContentDivider.getY());
            splitPaneSkin$ContentDivider.posExplicit = false;
        }
        this.checkDividerPos = true;
    }

    private void layoutDividersAndContent(double d2, double d3) {
        double d4 = this.snappedLeftInset();
        double d5 = this.snappedTopInset();
        double d6 = this.contentDividers.isEmpty() ? 0.0 : ((Node)((SplitPaneSkin$ContentDivider)this.contentDividers.get(0))).prefWidth(-1.0);
        for (SplitPaneSkin$Content stackPane : this.contentRegions) {
            if (this.horizontal) {
                SplitPaneSkin$Content splitPaneSkin$Content = stackPane;
                splitPaneSkin$Content.setClipSize(splitPaneSkin$Content.getArea(), d3);
                SplitPaneSkin$Content splitPaneSkin$Content2 = stackPane;
                this.layoutInArea(splitPaneSkin$Content2, splitPaneSkin$Content2.getX() + d4, stackPane.getY() + d5, stackPane.getArea(), d3, 0.0, HPos.CENTER, VPos.CENTER);
                continue;
            }
            stackPane.setClipSize(d2, stackPane.getArea());
            SplitPaneSkin$Content splitPaneSkin$Content = stackPane;
            this.layoutInArea(splitPaneSkin$Content, splitPaneSkin$Content.getX() + d4, stackPane.getY() + d5, d2, stackPane.getArea(), 0.0, HPos.CENTER, VPos.CENTER);
        }
        for (SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider : this.contentDividers) {
            if (this.horizontal) {
                ((Node)splitPaneSkin$ContentDivider).resize(d6, d3);
                SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider2 = splitPaneSkin$ContentDivider;
                this.positionInArea(splitPaneSkin$ContentDivider2, splitPaneSkin$ContentDivider2.getX() + d4, splitPaneSkin$ContentDivider.getY() + d5, d6, d3, 0.0, HPos.CENTER, VPos.CENTER);
                continue;
            }
            ((Node)splitPaneSkin$ContentDivider).resize(d2, d6);
            SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider3 = splitPaneSkin$ContentDivider;
            this.positionInArea(splitPaneSkin$ContentDivider3, splitPaneSkin$ContentDivider3.getX() + d4, splitPaneSkin$ContentDivider.getY() + d5, d2, d6, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    private void setAndCheckAbsoluteDividerPos(SplitPaneSkin$ContentDivider splitPaneSkin$ContentDivider, double d2) {
        double d3 = splitPaneSkin$ContentDivider.getDividerPos();
        this.setAbsoluteDividerPos(splitPaneSkin$ContentDivider, d2);
        this.checkDividerPosition(splitPaneSkin$ContentDivider, d2, d3);
    }
}

