/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import java.util.Collection;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.geometry.HPos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.skin.TabPaneSkin;
import javafx.scene.control.skin.TabPaneSkin$TabControlButtons$1;
import javafx.scene.control.skin.TabPaneSkin$TabMenuItem;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

class TabPaneSkin$TabControlButtons
extends StackPane {
    private StackPane inner;
    private StackPane downArrow;
    private Pane downArrowBtn;
    private boolean showControlButtons;
    private ContextMenu popup;
    InvalidationListener sidePropListener = object -> {
        object = ((TabPane)this.this$0.getSkinnable()).getSide();
        this.downArrow.setRotate(((Enum)((Object)object)).equals((Object)Side.BOTTOM) ? 180.0 : 0.0);
    };
    ListChangeListener<Tab> tabsListenerForPopup = listChangeListener$Change -> this.setupPopupMenu();
    WeakInvalidationListener weakSidePropListener = new WeakInvalidationListener(this.sidePropListener);
    WeakListChangeListener weakTabsListenerForPopup = new WeakListChangeListener<Tab>(this.tabsListenerForPopup);
    private boolean showTabsMenu = false;
    final /* synthetic */ TabPaneSkin this$0;

    public TabPaneSkin$TabControlButtons(TabPaneSkin tabPaneSkin) {
        this.this$0 = tabPaneSkin;
        this.getStyleClass().setAll((String[])new String[]{"control-buttons-tab"});
        TabPane tabPane = (TabPane)tabPaneSkin.getSkinnable();
        this.downArrowBtn = new Pane();
        this.downArrowBtn.getStyleClass().setAll((String[])new String[]{"tab-down-button"});
        this.downArrowBtn.setVisible(this.isShowTabsMenu());
        this.downArrow = new StackPane();
        this.downArrow.setManaged(false);
        this.downArrow.getStyleClass().setAll((String[])new String[]{"arrow"});
        this.downArrow.setRotate(tabPane.getSide().equals((Object)Side.BOTTOM) ? 180.0 : 0.0);
        this.downArrowBtn.getChildren().add(this.downArrow);
        this.downArrowBtn.setOnMouseClicked(mouseEvent -> this.showPopupMenu());
        this.setupPopupMenu();
        this.inner = new TabPaneSkin$TabControlButtons$1(this, tabPaneSkin);
        this.inner.getStyleClass().add("container");
        this.inner.getChildren().add(this.downArrowBtn);
        this.getChildren().add(this.inner);
        tabPane.sideProperty().addListener(this.weakSidePropListener);
        tabPane.getTabs().addListener(this.weakTabsListenerForPopup);
        this.showControlButtons = false;
        if (this.isShowTabsMenu()) {
            this.showControlButtons = true;
            ((Parent)this).requestLayout();
        }
        this.getProperties().put(ContextMenu.class, this.popup);
    }

    void dispose() {
        ((TabPane)this.this$0.getSkinnable()).sideProperty().removeListener(this.weakSidePropListener);
        ((TabPane)this.this$0.getSkinnable()).getTabs().removeListener(this.weakTabsListenerForPopup);
    }

    private void showTabsMenu(boolean bl2) {
        boolean bl3 = this.isShowTabsMenu();
        this.showTabsMenu = bl2;
        if (this.showTabsMenu && !bl3) {
            this.downArrowBtn.setVisible(true);
            this.showControlButtons = true;
            ((Parent)this.inner).requestLayout();
            ((Parent)this.this$0.tabHeaderArea).requestLayout();
            return;
        }
        if (!this.showTabsMenu && bl3) {
            this.hideControlButtons();
        }
    }

    private boolean isShowTabsMenu() {
        return this.showTabsMenu;
    }

    @Override
    protected double computePrefWidth(double d2) {
        double d3;
        TabPaneSkin$TabControlButtons tabPaneSkin$TabControlButtons = this;
        double d4 = tabPaneSkin$TabControlButtons.snapSizeX(((Node)tabPaneSkin$TabControlButtons.inner).prefWidth(d2));
        if (d3 > 0.0) {
            d4 += this.snappedLeftInset() + this.snappedRightInset();
        }
        return d4;
    }

    @Override
    protected double computePrefHeight(double d2) {
        TabPaneSkin$TabControlButtons tabPaneSkin$TabControlButtons = this;
        return Math.max(((TabPane)this.this$0.getSkinnable()).getTabMinHeight(), tabPaneSkin$TabControlButtons.snapSizeY(((Node)tabPaneSkin$TabControlButtons.inner).prefHeight(d2))) + this.snappedTopInset() + this.snappedBottomInset();
    }

    @Override
    protected void layoutChildren() {
        double d2 = this.snappedLeftInset();
        double d3 = this.snappedTopInset();
        TabPaneSkin$TabControlButtons tabPaneSkin$TabControlButtons = this;
        double d4 = tabPaneSkin$TabControlButtons.snapSizeX(tabPaneSkin$TabControlButtons.getWidth()) - d2 + this.snappedRightInset();
        TabPaneSkin$TabControlButtons tabPaneSkin$TabControlButtons2 = this;
        double d5 = tabPaneSkin$TabControlButtons2.snapSizeY(tabPaneSkin$TabControlButtons2.getHeight()) - d3 + this.snappedBottomInset();
        if (this.showControlButtons) {
            this.showControlButtons();
            this.showControlButtons = false;
        }
        ((Node)this.inner).resize(d4, d5);
        TabPaneSkin$TabControlButtons tabPaneSkin$TabControlButtons3 = this;
        tabPaneSkin$TabControlButtons3.positionInArea(tabPaneSkin$TabControlButtons3.inner, d2, d3, d4, d5, 0.0, HPos.CENTER, VPos.BOTTOM);
    }

    private void showControlButtons() {
        this.setVisible(true);
        if (this.popup == null) {
            this.setupPopupMenu();
        }
    }

    private void hideControlButtons() {
        if (this.isShowTabsMenu()) {
            this.showControlButtons = true;
        } else {
            this.setVisible(false);
            this.clearPopupMenu();
            this.popup = null;
        }
        ((Parent)this).requestLayout();
    }

    private void setupPopupMenu() {
        if (this.popup == null) {
            this.popup = new ContextMenu();
        }
        this.clearPopupMenu();
        ToggleGroup toggleGroup = new ToggleGroup();
        ObservableList<TabPaneSkin$TabMenuItem> observableList = FXCollections.observableArrayList();
        for (Tab tab : ((TabPane)this.this$0.getSkinnable()).getTabs()) {
            TabPaneSkin$TabMenuItem tabPaneSkin$TabMenuItem = new TabPaneSkin$TabMenuItem(tab);
            tabPaneSkin$TabMenuItem.setToggleGroup(toggleGroup);
            tabPaneSkin$TabMenuItem.setOnAction(actionEvent -> ((SelectionModel)((TabPane)this.this$0.getSkinnable()).getSelectionModel()).select(tab));
            observableList.add(tabPaneSkin$TabMenuItem);
        }
        this.popup.getItems().addAll((Collection<MenuItem>)observableList);
    }

    private void clearPopupMenu() {
        for (MenuItem menuItem : this.popup.getItems()) {
            ((TabPaneSkin$TabMenuItem)menuItem).dispose();
        }
        this.popup.getItems().clear();
    }

    private void showPopupMenu() {
        for (MenuItem menuItem : this.popup.getItems()) {
            if (!this.this$0.selectedTab.equals(((TabPaneSkin$TabMenuItem)(menuItem = (TabPaneSkin$TabMenuItem)menuItem)).getTab())) continue;
            ((RadioMenuItem)menuItem).setSelected(true);
            break;
        }
        this.popup.show(this.downArrowBtn, Side.BOTTOM, 0.0, 0.0);
    }
}

