/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import javafx.geometry.HPos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.skin.TabPaneSkin;
import javafx.scene.control.skin.TabPaneSkin$TabControlButtons;
import javafx.scene.control.skin.TabPaneSkin$TabHeaderArea$1;
import javafx.scene.control.skin.TabPaneSkin$TabHeaderSkin;
import javafx.scene.effect.DropShadow;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;

class TabPaneSkin$TabHeaderArea
extends StackPane {
    private Rectangle headerClip;
    private StackPane headersRegion;
    private StackPane headerBackground;
    private TabPaneSkin$TabControlButtons controlButtons;
    private boolean measureClosingTabs = false;
    private double scrollOffset;
    private boolean scrollOffsetDirty = true;
    final /* synthetic */ TabPaneSkin this$0;

    public TabPaneSkin$TabHeaderArea(TabPaneSkin tabPaneSkin) {
        this.this$0 = tabPaneSkin;
        this.getStyleClass().setAll((String[])new String[]{"tab-header-area"});
        this.setManaged(false);
        TabPane tabPane = (TabPane)tabPaneSkin.getSkinnable();
        this.headerClip = new Rectangle();
        this.headersRegion = new TabPaneSkin$TabHeaderArea$1(this, tabPaneSkin);
        this.headersRegion.getStyleClass().setAll((String[])new String[]{"headers-region"});
        this.headersRegion.setClip(this.headerClip);
        tabPaneSkin.setupReordering(this.headersRegion);
        this.headerBackground = new StackPane();
        this.headerBackground.getStyleClass().setAll((String[])new String[]{"tab-header-background"});
        int n2 = 0;
        for (Tab tab : tabPane.getTabs()) {
            this.addTab(tab, n2++);
        }
        this.controlButtons = new TabPaneSkin$TabControlButtons(tabPaneSkin);
        this.controlButtons.setVisible(false);
        if (this.controlButtons.isVisible()) {
            this.controlButtons.setVisible(true);
        }
        this.getChildren().addAll((Node[])new Node[]{this.headerBackground, this.headersRegion, this.controlButtons});
        this.addEventHandler(ScrollEvent.SCROLL, (? super T scrollEvent) -> {
            Side side = ((TabPane)this.this$0.getSkinnable()).getSide();
            side = side == null ? Side.TOP : side;
            switch (side) {
                default: {
                    TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea = this;
                    tabPaneSkin$TabHeaderArea.setScrollOffset(tabPaneSkin$TabHeaderArea.scrollOffset + scrollEvent.getDeltaY());
                    return;
                }
                case LEFT: 
                case RIGHT: 
            }
            TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea = this;
            tabPaneSkin$TabHeaderArea.setScrollOffset(tabPaneSkin$TabHeaderArea.scrollOffset - scrollEvent.getDeltaY());
        });
    }

    private void updateHeaderClip() {
        double d2;
        double d3;
        Side side = ((TabPane)this.this$0.getSkinnable()).getSide();
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = this.firstTabIndent();
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea = this;
        double d7 = tabPaneSkin$TabHeaderArea.snapSizeX(((Node)tabPaneSkin$TabHeaderArea.controlButtons).prefWidth(-1.0));
        this.measureClosingTabs = true;
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea2 = this;
        double d8 = tabPaneSkin$TabHeaderArea2.snapSizeX(((Node)tabPaneSkin$TabHeaderArea2.headersRegion).prefWidth(-1.0));
        this.measureClosingTabs = false;
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea3 = this;
        double d9 = tabPaneSkin$TabHeaderArea3.snapSizeY(((Node)tabPaneSkin$TabHeaderArea3.headersRegion).prefHeight(-1.0));
        if (d7 > 0.0) {
            d7 += 10.0;
        }
        if (this.headersRegion.getEffect() instanceof DropShadow) {
            DropShadow dropShadow = (DropShadow)this.headersRegion.getEffect();
            d5 = dropShadow.getRadius();
        }
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea4 = this;
        double d10 = tabPaneSkin$TabHeaderArea4.snapSizeX(tabPaneSkin$TabHeaderArea4.getWidth()) - d7 - d6;
        if (side.equals((Object)Side.LEFT) || side.equals((Object)Side.BOTTOM)) {
            if (d8 < d10) {
                d3 = d8 + d5;
            } else {
                d4 = d8 - d10;
                d3 = d10 + d5;
            }
            d2 = d9;
        } else {
            d4 = -d5;
            d3 = (d8 < d10 ? d8 : d10) + d5;
            d2 = d9;
        }
        this.headerClip.setX(d4);
        this.headerClip.setY(0.0);
        this.headerClip.setWidth(d3);
        this.headerClip.setHeight(d2);
    }

    private void addTab(Tab eventTarget, int n2) {
        eventTarget = new TabPaneSkin$TabHeaderSkin(this.this$0, (Tab)eventTarget);
        this.headersRegion.getChildren().add(n2, (Node)eventTarget);
        this.invalidateScrollOffset();
    }

    private void removeTab(Tab eventTarget) {
        if ((eventTarget = this.getTabHeaderSkin((Tab)eventTarget)) != null) {
            this.headersRegion.getChildren().remove(eventTarget);
        }
        this.invalidateScrollOffset();
    }

    private void moveTab(int n2, TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin) {
        if (n2 != this.headersRegion.getChildren().indexOf(tabPaneSkin$TabHeaderSkin)) {
            this.headersRegion.getChildren().remove(tabPaneSkin$TabHeaderSkin);
            this.headersRegion.getChildren().add(n2, tabPaneSkin$TabHeaderSkin);
        }
        this.invalidateScrollOffset();
    }

    private TabPaneSkin$TabHeaderSkin getTabHeaderSkin(Tab tab) {
        for (Node node : this.headersRegion.getChildren()) {
            if (!((TabPaneSkin$TabHeaderSkin)(node = (TabPaneSkin$TabHeaderSkin)node)).getTab().equals(tab)) continue;
            return node;
        }
        return null;
    }

    private boolean tabsFit() {
        double d2;
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea = this;
        double d3 = tabPaneSkin$TabHeaderArea.snapSizeX(((Node)tabPaneSkin$TabHeaderArea.headersRegion).prefWidth(-1.0));
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea2 = this;
        double d4 = tabPaneSkin$TabHeaderArea2.snapSizeX(((Node)tabPaneSkin$TabHeaderArea2.controlButtons).prefWidth(-1.0));
        double d5 = d3 + d4 + this.firstTabIndent() + 10.0;
        return d2 < this.getWidth();
    }

    private void ensureSelectedTabIsVisible() {
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea = this;
        double d2 = tabPaneSkin$TabHeaderArea.snapSizeX(tabPaneSkin$TabHeaderArea.this$0.isHorizontal() ? ((TabPane)this.this$0.getSkinnable()).getWidth() : ((TabPane)this.this$0.getSkinnable()).getHeight());
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea2 = this;
        double d3 = tabPaneSkin$TabHeaderArea2.snapSizeX(tabPaneSkin$TabHeaderArea2.controlButtons.getWidth());
        double d4 = d2 - d3 - this.firstTabIndent() - 10.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (Node node : this.headersRegion.getChildren()) {
            TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin = (TabPaneSkin$TabHeaderSkin)node;
            double d8 = this.snapSizeX(((Node)tabPaneSkin$TabHeaderSkin).prefWidth(-1.0));
            if (this.this$0.selectedTab != null && this.this$0.selectedTab.equals(tabPaneSkin$TabHeaderSkin.getTab())) {
                d6 = d5;
                d7 = d8;
            }
            d5 += d8;
        }
        double d9 = this.getScrollOffset();
        double d10 = d6;
        double d11 = d6 + d7;
        double d12 = d4;
        if (d10 < -d9) {
            this.setScrollOffset(-d10);
            return;
        }
        if (d11 > d12 - d9) {
            this.setScrollOffset(d12 - d11);
        }
    }

    public double getScrollOffset() {
        return this.scrollOffset;
    }

    public void invalidateScrollOffset() {
        this.scrollOffsetDirty = true;
    }

    private void validateScrollOffset() {
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea = this;
        tabPaneSkin$TabHeaderArea.setScrollOffset(tabPaneSkin$TabHeaderArea.getScrollOffset());
    }

    private void setScrollOffset(double d2) {
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea = this;
        double d3 = tabPaneSkin$TabHeaderArea.snapSizeX(tabPaneSkin$TabHeaderArea.this$0.isHorizontal() ? ((TabPane)this.this$0.getSkinnable()).getWidth() : ((TabPane)this.this$0.getSkinnable()).getHeight());
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea2 = this;
        double d4 = tabPaneSkin$TabHeaderArea2.snapSizeX(tabPaneSkin$TabHeaderArea2.controlButtons.getWidth());
        double d5 = d3 - d4 - this.firstTabIndent() - 10.0;
        double d6 = 0.0;
        for (Node node : this.headersRegion.getChildren()) {
            TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin = (TabPaneSkin$TabHeaderSkin)node;
            double d7 = this.snapSizeX(((Node)tabPaneSkin$TabHeaderSkin).prefWidth(-1.0));
            d6 += d7;
        }
        double d8 = d5 - d2 > d6 && d2 < 0.0 ? d5 - d6 : (d2 > 0.0 ? 0.0 : d2);
        if (Math.abs(d8 - this.scrollOffset) > 0.001) {
            this.scrollOffset = d8;
            ((Parent)this.headersRegion).requestLayout();
        }
    }

    private double firstTabIndent() {
        switch (((TabPane)this.this$0.getSkinnable()).getSide()) {
            case TOP: 
            case BOTTOM: {
                return this.snappedLeftInset();
            }
            case LEFT: 
            case RIGHT: {
                return this.snappedTopInset();
            }
        }
        return 0.0;
    }

    @Override
    protected double computePrefWidth(double d2) {
        double d3 = this.this$0.isHorizontal() ? this.snappedLeftInset() + this.snappedRightInset() : this.snappedTopInset() + this.snappedBottomInset();
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea = this;
        return tabPaneSkin$TabHeaderArea.snapSizeX(((Node)tabPaneSkin$TabHeaderArea.headersRegion).prefWidth(d2)) + ((Node)this.controlButtons).prefWidth(d2) + this.firstTabIndent() + 10.0 + d3;
    }

    @Override
    protected double computePrefHeight(double d2) {
        double d3 = this.this$0.isHorizontal() ? this.snappedTopInset() + this.snappedBottomInset() : this.snappedLeftInset() + this.snappedRightInset();
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea = this;
        return tabPaneSkin$TabHeaderArea.snapSizeY(((Node)tabPaneSkin$TabHeaderArea.headersRegion).prefHeight(-1.0)) + d3;
    }

    @Override
    public double getBaselineOffset() {
        if (((TabPane)this.this$0.getSkinnable()).getSide() == Side.TOP) {
            return ((Node)this.headersRegion).getBaselineOffset() + this.snappedTopInset();
        }
        return 0.0;
    }

    @Override
    protected void layoutChildren() {
        double d2 = this.snappedLeftInset();
        double d3 = this.snappedRightInset();
        double d4 = this.snappedTopInset();
        double d5 = this.snappedBottomInset();
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea = this;
        double d6 = tabPaneSkin$TabHeaderArea.snapSizeX(tabPaneSkin$TabHeaderArea.getWidth()) - (this.this$0.isHorizontal() ? d2 + d3 : d4 + d5);
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea2 = this;
        double d7 = tabPaneSkin$TabHeaderArea2.snapSizeY(tabPaneSkin$TabHeaderArea2.getHeight()) - (this.this$0.isHorizontal() ? d4 + d5 : d2 + d3);
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea3 = this;
        double d8 = tabPaneSkin$TabHeaderArea3.snapSizeY(((Node)tabPaneSkin$TabHeaderArea3).prefHeight(-1.0));
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea4 = this;
        double d9 = tabPaneSkin$TabHeaderArea4.snapSizeX(((Node)tabPaneSkin$TabHeaderArea4.headersRegion).prefWidth(-1.0));
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea5 = this;
        double d10 = tabPaneSkin$TabHeaderArea5.snapSizeY(((Node)tabPaneSkin$TabHeaderArea5.headersRegion).prefHeight(-1.0));
        this.controlButtons.showTabsMenu(!this.tabsFit());
        this.updateHeaderClip();
        ((Parent)this.headersRegion).requestLayout();
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea6 = this;
        double d11 = tabPaneSkin$TabHeaderArea6.snapSizeX(((Node)tabPaneSkin$TabHeaderArea6.controlButtons).prefWidth(-1.0));
        double d12 = ((Node)this.controlButtons).prefHeight(d11);
        ((Node)this.controlButtons).resize(d11, d12);
        ((Node)this.headersRegion).resize(d9, d10);
        if (this.this$0.isFloatingStyleClass()) {
            this.headerBackground.setVisible(false);
        } else {
            TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea7 = this;
            TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea8 = this;
            ((Node)this.headerBackground).resize(tabPaneSkin$TabHeaderArea7.snapSizeX(tabPaneSkin$TabHeaderArea7.getWidth()), tabPaneSkin$TabHeaderArea8.snapSizeY(tabPaneSkin$TabHeaderArea8.getHeight()));
            this.headerBackground.setVisible(true);
        }
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        Side side = ((TabPane)this.this$0.getSkinnable()).getSide();
        if (side.equals((Object)Side.TOP)) {
            d13 = d2;
            d14 = d8 - d10 - d5;
            d15 = d6 - d11 + d2;
            TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea9 = this;
            d16 = tabPaneSkin$TabHeaderArea9.snapSizeY(tabPaneSkin$TabHeaderArea9.getHeight()) - d12 - d5;
        } else if (side.equals((Object)Side.RIGHT)) {
            d13 = d4;
            d14 = d8 - d10 - d2;
            d15 = d6 - d11 + d4;
            TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea10 = this;
            d16 = tabPaneSkin$TabHeaderArea10.snapSizeY(tabPaneSkin$TabHeaderArea10.getHeight()) - d12 - d2;
        } else if (side.equals((Object)Side.BOTTOM)) {
            TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea11 = this;
            d13 = tabPaneSkin$TabHeaderArea11.snapSizeX(tabPaneSkin$TabHeaderArea11.getWidth()) - d9 - d2;
            d14 = d8 - d10 - d4;
            d15 = d3;
            TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea12 = this;
            d16 = tabPaneSkin$TabHeaderArea12.snapSizeY(tabPaneSkin$TabHeaderArea12.getHeight()) - d12 - d4;
        } else if (side.equals((Object)Side.LEFT)) {
            TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea13 = this;
            d13 = tabPaneSkin$TabHeaderArea13.snapSizeX(tabPaneSkin$TabHeaderArea13.getWidth()) - d9 - d4;
            d14 = d8 - d10 - d3;
            d15 = d2;
            TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea14 = this;
            d16 = tabPaneSkin$TabHeaderArea14.snapSizeY(tabPaneSkin$TabHeaderArea14.getHeight()) - d12 - d3;
        }
        if (this.headerBackground.isVisible()) {
            TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea15 = this;
            TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea16 = this;
            TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea17 = this;
            tabPaneSkin$TabHeaderArea15.positionInArea(tabPaneSkin$TabHeaderArea15.headerBackground, 0.0, 0.0, tabPaneSkin$TabHeaderArea16.snapSizeX(tabPaneSkin$TabHeaderArea16.getWidth()), tabPaneSkin$TabHeaderArea17.snapSizeY(tabPaneSkin$TabHeaderArea17.getHeight()), 0.0, HPos.CENTER, VPos.CENTER);
        }
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea18 = this;
        tabPaneSkin$TabHeaderArea18.positionInArea(tabPaneSkin$TabHeaderArea18.headersRegion, d13, d14, d6, d7, 0.0, HPos.LEFT, VPos.CENTER);
        TabPaneSkin$TabHeaderArea tabPaneSkin$TabHeaderArea19 = this;
        tabPaneSkin$TabHeaderArea19.positionInArea(tabPaneSkin$TabHeaderArea19.controlButtons, d15, d16, d11, d12, 0.0, HPos.CENTER, VPos.CENTER);
    }

    void dispose() {
        for (Node node : this.headersRegion.getChildren()) {
            node = (TabPaneSkin$TabHeaderSkin)node;
            ((TabPaneSkin$TabHeaderSkin)node).dispose();
        }
        this.controlButtons.dispose();
    }
}

