/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.Properties;
import com.sun.javafx.scene.control.TabObservableList;
import com.sun.javafx.scene.control.behavior.TabPaneBehavior;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.Animation$Status;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TabPane$TabDragPolicy;
import javafx.scene.control.skin.TabPaneSkin$1;
import javafx.scene.control.skin.TabPaneSkin$2;
import javafx.scene.control.skin.TabPaneSkin$3;
import javafx.scene.control.skin.TabPaneSkin$4;
import javafx.scene.control.skin.TabPaneSkin$5;
import javafx.scene.control.skin.TabPaneSkin$6;
import javafx.scene.control.skin.TabPaneSkin$DragState;
import javafx.scene.control.skin.TabPaneSkin$StyleableProperties;
import javafx.scene.control.skin.TabPaneSkin$TabAnimation;
import javafx.scene.control.skin.TabPaneSkin$TabAnimationState;
import javafx.scene.control.skin.TabPaneSkin$TabContentRegion;
import javafx.scene.control.skin.TabPaneSkin$TabHeaderArea;
import javafx.scene.control.skin.TabPaneSkin$TabHeaderSkin;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;
import javafx.util.Pair;

public class TabPaneSkin
extends SkinBase<TabPane> {
    static int CLOSE_BTN_SIZE = 16;
    private static final double ANIMATION_SPEED = 150.0;
    private static final int SPACER = 10;
    private TabPaneSkin$TabHeaderArea tabHeaderArea;
    private ObservableList<TabPaneSkin$TabContentRegion> tabContentRegions;
    private Rectangle clipRect;
    private Rectangle tabHeaderAreaClipRect;
    private Tab selectedTab;
    private final TabPaneBehavior behavior;
    private ObjectProperty<TabPaneSkin$TabAnimation> openTabAnimation = new TabPaneSkin$1(this, TabPaneSkin$TabAnimation.GROW);
    private ObjectProperty<TabPaneSkin$TabAnimation> closeTabAnimation = new TabPaneSkin$2(this, TabPaneSkin$TabAnimation.GROW);
    private SelectionModel<Tab> selectionModel;
    private InvalidationListener selectionChangeListener = observable -> {
        this.tabHeaderArea.invalidateScrollOffset();
        this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        ((TabPane)this.getSkinnable()).requestLayout();
    };
    private WeakInvalidationListener weakSelectionChangeListener = new WeakInvalidationListener(this.selectionChangeListener);
    ListChangeListener<Tab> tabsListener;
    WeakListChangeListener<Tab> weakTabsListener;
    private static final PseudoClass SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("selected");
    private static final PseudoClass TOP_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("top");
    private static final PseudoClass BOTTOM_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("bottom");
    private static final PseudoClass LEFT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("left");
    private static final PseudoClass RIGHT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("right");
    private static final PseudoClass DISABLED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("disabled");
    private EventHandler<MouseEvent> headerDraggedHandler = this::handleHeaderDragged;
    private EventHandler<MouseEvent> headerMousePressedHandler = this::handleHeaderMousePressed;
    private EventHandler<MouseEvent> headerMouseReleasedHandler = this::handleHeaderMouseReleased;
    private int dragTabHeaderStartIndex;
    private int dragTabHeaderIndex;
    private TabPaneSkin$TabHeaderSkin dragTabHeader;
    private TabPaneSkin$TabHeaderSkin dropTabHeader;
    private StackPane headersRegion;
    private TabPaneSkin$DragState dragState;
    private final int MIN_TO_MAX = 1;
    private final int MAX_TO_MIN = -1;
    private int xLayoutDirection;
    private double dragEventPrevLoc;
    private int prevDragDirection = 1;
    private final double DRAG_DIST_THRESHOLD = 0.75;
    private final double ANIM_DURATION = 120.0;
    private TabPaneSkin$TabHeaderSkin dropAnimHeader;
    private double dropHeaderSourceX;
    private double dropHeaderTransitionX;
    private final Animation dropHeaderAnim = new TabPaneSkin$3(this);
    private double dragHeaderDestX;
    private double dragHeaderSourceX;
    private double dragHeaderTransitionX;
    private final Animation dragHeaderAnim = new TabPaneSkin$4(this);
    private ListChangeListener childListener = new TabPaneSkin$5(this);

    public TabPaneSkin(TabPane tabPane) {
        super(tabPane);
        this.behavior = new TabPaneBehavior(tabPane);
        this.clipRect = new Rectangle(tabPane.getWidth(), tabPane.getHeight());
        ((TabPane)this.getSkinnable()).setClip(this.clipRect);
        this.tabContentRegions = FXCollections.observableArrayList();
        for (Tab tab : ((TabPane)this.getSkinnable()).getTabs()) {
            this.addTabContent(tab);
        }
        this.tabHeaderAreaClipRect = new Rectangle();
        this.tabHeaderArea = new TabPaneSkin$TabHeaderArea(this);
        this.tabHeaderArea.setClip(this.tabHeaderAreaClipRect);
        this.getChildren().add(this.tabHeaderArea);
        if (((TabPane)this.getSkinnable()).getTabs().size() == 0) {
            this.tabHeaderArea.setVisible(false);
        }
        this.initializeTabListener();
        this.updateSelectionModel();
        this.registerChangeListener(tabPane.selectionModelProperty(), observableValue -> this.updateSelectionModel());
        this.registerChangeListener(tabPane.sideProperty(), observableValue -> this.updateTabPosition());
        this.registerChangeListener(tabPane.widthProperty(), observableValue -> {
            this.tabHeaderArea.invalidateScrollOffset();
            this.clipRect.setWidth(((TabPane)this.getSkinnable()).getWidth());
        });
        this.registerChangeListener(tabPane.heightProperty(), observableValue -> {
            this.tabHeaderArea.invalidateScrollOffset();
            this.clipRect.setHeight(((TabPane)this.getSkinnable()).getHeight());
        });
        this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        if (this.selectedTab == null && ((TabPane)this.getSkinnable()).getSelectionModel().getSelectedIndex() != -1) {
            ((SelectionModel)((TabPane)this.getSkinnable()).getSelectionModel()).select(((TabPane)this.getSkinnable()).getSelectionModel().getSelectedIndex());
            this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        }
        if (this.selectedTab == null) {
            ((SelectionModel)((TabPane)this.getSkinnable()).getSelectionModel()).selectFirst();
        }
        this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        this.initializeSwipeHandlers();
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        if (this.selectionModel != null) {
            this.selectionModel.selectedItemProperty().removeListener(this.weakSelectionChangeListener);
            this.selectionModel = null;
        }
        ((TabPane)this.getSkinnable()).getTabs().removeListener(this.weakTabsListener);
        this.tabHeaderArea.dispose();
        this.getChildren().remove(this.tabHeaderArea);
        for (Tab tab : ((TabPane)this.getSkinnable()).getTabs()) {
            this.removeTabContent(tab);
        }
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8 = 0.0;
        for (TabPaneSkin$TabContentRegion tabPaneSkin$TabContentRegion : this.tabContentRegions) {
            d8 = Math.max(d8, this.snapSizeX(((Node)tabPaneSkin$TabContentRegion).prefWidth(-1.0)));
        }
        boolean bl2 = this.isHorizontal();
        if (bl2) {
            TabPaneSkin tabPaneSkin = this;
            d7 = tabPaneSkin.snapSizeX(((Node)tabPaneSkin.tabHeaderArea).prefWidth(-1.0));
        } else {
            TabPaneSkin tabPaneSkin = this;
            d7 = tabPaneSkin.snapSizeY(((Node)tabPaneSkin.tabHeaderArea).prefHeight(-1.0));
        }
        double d9 = d7;
        double d10 = bl2 ? Math.max(d8, d9) : d8 + d9;
        return this.snapSizeX(d10) + d4 + d6;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8 = 0.0;
        for (TabPaneSkin$TabContentRegion tabPaneSkin$TabContentRegion : this.tabContentRegions) {
            d8 = Math.max(d8, this.snapSizeY(((Node)tabPaneSkin$TabContentRegion).prefHeight(-1.0)));
        }
        boolean bl2 = this.isHorizontal();
        if (bl2) {
            TabPaneSkin tabPaneSkin = this;
            d7 = tabPaneSkin.snapSizeY(((Node)tabPaneSkin.tabHeaderArea).prefHeight(-1.0));
        } else {
            TabPaneSkin tabPaneSkin = this;
            d7 = tabPaneSkin.snapSizeX(((Node)tabPaneSkin.tabHeaderArea).prefWidth(-1.0));
        }
        double d9 = d7;
        double d10 = bl2 ? d8 + this.snapSizeY(d9) : Math.max(d8, d9);
        return this.snapSizeY(d10) + d3 + d5;
    }

    @Override
    public double computeBaselineOffset(double d2, double d3, double d4, double d5) {
        Side side = ((TabPane)this.getSkinnable()).getSide();
        if (side == Side.TOP) {
            return ((Node)this.tabHeaderArea).getBaselineOffset() + d2;
        }
        return 0.0;
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6;
        Object object = (TabPane)this.getSkinnable();
        if (((Side)((Object)(object = ((TabPane)object).getSide()))).isHorizontal()) {
            TabPaneSkin tabPaneSkin = this;
            d6 = tabPaneSkin.snapSizeY(((Node)tabPaneSkin.tabHeaderArea).prefHeight(-1.0));
        } else {
            TabPaneSkin tabPaneSkin = this;
            d6 = tabPaneSkin.snapSizeX(((Node)tabPaneSkin.tabHeaderArea).prefHeight(-1.0));
        }
        double d7 = d6;
        double d8 = ((Enum)object).equals((Object)Side.RIGHT) ? d2 + d4 - d7 : d2;
        double d9 = ((Enum)object).equals((Object)Side.BOTTOM) ? d3 + d5 - d7 : d3;
        double d10 = this.snappedLeftInset();
        double d11 = this.snappedTopInset();
        if (object == Side.TOP) {
            ((Node)this.tabHeaderArea).resize(d4, d7);
            this.tabHeaderArea.relocate(d8, d9);
            this.tabHeaderArea.getTransforms().clear();
            this.tabHeaderArea.getTransforms().add(new Rotate(TabPaneSkin.getRotation(Side.TOP)));
        } else if (object == Side.BOTTOM) {
            ((Node)this.tabHeaderArea).resize(d4, d7);
            this.tabHeaderArea.relocate(d4 + d10, d9 - d7);
            this.tabHeaderArea.getTransforms().clear();
            this.tabHeaderArea.getTransforms().add(new Rotate(TabPaneSkin.getRotation(Side.BOTTOM), 0.0, d7));
        } else if (object == Side.LEFT) {
            ((Node)this.tabHeaderArea).resize(d5, d7);
            this.tabHeaderArea.relocate(d8 + d7, d5 - d7 + d11);
            this.tabHeaderArea.getTransforms().clear();
            this.tabHeaderArea.getTransforms().add(new Rotate(TabPaneSkin.getRotation(Side.LEFT), 0.0, d7));
        } else if (object == Side.RIGHT) {
            ((Node)this.tabHeaderArea).resize(d5, d7);
            this.tabHeaderArea.relocate(d8, d3 - d7);
            this.tabHeaderArea.getTransforms().clear();
            this.tabHeaderArea.getTransforms().add(new Rotate(TabPaneSkin.getRotation(Side.RIGHT), 0.0, d7));
        }
        this.tabHeaderAreaClipRect.setX(0.0);
        this.tabHeaderAreaClipRect.setY(0.0);
        if (this.isHorizontal()) {
            this.tabHeaderAreaClipRect.setWidth(d4);
        } else {
            this.tabHeaderAreaClipRect.setWidth(d5);
        }
        this.tabHeaderAreaClipRect.setHeight(d7);
        double d12 = 0.0;
        double d13 = 0.0;
        if (object == Side.TOP) {
            d12 = d2;
            d13 = d3 + d7;
            if (this.isFloatingStyleClass()) {
                d13 -= 1.0;
            }
        } else if (object == Side.BOTTOM) {
            d12 = d2;
            d13 = d3 + d11;
            if (this.isFloatingStyleClass()) {
                d13 = d11 + 1.0;
            }
        } else if (object == Side.LEFT) {
            d12 = d2 + d7;
            d13 = d3;
            if (this.isFloatingStyleClass()) {
                d12 -= 1.0;
            }
        } else if (object == Side.RIGHT) {
            d12 = d2 + d10;
            d13 = d3;
            if (this.isFloatingStyleClass()) {
                d12 = d10 + 1.0;
            }
        }
        double d14 = d4 - (this.isHorizontal() ? 0.0 : d7);
        double d15 = d5 - (this.isHorizontal() ? d7 : 0.0);
        int n2 = this.tabContentRegions.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TabPaneSkin$TabContentRegion tabPaneSkin$TabContentRegion = (TabPaneSkin$TabContentRegion)this.tabContentRegions.get(i2);
            tabPaneSkin$TabContentRegion.setAlignment(Pos.TOP_LEFT);
            if (tabPaneSkin$TabContentRegion.getClip() != null) {
                ((Rectangle)tabPaneSkin$TabContentRegion.getClip()).setWidth(d14);
                ((Rectangle)tabPaneSkin$TabContentRegion.getClip()).setHeight(d15);
            }
            ((Node)tabPaneSkin$TabContentRegion).resize(d14, d15);
            tabPaneSkin$TabContentRegion.relocate(d12, d13);
        }
    }

    private void updateSelectionModel() {
        if (this.selectionModel != null) {
            this.selectionModel.selectedItemProperty().removeListener(this.weakSelectionChangeListener);
        }
        this.selectionModel = ((TabPane)this.getSkinnable()).getSelectionModel();
        if (this.selectionModel != null) {
            this.selectionModel.selectedItemProperty().addListener(this.weakSelectionChangeListener);
        }
    }

    private static int getRotation(Side side) {
        switch (side) {
            case TOP: {
                return 0;
            }
            case BOTTOM: {
                return 180;
            }
            case LEFT: {
                return -90;
            }
            case RIGHT: {
                return 90;
            }
        }
        return 0;
    }

    private static Node clone(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ImageView) {
            node = (ImageView)node;
            ImageView imageView = new ImageView();
            imageView.imageProperty().bind(((ImageView)node).imageProperty());
            return imageView;
        }
        if (node instanceof Label) {
            node = (Label)node;
            Label label = new Label(((Labeled)node).getText(), TabPaneSkin.clone(((Labeled)node).getGraphic()));
            label.textProperty().bind(((Labeled)node).textProperty());
            return label;
        }
        return null;
    }

    private void removeTabs(List<? extends Tab> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Tab)object.next();
            this.stopCurrentAnimation((Tab)object2);
            TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin = this.tabHeaderArea.getTabHeaderSkin((Tab)object2);
            if (tabPaneSkin$TabHeaderSkin == null) continue;
            tabPaneSkin$TabHeaderSkin.isClosing = true;
            tabPaneSkin$TabHeaderSkin.dispose();
            this.removeTabContent((Tab)object2);
            object2 = arg_0 -> this.lambda$removeTabs$5(tabPaneSkin$TabHeaderSkin, (Tab)object2, arg_0);
            if (this.closeTabAnimation.get() == TabPaneSkin$TabAnimation.GROW) {
                tabPaneSkin$TabHeaderSkin.animationState = TabPaneSkin$TabAnimationState.HIDING;
                tabPaneSkin$TabHeaderSkin.currentAnimation = this.createTimeline(tabPaneSkin$TabHeaderSkin, Duration.millis(150.0), 0.0, (EventHandler<ActionEvent>)object2);
                object2 = tabPaneSkin$TabHeaderSkin.currentAnimation;
                tabPaneSkin$TabHeaderSkin.currentAnimation.play();
                continue;
            }
            object2.handle(null);
        }
    }

    private void stopCurrentAnimation(Tab eventTarget) {
        Timeline timeline;
        if ((eventTarget = this.tabHeaderArea.getTabHeaderSkin((Tab)eventTarget)) != null && (timeline = ((TabPaneSkin$TabHeaderSkin)eventTarget).currentAnimation) != null && timeline.getStatus() == Animation$Status.RUNNING) {
            timeline.getOnFinished().handle(null);
            ((Animation)timeline).stop();
            ((TabPaneSkin$TabHeaderSkin)eventTarget).currentAnimation = null;
        }
    }

    private void addTabs(List<? extends Tab> object, int n2) {
        EventTarget eventTarget;
        int n3 = 0;
        Iterator<? extends Tab> iterator = new ArrayList<Node>(this.tabHeaderArea.headersRegion.getChildren());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            eventTarget = (Node)iterator.next();
            TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin = (TabPaneSkin$TabHeaderSkin)eventTarget;
            if (tabPaneSkin$TabHeaderSkin.animationState != TabPaneSkin$TabAnimationState.HIDING) continue;
            this.stopCurrentAnimation(tabPaneSkin$TabHeaderSkin.tab);
        }
        iterator = object.iterator();
        while (iterator.hasNext()) {
            eventTarget = iterator.next();
            this.stopCurrentAnimation((Tab)eventTarget);
            if (!this.tabHeaderArea.isVisible()) {
                this.tabHeaderArea.setVisible(true);
            }
            int n4 = n2 + n3++;
            this.tabHeaderArea.addTab((Tab)eventTarget, n4);
            this.addTabContent((Tab)eventTarget);
            object = this.tabHeaderArea.getTabHeaderSkin((Tab)eventTarget);
            if (object == null) continue;
            if (this.openTabAnimation.get() == TabPaneSkin$TabAnimation.GROW) {
                ((TabPaneSkin$TabHeaderSkin)object).animationState = TabPaneSkin$TabAnimationState.SHOWING;
                ((TabPaneSkin$TabHeaderSkin)object).animationTransition.setValue(0.0);
                ((Node)object).setVisible(true);
                ((TabPaneSkin$TabHeaderSkin)object).currentAnimation = this.createTimeline((TabPaneSkin$TabHeaderSkin)object, Duration.millis(150.0), 1.0, arg_0 -> TabPaneSkin.lambda$addTabs$6((TabPaneSkin$TabHeaderSkin)object, arg_0));
                ((TabPaneSkin$TabHeaderSkin)object).currentAnimation.play();
                continue;
            }
            ((Node)object).setVisible(true);
            ((Parent)((TabPaneSkin$TabHeaderSkin)object).inner).requestLayout();
        }
    }

    private void initializeTabListener() {
        this.tabsListener = listChangeListener$Change -> {
            Object object;
            Tab tab;
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            while (listChangeListener$Change.next()) {
                if (listChangeListener$Change.wasPermutated() && this.dragState != TabPaneSkin$DragState.REORDER) {
                    TabPane tabPane = (TabPane)this.getSkinnable();
                    Iterator iterator = tabPane.getTabs();
                    int n2 = listChangeListener$Change.getTo() - listChangeListener$Change.getFrom();
                    tab = (Tab)tabPane.getSelectionModel().getSelectedItem();
                    object = new ArrayList(n2);
                    ((SelectionModel)((TabPane)this.getSkinnable()).getSelectionModel()).clearSelection();
                    TabPaneSkin$TabAnimation tabPaneSkin$TabAnimation = (TabPaneSkin$TabAnimation)((Object)((Object)this.openTabAnimation.get()));
                    TabPaneSkin$TabAnimation tabPaneSkin$TabAnimation2 = (TabPaneSkin$TabAnimation)((Object)((Object)this.closeTabAnimation.get()));
                    this.openTabAnimation.set(TabPaneSkin$TabAnimation.NONE);
                    this.closeTabAnimation.set(TabPaneSkin$TabAnimation.NONE);
                    for (int i2 = listChangeListener$Change.getFrom(); i2 < listChangeListener$Change.getTo(); ++i2) {
                        object.add((Tab)iterator.get(i2));
                    }
                    this.removeTabs((List<? extends Tab>)object);
                    this.addTabs((List<? extends Tab>)object, listChangeListener$Change.getFrom());
                    this.openTabAnimation.set(tabPaneSkin$TabAnimation);
                    this.closeTabAnimation.set(tabPaneSkin$TabAnimation2);
                    ((SelectionModel)((TabPane)this.getSkinnable()).getSelectionModel()).select(tab);
                }
                if (listChangeListener$Change.wasRemoved()) {
                    arrayList.addAll(listChangeListener$Change.getRemoved());
                }
                if (!listChangeListener$Change.wasAdded()) continue;
                arrayList2.addAll(listChangeListener$Change.getAddedSubList());
            }
            arrayList.removeAll(arrayList2);
            this.removeTabs(arrayList);
            ArrayList<Pair<Integer, Object>> arrayList3 = new ArrayList<Pair<Integer, Object>>();
            if (!arrayList2.isEmpty()) {
                for (TabPaneSkin$TabContentRegion tabPaneSkin$TabContentRegion : this.tabContentRegions) {
                    int n3;
                    tab = tabPaneSkin$TabContentRegion.getTab();
                    object = this.tabHeaderArea.getTabHeaderSkin(tab);
                    if (((TabPaneSkin$TabHeaderSkin)object).isClosing || !arrayList2.contains(tabPaneSkin$TabContentRegion.getTab())) continue;
                    arrayList2.remove(tabPaneSkin$TabContentRegion.getTab());
                    int n4 = ((TabPane)this.getSkinnable()).getTabs().indexOf(tab);
                    if (n4 == (n3 = this.tabHeaderArea.headersRegion.getChildren().indexOf(object))) continue;
                    arrayList3.add(new Pair<Integer, Object>(n4, object));
                }
                if (!arrayList2.isEmpty()) {
                    this.addTabs(arrayList2, ((TabPane)this.getSkinnable()).getTabs().indexOf(arrayList2.get(0)));
                }
                for (Pair pair : arrayList3) {
                    this.tabHeaderArea.moveTab((Integer)pair.getKey(), (TabPaneSkin$TabHeaderSkin)pair.getValue());
                }
            }
            ((TabPane)this.getSkinnable()).requestLayout();
        };
        this.weakTabsListener = new WeakListChangeListener<Tab>(this.tabsListener);
        ((TabPane)this.getSkinnable()).getTabs().addListener(this.weakTabsListener);
    }

    private void addTabContent(Tab eventTarget) {
        eventTarget = new TabPaneSkin$TabContentRegion((Tab)eventTarget);
        ((Node)eventTarget).setClip(new Rectangle());
        this.tabContentRegions.add((TabPaneSkin$TabContentRegion)eventTarget);
        this.getChildren().add(0, (Node)eventTarget);
    }

    private void removeTabContent(Tab tab) {
        for (TabPaneSkin$TabContentRegion tabPaneSkin$TabContentRegion : this.tabContentRegions) {
            if (!tabPaneSkin$TabContentRegion.getTab().equals(tab)) continue;
            this.removeTabContent(tabPaneSkin$TabContentRegion);
            return;
        }
    }

    private void removeTabContent(TabPaneSkin$TabContentRegion tabPaneSkin$TabContentRegion) {
        tabPaneSkin$TabContentRegion.dispose();
        this.tabContentRegions.remove(tabPaneSkin$TabContentRegion);
        this.getChildren().remove(tabPaneSkin$TabContentRegion);
    }

    private void updateTabPosition() {
        this.tabHeaderArea.invalidateScrollOffset();
        ((TabPane)this.getSkinnable()).applyCss();
        ((TabPane)this.getSkinnable()).requestLayout();
    }

    private Timeline createTimeline(TabPaneSkin$TabHeaderSkin object, Duration duration, double d2, EventHandler<ActionEvent> eventHandler) {
        Timeline timeline = new Timeline();
        timeline.setCycleCount(1);
        object = new KeyValue(((TabPaneSkin$TabHeaderSkin)object).animationTransition, d2, Interpolator.LINEAR);
        timeline.getKeyFrames().clear();
        timeline.getKeyFrames().add(new KeyFrame(duration, new KeyValue[]{object}));
        timeline.setOnFinished(eventHandler);
        return timeline;
    }

    private boolean isHorizontal() {
        Side side = ((TabPane)this.getSkinnable()).getSide();
        return Side.TOP.equals((Object)side) || Side.BOTTOM.equals((Object)side);
    }

    private void initializeSwipeHandlers() {
        if (Properties.IS_TOUCH_SUPPORTED) {
            ((TabPane)this.getSkinnable()).addEventHandler(SwipeEvent.SWIPE_LEFT, swipeEvent -> this.behavior.selectNextTab());
            ((TabPane)this.getSkinnable()).addEventHandler(SwipeEvent.SWIPE_RIGHT, swipeEvent -> this.behavior.selectPreviousTab());
        }
    }

    private boolean isFloatingStyleClass() {
        return ((TabPane)this.getSkinnable()).getStyleClass().contains("floating");
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return TabPaneSkin$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TabPaneSkin.getClassCssMetaData();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute object, Object ... objectArray) {
        switch (TabPaneSkin$6.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 3: {
                return this.tabHeaderArea.getTabHeaderSkin(this.selectedTab);
            }
            case 4: {
                return this.tabHeaderArea.headersRegion.getChildren().size();
            }
            case 5: {
                object = (Integer)objectArray[0];
                if (object == null) {
                    return null;
                }
                return this.tabHeaderArea.headersRegion.getChildren().get((Integer)object);
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray);
    }

    private void addReorderListeners(Node node) {
        node.addEventHandler(MouseEvent.MOUSE_PRESSED, this.headerMousePressedHandler);
        node.addEventHandler(MouseEvent.MOUSE_RELEASED, this.headerMouseReleasedHandler);
        node.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.headerDraggedHandler);
    }

    private void removeReorderListeners(Node node) {
        node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.headerMousePressedHandler);
        node.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.headerMouseReleasedHandler);
        node.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.headerDraggedHandler);
    }

    private void updateListeners() {
        if (((TabPane)this.getSkinnable()).getTabDragPolicy() == TabPane$TabDragPolicy.FIXED || ((TabPane)this.getSkinnable()).getTabDragPolicy() == null) {
            for (Node node : this.headersRegion.getChildren()) {
                this.removeReorderListeners(node);
            }
            this.headersRegion.getChildren().removeListener(this.childListener);
            return;
        }
        if (((TabPane)this.getSkinnable()).getTabDragPolicy() == TabPane$TabDragPolicy.REORDER) {
            for (Node node : this.headersRegion.getChildren()) {
                this.addReorderListeners(node);
            }
            this.headersRegion.getChildren().addListener(this.childListener);
        }
    }

    private void setupReordering(StackPane stackPane) {
        this.dragState = TabPaneSkin$DragState.NONE;
        this.headersRegion = stackPane;
        this.updateListeners();
        TabPaneSkin tabPaneSkin = this;
        tabPaneSkin.registerChangeListener(((TabPane)tabPaneSkin.getSkinnable()).tabDragPolicyProperty(), observableValue -> this.updateListeners());
    }

    private void handleHeaderMousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.startDrag(mouseEvent);
        }
    }

    private void handleHeaderMouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.stopDrag();
            mouseEvent.consume();
        }
    }

    private void handleHeaderDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.performDrag(mouseEvent);
        }
    }

    private double getDragDelta(double d2, double d3) {
        if (((TabPane)this.getSkinnable()).getSide().equals((Object)Side.TOP) || ((TabPane)this.getSkinnable()).getSide().equals((Object)Side.RIGHT)) {
            return d2 - d3;
        }
        return d3 - d2;
    }

    private int deriveTabHeaderLayoutXDirection() {
        if (((TabPane)this.getSkinnable()).getSide().equals((Object)Side.TOP) || ((TabPane)this.getSkinnable()).getSide().equals((Object)Side.RIGHT)) {
            return 1;
        }
        return -1;
    }

    private void performDrag(MouseEvent mouseEvent) {
        double d2;
        double d3;
        if (this.dragState == TabPaneSkin$DragState.NONE) {
            return;
        }
        double d4 = this.getHeaderRegionLocalX(mouseEvent);
        double d5 = this.getDragDelta(d4, this.dragEventPrevLoc);
        int n2 = d3 > 0.0 ? 1 : -1;
        if (this.prevDragDirection != n2) {
            TabPaneSkin tabPaneSkin = this;
            tabPaneSkin.stopAnim(tabPaneSkin.dropHeaderAnim);
            this.prevDragDirection = n2;
        }
        double d6 = this.dragTabHeader.getLayoutX() + (double)this.xLayoutDirection * d5;
        if (d2 >= 0.0 && d6 + this.dragTabHeader.getWidth() <= this.headersRegion.getWidth()) {
            this.dragState = TabPaneSkin$DragState.REORDER;
            this.dragTabHeader.setLayoutX(d6);
            Bounds bounds = this.dragTabHeader.getBoundsInParent();
            if (n2 == 1) {
                for (int i2 = this.dragTabHeaderIndex + 1; i2 < this.headersRegion.getChildren().size(); ++i2) {
                    Bounds bounds2;
                    this.dropTabHeader = (TabPaneSkin$TabHeaderSkin)this.headersRegion.getChildren().get(i2);
                    if (this.dropAnimHeader == this.dropTabHeader) continue;
                    double d7 = this.xLayoutDirection == 1 ? bounds.getMaxX() - bounds2.getMinX() : bounds2.getMaxX() - bounds.getMinX();
                    if (d7 > (bounds2 = this.dropTabHeader.getBoundsInParent()).getWidth() * 0.75) {
                        TabPaneSkin tabPaneSkin = this;
                        tabPaneSkin.stopAnim(tabPaneSkin.dropHeaderAnim);
                        this.dropHeaderTransitionX = (double)this.xLayoutDirection * -bounds.getWidth();
                        this.dragHeaderDestX = this.xLayoutDirection == 1 ? bounds2.getMaxX() - bounds.getWidth() : bounds2.getMinX();
                        this.startHeaderReorderingAnim();
                        continue;
                    }
                    break;
                }
            } else {
                for (int i3 = this.dragTabHeaderIndex - 1; i3 >= 0; --i3) {
                    Bounds bounds3;
                    this.dropTabHeader = (TabPaneSkin$TabHeaderSkin)this.headersRegion.getChildren().get(i3);
                    if (this.dropAnimHeader == this.dropTabHeader) continue;
                    double d8 = this.xLayoutDirection == 1 ? bounds3.getMaxX() - bounds.getMinX() : bounds.getMaxX() - bounds3.getMinX();
                    if (d8 > (bounds3 = this.dropTabHeader.getBoundsInParent()).getWidth() * 0.75) {
                        TabPaneSkin tabPaneSkin = this;
                        tabPaneSkin.stopAnim(tabPaneSkin.dropHeaderAnim);
                        this.dropHeaderTransitionX = (double)this.xLayoutDirection * bounds.getWidth();
                        this.dragHeaderDestX = this.xLayoutDirection == 1 ? bounds3.getMinX() : bounds3.getMaxX() - bounds.getWidth();
                        this.startHeaderReorderingAnim();
                        continue;
                    }
                    break;
                }
            }
        }
        this.dragEventPrevLoc = d4;
        mouseEvent.consume();
    }

    private void startDrag(MouseEvent mouseEvent) {
        TabPaneSkin tabPaneSkin = this;
        tabPaneSkin.stopAnim(tabPaneSkin.dropHeaderAnim);
        TabPaneSkin tabPaneSkin2 = this;
        tabPaneSkin2.stopAnim(tabPaneSkin2.dragHeaderAnim);
        this.dragTabHeader = (TabPaneSkin$TabHeaderSkin)mouseEvent.getSource();
        if (this.dragTabHeader != null) {
            this.dragState = TabPaneSkin$DragState.START;
            this.xLayoutDirection = this.deriveTabHeaderLayoutXDirection();
            this.dragEventPrevLoc = this.getHeaderRegionLocalX(mouseEvent);
            this.dragTabHeaderStartIndex = this.dragTabHeaderIndex = this.headersRegion.getChildren().indexOf(this.dragTabHeader);
            this.dragTabHeader.setViewOrder(0.0);
            this.dragHeaderDestX = this.dragTabHeader.getLayoutX();
        }
    }

    private double getHeaderRegionLocalX(MouseEvent object) {
        object = this.headersRegion.sceneToLocal(((MouseEvent)object).getSceneX(), ((MouseEvent)object).getSceneY());
        return ((Point2D)object).getX();
    }

    private void stopDrag() {
        if (this.dragState == TabPaneSkin$DragState.START) {
            this.resetDrag();
        } else if (this.dragState == TabPaneSkin$DragState.REORDER) {
            this.dragHeaderSourceX = this.dragTabHeader.getLayoutX();
            this.dragHeaderTransitionX = this.dragHeaderDestX - this.dragHeaderSourceX;
            this.dragHeaderAnim.playFromStart();
        }
        this.tabHeaderArea.invalidateScrollOffset();
    }

    private void reorderTabs() {
        if (this.dragTabHeaderIndex != this.dragTabHeaderStartIndex) {
            ((TabObservableList)((TabPane)this.getSkinnable()).getTabs()).reorder((Tab)((TabPane)this.getSkinnable()).getTabs().get(this.dragTabHeaderStartIndex), (Tab)((TabPane)this.getSkinnable()).getTabs().get(this.dragTabHeaderIndex));
        }
    }

    private void resetDrag() {
        this.dragState = TabPaneSkin$DragState.NONE;
        this.dragTabHeader.setViewOrder(1.0);
        this.dragTabHeader = null;
        this.dropTabHeader = null;
        ((Parent)this.headersRegion).requestLayout();
    }

    private void startHeaderReorderingAnim() {
        this.dropAnimHeader = this.dropTabHeader;
        this.dropHeaderSourceX = this.dropAnimHeader.getLayoutX();
        this.dropHeaderAnim.playFromStart();
    }

    private void completeHeaderReordering() {
        if (this.dropAnimHeader != null) {
            this.headersRegion.getChildren().remove(this.dropAnimHeader);
            this.headersRegion.getChildren().add(this.dragTabHeaderIndex, this.dropAnimHeader);
            this.dropAnimHeader = null;
            ((Parent)this.headersRegion).requestLayout();
            this.dragTabHeaderIndex = this.headersRegion.getChildren().indexOf(this.dragTabHeader);
        }
    }

    private void stopAnim(Animation animation) {
        if (animation.getStatus() == Animation$Status.RUNNING) {
            animation.getOnFinished().handle(null);
            animation.stop();
        }
    }

    ContextMenu test_getTabsMenu() {
        return this.tabHeaderArea.controlButtons.popup;
    }

    void test_disableAnimations() {
        this.closeTabAnimation.set(TabPaneSkin$TabAnimation.NONE);
        this.openTabAnimation.set(TabPaneSkin$TabAnimation.NONE);
    }

    double test_getHeaderAreaScrollOffset() {
        return this.tabHeaderArea.getScrollOffset();
    }

    void test_setHeaderAreaScrollOffset(double d2) {
        this.tabHeaderArea.setScrollOffset(d2);
    }

    boolean test_isTabsFit() {
        return this.tabHeaderArea.tabsFit();
    }

    private static /* synthetic */ void lambda$addTabs$6(TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin, ActionEvent actionEvent) {
        tabPaneSkin$TabHeaderSkin.animationState = TabPaneSkin$TabAnimationState.NONE;
        tabPaneSkin$TabHeaderSkin.setVisible(true);
        ((Parent)tabPaneSkin$TabHeaderSkin.inner).requestLayout();
    }

    private /* synthetic */ void lambda$removeTabs$5(TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin, Tab tab, ActionEvent actionEvent) {
        tabPaneSkin$TabHeaderSkin.animationState = TabPaneSkin$TabAnimationState.NONE;
        this.tabHeaderArea.removeTab(tab);
        ((Parent)this.tabHeaderArea).requestLayout();
        if (((TabPane)this.getSkinnable()).getTabs().isEmpty()) {
            this.tabHeaderArea.setVisible(false);
        }
    }
}

