/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.LambdaMultiplePropertyChangeListenerHandler;
import com.sun.javafx.scene.control.Properties;
import com.sun.javafx.scene.control.TableColumnBaseHelper;
import com.sun.javafx.scene.control.TableColumnSortTypeWrapper;
import com.sun.javafx.scene.control.TreeTableViewBackingList;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Skinnable;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumn$SortType;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.skin.NestedTableColumnHeader;
import javafx.scene.control.skin.TableColumnHeader$1;
import javafx.scene.control.skin.TableColumnHeader$StyleableProperties;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TableSkinUtils;
import javafx.scene.control.skin.TableViewSkinBase;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.stage.PopupWindow;
import javafx.stage.Window;
import javafx.util.Callback;

public class TableColumnHeader
extends Region {
    static final String DEFAULT_STYLE_CLASS = "column-header";
    static final double DEFAULT_COLUMN_WIDTH = 80.0;
    private boolean autoSizeComplete = false;
    private double dragOffset;
    private NestedTableColumnHeader nestedColumnHeader;
    private TableHeaderRow tableHeaderRow;
    private NestedTableColumnHeader parentHeader;
    Label label;
    int sortPos = -1;
    private Region arrow;
    private Label sortOrderLabel;
    private HBox sortOrderDots;
    private Node sortArrow;
    private boolean isSortColumn;
    private boolean isSizeDirty = false;
    boolean isLastVisibleColumn = false;
    int columnIndex = -1;
    private int newColumnPos;
    Region columnReorderLine;
    final LambdaMultiplePropertyChangeListenerHandler changeListenerHandler;
    private ListChangeListener<TableColumnBase<?, ?>> sortOrderListener = listChangeListener$Change -> this.updateSortPosition();
    private ListChangeListener<TableColumnBase<?, ?>> visibleLeafColumnsListener = listChangeListener$Change -> {
        this.updateColumnIndex();
        this.updateSortPosition();
    };
    private ListChangeListener<String> styleClassListener = listChangeListener$Change -> {
        while (listChangeListener$Change.next()) {
            if (listChangeListener$Change.wasRemoved()) {
                this.getStyleClass().removeAll(listChangeListener$Change.getRemoved());
            }
            if (!listChangeListener$Change.wasAdded()) continue;
            this.getStyleClass().addAll(listChangeListener$Change.getAddedSubList());
        }
    };
    private WeakListChangeListener<TableColumnBase<?, ?>> weakSortOrderListener = new WeakListChangeListener(this.sortOrderListener);
    private final WeakListChangeListener<TableColumnBase<?, ?>> weakVisibleLeafColumnsListener = new WeakListChangeListener(this.visibleLeafColumnsListener);
    private final WeakListChangeListener<String> weakStyleClassListener = new WeakListChangeListener<String>(this.styleClassListener);
    private static final EventHandler<MouseEvent> mousePressedHandler = mouseEvent -> {
        TableColumnHeader tableColumnHeader = (TableColumnHeader)mouseEvent.getSource();
        EventTarget eventTarget = tableColumnHeader.getTableColumn();
        if ((eventTarget = ((TableColumnBase)eventTarget).getContextMenu()) != null && ((Window)eventTarget).isShowing()) {
            ((Window)eventTarget).hide();
        }
        if (mouseEvent.isConsumed()) {
            return;
        }
        mouseEvent.consume();
        tableColumnHeader.getTableHeaderRow().columnDragLock = true;
        ((Node)((Object)tableColumnHeader.getTableSkin().getSkinnable())).requestFocus();
        if (mouseEvent.isPrimaryButtonDown() && tableColumnHeader.isColumnReorderingEnabled()) {
            tableColumnHeader.columnReorderingStarted(mouseEvent.getX());
        }
    };
    private static final EventHandler<MouseEvent> mouseDraggedHandler = mouseEvent -> {
        if (mouseEvent.isConsumed()) {
            return;
        }
        mouseEvent.consume();
        TableColumnHeader tableColumnHeader = (TableColumnHeader)mouseEvent.getSource();
        if (mouseEvent.isPrimaryButtonDown() && tableColumnHeader.isColumnReorderingEnabled()) {
            tableColumnHeader.columnReordering(mouseEvent.getSceneX(), mouseEvent.getSceneY());
        }
    };
    private static final EventHandler<MouseEvent> mouseReleasedHandler = mouseEvent -> {
        TableColumnHeader tableColumnHeader = (TableColumnHeader)mouseEvent.getSource();
        ((TableColumnHeader)mouseEvent.getSource()).getTableHeaderRow().columnDragLock = false;
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        if (mouseEvent.isConsumed()) {
            return;
        }
        mouseEvent.consume();
        if (tableColumnHeader.getTableHeaderRow().isReordering() && tableColumnHeader.isColumnReorderingEnabled()) {
            tableColumnHeader.columnReorderingComplete();
            return;
        }
        if (mouseEvent.isStillSincePress()) {
            tableColumnHeader.sortColumn(mouseEvent.isShiftDown());
        }
    };
    private static final EventHandler<ContextMenuEvent> contextMenuRequestedHandler = contextMenuEvent -> {
        TableColumnHeader tableColumnHeader = (TableColumnHeader)contextMenuEvent.getSource();
        EventTarget eventTarget = tableColumnHeader.getTableColumn();
        if ((eventTarget = ((TableColumnBase)eventTarget).getContextMenu()) != null) {
            ((PopupWindow)eventTarget).show(tableColumnHeader, contextMenuEvent.getScreenX(), contextMenuEvent.getScreenY());
            contextMenuEvent.consume();
        }
    };
    private DoubleProperty size;
    private ReadOnlyObjectWrapper<TableColumnBase<?, ?>> tableColumn = new ReadOnlyObjectWrapper(this, "tableColumn");
    private static final PseudoClass PSEUDO_CLASS_LAST_VISIBLE = PseudoClass.getPseudoClass("last-visible");

    public TableColumnHeader(TableColumnBase tableColumnBase) {
        this.setTableColumn(tableColumnBase);
        this.setFocusTraversable(false);
        this.initStyleClasses();
        this.initUI();
        this.changeListenerHandler = new LambdaMultiplePropertyChangeListenerHandler();
        this.changeListenerHandler.registerChangeListener(this.sceneProperty(), observableValue -> this.updateScene());
        if (this.getTableColumn() != null) {
            this.changeListenerHandler.registerChangeListener(tableColumnBase.idProperty(), observableValue -> this.setId(tableColumnBase.getId()));
            this.changeListenerHandler.registerChangeListener(tableColumnBase.styleProperty(), observableValue -> this.setStyle(tableColumnBase.getStyle()));
            this.changeListenerHandler.registerChangeListener(tableColumnBase.widthProperty(), observableValue -> {
                this.isSizeDirty = true;
                this.requestLayout();
            });
            this.changeListenerHandler.registerChangeListener(tableColumnBase.visibleProperty(), observableValue -> {
                TableColumnHeader tableColumnHeader = this;
                tableColumnHeader.setVisible(tableColumnHeader.getTableColumn().isVisible());
            });
            this.changeListenerHandler.registerChangeListener(tableColumnBase.sortNodeProperty(), observableValue -> this.updateSortGrid());
            this.changeListenerHandler.registerChangeListener(tableColumnBase.sortableProperty(), object -> {
                if (TableSkinUtils.getSortOrder(this.getTableSkin()).contains(this.getTableColumn())) {
                    object = this.getTableHeaderRow().getRootHeader();
                    this.updateAllHeaders((TableColumnHeader)object);
                }
            });
            this.changeListenerHandler.registerChangeListener(tableColumnBase.textProperty(), observableValue -> this.label.setText(tableColumnBase.getText()));
            this.changeListenerHandler.registerChangeListener(tableColumnBase.graphicProperty(), observableValue -> this.label.setGraphic(tableColumnBase.getGraphic()));
            this.setId(tableColumnBase.getId());
            this.setStyle(tableColumnBase.getStyle());
            this.setAccessibleRole(AccessibleRole.TABLE_COLUMN);
        }
    }

    private final double getSize() {
        if (this.size == null) {
            return 20.0;
        }
        return this.size.doubleValue();
    }

    private final DoubleProperty sizeProperty() {
        if (this.size == null) {
            this.size = new TableColumnHeader$1(this, 20.0);
        }
        return this.size;
    }

    private final void setTableColumn(TableColumnBase<?, ?> tableColumnBase) {
        this.tableColumn.set(tableColumnBase);
    }

    public final TableColumnBase<?, ?> getTableColumn() {
        return (TableColumnBase)this.tableColumn.get();
    }

    public final ReadOnlyObjectProperty<TableColumnBase<?, ?>> tableColumnProperty() {
        return this.tableColumn.getReadOnlyProperty();
    }

    @Override
    protected void layoutChildren() {
        if (this.isSizeDirty) {
            TableColumnHeader tableColumnHeader = this;
            ((Node)tableColumnHeader).resize(tableColumnHeader.getTableColumn().getWidth(), this.getHeight());
            this.isSizeDirty = false;
        }
        double d2 = this.tableHeaderRow == null || !this.isLastVisibleColumn ? 0.0 : this.tableHeaderRow.cornerPadding.get();
        double d3 = 0.0;
        TableColumnHeader tableColumnHeader = this;
        double d4 = tableColumnHeader.snapSizeX(tableColumnHeader.getWidth()) - (this.snappedLeftInset() + this.snappedRightInset()) - d2;
        double d5 = this.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
        double d6 = d4;
        if (this.arrow != null) {
            this.arrow.setMaxSize(((Node)this.arrow).prefWidth(-1.0), ((Node)this.arrow).prefHeight(-1.0));
        }
        if (this.sortArrow != null && this.sortArrow.isVisible()) {
            d3 = this.sortArrow.prefWidth(-1.0);
            this.sortArrow.resize(d3, this.sortArrow.prefHeight(-1.0));
            TableColumnHeader tableColumnHeader2 = this;
            tableColumnHeader2.positionInArea(tableColumnHeader2.sortArrow, d6 -= d3, this.snappedTopInset(), d3, d5, 0.0, HPos.CENTER, VPos.CENTER);
        }
        if (this.label != null) {
            double d7 = d4 - d3;
            this.label.resizeRelocate(this.snappedLeftInset(), 0.0, d7, this.getHeight());
        }
    }

    @Override
    protected double computePrefWidth(double d2) {
        if (this.getNestedColumnHeader() != null) {
            double d3 = ((Node)this.getNestedColumnHeader()).prefWidth(d2);
            if (this.getTableColumn() != null) {
                TableColumnBaseHelper.setWidth(this.getTableColumn(), d3);
            }
            return d3;
        }
        if (this.getTableColumn() != null && this.getTableColumn().isVisible()) {
            TableColumnHeader tableColumnHeader = this;
            return tableColumnHeader.snapSizeX(tableColumnHeader.getTableColumn().getWidth());
        }
        return 0.0;
    }

    @Override
    protected double computeMinHeight(double d2) {
        if (this.label == null) {
            return 0.0;
        }
        return ((Node)this.label).minHeight(d2);
    }

    @Override
    protected double computePrefHeight(double d2) {
        if (this.getTableColumn() == null) {
            return 0.0;
        }
        return Math.max(this.getSize(), ((Node)this.label).prefHeight(-1.0));
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TableColumnHeader.getClassCssMetaData();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case INDEX: {
                TableColumnHeader tableColumnHeader = this;
                return tableColumnHeader.getIndex(tableColumnHeader.getTableColumn());
            }
            case TEXT: {
                if (this.getTableColumn() != null) {
                    return this.getTableColumn().getText();
                }
                return null;
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    void initStyleClasses() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.installTableColumnStyleClassListener();
    }

    void installTableColumnStyleClassListener() {
        TableColumnBase<?, ?> tableColumnBase = this.getTableColumn();
        if (tableColumnBase != null) {
            this.getStyleClass().addAll((Collection<String>)tableColumnBase.getStyleClass());
            tableColumnBase.getStyleClass().addListener(this.weakStyleClassListener);
        }
    }

    NestedTableColumnHeader getNestedColumnHeader() {
        return this.nestedColumnHeader;
    }

    void setNestedColumnHeader(NestedTableColumnHeader nestedTableColumnHeader) {
        this.nestedColumnHeader = nestedTableColumnHeader;
    }

    protected TableHeaderRow getTableHeaderRow() {
        return this.tableHeaderRow;
    }

    void setTableHeaderRow(TableHeaderRow tableHeaderRow) {
        if (this.tableHeaderRow != null) {
            this.changeListenerHandler.unregisterChangeListeners(this.tableHeaderRow.cornerPadding);
        }
        this.tableHeaderRow = tableHeaderRow;
        if (this.tableHeaderRow != null) {
            this.changeListenerHandler.registerChangeListener(this.tableHeaderRow.cornerPadding, observableValue -> {
                if (this.isLastVisibleColumn) {
                    this.requestLayout();
                }
            });
        }
        this.updateTableSkin();
    }

    private void updateTableSkin() {
        TableViewSkinBase<?, ?, ?, ?, ?> tableViewSkinBase = this.getTableSkin();
        if (tableViewSkinBase == null) {
            return;
        }
        this.updateColumnIndex();
        this.columnReorderLine = tableViewSkinBase.getColumnReorderLine();
        if (this.getTableColumn() != null) {
            this.updateSortPosition();
            TableSkinUtils.getSortOrder(tableViewSkinBase).addListener(this.weakSortOrderListener);
            TableSkinUtils.getVisibleLeafColumns(tableViewSkinBase).addListener(this.weakVisibleLeafColumnsListener);
        }
    }

    protected TableViewSkinBase<?, ?, ?, ?, ?> getTableSkin() {
        if (this.tableHeaderRow == null) {
            return null;
        }
        return this.tableHeaderRow.tableSkin;
    }

    NestedTableColumnHeader getParentHeader() {
        return this.parentHeader;
    }

    void setParentHeader(NestedTableColumnHeader nestedTableColumnHeader) {
        this.parentHeader = nestedTableColumnHeader;
    }

    private void updateAllHeaders(TableColumnHeader object) {
        if (object instanceof NestedTableColumnHeader) {
            object = ((NestedTableColumnHeader)object).getColumnHeaders();
            for (int i2 = 0; i2 < object.size(); ++i2) {
                this.updateAllHeaders((TableColumnHeader)object.get(i2));
            }
            return;
        }
        ((TableColumnHeader)object).updateSortPosition();
    }

    private void updateScene() {
        if (!this.autoSizeComplete) {
            if (this.getTableColumn() == null || this.getTableColumn().getWidth() != 80.0 || this.getScene() == null) {
                return;
            }
            this.doColumnAutoSize(30);
            this.autoSizeComplete = true;
        }
    }

    void dispose() {
        TableViewSkinBase<?, ?, ?, ?, ?> tableViewSkinBase = this.getTableSkin();
        if (tableViewSkinBase != null) {
            TableSkinUtils.getVisibleLeafColumns(tableViewSkinBase).removeListener(this.weakVisibleLeafColumnsListener);
            TableSkinUtils.getSortOrder(tableViewSkinBase).removeListener(this.weakSortOrderListener);
        }
        this.changeListenerHandler.dispose();
    }

    private boolean isSortingEnabled() {
        return true;
    }

    private boolean isColumnReorderingEnabled() {
        return !Properties.IS_TOUCH_SUPPORTED && TableSkinUtils.getVisibleLeafColumns(this.getTableSkin()).size() > 1;
    }

    private void initUI() {
        if (this.getTableColumn() == null) {
            return;
        }
        this.setOnMousePressed(mousePressedHandler);
        this.setOnMouseDragged(mouseDraggedHandler);
        this.setOnDragDetected(mouseEvent -> mouseEvent.consume());
        this.setOnContextMenuRequested(contextMenuRequestedHandler);
        this.setOnMouseReleased(mouseReleasedHandler);
        this.label = new Label();
        this.label.setText(this.getTableColumn().getText());
        this.label.setGraphic(this.getTableColumn().getGraphic());
        this.label.setVisible(this.getTableColumn().isVisible());
        if (this.isSortingEnabled()) {
            this.updateSortGrid();
        }
    }

    private void doColumnAutoSize(int n2) {
        double d2 = this.getTableColumn().getPrefWidth();
        if (d2 == 80.0) {
            this.resizeColumnToFitContent(n2);
        }
    }

    protected void resizeColumnToFitContent(int n2) {
        TableColumnBase<?, ?> tableColumnBase = this.getTableColumn();
        if (!tableColumnBase.isResizable()) {
            return;
        }
        Skinnable skinnable = this.getTableSkin().getSkinnable();
        if (skinnable instanceof TableView) {
            this.resizeColumnToFitContent((TableView)skinnable, (TableColumn)tableColumnBase, this.getTableSkin(), n2);
            return;
        }
        if (skinnable instanceof TreeTableView) {
            this.resizeColumnToFitContent((TreeTableView)skinnable, (TreeTableColumn)tableColumnBase, this.getTableSkin(), n2);
        }
    }

    private <T, S> void resizeColumnToFitContent(TableView<T> tableView, TableColumn<T, S> tableColumn, TableViewSkinBase tableViewSkinBase, int n2) {
        ObservableList<T> observableList = tableView.getItems();
        if (observableList == null || observableList.isEmpty()) {
            return;
        }
        Callback<TableColumn<T, S>, TableCell<T, S>> callback = tableColumn.getCellFactory();
        if (callback == null) {
            return;
        }
        if ((callback = callback.call(tableColumn)) == null) {
            return;
        }
        ((Node)((Object)callback)).getProperties().put("deferToParentPrefWidth", Boolean.TRUE);
        double d2 = 10.0;
        TableRow<T> tableRow = ((Control)((Object)callback)).getSkin() == null ? null : ((Control)((Object)callback)).getSkin().getNode();
        if (tableRow instanceof Region) {
            tableRow = tableRow;
            d2 = tableRow.snappedLeftInset() + tableRow.snappedRightInset();
        }
        tableRow = tableView.getRowFactory();
        tableRow = this.createMeasureRow(tableView, tableViewSkinBase, (Callback<TableView<T>, TableRow<T>>)((Object)tableRow));
        ((SkinBase)tableRow.getSkin()).getChildren().add((Node)((Object)callback));
        int n3 = n2 == -1 ? observableList.size() : Math.min(observableList.size(), n2);
        double d3 = 0.0;
        ((TableCell)((Object)callback)).updateTableColumn(tableColumn);
        ((TableCell)((Object)callback)).updateTableView(tableView);
        for (int i2 = 0; i2 < n3; ++i2) {
            tableRow.updateIndex(i2);
            ((TableCell)((Object)callback)).updateTableRow(tableRow);
            ((IndexedCell)((Object)callback)).updateIndex(i2);
            if ((((Labeled)((Object)callback)).getText() == null || ((Labeled)((Object)callback)).getText().isEmpty()) && ((Labeled)((Object)callback)).getGraphic() == null) continue;
            tableRow.applyCss();
            d3 = Math.max(d3, ((Node)((Object)callback)).prefWidth(-1.0));
        }
        tableViewSkinBase.getChildren().remove(tableRow);
        tableRow.updateIndex(-1);
        ((IndexedCell)((Object)callback)).updateIndex(-1);
        TableColumnHeader tableColumnHeader = tableViewSkinBase.getTableHeaderRow().getColumnHeaderFor(tableColumn);
        double d4 = Utils.computeTextWidth(tableColumnHeader.label.getFont(), tableColumn.getText(), -1.0);
        Node node = tableColumnHeader.label.getGraphic();
        double d5 = node == null ? 0.0 : node.prefWidth(-1.0) + tableColumnHeader.label.getGraphicTextGap();
        double d6 = d4 + d5 + 10.0 + tableColumnHeader.snappedLeftInset() + tableColumnHeader.snappedRightInset();
        d3 = Math.max(d3, d6);
        d3 += d2;
        if (TableSkinUtils.isConstrainedResizePolicy(tableView.getColumnResizePolicy()) && tableView.getWidth() > 0.0) {
            int n4;
            if (d3 > tableColumn.getMaxWidth()) {
                d3 = tableColumn.getMaxWidth();
            }
            if ((n4 = ((TableColumnBase)tableColumn).getColumns().size()) > 0) {
                TableColumnHeader tableColumnHeader2 = this.getTableHeaderRow().getColumnHeaderFor((TableColumnBase)((TableColumnBase)tableColumn).getColumns().get(n4 - 1));
                if (tableColumnHeader2 != null) {
                    tableColumnHeader2.resizeColumnToFitContent(n2);
                }
                return;
            }
            TableSkinUtils.resizeColumn(tableViewSkinBase, tableColumn, Math.round(d3 - tableColumn.getWidth()));
            return;
        }
        TableColumnBaseHelper.setWidth(tableColumn, d3);
    }

    private <T> TableRow<T> createMeasureRow(TableView<T> tableView, TableViewSkinBase tableViewSkinBase, Callback<TableView<T>, TableRow<T>> tableRow) {
        tableRow = tableRow != null ? tableRow.call(tableView) : new TableRow<T>();
        tableRow.updateTableView(tableView);
        tableViewSkinBase.getChildren().add(tableRow);
        tableRow.applyCss();
        if (!(tableRow.getSkin() instanceof SkinBase)) {
            tableViewSkinBase.getChildren().remove(tableRow);
            tableRow = this.createMeasureRow(tableView, tableViewSkinBase, null);
        }
        return tableRow;
    }

    private <T, S> void resizeColumnToFitContent(TreeTableView<T> treeTableView, TreeTableColumn<T, S> treeTableColumn, TableViewSkinBase tableViewSkinBase, int n2) {
        double d2;
        TreeTableViewBackingList<T> treeTableViewBackingList = new TreeTableViewBackingList<T>(treeTableView);
        if (treeTableViewBackingList.isEmpty()) {
            return;
        }
        Callback<TreeTableColumn<T, S>, TreeTableCell<T, S>> callback = treeTableColumn.getCellFactory();
        if (callback == null) {
            return;
        }
        if ((callback = callback.call(treeTableColumn)) == null) {
            return;
        }
        ((Node)((Object)callback)).getProperties().put("deferToParentPrefWidth", Boolean.TRUE);
        double d3 = 10.0;
        TreeTableRow<T> treeTableRow = ((Control)((Object)callback)).getSkin() == null ? null : ((Control)((Object)callback)).getSkin().getNode();
        if (treeTableRow instanceof Region) {
            treeTableRow = treeTableRow;
            d3 = treeTableRow.snappedLeftInset() + treeTableRow.snappedRightInset();
        }
        treeTableRow = treeTableView.getRowFactory();
        treeTableRow = this.createMeasureRow(treeTableView, tableViewSkinBase, (Callback<TreeTableView<T>, TreeTableRow<T>>)((Object)treeTableRow));
        ((SkinBase)treeTableRow.getSkin()).getChildren().add((Node)((Object)callback));
        int n3 = n2 == -1 ? treeTableViewBackingList.size() : Math.min(treeTableViewBackingList.size(), n2);
        double d4 = 0.0;
        ((TreeTableCell)((Object)callback)).updateTableColumn(treeTableColumn);
        ((TreeTableCell)((Object)callback)).updateTreeTableView(treeTableView);
        for (int i2 = 0; i2 < n3; ++i2) {
            treeTableRow.updateIndex(i2);
            treeTableRow.updateTreeItem(treeTableView.getTreeItem(i2));
            ((TreeTableCell)((Object)callback)).updateTableRow(treeTableRow);
            ((IndexedCell)((Object)callback)).updateIndex(i2);
            if ((((Labeled)((Object)callback)).getText() == null || ((Labeled)((Object)callback)).getText().isEmpty()) && ((Labeled)((Object)callback)).getGraphic() == null) continue;
            treeTableRow.applyCss();
            d2 = ((Node)((Object)callback)).prefWidth(-1.0);
            d4 = Math.max(d4, d2);
        }
        tableViewSkinBase.getChildren().remove(treeTableRow);
        treeTableRow.updateIndex(-1);
        ((IndexedCell)((Object)callback)).updateIndex(-1);
        TableColumnHeader tableColumnHeader = tableViewSkinBase.getTableHeaderRow().getColumnHeaderFor(treeTableColumn);
        d2 = Utils.computeTextWidth(tableColumnHeader.label.getFont(), treeTableColumn.getText(), -1.0);
        Node node = tableColumnHeader.label.getGraphic();
        double d5 = node == null ? 0.0 : node.prefWidth(-1.0) + tableColumnHeader.label.getGraphicTextGap();
        double d6 = d2 + d5 + 10.0 + tableColumnHeader.snappedLeftInset() + tableColumnHeader.snappedRightInset();
        d4 = Math.max(d4, d6);
        d4 += d3;
        if (TableSkinUtils.isConstrainedResizePolicy(treeTableView.getColumnResizePolicy()) && treeTableView.getWidth() > 0.0) {
            int n4;
            if (d4 > treeTableColumn.getMaxWidth()) {
                d4 = treeTableColumn.getMaxWidth();
            }
            if ((n4 = ((TableColumnBase)treeTableColumn).getColumns().size()) > 0) {
                TableColumnHeader tableColumnHeader2 = this.getTableHeaderRow().getColumnHeaderFor((TableColumnBase)((TableColumnBase)treeTableColumn).getColumns().get(n4 - 1));
                if (tableColumnHeader2 != null) {
                    tableColumnHeader2.resizeColumnToFitContent(n2);
                }
                return;
            }
            TableSkinUtils.resizeColumn(tableViewSkinBase, treeTableColumn, Math.round(d4 - treeTableColumn.getWidth()));
            return;
        }
        TableColumnBaseHelper.setWidth(treeTableColumn, d4);
    }

    private <T> TreeTableRow<T> createMeasureRow(TreeTableView<T> treeTableView, TableViewSkinBase tableViewSkinBase, Callback<TreeTableView<T>, TreeTableRow<T>> treeTableRow) {
        treeTableRow = treeTableRow != null ? treeTableRow.call(treeTableView) : new TreeTableRow<T>();
        treeTableRow.updateTreeTableView(treeTableView);
        tableViewSkinBase.getChildren().add(treeTableRow);
        treeTableRow.applyCss();
        if (!(treeTableRow.getSkin() instanceof SkinBase)) {
            tableViewSkinBase.getChildren().remove(treeTableRow);
            treeTableRow = this.createMeasureRow(treeTableView, tableViewSkinBase, null);
        }
        return treeTableRow;
    }

    private void updateSortPosition() {
        this.sortPos = !this.getTableColumn().isSortable() ? -1 : this.getSortPosition();
        this.updateSortGrid();
    }

    private void updateSortGrid() {
        Node node;
        int n2;
        if (this instanceof NestedTableColumnHeader) {
            return;
        }
        this.getChildren().clear();
        this.getChildren().add(this.label);
        if (!this.isSortingEnabled()) {
            return;
        }
        boolean bl2 = this.isSortColumn = this.sortPos != -1;
        if (!this.isSortColumn) {
            if (this.sortArrow != null) {
                this.sortArrow.setVisible(false);
            }
            return;
        }
        int n3 = TableSkinUtils.getVisibleLeafIndex(this.getTableSkin(), this.getTableColumn());
        if (n3 == -1) {
            return;
        }
        n3 = this.getVisibleSortOrderColumnCount();
        int n4 = n2 = this.sortPos <= 3 && n3 > 1 ? 1 : 0;
        if (this.getTableColumn().getSortNode() != null) {
            node = this.getTableColumn().getSortNode();
            this.getChildren().add(node);
        } else {
            GridPane gridPane = new GridPane();
            node = gridPane;
            gridPane.setPadding(new Insets(0.0, 3.0, 0.0, 0.0));
            this.getChildren().add(gridPane);
            if (this.arrow == null) {
                this.arrow = new Region();
                this.arrow.getStyleClass().setAll((String[])new String[]{"arrow"});
                this.arrow.setVisible(true);
                this.arrow.setRotate(TableColumnSortTypeWrapper.isAscending(this.getTableColumn()) ? 180.0 : 0.0);
                this.changeListenerHandler.registerChangeListener(TableColumnSortTypeWrapper.getSortTypeProperty(this.getTableColumn()), observableValue -> {
                    this.updateSortGrid();
                    if (this.arrow != null) {
                        this.arrow.setRotate(TableColumnSortTypeWrapper.isAscending(this.getTableColumn()) ? 180.0 : 0.0);
                    }
                });
            }
            this.arrow.setVisible(this.isSortColumn);
            if (this.sortPos > 2) {
                if (this.sortOrderLabel == null) {
                    this.sortOrderLabel = new Label();
                    this.sortOrderLabel.getStyleClass().add("sort-order");
                }
                this.sortOrderLabel.setText("" + (this.sortPos + 1));
                this.sortOrderLabel.setVisible(n3 > 1);
                gridPane.add(this.arrow, 1, 1);
                GridPane.setHgrow(this.arrow, Priority.NEVER);
                GridPane.setVgrow(this.arrow, Priority.NEVER);
                gridPane.add(this.sortOrderLabel, 2, 1);
            } else if (n2 != 0) {
                if (this.sortOrderDots == null) {
                    this.sortOrderDots = new HBox(0.0);
                    this.sortOrderDots.getStyleClass().add("sort-order-dots-container");
                }
                boolean bl3 = TableColumnSortTypeWrapper.isAscending(this.getTableColumn());
                n3 = bl3 ? 1 : 0;
                n2 = bl3 ? 1 : 2;
                n3 = n3 != 0 ? 2 : 1;
                gridPane.add(this.arrow, 1, n2);
                GridPane.setHalignment(this.arrow, HPos.CENTER);
                gridPane.add(this.sortOrderDots, 1, n3);
                TableColumnHeader tableColumnHeader = this;
                tableColumnHeader.updateSortOrderDots(tableColumnHeader.sortPos);
            } else {
                gridPane.add(this.arrow, 1, 1);
                GridPane.setHgrow(this.arrow, Priority.NEVER);
                GridPane.setVgrow(this.arrow, Priority.ALWAYS);
            }
        }
        this.sortArrow = node;
        if (this.sortArrow != null) {
            this.sortArrow.setVisible(this.isSortColumn);
        }
        this.requestLayout();
    }

    private void updateSortOrderDots(int n2) {
        double d2 = ((Node)this.arrow).prefWidth(-1.0);
        this.sortOrderDots.getChildren().clear();
        for (int i2 = 0; i2 <= n2; ++i2) {
            Region region = new Region();
            region.getStyleClass().add("sort-order-dot");
            String string = TableColumnSortTypeWrapper.getSortTypeName(this.getTableColumn());
            if (string != null && !string.isEmpty()) {
                region.getStyleClass().add(string.toLowerCase(Locale.ROOT));
            }
            this.sortOrderDots.getChildren().add(region);
            if (i2 >= n2) continue;
            region = new Region();
            double d3 = n2 == 1 ? 1.0 : 0.0;
            region.setPadding(new Insets(0.0, 1.0, 0.0, d3));
            this.sortOrderDots.getChildren().add(region);
        }
        this.sortOrderDots.setAlignment(Pos.TOP_CENTER);
        this.sortOrderDots.setMaxWidth(d2);
    }

    void moveColumn(TableColumnBase tableColumnBase, int n2) {
        if (tableColumnBase == null || n2 < 0) {
            return;
        }
        ObservableList<TableColumnBase<?, ?>> observableList = this.getColumns(tableColumnBase);
        int n3 = observableList.size();
        int n4 = observableList.indexOf(tableColumnBase);
        int n5 = n2;
        int n6 = 0;
        for (int i2 = 0; i2 < n3 && n6 != n5 + 1; ++i2) {
            if (((TableColumnBase)observableList.get(i2)).isVisible()) {
                ++n6;
                continue;
            }
            ++n2;
        }
        if (n2 >= n3) {
            n2 = n3 - 1;
        } else if (n2 < 0) {
            n2 = 0;
        }
        if (n2 == n4) {
            return;
        }
        ArrayList arrayList = new ArrayList(observableList);
        arrayList.remove(tableColumnBase);
        arrayList.add(n2, tableColumnBase);
        observableList.setAll(arrayList);
    }

    private ObservableList<TableColumnBase<?, ?>> getColumns(TableColumnBase tableColumnBase) {
        if (tableColumnBase.getParentColumn() == null) {
            return TableSkinUtils.getColumns(this.getTableSkin());
        }
        return tableColumnBase.getParentColumn().getColumns();
    }

    private int getIndex(TableColumnBase<?, ?> tableColumnBase) {
        if (tableColumnBase == null) {
            return -1;
        }
        ObservableList<TableColumnBase<?, ?>> observableList = this.getColumns(tableColumnBase);
        int n2 = -1;
        for (int i2 = 0; i2 < observableList.size(); ++i2) {
            TableColumnBase tableColumnBase2 = (TableColumnBase)observableList.get(i2);
            if (!tableColumnBase2.isVisible()) continue;
            ++n2;
            if (tableColumnBase.equals(tableColumnBase2)) break;
        }
        return n2;
    }

    private void updateColumnIndex() {
        TableColumnBase<?, ?> tableColumnBase = this.getTableColumn();
        TableViewSkinBase<?, ?, ?, ?, ?> tableViewSkinBase = this.getTableSkin();
        this.columnIndex = tableViewSkinBase == null || tableColumnBase == null ? -1 : TableSkinUtils.getVisibleLeafIndex(tableViewSkinBase, tableColumnBase);
        this.isLastVisibleColumn = this.getTableColumn() != null && this.columnIndex != -1 && this.columnIndex == TableSkinUtils.getVisibleLeafColumns(tableViewSkinBase).size() - 1;
        this.pseudoClassStateChanged(PSEUDO_CLASS_LAST_VISIBLE, this.isLastVisibleColumn);
    }

    private void sortColumn(boolean n2) {
        if (!this.isSortingEnabled()) {
            return;
        }
        if (this.getTableColumn() == null || this.getTableColumn().getColumns().size() != 0 || this.getTableColumn().getComparator() == null || !this.getTableColumn().isSortable()) {
            return;
        }
        ObservableList<TableColumnBase<?, ?>> observableList = TableSkinUtils.getSortOrder(this.getTableSkin());
        if (n2) {
            if (!this.isSortColumn) {
                TableColumnSortTypeWrapper.setSortType(this.getTableColumn(), TableColumn$SortType.ASCENDING);
                observableList.add(this.getTableColumn());
                return;
            }
            if (TableColumnSortTypeWrapper.isAscending(this.getTableColumn())) {
                TableColumnSortTypeWrapper.setSortType(this.getTableColumn(), TableColumn$SortType.DESCENDING);
                return;
            }
            n2 = observableList.indexOf(this.getTableColumn());
            if (n2 != -1) {
                observableList.remove(n2);
            }
            return;
        }
        if (this.isSortColumn && observableList.size() == 1) {
            if (TableColumnSortTypeWrapper.isAscending(this.getTableColumn())) {
                TableColumnSortTypeWrapper.setSortType(this.getTableColumn(), TableColumn$SortType.DESCENDING);
                return;
            }
            observableList.remove(this.getTableColumn());
            return;
        }
        if (this.isSortColumn) {
            if (TableColumnSortTypeWrapper.isAscending(this.getTableColumn())) {
                TableColumnSortTypeWrapper.setSortType(this.getTableColumn(), TableColumn$SortType.DESCENDING);
            } else if (TableColumnSortTypeWrapper.isDescending(this.getTableColumn())) {
                TableColumnSortTypeWrapper.setSortType(this.getTableColumn(), TableColumn$SortType.ASCENDING);
            }
            ArrayList arrayList = new ArrayList(observableList);
            arrayList.remove(this.getTableColumn());
            arrayList.add(0, this.getTableColumn());
            observableList.setAll(this.getTableColumn());
            return;
        }
        TableColumnSortTypeWrapper.setSortType(this.getTableColumn(), TableColumn$SortType.ASCENDING);
        observableList.setAll(this.getTableColumn());
    }

    private int getSortPosition() {
        if (this.getTableColumn() == null) {
            return -1;
        }
        List<TableColumnBase> list = this.getVisibleSortOrderColumns();
        int n2 = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            TableColumnBase tableColumnBase = list.get(i2);
            if (this.getTableColumn().equals(tableColumnBase)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private List<TableColumnBase> getVisibleSortOrderColumns() {
        ObservableList<TableColumnBase<?, ?>> observableList = TableSkinUtils.getSortOrder(this.getTableSkin());
        ArrayList<TableColumnBase> arrayList = new ArrayList<TableColumnBase>();
        for (int i2 = 0; i2 < observableList.size(); ++i2) {
            TableColumnBase tableColumnBase = (TableColumnBase)observableList.get(i2);
            if (tableColumnBase == null || !tableColumnBase.isSortable() || !tableColumnBase.isVisible()) continue;
            arrayList.add(tableColumnBase);
        }
        return arrayList;
    }

    private int getVisibleSortOrderColumnCount() {
        return this.getVisibleSortOrderColumns().size();
    }

    void columnReorderingStarted(double d2) {
        if (!this.getTableColumn().isReorderable()) {
            return;
        }
        this.dragOffset = d2;
        this.getTableHeaderRow().setReorderingColumn(this.getTableColumn());
        this.getTableHeaderRow().setReorderingRegion(this);
    }

    void columnReordering(double d2, double d3) {
        double d4;
        if (!this.getTableColumn().isReorderable()) {
            return;
        }
        this.getTableHeaderRow().setReordering(true);
        TableColumnHeader tableColumnHeader = null;
        double d5 = this.getParentHeader().sceneToLocal(d2, d3).getX();
        double d6 = ((Node)((Object)this.getTableSkin().getSkinnable())).sceneToLocal(d2, d3).getX() - this.dragOffset;
        this.getTableHeaderRow().setDragHeaderX(d6);
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        this.newColumnPos = 0;
        for (TableColumnHeader tableColumnHeader2 : this.getParentHeader().getColumnHeaders()) {
            if (!tableColumnHeader2.isVisible()) continue;
            double d10 = ((Node)tableColumnHeader2).prefWidth(-1.0);
            d9 += d10;
            d7 = tableColumnHeader2.getBoundsInParent().getMinX();
            d8 = d7 + d10;
            if (d5 >= d7 && d5 < d8) {
                tableColumnHeader = tableColumnHeader2;
                break;
            }
            ++this.newColumnPos;
        }
        if (tableColumnHeader == null) {
            this.newColumnPos = d5 > d9 ? this.getParentHeader().getColumns().size() - 1 : 0;
            return;
        }
        double d11 = d7 + (d8 - d7) / 2.0;
        boolean bl2 = d5 <= d11;
        TableColumnHeader tableColumnHeader3 = this;
        int n2 = tableColumnHeader3.getIndex(tableColumnHeader3.getTableColumn());
        this.newColumnPos += this.newColumnPos > n2 && bl2 ? -1 : (this.newColumnPos < n2 && !bl2 ? 1 : 0);
        TableColumnHeader tableColumnHeader4 = tableColumnHeader;
        double d12 = this.getTableHeaderRow().sceneToLocal(tableColumnHeader4.localToScene(tableColumnHeader4.getBoundsInLocal())).getMinX();
        d12 += bl2 ? 0.0 : tableColumnHeader.getWidth();
        if (d4 >= -0.5 && d12 <= ((Region)((Object)this.getTableSkin().getSkinnable())).getWidth()) {
            this.columnReorderLine.setTranslateX(d12);
            this.columnReorderLine.setVisible(true);
        }
        this.getTableHeaderRow().setReordering(true);
    }

    void columnReorderingComplete() {
        if (!this.getTableColumn().isReorderable()) {
            return;
        }
        TableColumnHeader tableColumnHeader = this;
        tableColumnHeader.moveColumn(tableColumnHeader.getTableColumn(), this.newColumnPos);
        this.columnReorderLine.setTranslateX(0.0);
        this.columnReorderLine.setLayoutX(0.0);
        this.newColumnPos = 0;
        this.getTableHeaderRow().setReordering(false);
        this.columnReorderLine.setVisible(false);
        this.getTableHeaderRow().setReorderingColumn(null);
        this.getTableHeaderRow().setReorderingRegion(null);
        this.dragOffset = 0.0;
    }

    double getDragRectHeight() {
        return this.getHeight();
    }

    boolean represents(TableColumnBase<?, ?> tableColumnBase) {
        if (!tableColumnBase.getColumns().isEmpty()) {
            return false;
        }
        return tableColumnBase == this.getTableColumn();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return TableColumnHeader$StyleableProperties.STYLEABLES;
    }
}

