/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Skinnable;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.skin.NestedTableColumnHeader;
import javafx.scene.control.skin.TableColumnHeader;
import javafx.scene.control.skin.TableHeaderRow$1;
import javafx.scene.control.skin.TableHeaderRow$2;
import javafx.scene.control.skin.TableSkinUtils;
import javafx.scene.control.skin.TableViewSkinBase;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;

public class TableHeaderRow
extends StackPane {
    private final String MENU_SEPARATOR = ControlResources.getString("TableView.nestedColumnControlMenuSeparator");
    private final VirtualFlow flow;
    final TableViewSkinBase<?, ?, ?, ?, ?> tableSkin;
    private Map<TableColumnBase, CheckMenuItem> columnMenuItems;
    private double scrollX;
    private double tableWidth;
    private Rectangle clip;
    private TableColumnHeader reorderingRegion;
    private StackPane dragHeader;
    private final Label dragHeaderLabel = new Label();
    private Region filler;
    private Pane cornerRegion;
    final DoubleProperty cornerPadding = new SimpleDoubleProperty();
    private ContextMenu columnPopupMenu;
    boolean columnDragLock = false;
    private InvalidationListener tableWidthListener = observable -> this.updateTableWidth();
    private InvalidationListener tablePaddingListener = observable -> this.updateTableWidth();
    private ListChangeListener visibleLeafColumnsListener = listChangeListener$Change -> this.getRootHeader().setHeadersNeedUpdate();
    private final ListChangeListener tableColumnsListener = listChangeListener$Change -> {
        while (listChangeListener$Change.next()) {
            this.updateTableColumnListeners(listChangeListener$Change.getAddedSubList(), listChangeListener$Change.getRemoved());
        }
    };
    private final InvalidationListener columnTextListener = object -> {
        CheckMenuItem checkMenuItem = this.columnMenuItems.get(object = (TableColumnBase)((StringProperty)object).getBean());
        if (checkMenuItem != null) {
            checkMenuItem.setText(this.getText(((TableColumnBase)((Object)object)).getText(), (TableColumnBase)((Object)object)));
        }
    };
    private final ChangeListener<Boolean> cornerPaddingListener = (observableValue, bl2, bl3) -> this.updateCornerPadding();
    private final WeakInvalidationListener weakTableWidthListener = new WeakInvalidationListener(this.tableWidthListener);
    private final WeakInvalidationListener weakTablePaddingListener = new WeakInvalidationListener(this.tablePaddingListener);
    private final WeakListChangeListener weakVisibleLeafColumnsListener = new WeakListChangeListener(this.visibleLeafColumnsListener);
    private final WeakListChangeListener weakTableColumnsListener = new WeakListChangeListener(this.tableColumnsListener);
    private final WeakInvalidationListener weakColumnTextListener = new WeakInvalidationListener(this.columnTextListener);
    private final WeakChangeListener<Boolean> weakCornerPaddingListener = new WeakChangeListener<Boolean>(this.cornerPaddingListener);
    private BooleanProperty reordering;
    private ReadOnlyObjectWrapper<NestedTableColumnHeader> rootHeader;

    public TableHeaderRow(TableViewSkinBase object2) {
        TableHeaderRow tableHeaderRow = this;
        this.reordering = new TableHeaderRow$2(tableHeaderRow, tableHeaderRow, "reordering", false);
        this.rootHeader = new ReadOnlyObjectWrapper(this, "rootHeader");
        this.tableSkin = object2;
        this.flow = ((TableViewSkinBase)object2).flow;
        this.getStyleClass().setAll((String[])new String[]{"column-header-background"});
        this.clip = new Rectangle();
        this.clip.setSmooth(false);
        this.clip.heightProperty().bind(this.heightProperty());
        TableHeaderRow tableHeaderRow2 = this;
        tableHeaderRow2.setClip(tableHeaderRow2.clip);
        this.updateTableWidth();
        ((Region)((Object)this.tableSkin.getSkinnable())).widthProperty().addListener(this.weakTableWidthListener);
        ((Region)((Object)this.tableSkin.getSkinnable())).paddingProperty().addListener(this.weakTablePaddingListener);
        TableSkinUtils.getVisibleLeafColumns(object2).addListener(this.weakVisibleLeafColumnsListener);
        this.dragHeader = new StackPane();
        this.dragHeader.setVisible(false);
        this.dragHeader.getStyleClass().setAll((String[])new String[]{"column-drag-header"});
        this.dragHeader.setManaged(false);
        this.dragHeader.setMouseTransparent(true);
        this.dragHeader.getChildren().add(this.dragHeaderLabel);
        NestedTableColumnHeader nestedTableColumnHeader = this.createRootHeader();
        this.setRootHeader(nestedTableColumnHeader);
        nestedTableColumnHeader.setFocusTraversable(false);
        nestedTableColumnHeader.setTableHeaderRow(this);
        this.filler = new Region();
        this.filler.getStyleClass().setAll((String[])new String[]{"filler"});
        this.setOnMousePressed(arg_0 -> TableHeaderRow.lambda$new$6((TableViewSkinBase)object2, arg_0));
        StackPane stackPane = new StackPane();
        stackPane.setSnapToPixel(false);
        stackPane.getStyleClass().setAll((String[])new String[]{"show-hide-column-image"});
        this.cornerRegion = new TableHeaderRow$1(this, stackPane);
        this.cornerRegion.getStyleClass().setAll((String[])new String[]{"show-hide-columns-button"});
        this.cornerRegion.getChildren().addAll((Node[])new Node[]{stackPane});
        object2 = TableSkinUtils.tableMenuButtonVisibleProperty(object2);
        if (object2 != null) {
            this.cornerRegion.visibleProperty().bind(object2);
        }
        this.cornerRegion.setOnMousePressed(this::showColumnMenu);
        this.cornerRegion.visibleProperty().addListener(this.weakCornerPaddingListener);
        this.flow.getVbar().visibleProperty().addListener(this.weakCornerPaddingListener);
        this.getChildren().addAll((Node[])new Node[]{this.filler, nestedTableColumnHeader, this.cornerRegion, this.dragHeader});
    }

    public final void setReordering(boolean bl2) {
        this.reordering.set(bl2);
    }

    public final boolean isReordering() {
        return this.reordering.get();
    }

    public final BooleanProperty reorderingProperty() {
        return this.reordering;
    }

    private final ReadOnlyObjectProperty<NestedTableColumnHeader> rootHeaderProperty() {
        return this.rootHeader.getReadOnlyProperty();
    }

    public final NestedTableColumnHeader getRootHeader() {
        return (NestedTableColumnHeader)this.rootHeader.get();
    }

    private final void setRootHeader(NestedTableColumnHeader nestedTableColumnHeader) {
        this.rootHeader.set(nestedTableColumnHeader);
    }

    @Override
    protected void layoutChildren() {
        double d2 = this.scrollX;
        TableHeaderRow tableHeaderRow = this;
        double d3 = tableHeaderRow.snapSizeX(((Node)tableHeaderRow.getRootHeader()).prefWidth(-1.0));
        double d4 = this.getHeight() - this.snappedTopInset() - this.snappedBottomInset();
        TableHeaderRow tableHeaderRow2 = this;
        double d5 = tableHeaderRow2.snapSizeX(((Node)tableHeaderRow2.flow.getVbar()).prefWidth(-1.0));
        this.getRootHeader().resizeRelocate(d2, this.snappedTopInset(), d3, d4);
        Skinnable skinnable = this.tableSkin.getSkinnable();
        if (skinnable == null) {
            return;
        }
        BooleanProperty booleanProperty = TableSkinUtils.tableMenuButtonVisibleProperty(this.tableSkin);
        double d6 = ((Region)((Object)skinnable)).snappedLeftInset() + ((Region)((Object)skinnable)).snappedRightInset();
        double d7 = this.tableWidth - d3 + this.filler.getInsets().getLeft() - d6;
        this.filler.setVisible((d7 -= booleanProperty != null && booleanProperty.get() ? d5 : 0.0) > 0.0);
        if (d7 > 0.0) {
            this.filler.resizeRelocate(d2 + d3, this.snappedTopInset(), d7, d4);
        }
        this.cornerRegion.resizeRelocate(this.tableWidth - d5, this.snappedTopInset(), d5, d4);
        this.updateCornerPadding();
    }

    @Override
    protected double computePrefWidth(double d2) {
        return ((Node)this.getRootHeader()).prefWidth(d2);
    }

    @Override
    protected double computeMinHeight(double d2) {
        return this.computePrefHeight(d2);
    }

    @Override
    protected double computePrefHeight(double d2) {
        double d3 = ((Node)this.getRootHeader()).prefHeight(d2);
        d3 = d3 == 0.0 ? 24.0 : d3;
        return this.snappedTopInset() + d3 + this.snappedBottomInset();
    }

    protected void updateScrollX() {
        this.scrollX = this.flow.getHbar().isVisible() ? -this.flow.getHbar().getValue() : 0.0;
        ((Parent)this).requestLayout();
        this.layout();
    }

    protected void updateTableWidth() {
        Skinnable skinnable = this.tableSkin.getSkinnable();
        if (skinnable == null) {
            this.tableWidth = 0.0;
        } else {
            Insets insets = ((Region)((Object)skinnable)).getInsets() == null ? Insets.EMPTY : ((Region)((Object)skinnable)).getInsets();
            double d2 = this.snapSizeX(insets.getLeft()) + this.snapSizeX(insets.getRight());
            this.tableWidth = this.snapSizeX(((Region)((Object)skinnable)).getWidth()) - d2;
        }
        this.clip.setWidth(this.tableWidth);
    }

    protected NestedTableColumnHeader createRootHeader() {
        return new NestedTableColumnHeader(null);
    }

    protected void showColumnMenu(MouseEvent mouseEvent) {
        if (this.columnPopupMenu == null) {
            this.columnPopupMenu = new ContextMenu();
            this.columnMenuItems = new HashMap<TableColumnBase, CheckMenuItem>();
            TableSkinUtils.getVisibleLeafColumns(this.tableSkin).addListener(this.weakTableColumnsListener);
            TableSkinUtils.getColumns(this.tableSkin).addListener(this.weakTableColumnsListener);
            TableHeaderRow tableHeaderRow = this;
            tableHeaderRow.updateTableColumnListeners(TableSkinUtils.getColumns(tableHeaderRow.tableSkin), List.of());
        }
        this.columnPopupMenu.show(this.cornerRegion, Side.BOTTOM, 0.0, 0.0);
        mouseEvent.consume();
    }

    protected TableColumnHeader getReorderingRegion() {
        return this.reorderingRegion;
    }

    void setReorderingColumn(TableColumnBase tableColumnBase) {
        this.dragHeaderLabel.setText(tableColumnBase == null ? "" : tableColumnBase.getText());
    }

    protected void setReorderingRegion(TableColumnHeader tableColumnHeader) {
        this.reorderingRegion = tableColumnHeader;
        if (tableColumnHeader != null) {
            ((Node)this.dragHeader).resize(tableColumnHeader.getWidth(), this.dragHeader.getHeight());
        }
    }

    void setDragHeaderX(double d2) {
        this.dragHeader.setTranslateX(d2);
    }

    TableColumnHeader getColumnHeaderFor(TableColumnBase<?, ?> eventTarget) {
        if (eventTarget == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add((TableColumnBase<?, ?>)eventTarget);
        for (eventTarget = ((TableColumnBase)eventTarget).getParentColumn(); eventTarget != null; eventTarget = ((TableColumnBase)eventTarget).getParentColumn()) {
            arrayList.add(0, (TableColumnBase<?, ?>)eventTarget);
        }
        eventTarget = this.getRootHeader();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            TableColumnBase tableColumnBase = (TableColumnBase)arrayList.get(i2);
            eventTarget = this.getColumnHeaderFor(tableColumnBase, (TableColumnHeader)eventTarget);
        }
        return eventTarget;
    }

    private TableColumnHeader getColumnHeaderFor(TableColumnBase<?, ?> tableColumnBase, TableColumnHeader object) {
        if (object instanceof NestedTableColumnHeader) {
            object = ((NestedTableColumnHeader)object).getColumnHeaders();
            for (int i2 = 0; i2 < object.size(); ++i2) {
                TableColumnHeader tableColumnHeader = (TableColumnHeader)object.get(i2);
                if (tableColumnHeader.getTableColumn() != tableColumnBase) continue;
                return tableColumnHeader;
            }
        }
        return null;
    }

    private void updateTableColumnListeners(List<? extends TableColumnBase<?, ?>> object, List<? extends TableColumnBase<?, ?>> object2) {
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (TableColumnBase)object.next();
            this.remove((TableColumnBase<?, ?>)object2);
        }
        this.rebuildColumnMenu();
    }

    private void remove(TableColumnBase<?, ?> object) {
        if (object == null) {
            return;
        }
        CheckMenuItem eventTarget2 = this.columnMenuItems.remove(object);
        if (eventTarget2 != null) {
            ((TableColumnBase)((Object)object)).textProperty().removeListener(this.weakColumnTextListener);
            eventTarget2.selectedProperty().unbindBidirectional(((TableColumnBase)((Object)object)).visibleProperty());
            this.columnPopupMenu.getItems().remove(eventTarget2);
        }
        if (!((TableColumnBase)((Object)object)).getColumns().isEmpty()) {
            for (TableColumnBase tableColumnBase : ((TableColumnBase)((Object)object)).getColumns()) {
                this.remove(tableColumnBase);
            }
        }
    }

    private void rebuildColumnMenu() {
        this.columnPopupMenu.getItems().clear();
        for (TableColumnBase tableColumnBase : TableSkinUtils.getColumns(this.tableSkin)) {
            if (tableColumnBase.getColumns().isEmpty()) {
                this.createMenuItem(tableColumnBase);
                continue;
            }
            List<TableColumnBase<?, ?>> list = this.getLeafColumns(tableColumnBase);
            for (TableColumnBase<?, ?> tableColumnBase2 : list) {
                this.createMenuItem(tableColumnBase2);
            }
        }
    }

    private List<TableColumnBase<?, ?>> getLeafColumns(TableColumnBase<?, ?> object) {
        ArrayList arrayList = new ArrayList();
        for (TableColumnBase tableColumnBase : ((TableColumnBase)((Object)object)).getColumns()) {
            if (tableColumnBase.getColumns().isEmpty()) {
                arrayList.add(tableColumnBase);
                continue;
            }
            arrayList.addAll(this.getLeafColumns(tableColumnBase));
        }
        return arrayList;
    }

    private void createMenuItem(TableColumnBase<?, ?> tableColumnBase) {
        CheckMenuItem checkMenuItem = this.columnMenuItems.get(tableColumnBase);
        if (checkMenuItem == null) {
            checkMenuItem = new CheckMenuItem();
            this.columnMenuItems.put(tableColumnBase, checkMenuItem);
        }
        checkMenuItem.setText(this.getText(tableColumnBase.getText(), tableColumnBase));
        tableColumnBase.textProperty().addListener(this.weakColumnTextListener);
        checkMenuItem.setDisable(tableColumnBase.visibleProperty().isBound());
        checkMenuItem.setSelected(tableColumnBase.isVisible());
        CheckMenuItem checkMenuItem2 = checkMenuItem;
        checkMenuItem.selectedProperty().addListener(observable -> {
            if (tableColumnBase.visibleProperty().isBound()) {
                return;
            }
            tableColumnBase.setVisible(checkMenuItem2.isSelected());
        });
        tableColumnBase.visibleProperty().addListener(observable -> checkMenuItem2.setSelected(tableColumnBase.isVisible()));
        this.columnPopupMenu.getItems().add(checkMenuItem);
    }

    private String getText(String object, TableColumnBase tableColumnBase) {
        for (tableColumnBase = tableColumnBase.getParentColumn(); tableColumnBase != null; tableColumnBase = tableColumnBase.getParentColumn()) {
            if (!this.isColumnVisibleInHeader(tableColumnBase, TableSkinUtils.getColumns(this.tableSkin))) continue;
            object = tableColumnBase.getText() + this.MENU_SEPARATOR + (String)object;
        }
        return object;
    }

    private boolean isColumnVisibleInHeader(TableColumnBase tableColumnBase, List list) {
        if (tableColumnBase == null) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            boolean bl2;
            TableColumnBase tableColumnBase2 = (TableColumnBase)list.get(i2);
            if (tableColumnBase.equals(tableColumnBase2)) {
                return true;
            }
            if (tableColumnBase2.getColumns().isEmpty() || !(bl2 = this.isColumnVisibleInHeader(tableColumnBase, tableColumnBase2.getColumns()))) continue;
            return true;
        }
        return false;
    }

    private void updateCornerPadding() {
        double d2 = 0.0;
        if (this.cornerRegion.isVisible() && !this.flow.getVbar().isVisible()) {
            double d3 = this.cornerRegion.getLayoutX();
            d2 = this.getRootHeader().getColumnHeaders().stream().filter(tableColumnHeader -> tableColumnHeader.isLastVisibleColumn).findFirst().map(object -> {
                Bounds bounds;
                TableColumnHeader tableColumnHeader = object;
                object = tableColumnHeader.localToScene(tableColumnHeader.getBoundsInLocal());
                return bounds.getMinX() <= d3 && d3 < ((Bounds)object).getMaxX() ? this.cornerRegion.getWidth() : 0.0;
            }).orElse(0.0);
        }
        this.cornerPadding.set(d2);
    }

    Pane getCornerRegion() {
        return this.cornerRegion;
    }

    ContextMenu getColumnPopupMenu() {
        return this.columnPopupMenu;
    }

    private static /* synthetic */ void lambda$new$6(TableViewSkinBase tableViewSkinBase, MouseEvent mouseEvent) {
        ((Node)((Object)tableViewSkinBase.getSkinnable())).requestFocus();
    }
}

