/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.security.AccessController;
import java.util.Iterator;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.FocusModel;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.Skinnable;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableView;
import javafx.scene.control.skin.TableColumnHeader;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TableSkinUtils;
import javafx.scene.control.skin.TableViewSkinBase$1;
import javafx.scene.control.skin.TableViewSkinBase$2;
import javafx.scene.control.skin.VirtualContainerBase;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public abstract class TableViewSkinBase<M, S, C extends Control, I extends IndexedCell<M>, TC extends TableColumnBase<S, ?>>
extends VirtualContainerBase<C, I> {
    private static final double GOLDEN_RATIO_MULTIPLIER = 0.618033987;
    private static final boolean IS_PANNABLE = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.scene.control.skin.TableViewSkin.pannable"));
    private final String EMPTY_TABLE_TEXT = ControlResources.getString("TableView.noContent");
    private final String NO_COLUMNS_TEXT = ControlResources.getString("TableView.noColumns");
    VirtualFlow<I> flow;
    private boolean contentWidthDirty = true;
    private Region columnReorderLine;
    private Region columnReorderOverlay;
    private TableHeaderRow tableHeaderRow;
    private Callback<C, I> rowFactory;
    private StackPane placeholderRegion;
    private Label placeholderLabel;
    private int visibleColCount;
    boolean needCellsRecreated = true;
    boolean needCellsReconfigured = false;
    private int itemCount = -1;
    private ListChangeListener<S> rowCountListener = listChangeListener$Change -> {
        while (listChangeListener$Change.next()) {
            if (listChangeListener$Change.wasReplaced()) {
                this.itemCount = 0;
                break;
            }
            if (listChangeListener$Change.getRemovedSize() != this.itemCount) continue;
            this.itemCount = 0;
            break;
        }
        if (this.getSkinnable() instanceof TableView) {
            ((TableView)this.getSkinnable()).edit(-1, null);
        }
        this.markItemCountDirty();
        ((Parent)((Object)this.getSkinnable())).requestLayout();
    };
    private InvalidationListener widthListener = observable -> {
        this.needCellsReconfigured = true;
        if (this.getSkinnable() != null) {
            ((Parent)((Object)this.getSkinnable())).requestLayout();
        }
    };
    private WeakListChangeListener<S> weakRowCountListener = new WeakListChangeListener<S>(this.rowCountListener);
    private WeakInvalidationListener weakWidthListener = new WeakInvalidationListener(this.widthListener);

    public TableViewSkinBase(C object) {
        super(object);
        this.flow = this.getVirtualFlow();
        this.flow.setPannable(IS_PANNABLE);
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        listenerHelper.addInvalidationListener(this.flow.getHbar().valueProperty(), observable -> this.horizontalScroll());
        this.flow.getHbar().setUnitIncrement(15.0);
        this.flow.getHbar().setBlockIncrement(80.0);
        this.columnReorderLine = new Region();
        this.columnReorderLine.getStyleClass().setAll((String[])new String[]{"column-resize-line"});
        this.columnReorderLine.setManaged(false);
        this.columnReorderLine.setVisible(false);
        this.columnReorderOverlay = new Region();
        this.columnReorderOverlay.getStyleClass().setAll((String[])new String[]{"column-overlay"});
        this.columnReorderOverlay.setVisible(false);
        this.columnReorderOverlay.setManaged(false);
        this.tableHeaderRow = this.createTableHeaderRow();
        this.tableHeaderRow.setFocusTraversable(false);
        this.getChildren().addAll((Node[])new Node[]{this.tableHeaderRow, this.flow, this.columnReorderOverlay, this.columnReorderLine});
        this.updateVisibleColumnCount();
        TableViewSkinBase tableViewSkinBase = this;
        tableViewSkinBase.updateVisibleLeafColumnWidthListeners(tableViewSkinBase.getVisibleLeafColumns(), FXCollections.emptyObservableList());
        listenerHelper.addInvalidationListener(this.tableHeaderRow.reorderingProperty(), observable -> ((Parent)((Object)this.getSkinnable())).requestLayout());
        listenerHelper.addListChangeListener(this.getVisibleLeafColumns(), listChangeListener$Change -> {
            this.updateVisibleColumnCount();
            while (listChangeListener$Change.next()) {
                this.updateVisibleLeafColumnWidthListeners(listChangeListener$Change.getAddedSubList(), listChangeListener$Change.getRemoved());
            }
        });
        Observable observable2 = TableSkinUtils.itemsProperty(this);
        this.updateTableItems(null, (ObservableList)observable2.get());
        listenerHelper.addInvalidationListener(observable2, new TableViewSkinBase$1(this, observable2));
        observable2 = ((Node)object).getProperties();
        observable2.remove("refreshKey");
        observable2.remove("recreateKey");
        listenerHelper.addMapChangeListener(observable2, mapChangeListener$Change -> {
            if (!mapChangeListener$Change.wasAdded()) {
                return;
            }
            if ("refreshKey".equals(mapChangeListener$Change.getKey())) {
                this.refreshView();
                ((Node)((Object)this.getSkinnable())).getProperties().remove("refreshKey");
                return;
            }
            if ("recreateKey".equals(mapChangeListener$Change.getKey())) {
                this.needCellsRecreated = true;
                this.refreshView();
                ((Node)((Object)this.getSkinnable())).getProperties().remove("recreateKey");
            }
        });
        listenerHelper.addEventHandler(object, ScrollToEvent.scrollToColumn(), scrollToEvent -> this.scrollHorizontally((TableColumnBase)scrollToEvent.getScrollTarget()));
        listenerHelper.addInvalidationListener(() -> {
            this.contentWidthDirty = true;
            ((Parent)((Object)this.getSkinnable())).requestLayout();
        }, this.flow.widthProperty(), this.flow.getVbar().widthProperty());
        object = TableSkinUtils.rowFactoryProperty(this);
        listenerHelper.addChangeListener(object, callback -> {
            callback = this.rowFactory;
            this.rowFactory = (Callback)object.get();
            if (callback != this.rowFactory) {
                this.requestRebuildCells();
            }
        });
        listenerHelper.addChangeListener(TableSkinUtils.placeholderProperty(this), node -> this.updatePlaceholderRegionVisibility());
        listenerHelper.addChangeListener(this.flow.getVbar().visibleProperty(), bl2 -> this.updateContentWidth());
        listenerHelper.addChangeListener(TableSkinUtils.columnResizePolicyProperty(this), callback -> this.updateSuppressBreadthBar());
        this.updateSuppressBreadthBar();
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        if (this.placeholderRegion != null) {
            this.getChildren().remove(this.placeholderRegion);
        }
        this.getChildren().removeAll((Node[])new Node[]{this.tableHeaderRow, this.flow, this.columnReorderOverlay, this.columnReorderLine});
        ObjectProperty objectProperty = TableSkinUtils.itemsProperty(this);
        this.updateTableItems((ObservableList)objectProperty.get(), null);
        super.dispose();
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return 400.0;
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = this.computePrefHeight(-1.0, d3, d4, d5, d6);
        ObservableList<TC> observableList = this.getVisibleLeafColumns();
        if (observableList == null || observableList.isEmpty()) {
            return d7 * 0.618033987;
        }
        double d8 = d6 + d4;
        int n2 = observableList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TableColumnBase tableColumnBase = (TableColumnBase)observableList.get(i2);
            d8 += Math.max(tableColumnBase.getPrefWidth(), tableColumnBase.getMinWidth());
        }
        return Math.max(d8, d7 * 0.618033987);
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        Skinnable skinnable = this.getSkinnable();
        if (skinnable == null) {
            return;
        }
        super.layoutChildren(d2, d3, d4, d5);
        if (this.needCellsRecreated) {
            this.flow.recreateCells();
        } else if (this.needCellsReconfigured) {
            this.flow.reconfigureCells();
        }
        this.needCellsRecreated = false;
        this.needCellsReconfigured = false;
        double d6 = ((Node)((Object)skinnable)).getLayoutBounds().getHeight() / 2.0;
        double d7 = ((Node)this.tableHeaderRow).prefHeight(-1.0);
        TableViewSkinBase tableViewSkinBase = this;
        tableViewSkinBase.layoutInArea(tableViewSkinBase.tableHeaderRow, d2, d3, d4, d7, d6, HPos.CENTER, VPos.CENTER);
        d3 += d7;
        double d8 = Math.floor(d5 - d7);
        if (this.getItemCount() == 0 || this.visibleColCount == 0) {
            TableViewSkinBase tableViewSkinBase2 = this;
            tableViewSkinBase2.layoutInArea(tableViewSkinBase2.placeholderRegion, d2, d3, d4, d8, d6, HPos.CENTER, VPos.CENTER);
        } else {
            TableViewSkinBase tableViewSkinBase3 = this;
            tableViewSkinBase3.layoutInArea(tableViewSkinBase3.flow, d2, d3, d4, d8, d6, HPos.CENTER, VPos.CENTER);
        }
        if (this.tableHeaderRow.getReorderingRegion() != null) {
            TableColumnHeader tableColumnHeader = this.tableHeaderRow.getReorderingRegion();
            TableColumnBase<?, ?> tableColumnBase = tableColumnHeader.getTableColumn();
            if (tableColumnBase != null) {
                TableColumnHeader tableColumnHeader2;
                TableColumnHeader tableColumnHeader3 = tableColumnHeader2 = this.tableHeaderRow.getReorderingRegion();
                double d9 = this.tableHeaderRow.sceneToLocal(tableColumnHeader3.localToScene(tableColumnHeader3.getBoundsInLocal())).getMinX();
                double d10 = tableColumnHeader.getWidth();
                if (d9 < 0.0) {
                    d10 += d9;
                }
                double d11 = d9 = d9 < 0.0 ? 0.0 : d9;
                if (d11 + d10 > d4) {
                    d10 = d4 - d9;
                    if (this.flow.getVbar().isVisible()) {
                        d10 -= this.flow.getVbar().getWidth() - 1.0;
                    }
                }
                double d12 = d8;
                if (this.flow.getHbar().isVisible()) {
                    d12 -= this.flow.getHbar().getHeight();
                }
                ((Node)this.columnReorderOverlay).resize(d10, d12);
                this.columnReorderOverlay.setLayoutX(d9);
                this.columnReorderOverlay.setLayoutY(this.tableHeaderRow.getHeight());
            }
            double d13 = this.columnReorderLine.snappedLeftInset() + this.columnReorderLine.snappedRightInset();
            double d14 = d5 - (this.flow.getHbar().isVisible() ? this.flow.getHbar().getHeight() - 1.0 : 0.0);
            this.columnReorderLine.resizeRelocate(0.0, this.columnReorderLine.snappedTopInset(), d13, d14);
        }
        this.columnReorderLine.setVisible(this.tableHeaderRow.isReordering());
        this.columnReorderOverlay.setVisible(this.tableHeaderRow.isReordering());
        this.checkContentWidthState();
    }

    protected TableHeaderRow createTableHeaderRow() {
        return new TableHeaderRow(this);
    }

    protected TableHeaderRow getTableHeaderRow() {
        return this.tableHeaderRow;
    }

    private TableSelectionModel<S> getSelectionModel() {
        return TableSkinUtils.getSelectionModel(this);
    }

    private TableFocusModel<M, ?> getFocusModel() {
        return TableSkinUtils.getFocusModel(this);
    }

    private TablePositionBase<? extends TC> getFocusedCell() {
        return TableSkinUtils.getFocusedCell(this);
    }

    private ObservableList<? extends TC> getVisibleLeafColumns() {
        return TableSkinUtils.getVisibleLeafColumns(this);
    }

    @Override
    protected void updateItemCount() {
        int n2;
        this.updatePlaceholderRegionVisibility();
        int n3 = this.itemCount;
        this.itemCount = n2 = this.getItemCount();
        if (this.itemCount == 0) {
            this.flow.getHbar().setValue(0.0);
        }
        this.flow.setCellCount(n2);
        if (n2 == n3) {
            this.needCellsReconfigured = true;
            return;
        }
        if (n3 == 0) {
            this.requestRebuildCells();
        }
    }

    private void checkContentWidthState() {
        if (this.contentWidthDirty || this.getItemCount() == 0) {
            this.updateContentWidth();
            this.contentWidthDirty = false;
        }
    }

    void horizontalScroll() {
        this.tableHeaderRow.updateScrollX();
    }

    protected void onFocusAboveCell() {
        TableFocusModel<M, ?> tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        this.flow.scrollTo(tableFocusModel.getFocusedIndex());
    }

    protected void onFocusBelowCell() {
        TableFocusModel<M, ?> tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        this.flow.scrollTo(tableFocusModel.getFocusedIndex());
    }

    protected void onSelectAboveCell() {
        TableSelectionModel<S> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        this.flow.scrollTo(tableSelectionModel.getSelectedIndex());
    }

    protected void onSelectBelowCell() {
        TableSelectionModel<S> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        this.flow.scrollTo(tableSelectionModel.getSelectedIndex());
    }

    protected void onSelectLeftCell() {
        this.scrollHorizontally();
    }

    protected void onSelectRightCell() {
        this.scrollHorizontally();
    }

    protected void onFocusLeftCell() {
        this.scrollHorizontally();
    }

    protected void onFocusRightCell() {
        this.scrollHorizontally();
    }

    protected void onMoveToFirstCell() {
        this.flow.scrollTo(0);
        this.flow.setPosition(0.0);
    }

    protected void onMoveToLastCell() {
        int n2 = this.getItemCount();
        this.flow.scrollTo(n2);
        this.flow.setPosition(1.0);
    }

    private void updateTableItems(ObservableList<S> observableList, ObservableList<S> observableList2) {
        if (observableList != null) {
            observableList.removeListener(this.weakRowCountListener);
        }
        if (observableList2 != null) {
            observableList2.addListener(this.weakRowCountListener);
        }
        this.markItemCountDirty();
        ((Parent)((Object)this.getSkinnable())).requestLayout();
    }

    Region getColumnReorderLine() {
        return this.columnReorderLine;
    }

    protected int onScrollPageDown(boolean bl2) {
        int n2;
        boolean bl3;
        TableSelectionModel<S> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return -1;
        }
        int n3 = this.getItemCount();
        I i2 = this.flow.getLastVisibleCellWithinViewport();
        if (i2 == null) {
            return -1;
        }
        int n4 = ((IndexedCell)i2).getIndex();
        int n5 = n4 = n4 >= n3 ? n3 - 1 : n4;
        if (bl2) {
            bl3 = ((Node)i2).isFocused() || this.isCellFocused(n4);
        } else {
            boolean bl4 = bl3 = ((Cell)i2).isSelected() || this.isCellSelected(n4);
        }
        if (bl3 && (bl2 = this.isLeadIndex(bl2, n4))) {
            this.flow.scrollToTop(i2);
            I i3 = this.flow.getLastVisibleCellWithinViewport();
            i2 = i3 == null ? i2 : i3;
        }
        n2 = (n2 = ((IndexedCell)i2).getIndex()) >= n3 ? n3 - 1 : n2;
        this.flow.scrollTo(n2);
        return n2;
    }

    protected int onScrollPageUp(boolean bl2) {
        boolean bl3;
        I i2 = this.flow.getFirstVisibleCellWithinViewport();
        if (i2 == null) {
            return -1;
        }
        int n2 = ((IndexedCell)i2).getIndex();
        if (bl2) {
            bl3 = ((Node)i2).isFocused() || this.isCellFocused(n2);
        } else {
            boolean bl4 = bl3 = ((Cell)i2).isSelected() || this.isCellSelected(n2);
        }
        if (bl3 && (bl2 = this.isLeadIndex(bl2, n2))) {
            this.flow.scrollToBottom(i2);
            I i3 = this.flow.getFirstVisibleCellWithinViewport();
            i2 = i3 == null ? i2 : i3;
        }
        int n3 = ((IndexedCell)i2).getIndex();
        this.flow.scrollTo(n3);
        return n3;
    }

    private boolean isLeadIndex(boolean bl2, int n2) {
        TableSelectionModel<S> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return false;
        }
        TableFocusModel<M, ?> tableFocusModel = this.getFocusModel();
        return bl2 && tableFocusModel.getFocusedIndex() == n2 || !bl2 && tableSelectionModel.getSelectedIndex() == n2;
    }

    private void updateVisibleColumnCount() {
        this.visibleColCount = this.getVisibleLeafColumns().size();
        this.updatePlaceholderRegionVisibility();
        this.requestRebuildCells();
    }

    private void updateVisibleLeafColumnWidthListeners(List<? extends TC> list, List<? extends TC> list2) {
        TableColumnBase tableColumnBase;
        int n2;
        int n3 = list2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            tableColumnBase = (TableColumnBase)list2.get(n2);
            tableColumnBase.widthProperty().removeListener(this.weakWidthListener);
        }
        n3 = list.size();
        for (n2 = 0; n2 < n3; ++n2) {
            tableColumnBase = (TableColumnBase)list.get(n2);
            tableColumnBase.widthProperty().addListener(this.weakWidthListener);
        }
        this.requestRebuildCells();
    }

    final void updatePlaceholderRegionVisibility() {
        boolean bl2 = this.visibleColCount == 0 || this.getItemCount() == 0;
        if (bl2) {
            Object object;
            if (this.placeholderRegion == null) {
                this.placeholderRegion = new StackPane();
                this.placeholderRegion.getStyleClass().setAll((String[])new String[]{"placeholder"});
                this.getChildren().add(this.placeholderRegion);
            }
            if ((object = (Node)TableSkinUtils.placeholderProperty(this).get()) == null) {
                if (this.placeholderLabel == null) {
                    this.placeholderLabel = new Label();
                }
                object = this.visibleColCount == 0 ? this.NO_COLUMNS_TEXT : this.EMPTY_TABLE_TEXT;
                this.placeholderLabel.setText((String)object);
                this.placeholderRegion.getChildren().setAll((Node[])new Node[]{this.placeholderLabel});
            } else {
                this.placeholderRegion.getChildren().setAll((Node[])new Node[]{object});
            }
        }
        this.flow.setVisible(!bl2);
        if (this.placeholderRegion != null) {
            this.placeholderRegion.setVisible(bl2);
        }
    }

    private void updateContentWidth() {
        double d2 = this.flow.getWidth();
        if (this.flow.getVbar().isVisible()) {
            d2 -= this.flow.getVbar().getWidth();
        }
        if (d2 <= 0.0 || TableSkinUtils.getItemCount(this) == 0) {
            Skinnable skinnable = this.getSkinnable();
            d2 = ((Region)((Object)skinnable)).getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
        }
        d2 = Math.max(0.0, d2);
        ((Node)((Object)this.getSkinnable())).getProperties().put("TableView.contentWidth", Math.floor(d2));
    }

    void updateSuppressBreadthBar() {
        Callback callback = (Callback)TableSkinUtils.columnResizePolicyProperty(this).get();
        boolean bl2 = TableSkinUtils.isConstrainedResizePolicy(callback);
        this.flow.setSuppressBreadthBar(bl2);
    }

    private void refreshView() {
        this.markItemCountDirty();
        Skinnable skinnable = this.getSkinnable();
        if (skinnable != null) {
            ((Parent)((Object)skinnable)).requestLayout();
        }
    }

    public void scrollHorizontally() {
        TableFocusModel<Object, Object> tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        tableFocusModel = this.getFocusedCell().getTableColumn();
        this.scrollHorizontally(tableFocusModel);
    }

    protected void scrollHorizontally(TC TC) {
        double d2;
        TableColumnBase tableColumnBase;
        if (TC == null || !((TableColumnBase)TC).isVisible()) {
            return;
        }
        Skinnable skinnable = this.getSkinnable();
        TableColumnHeader tableColumnHeader = this.tableHeaderRow.getColumnHeaderFor((TableColumnBase<?, ?>)TC);
        if (tableColumnHeader == null || tableColumnHeader.getWidth() <= 0.0) {
            Platform.runLater(() -> this.scrollHorizontally(TC));
            return;
        }
        double d3 = 0.0;
        Iterator iterator = this.getVisibleLeafColumns().iterator();
        while (iterator.hasNext() && !(tableColumnBase = (TableColumnBase)iterator.next()).equals(TC)) {
            d3 += tableColumnBase.getWidth();
        }
        double d4 = d3 + ((TableColumnBase)TC).getWidth();
        double d5 = ((Region)((Object)skinnable)).getWidth() - this.snappedLeftInset() - this.snappedRightInset();
        double d6 = this.flow.getHbar().getValue();
        double d7 = this.flow.getHbar().getMax();
        if (d3 < d6 && d3 >= 0.0) {
            d2 = d3;
        } else {
            double d8 = d3 < 0.0 || d4 > d5 ? d3 - d6 : 0.0;
            d2 = d6 + d8 > d7 ? d7 : d6 + d8;
        }
        double d9 = d2;
        this.flow.getHbar().setValue(d9);
    }

    private boolean isCellSelected(int n2) {
        TableSelectionModel<S> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return false;
        }
        if (!tableSelectionModel.isCellSelectionEnabled()) {
            return false;
        }
        int n3 = this.getVisibleLeafColumns().size();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!tableSelectionModel.isSelected(n2, (TableColumnBase<S, ?>)TableSkinUtils.getVisibleLeafColumn(this, i2))) continue;
            return true;
        }
        return false;
    }

    private boolean isCellFocused(int n2) {
        TableFocusModel<M, ?> tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return false;
        }
        int n3 = this.getVisibleLeafColumns().size();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!tableFocusModel.isFocused(n2, TableSkinUtils.getVisibleLeafColumn(this, i2))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute object, Object ... objectArray) {
        switch (TableViewSkinBase$2.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                object = this.getFocusModel();
                if (object == null) {
                    return null;
                }
                int n2 = ((FocusModel)object).getFocusedIndex();
                if (n2 == -1) {
                    if (this.placeholderRegion != null && this.placeholderRegion.isVisible()) {
                        return this.placeholderRegion.getChildren().get(0);
                    }
                    if (this.getItemCount() > 0) {
                        n2 = 0;
                    } else {
                        return null;
                    }
                }
                return this.flow.getPrivateCell(n2);
            }
            case 2: {
                int n3 = (Integer)objectArray[0];
                return this.flow.getPrivateCell(n3);
            }
            case 3: {
                int n4 = (Integer)objectArray[0];
                Object TC = TableSkinUtils.getVisibleLeafColumn(this, n4);
                return this.getTableHeaderRow().getColumnHeaderFor((TableColumnBase<?, ?>)TC);
            }
            case 4: {
                return this.getTableHeaderRow();
            }
            case 5: {
                return this.flow.getVbar();
            }
            case 6: {
                return this.flow.getHbar();
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray);
    }
}

