/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.Properties;
import com.sun.javafx.scene.control.behavior.TextInputControlBehavior;
import com.sun.javafx.scene.control.skin.FXVK;
import com.sun.javafx.tk.FontMetrics;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.Animation$Status;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.AccessibleAction;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.skin.TextInputControlSkin$1;
import javafx.scene.control.skin.TextInputControlSkin$10;
import javafx.scene.control.skin.TextInputControlSkin$11;
import javafx.scene.control.skin.TextInputControlSkin$12;
import javafx.scene.control.skin.TextInputControlSkin$2;
import javafx.scene.control.skin.TextInputControlSkin$3;
import javafx.scene.control.skin.TextInputControlSkin$4;
import javafx.scene.control.skin.TextInputControlSkin$5;
import javafx.scene.control.skin.TextInputControlSkin$6;
import javafx.scene.control.skin.TextInputControlSkin$7;
import javafx.scene.control.skin.TextInputControlSkin$8;
import javafx.scene.control.skin.TextInputControlSkin$9;
import javafx.scene.control.skin.TextInputControlSkin$CaretBlinking;
import javafx.scene.control.skin.TextInputControlSkin$Direction;
import javafx.scene.control.skin.TextInputControlSkin$StyleableProperties;
import javafx.scene.control.skin.TextInputControlSkin$TextUnit;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Shape;
import javafx.scene.shape.VLineTo;

public abstract class TextInputControlSkin<T extends TextInputControl>
extends SkinBase<T> {
    static boolean preload = false;
    static final boolean SHOW_HANDLES;
    private static final boolean IS_FXVK_SUPPORTED;
    final ObservableObjectValue<FontMetrics> fontMetrics;
    private ObservableBooleanValue caretVisible;
    private TextInputControlSkin$CaretBlinking caretBlinking = new TextInputControlSkin$CaretBlinking(this.blinkProperty());
    final Path caretPath = new Path();
    StackPane caretHandle = null;
    StackPane selectionHandle1 = null;
    StackPane selectionHandle2 = null;
    private int imstart;
    private int imlength;
    private List<Shape> imattrs = new ArrayList<Shape>();
    private final EventHandler<InputMethodEvent> inputMethodTextChangedHandler = this::handleInputMethodEvent;
    private InputMethodRequests inputMethodRequests;
    private BooleanProperty blink;
    private final ObjectProperty<Paint> textFill = new TextInputControlSkin$7(this, Color.BLACK);
    private final ObjectProperty<Paint> promptTextFill = new TextInputControlSkin$8(this, Color.GRAY);
    private final ObjectProperty<Paint> highlightFill = new TextInputControlSkin$9(this, Color.DODGERBLUE);
    private final ObjectProperty<Paint> highlightTextFill = new TextInputControlSkin$10(this, Color.WHITE);
    private final BooleanProperty displayCaret = new TextInputControlSkin$11(this, true);
    private BooleanProperty forwardBias = new SimpleBooleanProperty(this, "forwardBias", true);

    public TextInputControlSkin(T t2) {
        super(t2);
        this.fontMetrics = new TextInputControlSkin$1(this, (TextInputControl)t2);
        this.caretVisible = new TextInputControlSkin$2(this, (TextInputControl)t2);
        if (SHOW_HANDLES) {
            this.caretHandle = new StackPane();
            this.selectionHandle1 = new StackPane();
            this.selectionHandle2 = new StackPane();
            this.caretHandle.setManaged(false);
            this.selectionHandle1.setManaged(false);
            this.selectionHandle2.setManaged(false);
            if (PlatformUtil.isIOS()) {
                this.caretHandle.setVisible(false);
            } else {
                this.caretHandle.visibleProperty().bind(new TextInputControlSkin$3(this, (TextInputControl)t2));
            }
            this.selectionHandle1.visibleProperty().bind(new TextInputControlSkin$4(this, (TextInputControl)t2));
            this.selectionHandle2.visibleProperty().bind(new TextInputControlSkin$5(this, (TextInputControl)t2));
            this.caretHandle.getStyleClass().setAll((String[])new String[]{"caret-handle"});
            this.selectionHandle1.getStyleClass().setAll((String[])new String[]{"selection-handle"});
            this.selectionHandle2.getStyleClass().setAll((String[])new String[]{"selection-handle"});
            this.selectionHandle1.setId("selection-handle-1");
            this.selectionHandle2.setId("selection-handle-2");
        }
        if (IS_FXVK_SUPPORTED) {
            EventTarget eventTarget;
            if (preload && (eventTarget = ((Node)t2).getScene()) != null && (eventTarget = eventTarget.getWindow()) != null) {
                FXVK.init(t2);
            }
            this.registerInvalidationListener(((Node)t2).focusedProperty(), object -> {
                if (FXVK.useFXVK()) {
                    object = ((TextInputControl)this.getSkinnable()).getScene();
                    if (t2.isEditable() && t2.isFocused()) {
                        FXVK.attach(t2);
                        return;
                    }
                    if (!(object != null && ((Scene)object).getWindow() != null && ((Scene)object).getWindow().isFocused() && ((Scene)object).getFocusOwner() instanceof TextInputControl && ((TextInputControl)((Scene)object).getFocusOwner()).isEditable())) {
                        FXVK.detach();
                    }
                }
            });
        }
    }

    @Override
    public void install() {
        super.install();
        TextInputControl textInputControl = (TextInputControl)this.getSkinnable();
        if (textInputControl.getOnInputMethodTextChanged() == null) {
            textInputControl.setOnInputMethodTextChanged(this.inputMethodTextChangedHandler);
        }
        if (textInputControl.getInputMethodRequests() == null) {
            this.inputMethodRequests = new TextInputControlSkin$6(this, textInputControl);
            textInputControl.setInputMethodRequests(this.inputMethodRequests);
        }
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        if (((TextInputControl)this.getSkinnable()).getInputMethodRequests() == this.inputMethodRequests) {
            ((TextInputControl)this.getSkinnable()).setInputMethodRequests(null);
        }
        if (((TextInputControl)this.getSkinnable()).getOnInputMethodTextChanged() == this.inputMethodTextChangedHandler) {
            ((TextInputControl)this.getSkinnable()).setOnInputMethodTextChanged(null);
        }
        super.dispose();
    }

    private final void setBlink(boolean bl2) {
        this.blinkProperty().set(bl2);
    }

    private final boolean isBlink() {
        return this.blinkProperty().get();
    }

    private final BooleanProperty blinkProperty() {
        if (this.blink == null) {
            this.blink = new SimpleBooleanProperty(this, "blink", true);
        }
        return this.blink;
    }

    protected final void setTextFill(Paint paint) {
        this.textFill.set(paint);
    }

    protected final Paint getTextFill() {
        return (Paint)this.textFill.get();
    }

    protected final ObjectProperty<Paint> textFillProperty() {
        return this.textFill;
    }

    protected final void setPromptTextFill(Paint paint) {
        this.promptTextFill.set(paint);
    }

    protected final Paint getPromptTextFill() {
        return (Paint)this.promptTextFill.get();
    }

    protected final ObjectProperty<Paint> promptTextFillProperty() {
        return this.promptTextFill;
    }

    protected final void setHighlightFill(Paint paint) {
        this.highlightFill.set(paint);
    }

    protected final Paint getHighlightFill() {
        return (Paint)this.highlightFill.get();
    }

    protected final ObjectProperty<Paint> highlightFillProperty() {
        return this.highlightFill;
    }

    protected final void setHighlightTextFill(Paint paint) {
        this.highlightTextFill.set(paint);
    }

    protected final Paint getHighlightTextFill() {
        return (Paint)this.highlightTextFill.get();
    }

    protected final ObjectProperty<Paint> highlightTextFillProperty() {
        return this.highlightTextFill;
    }

    private final void setDisplayCaret(boolean bl2) {
        this.displayCaret.set(bl2);
    }

    private final boolean isDisplayCaret() {
        return this.displayCaret.get();
    }

    private final BooleanProperty displayCaretProperty() {
        return this.displayCaret;
    }

    protected final BooleanProperty forwardBiasProperty() {
        return this.forwardBias;
    }

    public final void setForwardBias(boolean bl2) {
        this.forwardBias.set(bl2);
    }

    protected final boolean isForwardBias() {
        return this.forwardBias.get();
    }

    protected abstract PathElement[] getUnderlineShape(int var1, int var2);

    protected abstract PathElement[] getRangeShape(int var1, int var2);

    protected abstract void addHighlight(List<? extends Node> var1, int var2);

    protected abstract void removeHighlight(List<? extends Node> var1);

    public abstract void moveCaret(TextInputControlSkin$TextUnit var1, TextInputControlSkin$Direction var2, boolean var3);

    public Point2D getMenuPosition() {
        if (SHOW_HANDLES) {
            if (this.caretHandle.isVisible()) {
                return new Point2D(this.caretHandle.getLayoutX() + this.caretHandle.getWidth() / 2.0, this.caretHandle.getLayoutY());
            }
            if (this.selectionHandle1.isVisible() && this.selectionHandle2.isVisible()) {
                return new Point2D((this.selectionHandle1.getLayoutX() + this.selectionHandle1.getWidth() / 2.0 + this.selectionHandle2.getLayoutX() + this.selectionHandle2.getWidth() / 2.0) / 2.0, this.selectionHandle2.getLayoutY() + this.selectionHandle2.getHeight() / 2.0);
            }
            return null;
        }
        throw new UnsupportedOperationException();
    }

    protected String maskText(String string) {
        return string;
    }

    protected int getInsertionPoint(double d2, double d3) {
        return 0;
    }

    public Rectangle2D getCharacterBounds(int n2) {
        return null;
    }

    protected void scrollCharacterToVisible(int n2) {
    }

    protected void invalidateMetrics() {
    }

    protected void updateTextFill() {
    }

    protected void updateHighlightFill() {
    }

    protected void updateHighlightTextFill() {
    }

    protected void handleInputMethodEvent(InputMethodEvent inputMethodEvent) {
        TextInputControl textInputControl = (TextInputControl)this.getSkinnable();
        if (textInputControl.isEditable() && !textInputControl.textProperty().isBound() && !textInputControl.isDisabled()) {
            if (this.imlength != 0) {
                TextInputControlSkin textInputControlSkin = this;
                textInputControlSkin.removeHighlight(textInputControlSkin.imattrs);
                this.imattrs.clear();
                textInputControl.selectRange(this.imstart, this.imstart + this.imlength);
            }
            if (inputMethodEvent.getCommitted().length() != 0) {
                String object3 = inputMethodEvent.getCommitted();
                TextInputControl textInputControl2 = textInputControl;
                textInputControl2.replaceText(textInputControl2.getSelection(), object3);
            }
            this.imstart = textInputControl.getSelection().getStart();
            StringBuilder stringBuilder = new StringBuilder();
            for (InputMethodTextRun inputMethodTextRun : inputMethodEvent.getComposed()) {
                stringBuilder.append(inputMethodTextRun.getText());
            }
            TextInputControl textInputControl3 = textInputControl;
            textInputControl3.replaceText(textInputControl3.getSelection(), stringBuilder.toString());
            this.imlength = stringBuilder.length();
            if (this.imlength != 0) {
                int n2 = this.imstart;
                for (InputMethodTextRun inputMethodTextRun : inputMethodEvent.getComposed()) {
                    int n3 = n2 + inputMethodTextRun.getText().length();
                    this.createInputMethodAttributes(inputMethodTextRun.getHighlight(), n2, n3);
                    n2 = n3;
                }
                TextInputControlSkin textInputControlSkin = this;
                textInputControlSkin.addHighlight(textInputControlSkin.imattrs, this.imstart);
                int n4 = inputMethodEvent.getCaretPosition();
                if (n4 >= 0 && n4 < this.imlength) {
                    textInputControl.selectRange(this.imstart + n4, this.imstart + n4);
                }
            }
        }
    }

    public void setCaretAnimating(boolean bl2) {
        if (bl2) {
            this.caretBlinking.start();
            return;
        }
        this.caretBlinking.stop();
        this.blinkProperty().set(true);
    }

    TextInputControlBehavior getBehavior() {
        return null;
    }

    ObservableBooleanValue caretVisibleProperty() {
        return this.caretVisible;
    }

    boolean isCaretBlinking() {
        return this.caretBlinking.caretTimeline.getStatus() == Animation$Status.RUNNING;
    }

    boolean isRTL() {
        return ((TextInputControl)this.getSkinnable()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
    }

    private void createInputMethodAttributes(InputMethodHighlight inputMethodHighlight, int n2, int n3) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        PathElement[] pathElementArray = this.getUnderlineShape(n2, n3);
        for (int i2 = 0; i2 < pathElementArray.length; ++i2) {
            Object object = pathElementArray[i2];
            if (object instanceof MoveTo) {
                d2 = d3 = ((MoveTo)object).getX();
                d4 = d5 = ((MoveTo)object).getY();
            } else if (object instanceof LineTo) {
                d2 = d2 < ((LineTo)object).getX() ? d2 : ((LineTo)object).getX();
                d3 = d3 > ((LineTo)object).getX() ? d3 : ((LineTo)object).getX();
                d4 = d4 < ((LineTo)object).getY() ? d4 : ((LineTo)object).getY();
                d5 = d5 > ((LineTo)object).getY() ? d5 : ((LineTo)object).getY();
            } else if (object instanceof HLineTo) {
                d2 = d2 < ((HLineTo)object).getX() ? d2 : ((HLineTo)object).getX();
                d3 = d3 > ((HLineTo)object).getX() ? d3 : ((HLineTo)object).getX();
            } else if (object instanceof VLineTo) {
                d4 = d4 < ((VLineTo)object).getY() ? d4 : ((VLineTo)object).getY();
                double d6 = d5 = d5 > ((VLineTo)object).getY() ? d5 : ((VLineTo)object).getY();
            }
            if (!(object instanceof ClosePath) && i2 != pathElementArray.length - 1 && (i2 >= pathElementArray.length - 1 || !(pathElementArray[i2 + 1] instanceof MoveTo))) continue;
            object = null;
            if (inputMethodHighlight == InputMethodHighlight.SELECTED_RAW) {
                object = new Path();
                ((Path)object).getElements().addAll((PathElement[])this.getRangeShape(n2, n3));
                ((Shape)object).setFill(Color.BLUE);
                ((Node)object).setOpacity(0.3f);
            } else if (inputMethodHighlight == InputMethodHighlight.UNSELECTED_RAW) {
                object = new Line(d2 + 2.0, d5 + 1.0, d3 - 2.0, d5 + 1.0);
                ((Shape)object).setStroke((Paint)this.textFill.get());
                ((Shape)object).setStrokeWidth(d5 - d4);
                ObservableList<Double> observableList = ((Shape)object).getStrokeDashArray();
                observableList.add(2.0);
                observableList.add(2.0);
            } else if (inputMethodHighlight == InputMethodHighlight.SELECTED_CONVERTED) {
                object = new Line(d2 + 2.0, d5 + 1.0, d3 - 2.0, d5 + 1.0);
                ((Shape)object).setStroke((Paint)this.textFill.get());
                ((Shape)object).setStrokeWidth((d5 - d4) * 3.0);
            } else if (inputMethodHighlight == InputMethodHighlight.UNSELECTED_CONVERTED) {
                object = new Line(d2 + 2.0, d5 + 1.0, d3 - 2.0, d5 + 1.0);
                ((Shape)object).setStroke((Paint)this.textFill.get());
                ((Shape)object).setStrokeWidth(d5 - d4);
            }
            if (object == null) continue;
            ((Node)object).setManaged(false);
            this.imattrs.add((Shape)object);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return TextInputControlSkin$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TextInputControlSkin.getClassCssMetaData();
    }

    @Override
    protected void executeAccessibleAction(AccessibleAction object, Object ... object2) {
        switch (TextInputControlSkin$12.$SwitchMap$javafx$scene$AccessibleAction[((Enum)object).ordinal()]) {
            case 1: {
                object = (Integer)object2[0];
                object2 = (Integer)object2[1];
                if (object == null || object2 == null) break;
                this.scrollCharacterToVisible((Integer)object2);
                this.scrollCharacterToVisible((Integer)object);
                this.scrollCharacterToVisible((Integer)object2);
                return;
            }
            default: {
                super.executeAccessibleAction((AccessibleAction)((Object)object), (Object[])object2);
            }
        }
    }

    static {
        AccessController.doPrivileged(() -> {
            String string = System.getProperty("com.sun.javafx.virtualKeyboard.preload");
            if (string != null && string.equalsIgnoreCase("PRERENDER")) {
                preload = true;
            }
            return null;
        });
        SHOW_HANDLES = Properties.IS_TOUCH_SUPPORTED;
        IS_FXVK_SUPPORTED = Platform.isSupported(ConditionalFeature.VIRTUAL_KEYBOARD);
    }
}

