/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.TreeTableCellBehavior;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.skin.TableCellSkinBase;
import javafx.scene.control.skin.TableRowSkinBase;
import javafx.scene.control.skin.TreeTableRowSkin;

public class TreeTableCellSkin<S, T>
extends TableCellSkinBase<TreeItem<S>, T, TreeTableCell<S, T>> {
    private final BehaviorBase<TreeTableCell<S, T>> behavior;

    public TreeTableCellSkin(TreeTableCell<S, T> treeTableCell) {
        super(treeTableCell);
        this.behavior = new TreeTableCellBehavior<S, T>(treeTableCell);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    @Override
    public ReadOnlyObjectProperty<TreeTableColumn<S, T>> tableColumnProperty() {
        return ((TreeTableCell)this.getSkinnable()).tableColumnProperty();
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        return super.computeMinWidth(d2, d3, d4, d5, d6) + this.calculateIndentation();
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6 = this.calculateIndentation();
        super.layoutChildren(d2 += d6, d3, d4 -= d6, d5);
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        if (this.isDeferToParentForPrefWidth) {
            return super.computePrefWidth(d2, d3, d4, d5, d6) + this.calculateIndentation();
        }
        return super.computePrefWidth(d2, d3, d4, d5, d6);
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return super.computePrefHeight(d2 -= this.calculateIndentation(), d3, d4, d5, d6);
    }

    private double calculateIndentation() {
        double d2 = this.getCellSize();
        IndexedCell indexedCell = (TreeTableCell)this.getSkinnable();
        TreeTableColumn treeTableColumn = ((TreeTableCell)indexedCell).getTableColumn();
        if (treeTableColumn == null) {
            return 0.0;
        }
        Object object = ((TreeTableCell)indexedCell).getTreeTableView();
        if (object == null) {
            return 0.0;
        }
        int n2 = ((TreeTableView)object).getVisibleLeafIndex(treeTableColumn);
        TreeTableColumn treeTableColumn2 = ((TreeTableView)object).getTreeColumn();
        if (treeTableColumn2 == null && n2 != 0 || treeTableColumn2 != null && !treeTableColumn.equals(treeTableColumn2)) {
            return 0.0;
        }
        if ((indexedCell = ((TreeTableCell)indexedCell).getTableRow()) == null) {
            return 0.0;
        }
        TreeItem treeItem = ((TreeTableRow)indexedCell).getTreeItem();
        if (treeItem == null) {
            return 0.0;
        }
        int n3 = ((TreeTableView)object).getTreeItemLevel(treeItem);
        if (!((TreeTableView)object).isShowRoot()) {
            --n3;
        }
        double d3 = 10.0;
        if (indexedCell.getSkin() instanceof TreeTableRowSkin) {
            d3 = ((TreeTableRowSkin)indexedCell.getSkin()).getIndentationPerLevel();
        }
        double d4 = 0.0 + (double)n3 * d3;
        object = TableRowSkinBase.maxDisclosureWidthMap;
        d4 += object.containsKey(treeTableColumn2) ? (Double)object.get(treeTableColumn2) : 0.0;
        object = treeItem.getGraphic();
        return d4 += object == null ? 0.0 : ((Node)object).prefWidth(d2);
    }
}

