/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.TreeTableRowBehavior;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.event.EventTarget;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.TreeTableView$TreeTableViewFocusModel;
import javafx.scene.control.skin.TableRowSkinBase;
import javafx.scene.control.skin.TreeTableRowSkin$1;
import javafx.scene.control.skin.TreeTableRowSkin$2;
import javafx.scene.control.skin.TreeTableRowSkin$StyleableProperties;
import javafx.scene.control.skin.TreeTableViewSkin;
import javafx.scene.layout.Region;

public class TreeTableRowSkin<T>
extends TableRowSkinBase<TreeItem<T>, TreeTableRow<T>, TreeTableCell<T, ?>> {
    private TreeItem<?> treeItem;
    private boolean disclosureNodeDirty = true;
    private Node graphic;
    private final BehaviorBase<TreeTableRow<T>> behavior;
    private boolean childrenDirty = false;
    private DoubleProperty indent = null;

    public TreeTableRowSkin(TreeTableRow<T> treeTableRow) {
        super(treeTableRow);
        this.behavior = new TreeTableRowBehavior<T>(treeTableRow);
        this.updateTreeItem();
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        listenerHelper.addChangeListener(treeTableRow.indexProperty(), number -> {
            this.updateCells = true;
        });
        listenerHelper.addChangeListener(treeTableRow.treeItemProperty(), treeItem -> this.updateTreeItem());
        this.setupTreeTableViewListeners();
    }

    private void setupTreeTableViewListeners() {
        Region region = ((TreeTableRow)this.getSkinnable()).getTreeTableView();
        if (region == null) {
            TreeTableRowSkin treeTableRowSkin = this;
            treeTableRowSkin.registerInvalidationListener(((TreeTableRow)treeTableRowSkin.getSkinnable()).treeTableViewProperty(), observable -> {
                TreeTableRowSkin treeTableRowSkin = this;
                treeTableRowSkin.unregisterInvalidationListeners(((TreeTableRow)treeTableRowSkin.getSkinnable()).treeTableViewProperty());
                this.setupTreeTableViewListeners();
            });
            return;
        }
        this.registerChangeListener(((TreeTableView)region).treeColumnProperty(), observableValue -> {
            this.isDirty = true;
            if (this.getSkinnable() != null) {
                ((TreeTableRow)this.getSkinnable()).requestLayout();
            }
        });
        region = this.getTreeTableView().fixedCellSizeProperty();
        if (region != null) {
            this.registerChangeListener((ObservableValue<?>)((Object)region), observableValue -> this.updateCachedFixedSize());
            this.updateCachedFixedSize();
            region = this.getVirtualFlow();
            if (region != null) {
                TreeTableRowSkin treeTableRowSkin = this;
                treeTableRowSkin.registerChangeListener(treeTableRowSkin.getVirtualFlow().widthProperty(), object -> {
                    if (this.getSkinnable() != null) {
                        object = ((TreeTableRow)this.getSkinnable()).getTreeTableView();
                        ((Parent)object).requestLayout();
                    }
                });
            }
        }
    }

    private void updateCachedFixedSize() {
        TreeTableView treeTableView;
        if (this.getSkinnable() != null && (treeTableView = ((TreeTableRow)this.getSkinnable()).getTreeTableView()) != null) {
            TreeTableRowSkin treeTableRowSkin;
            this.fixedCellSize = treeTableView.getFixedCellSize();
            this.fixedCellSizeEnabled = treeTableRowSkin.fixedCellSize > 0.0;
        }
    }

    private void updateTreeItemGraphic() {
        this.disclosureNodeDirty = true;
        ((TreeTableRow)this.getSkinnable()).requestLayout();
    }

    public final void setIndent(double d2) {
        this.indentProperty().set(d2);
    }

    public final double getIndent() {
        if (this.indent == null) {
            return 10.0;
        }
        return this.indent.get();
    }

    public final DoubleProperty indentProperty() {
        if (this.indent == null) {
            this.indent = new TreeTableRowSkin$1(this, 10.0);
        }
        return this.indent;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    @Override
    protected void updateChildren() {
        super.updateChildren();
        this.updateDisclosureNodeAndGraphic();
        if (this.childrenDirty) {
            this.childrenDirty = false;
            if (this.cells.isEmpty()) {
                this.getChildren().clear();
                return;
            }
            this.getChildren().addAll(this.cells);
        }
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        Node node;
        if (this.disclosureNodeDirty) {
            this.updateDisclosureNodeAndGraphic();
            this.disclosureNodeDirty = false;
        }
        if ((node = this.getDisclosureNode()) != null && node.getScene() == null) {
            this.updateDisclosureNodeAndGraphic();
        }
        super.layoutChildren(d2, d3, d4, d5);
    }

    @Override
    protected TreeTableCell<T, ?> createCell(TableColumnBase tableColumnBase) {
        tableColumnBase = (TreeTableColumn)tableColumnBase;
        TreeTableCell treeTableCell = ((TreeTableColumn)tableColumnBase).getCellFactory().call(tableColumnBase);
        treeTableCell.updateTableColumn(tableColumnBase);
        treeTableCell.updateTreeTableView(((TreeTableColumn)tableColumnBase).getTreeTableView());
        return treeTableCell;
    }

    @Override
    void updateCells(boolean bl2) {
        super.updateCells(bl2);
        if (bl2) {
            this.childrenDirty = true;
            this.updateChildren();
        }
    }

    @Override
    boolean isIndentationRequired() {
        return true;
    }

    @Override
    TableColumnBase getTreeColumn() {
        return this.getTreeTableView().getTreeColumn();
    }

    @Override
    int getIndentationLevel(TreeTableRow<T> treeTableRow) {
        return this.getTreeTableView().getTreeItemLevel(treeTableRow.getTreeItem());
    }

    @Override
    double getIndentationPerLevel() {
        return this.getIndent();
    }

    @Override
    Node getDisclosureNode() {
        return ((TreeTableRow)this.getSkinnable()).getDisclosureNode();
    }

    @Override
    boolean isDisclosureNodeVisible() {
        return this.getDisclosureNode() != null && this.treeItem != null && !this.treeItem.isLeaf();
    }

    @Override
    boolean isShowRoot() {
        return this.getTreeTableView().isShowRoot();
    }

    @Override
    protected ObservableList<TreeTableColumn<T, ?>> getVisibleLeafColumns() {
        if (this.getTreeTableView() == null) {
            return FXCollections.emptyObservableList();
        }
        return this.getTreeTableView().getVisibleLeafColumns();
    }

    @Override
    protected void updateCell(TreeTableCell<T, ?> treeTableCell, TreeTableRow<T> treeTableRow) {
        treeTableCell.updateTableRow(treeTableRow);
    }

    @Override
    protected TreeTableColumn<T, ?> getTableColumn(TreeTableCell treeTableCell) {
        return treeTableCell.getTableColumn();
    }

    @Override
    protected ObjectProperty<Node> graphicProperty() {
        if (this.treeItem == null) {
            return null;
        }
        return this.treeItem.graphicProperty();
    }

    private void updateTreeItem() {
        TreeTableRowSkin treeTableRowSkin = this;
        treeTableRowSkin.unregisterInvalidationListeners(treeTableRowSkin.graphicProperty());
        this.treeItem = ((TreeTableRow)this.getSkinnable()).getTreeItem();
        TreeTableRowSkin treeTableRowSkin2 = this;
        treeTableRowSkin2.registerInvalidationListener(treeTableRowSkin2.graphicProperty(), observable -> this.updateTreeItemGraphic());
    }

    private TreeTableView<T> getTreeTableView() {
        return ((TreeTableRow)this.getSkinnable()).getTreeTableView();
    }

    private void updateDisclosureNodeAndGraphic() {
        if (((TreeTableRow)this.getSkinnable()).isEmpty()) {
            this.getChildren().remove(this.graphic);
            return;
        }
        ObjectProperty<Node> objectProperty = this.graphicProperty();
        objectProperty = objectProperty == null ? null : (Node)objectProperty.get();
        if (objectProperty != null) {
            if (objectProperty != this.graphic) {
                this.getChildren().remove(this.graphic);
            }
            if (!this.getChildren().contains(objectProperty)) {
                this.getChildren().add((Node)((Object)objectProperty));
                this.graphic = objectProperty;
            }
        }
        if ((objectProperty = ((TreeTableRow)this.getSkinnable()).getDisclosureNode()) != null) {
            boolean bl2 = this.treeItem != null && !this.treeItem.isLeaf();
            ((Node)((Object)objectProperty)).setVisible(bl2);
            if (!bl2) {
                this.getChildren().remove(objectProperty);
            } else if (((Node)((Object)objectProperty)).getParent() == null) {
                this.getChildren().add((Node)((Object)objectProperty));
                ((Node)((Object)objectProperty)).toFront();
            } else {
                ((Node)((Object)objectProperty)).toBack();
            }
            if (((Node)((Object)objectProperty)).getScene() != null) {
                ((Node)((Object)objectProperty)).applyCss();
            }
        }
    }

    TreeTableViewSkin<T> getTableViewSkin() {
        TreeTableView treeTableView = ((TreeTableRow)this.getSkinnable()).getTreeTableView();
        if (treeTableView != null && treeTableView.getSkin() instanceof TreeTableViewSkin) {
            return (TreeTableViewSkin)treeTableView.getSkin();
        }
        return null;
    }

    TreeItem<T> getTreeItem() {
        return this.treeItem;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return TreeTableRowSkin$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TreeTableRowSkin.getClassCssMetaData();
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute object, Object ... object2) {
        TreeTableView treeTableView = ((TreeTableRow)this.getSkinnable()).getTreeTableView();
        switch (TreeTableRowSkin$2.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                if (treeTableView.getSelectionModel() != null) {
                    object = new ArrayList();
                    int n2 = ((TreeTableRow)this.getSkinnable()).getIndex();
                    Iterator iterator = treeTableView.getSelectionModel().getSelectedCells().iterator();
                    if (iterator.hasNext()) {
                        if (((TablePositionBase)((Object)(iterator = (TreeTablePosition)iterator.next()))).getRow() == n2) {
                            EventTarget eventTarget = ((TreeTablePosition)((Object)iterator)).getTableColumn();
                            if (eventTarget == null) {
                                eventTarget = treeTableView.getVisibleLeafColumn(0);
                            }
                            if ((eventTarget = (TreeTableCell)this.cellsMap.get(eventTarget).get()) != null) {
                                object.add(eventTarget);
                            }
                        }
                        return FXCollections.observableArrayList(object);
                    }
                }
                return FXCollections.observableArrayList();
            }
            case 2: {
                int n3 = (Integer)object2[1];
                object2 = treeTableView.getVisibleLeafColumn(n3);
                if (this.cellsMap.containsKey(object2)) {
                    return this.cellsMap.get(object2).get();
                }
                return null;
            }
            case 3: {
                object = treeTableView.getFocusModel();
                object2 = ((TreeTableView$TreeTableViewFocusModel)object).getFocusedCell();
                TreeTableColumn treeTableColumn = object2.getTableColumn();
                if (treeTableColumn == null) {
                    treeTableColumn = treeTableView.getVisibleLeafColumn(0);
                }
                if (this.cellsMap.containsKey(treeTableColumn)) {
                    return this.cellsMap.get(treeTableColumn).get();
                }
                return null;
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), object2);
    }
}

