/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.IDisconnectable;
import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.TreeTableViewBackingList;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.TreeTableViewBehavior;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeItem$TreeModificationEvent;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.TreeTableView$TreeTableViewSelectionModel;
import javafx.scene.control.skin.TableViewSkinBase;
import javafx.scene.control.skin.TreeTableViewSkin$1;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;

public class TreeTableViewSkin<T>
extends TableViewSkinBase<T, TreeItem<T>, TreeTableView<T>, TreeTableRow<T>, TreeTableColumn<T, ?>> {
    TreeTableViewBackingList<T> tableBackingList;
    ObjectProperty<ObservableList<TreeItem<T>>> tableBackingListProperty;
    private WeakReference<TreeItem<T>> weakRootRef;
    private final TreeTableViewBehavior<T> behavior;
    private IDisconnectable rootListener;

    public TreeTableViewSkin(TreeTableView<T> treeTableView) {
        super(treeTableView);
        this.behavior = new TreeTableViewBehavior<T>(treeTableView);
        this.flow.setFixedCellSize(treeTableView.getFixedCellSize());
        this.flow.setCellFactory(virtualFlow -> this.createCell());
        TreeTableViewSkin treeTableViewSkin = this;
        treeTableViewSkin.setRoot(((TreeTableView)treeTableViewSkin.getSkinnable()).getRoot());
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        EventHandler<MouseEvent> eventHandler = mouseEvent -> {
            if (treeTableView.isFocusTraversable()) {
                treeTableView.requestFocus();
            }
        };
        listenerHelper.addEventFilter(this.flow.getVbar(), MouseEvent.MOUSE_PRESSED, eventHandler);
        listenerHelper.addEventFilter(this.flow.getHbar(), MouseEvent.MOUSE_PRESSED, eventHandler);
        this.behavior.setOnFocusPreviousRow(() -> this.onFocusAboveCell());
        this.behavior.setOnFocusNextRow(() -> this.onFocusBelowCell());
        this.behavior.setOnMoveToFirstCell(() -> this.onMoveToFirstCell());
        this.behavior.setOnMoveToLastCell(() -> this.onMoveToLastCell());
        this.behavior.setOnScrollPageDown(bl2 -> this.onScrollPageDown((boolean)bl2));
        this.behavior.setOnScrollPageUp(bl2 -> this.onScrollPageUp((boolean)bl2));
        this.behavior.setOnSelectPreviousRow(() -> this.onSelectAboveCell());
        this.behavior.setOnSelectNextRow(() -> this.onSelectBelowCell());
        this.behavior.setOnSelectLeftCell(() -> this.onSelectLeftCell());
        this.behavior.setOnSelectRightCell(() -> this.onSelectRightCell());
        this.behavior.setOnFocusLeftCell(() -> this.onFocusLeftCell());
        this.behavior.setOnFocusRightCell(() -> this.onFocusRightCell());
        listenerHelper.addChangeListener(treeTableView.rootProperty(), treeItem -> {
            ((TreeTableView)this.getSkinnable()).edit(-1, null);
            TreeTableViewSkin treeTableViewSkin = this;
            treeTableViewSkin.setRoot(((TreeTableView)treeTableViewSkin.getSkinnable()).getRoot());
        });
        listenerHelper.addChangeListener(treeTableView.showRootProperty(), bl2 -> {
            if (!((TreeTableView)this.getSkinnable()).isShowRoot() && this.getRoot() != null) {
                this.getRoot().setExpanded(true);
            }
            this.updateItemCount();
        });
        listenerHelper.addChangeListener(treeTableView.rowFactoryProperty(), callback -> this.flow.recreateCells());
        listenerHelper.addChangeListener(treeTableView.expandedItemCountProperty(), number -> this.markItemCountDirty());
        listenerHelper.addChangeListener(treeTableView.fixedCellSizeProperty(), number -> this.flow.setFixedCellSize(((TreeTableView)this.getSkinnable()).getFixedCellSize()));
    }

    @Override
    public void dispose() {
        this.flow.setCellFactory(null);
        if (this.rootListener != null) {
            this.rootListener.disconnect();
            this.rootListener = null;
        }
        if (this.behavior != null) {
            ((BehaviorBase)this.behavior).dispose();
        }
        super.dispose();
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute object, Object ... object2) {
        switch (TreeTableViewSkin$1.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                int n2 = (Integer)object2[0];
                if (n2 < 0) {
                    return null;
                }
                return this.flow.getPrivateCell(n2);
            }
            case 2: {
                object = new ArrayList();
                object2 = ((TreeTableView)this.getSkinnable()).getSelectionModel();
                if (object2 != null) {
                    for (TreeTablePosition treeTablePosition : ((TreeTableView$TreeTableViewSelectionModel)object2).getSelectedCells()) {
                        TreeTableRow object3 = (TreeTableRow)this.flow.getPrivateCell(treeTablePosition.getRow());
                        if (object3 == null) continue;
                        object.add(object3);
                    }
                }
                return FXCollections.observableArrayList(object);
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), (Object[])object2);
    }

    @Override
    protected void executeAccessibleAction(AccessibleAction object, Object ... object2) {
        switch (TreeTableViewSkin$1.$SwitchMap$javafx$scene$AccessibleAction[((Enum)object).ordinal()]) {
            case 1: {
                object = (Node)object2[0];
                if (!(object instanceof TreeTableCell)) break;
                object2 = (TreeTableCell)object;
                this.flow.scrollTo(((IndexedCell)object2).getIndex());
                return;
            }
            case 2: {
                object = (ObservableList)object2[0];
                if (object == null) break;
                object2 = ((TreeTableView)this.getSkinnable()).getSelectionModel();
                if (object2 != null) {
                    ((SelectionModel)object2).clearSelection();
                    object = object.iterator();
                    while (object.hasNext()) {
                        Node node = (Node)object.next();
                        if (!(node instanceof TreeTableCell)) continue;
                        node = (TreeTableCell)node;
                        ((TableSelectionModel)object2).select(((IndexedCell)node).getIndex(), ((TreeTableCell)node).getTableColumn());
                    }
                }
                return;
            }
            default: {
                super.executeAccessibleAction((AccessibleAction)((Object)object), (Object[])object2);
            }
        }
    }

    private TreeTableRow<T> createCell() {
        TreeTableView treeTableView = (TreeTableView)this.getSkinnable();
        TreeTableRow<Object> treeTableRow = treeTableView.getRowFactory() != null ? treeTableView.getRowFactory().call(treeTableView) : new TreeTableRow();
        if (treeTableRow.getDisclosureNode() == null) {
            StackPane stackPane = new StackPane();
            stackPane.getStyleClass().setAll((String[])new String[]{"tree-disclosure-node"});
            stackPane.setMouseTransparent(true);
            StackPane stackPane2 = new StackPane();
            stackPane2.getStyleClass().setAll((String[])new String[]{"arrow"});
            stackPane.getChildren().add(stackPane2);
            treeTableRow.setDisclosureNode(stackPane);
        }
        treeTableRow.updateTreeTableView(treeTableView);
        return treeTableRow;
    }

    private TreeItem<T> getRoot() {
        if (this.weakRootRef == null) {
            return null;
        }
        return (TreeItem)this.weakRootRef.get();
    }

    private void setRoot(TreeItem<T> treeItem) {
        if (this.rootListener != null) {
            this.rootListener.disconnect();
            this.rootListener = null;
        }
        this.weakRootRef = new WeakReference<TreeItem<TreeItem<T>>>(treeItem);
        if (this.getRoot() != null) {
            this.rootListener = ListenerHelper.get(this).addEventHandler(this.getRoot(), TreeItem.treeNotificationEvent(), serializable -> {
                if (((TreeItem$TreeModificationEvent)serializable).wasAdded() && ((TreeItem$TreeModificationEvent)serializable).wasRemoved() && ((TreeItem$TreeModificationEvent)serializable).getAddedSize() == ((TreeItem$TreeModificationEvent)serializable).getRemovedSize()) {
                    this.markItemCountDirty();
                    ((TreeTableView)this.getSkinnable()).requestLayout();
                } else if (((Event)serializable).getEventType().equals(TreeItem.valueChangedEvent())) {
                    this.requestRebuildCells();
                } else {
                    for (serializable = ((Event)serializable).getEventType(); serializable != null; serializable = ((EventType)((Object)serializable)).getSuperType()) {
                        if (!serializable.equals(TreeItem.expandedItemCountChangeEvent())) continue;
                        this.markItemCountDirty();
                        ((TreeTableView)this.getSkinnable()).requestLayout();
                        break;
                    }
                }
                ((TreeTableView)this.getSkinnable()).edit(-1, null);
            });
        }
        this.updateItemCount();
    }

    @Override
    protected int getItemCount() {
        return ((TreeTableView)this.getSkinnable()).getExpandedItemCount();
    }

    @Override
    void horizontalScroll() {
        super.horizontalScroll();
        if (((TreeTableView)this.getSkinnable()).getFixedCellSize() > 0.0) {
            this.flow.requestCellLayout();
        }
    }

    @Override
    protected void updateItemCount() {
        this.updatePlaceholderRegionVisibility();
        this.tableBackingList.resetSize();
        int n2 = this.flow.getCellCount();
        int n3 = this.getItemCount();
        this.flow.setCellCount(n3);
        if (n3 == n2) {
            this.needCellsReconfigured = true;
        }
    }
}

