/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.logging.PlatformLogger$Level;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.control.Logging;
import com.sun.javafx.scene.control.Properties;
import com.sun.javafx.scene.control.VirtualScrollBar;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventTarget;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleRole;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.skin.VirtualFlow$1;
import javafx.scene.control.skin.VirtualFlow$2;
import javafx.scene.control.skin.VirtualFlow$3;
import javafx.scene.control.skin.VirtualFlow$4;
import javafx.scene.control.skin.VirtualFlow$5;
import javafx.scene.control.skin.VirtualFlow$6;
import javafx.scene.control.skin.VirtualFlow$7;
import javafx.scene.control.skin.VirtualFlow$8;
import javafx.scene.control.skin.VirtualFlow$ArrayLinkedList;
import javafx.scene.control.skin.VirtualFlow$ClippedContainer;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import javafx.util.Duration;

public class VirtualFlow<T extends IndexedCell>
extends Region {
    private static final int MIN_SCROLLING_LINES_PER_PAGE = 8;
    private static final String NEW_CELL = "newcell";
    private static final double GOLDEN_RATIO_MULTIPLIER = 0.618033987;
    private static final int DEFAULT_IMPROVEMENT = 2;
    private boolean touchDetected = false;
    private boolean mouseDown = false;
    double lastWidth = -1.0;
    double lastHeight = -1.0;
    int lastCellCount = 0;
    boolean lastVertical;
    double lastPosition;
    double lastCellBreadth = -1.0;
    double lastCellLength = -1.0;
    final VirtualFlow$ArrayLinkedList<T> cells = new VirtualFlow$ArrayLinkedList();
    final VirtualFlow$ArrayLinkedList<T> pile = new VirtualFlow$ArrayLinkedList();
    T accumCell;
    Group accumCellParent;
    final Group sheet;
    final ObservableList<Node> sheetChildren;
    private VirtualScrollBar hbar = new VirtualScrollBar(this);
    private VirtualScrollBar vbar = new VirtualScrollBar(this);
    VirtualFlow$ClippedContainer clipView;
    StackPane corner;
    double absoluteOffset = 0.0;
    double estimatedSize = -1.0;
    private ArrayList<Double> itemSizeCache = new ArrayList();
    private double lastX;
    private double lastY;
    private boolean isPanning = false;
    private boolean fixedCellSizeEnabled = false;
    private boolean needsReconfigureCells = false;
    private boolean needsRecreateCells = false;
    private boolean needsRebuildCells = false;
    private boolean needsCellsLayout = false;
    private boolean sizeChanged = false;
    private final BitSet dirtyCells = new BitSet();
    Timeline sbTouchTimeline;
    KeyFrame sbTouchKF1;
    KeyFrame sbTouchKF2;
    private boolean needBreadthBar;
    private boolean needLengthBar;
    private boolean tempVisibility = false;
    private boolean suppressBreadthBar;
    private BooleanProperty vertical;
    private BooleanProperty pannable = new SimpleBooleanProperty(this, "pannable", true);
    private IntegerProperty cellCount;
    private DoubleProperty position;
    private DoubleProperty fixedCellSize;
    private ObjectProperty<Callback<VirtualFlow<T>, T>> cellFactory;
    private double maxPrefBreadth;
    private double viewportBreadth;
    private double viewportLength;
    private final List<T> privateCells;
    private boolean recalculating;

    public VirtualFlow() {
        VirtualFlow virtualFlow = this;
        this.cellCount = new VirtualFlow$5(virtualFlow, virtualFlow, "cellCount", 0);
        VirtualFlow virtualFlow2 = this;
        this.position = new VirtualFlow$6(virtualFlow2, virtualFlow2, "position");
        VirtualFlow virtualFlow3 = this;
        this.fixedCellSize = new VirtualFlow$7(virtualFlow3, virtualFlow3, "fixedCellSize");
        this.privateCells = new ArrayList<T>();
        this.recalculating = false;
        this.getStyleClass().add("virtual-flow");
        this.setId("virtual-flow");
        this.sheet = new Group();
        this.sheet.getStyleClass().add("sheet");
        this.sheet.setAutoSizeChildren(false);
        this.sheetChildren = this.sheet.getChildren();
        this.clipView = new VirtualFlow$ClippedContainer(this);
        this.clipView.setNode(this.sheet);
        this.getChildren().add(this.clipView);
        this.accumCellParent = new Group();
        this.accumCellParent.setVisible(false);
        this.getChildren().add(this.accumCellParent);
        ChangeListener<Number> changeListener = (event, eventDispatchChain) -> event;
        EventDispatcher eventDispatcher = this.hbar.getEventDispatcher();
        this.hbar.setEventDispatcher((arg_0, arg_1) -> VirtualFlow.lambda$new$1((EventDispatcher)((Object)changeListener), eventDispatcher, arg_0, arg_1));
        eventDispatcher = this.vbar.getEventDispatcher();
        this.vbar.setEventDispatcher((arg_0, arg_1) -> VirtualFlow.lambda$new$2((EventDispatcher)((Object)changeListener), eventDispatcher, arg_0, arg_1));
        this.setOnScroll(new VirtualFlow$1(this));
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, new VirtualFlow$2(this));
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, (? super T mouseEvent) -> {
            this.mouseDown = false;
            if (Properties.IS_TOUCH_SUPPORTED) {
                this.startSBReleasedAnimation();
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_DRAGGED, (? super T mouseEvent) -> {
            if (Properties.IS_TOUCH_SUPPORTED) {
                this.scrollBarOn();
            }
            if (!this.isPanning || !this.isPannable()) {
                return;
            }
            double d2 = this.lastX - mouseEvent.getX();
            double d3 = this.lastY - mouseEvent.getY();
            double d4 = this.isVertical() ? d3 : d2;
            double d5 = this.scrollPixels(d4);
            if (d5 != 0.0) {
                if (this.isVertical()) {
                    this.lastY = mouseEvent.getY();
                } else {
                    this.lastX = mouseEvent.getX();
                }
            }
            double d6 = this.isVertical() ? d2 : d3;
            VirtualScrollBar virtualScrollBar = this.isVertical() ? this.hbar : this.vbar;
            if (virtualScrollBar.isVisible()) {
                double d7;
                double d8 = virtualScrollBar.getValue() + d6;
                if (d7 < virtualScrollBar.getMin()) {
                    VirtualScrollBar virtualScrollBar2 = virtualScrollBar;
                    virtualScrollBar2.setValue(virtualScrollBar2.getMin());
                    return;
                }
                if (d8 > virtualScrollBar.getMax()) {
                    VirtualScrollBar virtualScrollBar3 = virtualScrollBar;
                    virtualScrollBar3.setValue(virtualScrollBar3.getMax());
                    return;
                }
                virtualScrollBar.setValue(d8);
                if (this.isVertical()) {
                    this.lastX = mouseEvent.getX();
                    return;
                }
                this.lastY = mouseEvent.getY();
            }
        });
        this.vbar.setOrientation(Orientation.VERTICAL);
        this.vbar.addEventHandler(MouseEvent.ANY, (? super T mouseEvent) -> mouseEvent.consume());
        this.getChildren().add(this.vbar);
        this.hbar.setOrientation(Orientation.HORIZONTAL);
        this.hbar.addEventHandler(MouseEvent.ANY, (? super T mouseEvent) -> mouseEvent.consume());
        this.getChildren().add(this.hbar);
        this.corner = new StackPane();
        this.corner.getStyleClass().setAll((String[])new String[]{"corner"});
        this.getChildren().add(this.corner);
        changeListener = observable -> this.updateHbar();
        this.verticalProperty().addListener((InvalidationListener)((Object)changeListener));
        this.hbar.valueProperty().addListener((InvalidationListener)((Object)changeListener));
        this.hbar.visibleProperty().addListener((InvalidationListener)((Object)changeListener));
        this.visibleProperty().addListener((InvalidationListener)((Object)changeListener));
        this.sceneProperty().addListener((InvalidationListener)((Object)changeListener));
        changeListener = (observableValue, number, number2) -> this.clipView.setClipY(this.isVertical() ? 0.0 : this.vbar.getValue());
        this.vbar.valueProperty().addListener(changeListener);
        super.heightProperty().addListener((observableValue, number, number2) -> {
            if (number.doubleValue() == 0.0 && number2.doubleValue() > 0.0) {
                this.recreateCells();
            }
        });
        VirtualFlow virtualFlow4 = this;
        virtualFlow4.setOnTouchPressed(touchEvent -> {
            this.touchDetected = true;
            this.scrollBarOn();
        });
        VirtualFlow virtualFlow5 = this;
        virtualFlow5.setOnTouchReleased(touchEvent -> {
            this.touchDetected = false;
            this.startSBReleasedAnimation();
        });
        ParentHelper.setTraversalEngine(this, new ParentTraversalEngine(this, new VirtualFlow$3(this)));
    }

    public final void setVertical(boolean bl2) {
        this.verticalProperty().set(bl2);
    }

    public final boolean isVertical() {
        if (this.vertical == null) {
            return true;
        }
        return this.vertical.get();
    }

    public final BooleanProperty verticalProperty() {
        if (this.vertical == null) {
            this.vertical = new VirtualFlow$4(this, true);
        }
        return this.vertical;
    }

    public final boolean isPannable() {
        return this.pannable.get();
    }

    public final void setPannable(boolean bl2) {
        this.pannable.set(bl2);
    }

    public final BooleanProperty pannableProperty() {
        return this.pannable;
    }

    public final int getCellCount() {
        return this.cellCount.get();
    }

    public final void setCellCount(int n2) {
        this.cellCount.set(n2);
    }

    public final IntegerProperty cellCountProperty() {
        return this.cellCount;
    }

    public final double getPosition() {
        return this.position.get();
    }

    public final void setPosition(double d2) {
        this.position.set(d2);
    }

    public final DoubleProperty positionProperty() {
        return this.position;
    }

    public final void setFixedCellSize(double d2) {
        this.fixedCellSize.set(d2);
    }

    public final double getFixedCellSize() {
        return this.fixedCellSize.get();
    }

    public final DoubleProperty fixedCellSizeProperty() {
        return this.fixedCellSize;
    }

    public final void setCellFactory(Callback<VirtualFlow<T>, T> callback) {
        this.cellFactoryProperty().set(callback);
    }

    public final Callback<VirtualFlow<T>, T> getCellFactory() {
        if (this.cellFactory == null) {
            return null;
        }
        return (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<VirtualFlow<T>, T>> cellFactoryProperty() {
        if (this.cellFactory == null) {
            VirtualFlow virtualFlow = this;
            this.cellFactory = new VirtualFlow$8(virtualFlow, virtualFlow, "cellFactory");
        }
        return this.cellFactory;
    }

    @Override
    public void requestLayout() {
        super.requestLayout();
    }

    void adjustAbsoluteOffset() {
        this.absoluteOffset = (this.estimatedSize - this.viewportLength) * this.getPosition();
    }

    void adjustPosition() {
        if (this.viewportLength >= this.estimatedSize) {
            this.setPosition(0.0);
            return;
        }
        VirtualFlow virtualFlow = this;
        virtualFlow.setPosition(virtualFlow.absoluteOffset / (this.estimatedSize - this.viewportLength));
    }

    @Override
    protected void layoutChildren() {
        double d2;
        Object object;
        int n2;
        int n3;
        int n4;
        if (this.needsRecreateCells) {
            this.lastWidth = -1.0;
            this.lastHeight = -1.0;
            VirtualFlow virtualFlow = this;
            virtualFlow.releaseCell(virtualFlow.accumCell);
            this.sheet.getChildren().clear();
            n4 = this.cells.size();
            for (n3 = 0; n3 < n4; ++n3) {
                ((IndexedCell)this.cells.get(n3)).updateIndex(-1);
            }
            this.cells.clear();
            this.pile.clear();
            this.releaseAllPrivateCells();
        } else if (this.needsRebuildCells) {
            this.lastWidth = -1.0;
            this.lastHeight = -1.0;
            VirtualFlow virtualFlow = this;
            virtualFlow.releaseCell(virtualFlow.accumCell);
            n4 = this.cells.size();
            for (n3 = 0; n3 < n4; ++n3) {
                ((IndexedCell)this.cells.get(n3)).updateIndex(-1);
            }
            this.addAllToPile();
            this.releaseAllPrivateCells();
        } else if (this.needsReconfigureCells) {
            this.setMaxPrefBreadth(-1.0);
            this.lastWidth = -1.0;
            this.lastHeight = -1.0;
        }
        if (!this.dirtyCells.isEmpty()) {
            n4 = this.cells.size();
            while ((n3 = this.dirtyCells.nextSetBit(0)) != -1 && n3 < n4) {
                IndexedCell indexedCell = (IndexedCell)this.cells.get(n3);
                if (indexedCell != null) {
                    indexedCell.requestLayout();
                }
                this.dirtyCells.clear(n3);
            }
            this.setMaxPrefBreadth(-1.0);
            this.lastWidth = -1.0;
            this.lastHeight = -1.0;
        }
        n3 = this.sizeChanged;
        n4 = this.needsRebuildCells || this.needsRecreateCells || this.sizeChanged ? 1 : 0;
        this.needsRecreateCells = false;
        this.needsReconfigureCells = false;
        this.needsRebuildCells = false;
        this.sizeChanged = false;
        if (this.needsCellsLayout) {
            int n5 = this.cells.size();
            for (int i2 = 0; i2 < n5; ++i2) {
                IndexedCell indexedCell = (IndexedCell)this.cells.get(i2);
                if (indexedCell == null) continue;
                indexedCell.requestLayout();
            }
            this.needsCellsLayout = false;
            return;
        }
        double d3 = this.getWidth();
        double d4 = this.getHeight();
        boolean bl2 = this.isVertical();
        double d5 = this.getPosition();
        if (d3 <= 0.0 || d4 <= 0.0) {
            this.addAllToPile();
            this.lastWidth = d3;
            this.lastHeight = d4;
            this.hbar.setVisible(false);
            this.vbar.setVisible(false);
            this.corner.setVisible(false);
            return;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (Properties.IS_TOUCH_SUPPORTED && (this.tempVisibility && (!this.hbar.isVisible() || !this.vbar.isVisible()) || !this.tempVisibility && (this.hbar.isVisible() || this.vbar.isVisible()))) {
            bl4 = true;
        }
        for (n2 = 0; n2 < this.cells.size() && !(bl3 = ((Parent)(object = (IndexedCell)this.cells.get(n2))).isNeedsLayout()); ++n2) {
        }
        n2 = this.getCellCount();
        object = this.getFirstVisibleCell();
        if (!bl3 && !bl4) {
            bl4 = false;
            if (object != null) {
                double d6 = this.getCellBreadth(object);
                d2 = this.getCellLength(object);
                bl4 = d6 != this.lastCellBreadth || d2 != this.lastCellLength;
                this.lastCellBreadth = d6;
                this.lastCellLength = d2;
            }
            if (d3 == this.lastWidth && d4 == this.lastHeight && n2 == this.lastCellCount && bl2 == this.lastVertical && d5 == this.lastPosition && !bl4) {
                return;
            }
        }
        bl4 = false;
        boolean bl5 = bl3 || bl2 != this.lastVertical || this.cells.isEmpty() || this.getMaxPrefBreadth() == -1.0 || d5 != this.lastPosition || n2 != this.lastCellCount || n3 != 0 || bl2 && d4 < this.lastHeight || !bl2 && d3 < this.lastWidth;
        if (!bl5) {
            double d7 = this.getMaxPrefBreadth();
            boolean bl6 = false;
            for (n3 = 0; n3 < this.cells.size(); ++n3) {
                VirtualFlow virtualFlow = this;
                double d8 = virtualFlow.getCellBreadth((IndexedCell)virtualFlow.cells.get(n3));
                if (d7 == d8) {
                    bl6 = true;
                    continue;
                }
                if (!(d8 > d7)) continue;
                bl5 = true;
                break;
            }
            if (!bl6) {
                bl5 = true;
            }
        }
        if (!bl5 && (bl2 && d4 > this.lastHeight || !bl2 && d3 > this.lastWidth)) {
            bl4 = true;
        }
        this.initViewport();
        int n6 = this.computeCurrentIndex();
        if (this.lastCellCount != n2) {
            if (d5 != 0.0 && d5 != 1.0 && n6 >= n2) {
                this.setPosition(1.0);
            }
            n6 = this.computeCurrentIndex();
        }
        if (bl5) {
            this.setMaxPrefBreadth(-1.0);
            this.addAllToPile();
            VirtualFlow virtualFlow = this;
            d2 = -virtualFlow.computeViewportOffset(virtualFlow.getPosition());
            this.addLeadingCells(n6, d2);
            this.addTrailingCells(true);
        } else if (bl4) {
            this.addTrailingCells(true);
        }
        this.computeBarVisiblity();
        this.recalculateAndImproveEstimatedSize(0);
        n4 = n4 != 0 || bl5 ? 1 : 0;
        this.updateScrollBarsAndCells(n4 != 0);
        this.lastWidth = this.getWidth();
        this.lastHeight = this.getHeight();
        this.lastCellCount = this.getCellCount();
        this.lastVertical = this.isVertical();
        this.lastPosition = this.getPosition();
        this.recalculateEstimatedSize();
        this.cleanPile();
    }

    @Override
    protected void setWidth(double d2) {
        if (d2 != this.lastWidth) {
            super.setWidth(d2);
            this.sizeChanged = true;
            this.setNeedsLayout(true);
            ((Parent)this).requestLayout();
        }
    }

    @Override
    protected void setHeight(double d2) {
        if (d2 != this.lastHeight) {
            super.setHeight(d2);
            this.sizeChanged = true;
            this.setNeedsLayout(true);
            ((Parent)this).requestLayout();
        }
    }

    protected T getAvailableCell(int n2) {
        Node node = null;
        int n3 = this.pile.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            IndexedCell indexedCell = (IndexedCell)this.pile.get(i2);
            assert (indexedCell != null);
            if (this.getCellIndex(indexedCell) != n2) continue;
            node = indexedCell;
            this.pile.remove(i2);
            break;
        }
        if (node == null && !this.pile.isEmpty()) {
            node = (IndexedCell)this.pile.removeLast();
        }
        if (node == null) {
            node = (IndexedCell)this.getCellFactory().call(this);
            node.getProperties().put(NEW_CELL, null);
        }
        if (node.getParent() == null) {
            this.sheetChildren.add(node);
        }
        return (T)node;
    }

    protected void addAllToPile() {
        int n2 = this.cells.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            VirtualFlow virtualFlow = this;
            virtualFlow.addToPile((IndexedCell)virtualFlow.cells.removeFirst());
        }
    }

    public T getVisibleCell(int n2) {
        if (this.cells.isEmpty()) {
            return null;
        }
        IndexedCell indexedCell = (IndexedCell)this.cells.getLast();
        int n3 = this.getCellIndex(indexedCell);
        if (n2 == n3) {
            return (T)indexedCell;
        }
        indexedCell = (IndexedCell)this.cells.getFirst();
        int n4 = this.getCellIndex(indexedCell);
        if (n2 == n4) {
            return (T)indexedCell;
        }
        if (n2 > n4 && n2 < n3 && this.getCellIndex(indexedCell = (IndexedCell)this.cells.get(n2 - n4)) == n2) {
            return (T)indexedCell;
        }
        return null;
    }

    public T getLastVisibleCell() {
        if (this.cells.isEmpty() || this.getViewportLength() <= 0.0) {
            return null;
        }
        for (int i2 = this.cells.size() - 1; i2 >= 0; --i2) {
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i2);
            if (indexedCell.isEmpty()) continue;
            return (T)indexedCell;
        }
        return null;
    }

    public T getFirstVisibleCell() {
        if (this.cells.isEmpty() || this.getViewportLength() <= 0.0) {
            return null;
        }
        IndexedCell indexedCell = (IndexedCell)this.cells.getFirst();
        if (indexedCell.isEmpty()) {
            return null;
        }
        return (T)indexedCell;
    }

    public void scrollToTop(T t2) {
        if (t2 != null) {
            VirtualFlow virtualFlow = this;
            virtualFlow.scrollPixels(virtualFlow.getCellPosition(t2));
        }
    }

    public void scrollToBottom(T t2) {
        if (t2 != null) {
            VirtualFlow virtualFlow = this;
            virtualFlow.scrollPixels(virtualFlow.getCellPosition(t2) + this.getCellLength(t2) - this.getViewportLength());
        }
    }

    public void scrollTo(T t2) {
        if (t2 != null) {
            double d2 = this.getCellPosition(t2);
            double d3 = this.getCellLength(t2);
            double d4 = d2 + d3;
            double d5 = this.getViewportLength();
            if (d2 < 0.0) {
                this.scrollPixels(d2);
                return;
            }
            if (d4 > d5) {
                this.scrollPixels(d4 - d5);
            }
        }
    }

    public void scrollTo(int n2) {
        T t2 = this.getVisibleCell(n2);
        if (t2 != null) {
            this.scrollTo(t2);
            return;
        }
        if (this.tryScrollOneCell(n2, true)) {
            return;
        }
        if (this.tryScrollOneCell(n2, false)) {
            return;
        }
        this.adjustPositionToIndex(n2);
        this.addAllToPile();
        ((Parent)this).requestLayout();
    }

    private boolean tryScrollOneCell(int n2, boolean bl2) {
        int n3 = bl2 ? -1 : 1;
        T t2 = this.getVisibleCell(n2 + n3);
        if (t2 != null) {
            t2 = this.getAvailableCell(n2);
            this.setCellIndex(t2, n2);
            this.resizeCell(t2);
            VirtualFlow virtualFlow = this;
            virtualFlow.setMaxPrefBreadth(Math.max(virtualFlow.getMaxPrefBreadth(), this.getCellBreadth(t2)));
            ((Node)t2).setVisible(true);
            if (bl2) {
                this.cells.addLast(t2);
                VirtualFlow virtualFlow2 = this;
                virtualFlow2.scrollPixels(virtualFlow2.getCellLength(t2));
            } else {
                this.cells.addFirst(t2);
                VirtualFlow virtualFlow3 = this;
                virtualFlow3.scrollPixels(-virtualFlow3.getCellLength(t2));
            }
            return true;
        }
        return false;
    }

    public void scrollToTop(int n2) {
        this.getCellSizesInExpectedViewport(n2);
        boolean bl2 = false;
        if (n2 > this.getCellCount() - 1) {
            this.setPosition(1.0);
            bl2 = true;
        } else if (n2 < 0) {
            this.setPosition(0.0);
            bl2 = true;
        }
        if (!bl2) {
            this.adjustPositionToIndex(n2);
        }
        ((Parent)this).requestLayout();
    }

    public double scrollPixels(double d2) {
        int n2 = this.computeCurrentIndex();
        if (d2 == 0.0) {
            return 0.0;
        }
        boolean bl2 = this.isVertical();
        if (bl2 && (!this.tempVisibility ? !this.vbar.isVisible() : !this.needLengthBar) || !bl2 && (this.tempVisibility ? !this.needLengthBar : !this.hbar.isVisible())) {
            return 0.0;
        }
        double d3 = this.getPosition();
        if (d3 == 0.0 && d2 < 0.0) {
            return 0.0;
        }
        if (d3 == 1.0 && d2 > 0.0) {
            return 0.0;
        }
        this.getCellSizesInExpectedViewport(n2);
        this.recalculateEstimatedSize();
        double d4 = this.adjustByPixelAmount(d2);
        if (d3 == this.getPosition()) {
            return 0.0;
        }
        if (this.cells.size() > 0) {
            double d5;
            int n3;
            for (n2 = 0; n2 < this.cells.size(); ++n2) {
                IndexedCell indexedCell = (IndexedCell)this.cells.get(n2);
                assert (indexedCell != null);
                this.positionCell(indexedCell, this.getCellPosition(indexedCell) - d2);
            }
            IndexedCell indexedCell = (IndexedCell)this.cells.getFirst();
            double d6 = indexedCell == null ? 0.0 : this.getCellPosition(indexedCell);
            for (n3 = 0; n3 < this.cells.size(); ++n3) {
                double d7;
                IndexedCell indexedCell2 = (IndexedCell)this.cells.get(n3);
                assert (indexedCell2 != null);
                double d8 = this.getCellPosition(indexedCell2);
                if (Math.abs(d7 - d6) > 0.001) {
                    this.positionCell(indexedCell2, d6);
                }
                d6 += this.getCellLength(indexedCell2);
            }
            this.cull();
            indexedCell = (IndexedCell)this.cells.getFirst();
            if (indexedCell != null) {
                n3 = this.getCellIndex(indexedCell);
                d5 = this.getCellLength(n3 - 1);
                this.addLeadingCells(n3 - 1, this.getCellPosition(indexedCell) - d5);
            } else {
                n3 = this.computeCurrentIndex();
                VirtualFlow virtualFlow = this;
                d5 = -virtualFlow.computeViewportOffset(virtualFlow.getPosition());
                this.addLeadingCells(n3, d5);
            }
            if (!this.addTrailingCells(false)) {
                double d9;
                T t2 = this.getLastVisibleCell();
                d5 = this.getCellLength(t2);
                double d10 = this.getCellPosition(t2) + d5;
                if (d10 < (d9 = this.getViewportLength())) {
                    int n4;
                    double d11 = d9 - d10;
                    for (n4 = 0; n4 < this.cells.size(); ++n4) {
                        IndexedCell indexedCell3 = (IndexedCell)this.cells.get(n4);
                        this.positionCell(indexedCell3, this.getCellPosition(indexedCell3) + d11);
                    }
                    this.setPosition(1.0);
                    indexedCell = (IndexedCell)this.cells.getFirst();
                    n4 = this.getCellIndex(indexedCell);
                    double d12 = this.getCellLength(n4 - 1);
                    this.addLeadingCells(n4 - 1, this.getCellPosition(indexedCell) - d12);
                }
            }
        }
        this.cull();
        this.updateScrollBarsAndCells(false);
        return d4;
    }

    @Override
    protected double computePrefWidth(double d2) {
        double d3 = this.isVertical() ? this.getPrefBreadth(d2) : this.getPrefLength();
        return d3 + ((Node)this.vbar).prefWidth(-1.0);
    }

    @Override
    protected double computePrefHeight(double d2) {
        double d3 = this.isVertical() ? this.getPrefLength() : this.getPrefBreadth(d2);
        return d3 + ((Node)this.hbar).prefHeight(-1.0);
    }

    public T getCell(int n2) {
        Callback<VirtualFlow<T>, T> callback;
        T t2;
        if (!this.cells.isEmpty() && (t2 = this.getVisibleCell(n2)) != null) {
            return t2;
        }
        for (int i2 = 0; i2 < this.pile.size(); ++i2) {
            IndexedCell indexedCell = (IndexedCell)this.pile.get(i2);
            if (this.getCellIndex(indexedCell) != n2) continue;
            this.resizeCell(indexedCell);
            return (T)indexedCell;
        }
        if (this.accumCell == null && (callback = this.getCellFactory()) != null) {
            this.accumCell = (IndexedCell)callback.call(this);
            ((Node)this.accumCell).getProperties().put(NEW_CELL, null);
            this.accumCellParent.getChildren().setAll((Node[])new Node[]{this.accumCell});
            ((Node)this.accumCell).setAccessibleRole(AccessibleRole.NODE);
            ((Parent)this.accumCell).getChildrenUnmodifiable().addListener(object -> {
                for (Node node : ((Parent)this.accumCell).getChildrenUnmodifiable()) {
                    node.setAccessibleRole(AccessibleRole.NODE);
                }
            });
        }
        VirtualFlow virtualFlow = this;
        virtualFlow.setCellIndex(virtualFlow.accumCell, n2);
        VirtualFlow virtualFlow2 = this;
        virtualFlow2.resizeCell(virtualFlow2.accumCell);
        return this.accumCell;
    }

    protected void setCellIndex(T t2, int n2) {
        assert (t2 != null);
        ((IndexedCell)t2).updateIndex(n2);
        if (((Parent)t2).isNeedsLayout() && ((Node)t2).getScene() != null || ((Node)t2).getProperties().containsKey(NEW_CELL)) {
            ((Node)t2).applyCss();
            ((Node)t2).getProperties().remove(NEW_CELL);
        }
    }

    protected int getCellIndex(T t2) {
        return ((IndexedCell)t2).getIndex();
    }

    protected final ScrollBar getHbar() {
        return this.hbar;
    }

    protected final ScrollBar getVbar() {
        return this.vbar;
    }

    private final void setMaxPrefBreadth(double d2) {
        this.maxPrefBreadth = d2;
    }

    final double getMaxPrefBreadth() {
        return this.maxPrefBreadth;
    }

    private final void setViewportBreadth(double d2) {
        this.viewportBreadth = d2;
    }

    private final double getViewportBreadth() {
        return this.viewportBreadth;
    }

    void setViewportLength(double d2) {
        if (d2 == this.viewportLength) {
            return;
        }
        this.viewportLength = d2;
        this.absoluteOffset = this.getPosition() * (this.estimatedSize - this.viewportLength);
        this.recalculateEstimatedSize();
    }

    double getViewportLength() {
        return this.viewportLength;
    }

    double getCellLength(int n2) {
        if (this.fixedCellSizeEnabled) {
            return this.getFixedCellSize();
        }
        T t2 = this.getCell(n2);
        double d2 = this.getCellLength(t2);
        this.releaseCell(t2);
        return d2;
    }

    double getCellBreadth(int n2) {
        T t2 = this.getCell(n2);
        double d2 = this.getCellBreadth(t2);
        this.releaseCell(t2);
        return d2;
    }

    double getCellLength(T t2) {
        if (t2 == null) {
            return 0.0;
        }
        if (this.fixedCellSizeEnabled) {
            return this.getFixedCellSize();
        }
        if (this.isVertical()) {
            return ((Node)t2).getLayoutBounds().getHeight();
        }
        return ((Node)t2).getLayoutBounds().getWidth();
    }

    double getCellBreadth(T t2) {
        if (this.isVertical()) {
            return ((Node)t2).prefWidth(-1.0);
        }
        return ((Node)t2).prefHeight(-1.0);
    }

    double getCellPosition(T t2) {
        if (t2 == null) {
            return 0.0;
        }
        if (this.isVertical()) {
            return ((Node)t2).getLayoutY();
        }
        return ((Node)t2).getLayoutX();
    }

    private void positionCell(T t2, double d2) {
        this.updateCellSize(t2);
        if (this.isVertical()) {
            ((Node)t2).setLayoutX(0.0);
            ((Node)t2).setLayoutY(this.snapSpaceY(d2));
            return;
        }
        ((Node)t2).setLayoutX(this.snapSpaceX(d2));
        ((Node)t2).setLayoutY(0.0);
    }

    protected void resizeCell(T t2) {
        if (t2 == null) {
            return;
        }
        double d2 = Math.max(this.getMaxPrefBreadth(), this.getViewportBreadth());
        if (this.isVertical()) {
            ((Node)t2).resize(d2, this.fixedCellSizeEnabled ? this.getFixedCellSize() : Utils.boundedSize(((Node)t2).prefHeight(d2), ((Node)t2).minHeight(d2), ((Node)t2).maxHeight(d2)));
            return;
        }
        ((Node)t2).resize(this.fixedCellSizeEnabled ? this.getFixedCellSize() : Utils.boundedSize(((Node)t2).prefWidth(d2), ((Node)t2).minWidth(d2), ((Node)t2).maxWidth(d2)), d2);
    }

    protected List<T> getCells() {
        return this.cells;
    }

    protected T getLastVisibleCellWithinViewport() {
        if (this.cells.isEmpty() || this.getViewportLength() <= 0.0) {
            return null;
        }
        double d2 = this.getViewportLength();
        for (int i2 = this.cells.size() - 1; i2 >= 0; --i2) {
            double d3;
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i2);
            if (indexedCell.isEmpty()) continue;
            double d4 = this.getCellPosition(indexedCell);
            double d5 = d4 + this.getCellLength(indexedCell);
            if (!(d3 <= d2 + 2.0)) continue;
            return (T)indexedCell;
        }
        return null;
    }

    protected T getFirstVisibleCellWithinViewport() {
        if (this.cells.isEmpty() || this.getViewportLength() <= 0.0) {
            return null;
        }
        for (int i2 = 0; i2 < this.cells.size(); ++i2) {
            double d2;
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i2);
            if (indexedCell.isEmpty()) continue;
            double d3 = this.getCellPosition(indexedCell);
            if (!(d2 >= 0.0)) continue;
            return (T)indexedCell;
        }
        return null;
    }

    void addLeadingCells(int n2, double d2) {
        Object object;
        double d3 = d2;
        boolean bl2 = true;
        if (n2 == this.getCellCount() && d3 == this.getViewportLength()) {
            --n2;
            bl2 = false;
        }
        while (n2 >= 0 && (d3 > 0.0 || bl2)) {
            object = this.getAvailableCell(n2);
            this.setCellIndex(object, n2);
            this.resizeCell(object);
            this.cells.addFirst(object);
            if (bl2) {
                bl2 = false;
            } else {
                d3 -= this.getCellLength(object);
            }
            this.positionCell(object, d3);
            VirtualFlow virtualFlow = this;
            virtualFlow.setMaxPrefBreadth(Math.max(virtualFlow.getMaxPrefBreadth(), this.getCellBreadth(object)));
            ((Node)object).setVisible(true);
            --n2;
        }
        if (this.cells.size() > 0) {
            object = (IndexedCell)this.cells.getFirst();
            n2 = this.getCellIndex(object);
            double d4 = this.getCellPosition(object);
            if (n2 == 0 && d4 > 0.0) {
                this.setPosition(0.0);
                d3 = 0.0;
                for (n2 = 0; n2 < this.cells.size(); ++n2) {
                    object = (IndexedCell)this.cells.get(n2);
                    this.positionCell(object, d3);
                    d3 += this.getCellLength(object);
                }
            }
            return;
        }
        this.vbar.setValue(0.0);
        this.hbar.setValue(0.0);
    }

    boolean addTrailingCells(boolean bl2) {
        Object object;
        int n2;
        if (this.cells.isEmpty()) {
            return false;
        }
        IndexedCell indexedCell = (IndexedCell)this.cells.getLast();
        double d2 = this.getCellPosition(indexedCell) + this.getCellLength(indexedCell);
        int n3 = this.getCellIndex(indexedCell) + 1;
        boolean bl3 = n3 <= (n2 = this.getCellCount());
        double d3 = this.getViewportLength();
        if (d2 < 0.0 && !bl2) {
            return false;
        }
        double d4 = d3;
        while (d2 < d3) {
            if (n3 >= n2) {
                if (d2 < d3) {
                    bl3 = false;
                }
                if (!bl2) {
                    return bl3;
                }
                if ((double)n3 > d4) {
                    object = Logging.getControlsLogger();
                    if (((PlatformLogger)object).isLoggable(PlatformLogger$Level.INFO)) {
                        ((PlatformLogger)object).info("index exceeds maxCellCount. Check size calculations for " + String.valueOf(indexedCell.getClass()));
                    }
                    return bl3;
                }
            }
            object = this.getAvailableCell(n3);
            this.setCellIndex(object, n3);
            this.resizeCell(object);
            this.cells.addLast(object);
            this.positionCell(object, d2);
            VirtualFlow virtualFlow = this;
            virtualFlow.setMaxPrefBreadth(Math.max(virtualFlow.getMaxPrefBreadth(), this.getCellBreadth(object)));
            d2 += this.getCellLength(object);
            ((Node)object).setVisible(true);
            ++n3;
        }
        object = (IndexedCell)this.cells.getFirst();
        n3 = this.getCellIndex(object);
        indexedCell = this.getLastVisibleCell();
        double d5 = this.getCellPosition(object);
        double d6 = this.getCellPosition(indexedCell) + this.getCellLength(indexedCell);
        if ((n3 != 0 || n3 == 0 && d5 < 0.0) && bl2 && indexedCell != null && this.getCellIndex(indexedCell) == n2 - 1 && d6 < d3) {
            double d7;
            double d8 = d3 - d6;
            for (double d9 = d6; d9 < d3 && n3 != 0 && -d5 < d8; d9 += d7) {
                T t2 = this.getAvailableCell(--n3);
                this.setCellIndex(t2, n3);
                this.resizeCell(t2);
                this.cells.addFirst(t2);
                d7 = this.getCellLength(t2);
                this.positionCell(t2, d5 -= d7);
                VirtualFlow virtualFlow = this;
                virtualFlow.setMaxPrefBreadth(Math.max(virtualFlow.getMaxPrefBreadth(), this.getCellBreadth(t2)));
                ((Node)t2).setVisible(true);
            }
            object = (IndexedCell)this.cells.getFirst();
            d5 = this.getCellPosition(object);
            double d10 = d3 - d6;
            if (this.getCellIndex(object) == 0 && d10 > -d5) {
                d10 = -d5;
            }
            for (int i2 = 0; i2 < this.cells.size(); ++i2) {
                IndexedCell indexedCell2 = (IndexedCell)this.cells.get(i2);
                this.positionCell(indexedCell2, this.getCellPosition(indexedCell2) + d10);
            }
            d5 = this.getCellPosition(object);
            if (this.getCellIndex(object) == 0 && d5 == 0.0) {
                this.setPosition(0.0);
            } else if (this.getPosition() != 1.0) {
                this.setPosition(1.0);
            }
        }
        return bl3;
    }

    protected void reconfigureCells() {
        this.needsReconfigureCells = true;
        ((Parent)this).requestLayout();
    }

    protected void recreateCells() {
        this.needsRecreateCells = true;
        ((Parent)this).requestLayout();
    }

    protected void rebuildCells() {
        this.needsRebuildCells = true;
        ((Parent)this).requestLayout();
    }

    protected void requestCellLayout() {
        this.needsCellsLayout = true;
        ((Parent)this).requestLayout();
    }

    void setCellDirty(int n2) {
        this.dirtyCells.set(n2);
        ((Parent)this).requestLayout();
    }

    void getCellSizesInExpectedViewport(int n2) {
        double d2;
        double d3;
        VirtualFlow virtualFlow = this;
        double d4 = virtualFlow.computeViewportOffset(virtualFlow.getPosition());
        int n3 = this.computeCurrentIndex();
        double d5 = this.getOrCreateCellSize(n2);
        if (n2 > 0) {
            this.getOrCreateCellSize(n2 - 1);
        }
        if (n2 < this.getCellCount() - 1) {
            this.getOrCreateCellSize(n2 + 1);
        }
        int n4 = n2;
        for (d3 = d5; d3 < this.viewportLength && ++n4 < this.getCellCount(); d3 += this.getOrCreateCellSize(n4)) {
        }
        if (d2 < this.viewportLength) {
            for (d3 = d5; d3 < this.viewportLength && n2-- > 0; d3 += this.getOrCreateCellSize(n2)) {
            }
        }
        this.recalculateAndImproveEstimatedSize(0, n3, d4);
    }

    private void startSBReleasedAnimation() {
        if (this.sbTouchTimeline == null) {
            this.sbTouchTimeline = new Timeline();
            this.sbTouchKF1 = new KeyFrame(Duration.millis(0.0), actionEvent -> {
                this.tempVisibility = true;
                ((Parent)this).requestLayout();
            }, new KeyValue[0]);
            this.sbTouchKF2 = new KeyFrame(Duration.millis(1000.0), actionEvent -> {
                if (!this.touchDetected && !this.mouseDown) {
                    this.tempVisibility = false;
                    ((Parent)this).requestLayout();
                }
            }, new KeyValue[0]);
            this.sbTouchTimeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{this.sbTouchKF1, this.sbTouchKF2});
        }
        this.sbTouchTimeline.playFromStart();
    }

    private void scrollBarOn() {
        this.tempVisibility = true;
        ((Parent)this).requestLayout();
    }

    void updateHbar() {
        if (!this.isVisible() || this.getScene() == null) {
            return;
        }
        if (this.isVertical()) {
            if (this.needBreadthBar) {
                this.clipView.setClipX(this.hbar.getValue());
                return;
            }
            this.clipView.setClipX(0.0);
            this.hbar.setValue(0.0);
        }
    }

    void setSuppressBreadthBar(boolean bl2) {
        this.suppressBreadthBar = bl2;
    }

    /*
     * Unable to fully structure code
     */
    private boolean computeBarVisiblity() {
        if (this.cells.isEmpty()) {
            this.needLengthBar = false;
            this.needBreadthBar = false;
            return true;
        }
        var1_1 = this.isVertical();
        var2_3 = false;
        var3_4 = var1_1 != false ? this.hbar : this.vbar;
        var1_2 = var1_1 != false ? this.vbar : this.hbar;
        var5_5 = this.getViewportBreadth();
        var4_6 = this.cells.size();
        var7_7 = this.getCellCount();
        for (var8_8 = 0; var8_8 < 2; ++var8_8) {
            block7: {
                if (this.getPosition() > 0.0 || var7_7 > var4_6) ** GOTO lbl-1000
                if (var7_7 != var4_6) break block7;
                v0 = this;
                v1 = this;
                if (v0.getCellPosition((IndexedCell)v0.cells.getLast()) + v1.getCellLength((IndexedCell)v1.cells.getLast()) > this.getViewportLength()) ** GOTO lbl-1000
            }
            if (var7_7 == var4_6 - 1 && var2_3 && this.needBreadthBar) lbl-1000:
            // 3 sources

            {
                v2 = true;
            } else {
                v2 = var9_9 = false;
            }
            if (v2 ^ this.needLengthBar) {
                this.needLengthBar = var9_9;
                var2_3 = true;
            }
            if (!((var9_9 = this.suppressBreadthBar == false && this.maxPrefBreadth > var5_5) ^ this.needBreadthBar)) continue;
            this.needBreadthBar = var9_9;
            var2_3 = true;
        }
        if (!Properties.IS_TOUCH_SUPPORTED) {
            this.updateViewportDimensions();
            var3_4.setVisible(this.needBreadthBar);
            v3 = var1_2;
            v4 = this.needLengthBar;
        } else {
            var3_4.setVisible(this.needBreadthBar != false && this.tempVisibility != false);
            v3 = var1_2;
            v4 = this.needLengthBar != false && this.tempVisibility != false;
        }
        v3.setVisible(v4);
        return var2_3;
    }

    private void updateViewportDimensions() {
        double d2;
        VirtualFlow virtualFlow;
        double d3;
        double d4;
        boolean bl2 = this.isVertical();
        if (bl2) {
            VirtualFlow virtualFlow2 = this;
            v1 = virtualFlow2.snapSizeY(((Node)virtualFlow2.hbar).prefHeight(-1.0));
        } else {
            VirtualFlow virtualFlow3 = this;
            v1 = d4 = virtualFlow3.snapSizeX(((Node)virtualFlow3.vbar).prefWidth(-1.0));
        }
        if (bl2) {
            VirtualFlow virtualFlow4 = this;
            v4 = virtualFlow4.snapSizeX(((Node)virtualFlow4.vbar).prefWidth(-1.0));
        } else {
            VirtualFlow virtualFlow5 = this;
            v4 = d3 = virtualFlow5.snapSizeY(((Node)virtualFlow5.hbar).prefHeight(-1.0));
        }
        if (!Properties.IS_TOUCH_SUPPORTED) {
            this.setViewportBreadth((bl2 ? this.getWidth() : this.getHeight()) - (this.needLengthBar ? d3 : 0.0));
            virtualFlow = this;
            d2 = (bl2 ? this.getHeight() : this.getWidth()) - (this.needBreadthBar ? d4 : 0.0);
        } else {
            this.setViewportBreadth(bl2 ? this.getWidth() : this.getHeight());
            virtualFlow = this;
            d2 = bl2 ? this.getHeight() : this.getWidth();
        }
        virtualFlow.setViewportLength(d2);
    }

    private void initViewport() {
        boolean bl2 = this.isVertical();
        this.updateViewportDimensions();
        VirtualScrollBar virtualScrollBar = bl2 ? this.hbar : this.vbar;
        VirtualScrollBar virtualScrollBar2 = bl2 ? this.vbar : this.hbar;
        virtualScrollBar.setVirtual(false);
        virtualScrollBar2.setVirtual(true);
    }

    private void shiftDown() {
        T t2 = this.getLastVisibleCell();
        IndexedCell indexedCell = (IndexedCell)this.cells.getFirst();
        int n2 = this.getCellIndex(indexedCell);
        double d2 = this.getCellPosition(t2) + this.getCellLength(t2);
        double d3 = this.viewportLength - d2;
        if (n2 > 0 && d3 > 0.0) {
            for (int i2 = 0; i2 < this.cells.size(); ++i2) {
                IndexedCell indexedCell2 = (IndexedCell)this.cells.get(i2);
                this.positionCell(indexedCell2, this.getCellPosition(indexedCell2) + d3);
            }
        }
    }

    private void updateScrollBarsAndCells(boolean bl2) {
        double d2;
        double d3;
        boolean bl3 = this.isVertical();
        VirtualScrollBar virtualScrollBar = bl3 ? this.hbar : this.vbar;
        VirtualScrollBar virtualScrollBar2 = bl3 ? this.vbar : this.hbar;
        this.fitCells();
        if (!this.cells.isEmpty()) {
            IndexedCell indexedCell;
            int n2;
            VirtualFlow virtualFlow = this;
            d3 = -virtualFlow.computeViewportOffset(virtualFlow.getPosition());
            int n3 = this.computeCurrentIndex() - ((IndexedCell)this.cells.getFirst()).getIndex();
            int n4 = this.cells.size();
            d2 = d3;
            for (n2 = n3 - 1; n2 >= 0 && n2 < n4; --n2) {
                indexedCell = (IndexedCell)this.cells.get(n2);
                this.positionCell(indexedCell, d2 -= this.getCellLength(indexedCell));
            }
            d2 = d3;
            for (n2 = n3; n2 >= 0 && n2 < n4; ++n2) {
                indexedCell = (IndexedCell)this.cells.get(n2);
                this.positionCell(indexedCell, d2);
                d2 += this.getCellLength(indexedCell);
            }
            this.shiftDown();
        }
        this.corner.setVisible(virtualScrollBar.isVisible() && virtualScrollBar2.isVisible());
        d3 = 0.0;
        double d4 = (bl3 ? this.getHeight() : this.getWidth()) - (virtualScrollBar.isVisible() ? ((Node)virtualScrollBar).prefHeight(-1.0) : 0.0);
        d2 = this.getViewportBreadth();
        double d5 = this.getViewportLength();
        if (virtualScrollBar.isVisible()) {
            double d6;
            if (!Properties.IS_TOUCH_SUPPORTED) {
                if (bl3) {
                    this.hbar.resizeRelocate(0.0, d5, d2, ((Node)this.hbar).prefHeight(d2));
                } else {
                    this.vbar.resizeRelocate(d5, 0.0, ((Node)this.vbar).prefWidth(d2), d2);
                }
            } else if (bl3) {
                d6 = ((Node)this.hbar).prefHeight(d2);
                this.hbar.resizeRelocate(0.0, d5 - d6, d2, d6);
            } else {
                d6 = ((Node)this.vbar).prefWidth(d2);
                this.vbar.resizeRelocate(d5 - d6, 0.0, d6, d2);
            }
            if (this.getMaxPrefBreadth() != -1.0 && (d6 = Math.max(1.0, this.getMaxPrefBreadth() - d2)) != virtualScrollBar.getMax()) {
                virtualScrollBar.setMax(d6);
                double d7 = virtualScrollBar.getValue();
                boolean bl4 = d7 != 0.0 && d6 == d7;
                if (bl4 || d7 > d6) {
                    virtualScrollBar.setValue(d6);
                }
                virtualScrollBar.setVisibleAmount(d2 / this.getMaxPrefBreadth() * d6);
            }
        }
        if (bl2 && (virtualScrollBar2.isVisible() || Properties.IS_TOUCH_SUPPORTED)) {
            int n5 = this.getCellCount();
            int n6 = 0;
            int n7 = this.cells.size();
            for (int i2 = 0; i2 < n7; ++i2) {
                IndexedCell indexedCell = (IndexedCell)this.cells.get(i2);
                if (indexedCell == null || indexedCell.isEmpty()) continue;
                if ((d3 += bl3 ? indexedCell.getHeight() : indexedCell.getWidth()) > d4) break;
                ++n6;
            }
            virtualScrollBar2.setMax(1.0);
            if (n6 == 0 && n5 == 1) {
                virtualScrollBar2.setVisibleAmount(d4 / d3);
            } else {
                virtualScrollBar2.setVisibleAmount(d5 / this.estimatedSize);
            }
        }
        if (virtualScrollBar2.isVisible()) {
            if (!Properties.IS_TOUCH_SUPPORTED) {
                if (bl3) {
                    this.vbar.resizeRelocate(d2, 0.0, ((Node)this.vbar).prefWidth(d5), d5);
                } else {
                    this.hbar.resizeRelocate(0.0, d2, d5, ((Node)this.hbar).prefHeight(-1.0));
                }
            } else if (bl3) {
                double d8 = ((Node)this.vbar).prefWidth(d5);
                this.vbar.resizeRelocate(d2 - d8, 0.0, d8, d5);
            } else {
                double d9 = ((Node)this.hbar).prefHeight(-1.0);
                this.hbar.resizeRelocate(0.0, d2 - d9, d5, d9);
            }
        }
        if (this.corner.isVisible()) {
            if (!Properties.IS_TOUCH_SUPPORTED) {
                ((Node)this.corner).resize(this.vbar.getWidth(), this.hbar.getHeight());
                this.corner.relocate(this.hbar.getLayoutX() + this.hbar.getWidth(), this.vbar.getLayoutY() + this.vbar.getHeight());
            } else {
                ((Node)this.corner).resize(this.vbar.getWidth(), this.hbar.getHeight());
                this.corner.relocate(this.hbar.getLayoutX() + (this.hbar.getWidth() - this.vbar.getWidth()), this.vbar.getLayoutY() + (this.vbar.getHeight() - this.hbar.getHeight()));
                ((Node)this.hbar).resize(this.hbar.getWidth() - this.vbar.getWidth(), this.hbar.getHeight());
                ((Node)this.vbar).resize(this.vbar.getWidth(), this.vbar.getHeight() - this.hbar.getHeight());
            }
        }
        ((Node)this.clipView).resize(this.snapSizeX(bl3 ? d2 : d5), this.snapSizeY(bl3 ? d5 : d2));
        if (this.getPosition() != virtualScrollBar2.getValue()) {
            virtualScrollBar2.setValue(this.getPosition());
        }
    }

    private void fitCells() {
        for (int i2 = 0; i2 < this.cells.size(); ++i2) {
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i2);
            this.resizeCell(indexedCell);
        }
    }

    private void cull() {
        double d2 = this.getViewportLength();
        for (int i2 = this.cells.size() - 1; i2 >= 0; --i2) {
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i2);
            double d3 = this.getCellLength(indexedCell);
            double d4 = this.getCellPosition(indexedCell);
            double d5 = d4 + d3;
            if (!(d4 >= d2) && !(d5 < 0.0)) continue;
            VirtualFlow virtualFlow = this;
            virtualFlow.addToPile((IndexedCell)virtualFlow.cells.remove(i2));
        }
    }

    private void releaseCell(T t2) {
        if (this.accumCell != null && t2 == this.accumCell) {
            ((Node)this.accumCell).setVisible(false);
            ((IndexedCell)this.accumCell).updateIndex(-1);
        }
    }

    protected T getPrivateCell(int n2) {
        Callback<VirtualFlow<T>, T> callback;
        Parent parent = null;
        if (!this.cells.isEmpty()) {
            T t2 = this.getVisibleCell(n2);
            parent = (Parent)t2;
            if (t2 != null) {
                parent.layout();
                return (T)parent;
            }
        }
        if (parent == null) {
            for (int i2 = 0; i2 < this.sheetChildren.size(); ++i2) {
                IndexedCell indexedCell = (IndexedCell)this.sheetChildren.get(i2);
                if (this.getCellIndex(indexedCell) != n2) continue;
                return (T)indexedCell;
            }
        }
        if ((callback = this.getCellFactory()) != null) {
            parent = (IndexedCell)callback.call(this);
        }
        if (parent != null) {
            this.setCellIndex(parent, n2);
            this.resizeCell(parent);
            parent.setVisible(false);
            this.sheetChildren.add(parent);
            this.privateCells.add(parent);
        }
        return (T)parent;
    }

    private void releaseAllPrivateCells() {
        this.sheetChildren.removeAll((Collection<?>)this.privateCells);
        this.privateCells.clear();
    }

    private void addToPile(T t2) {
        assert (t2 != null);
        this.pile.addLast(t2);
    }

    private void cleanPile() {
        boolean bl2 = false;
        int n2 = this.pile.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IndexedCell indexedCell = (IndexedCell)this.pile.get(i2);
            bl2 = bl2 || this.doesCellContainFocus(indexedCell);
            indexedCell.setVisible(false);
        }
        if (bl2) {
            this.requestFocus();
        }
    }

    private boolean doesCellContainFocus(T t2) {
        EventTarget eventTarget = ((Node)t2).getScene();
        eventTarget = eventTarget == null ? null : ((Scene)eventTarget).getFocusOwner();
        if (eventTarget != null) {
            if (t2.equals(eventTarget)) {
                return true;
            }
            for (eventTarget = ((Node)eventTarget).getParent(); eventTarget != null && !(eventTarget instanceof VirtualFlow); eventTarget = ((Node)eventTarget).getParent()) {
                if (!t2.equals(eventTarget)) continue;
                return true;
            }
        }
        return false;
    }

    private double getPrefBreadth(double d2) {
        double d3 = this.getMaxCellWidth(10);
        if (d2 > -1.0) {
            double d4 = this.getPrefLength();
            d3 = Math.max(d3, d4 * 0.618033987);
        }
        return d3;
    }

    private double getPrefLength() {
        double d2 = 0.0;
        int n2 = Math.min(10, this.getCellCount());
        for (int i2 = 0; i2 < n2; ++i2) {
            d2 += this.getCellLength(i2);
        }
        return d2;
    }

    double getMaxCellWidth(int n2) {
        double d2 = 0.0;
        n2 = Math.max(1, n2 == -1 ? this.getCellCount() : n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            d2 = Math.max(d2, this.getCellBreadth(i2));
        }
        return d2;
    }

    private double computeViewportOffset(double d2) {
        return this.computeViewportOffset(d2, this.getCellCount());
    }

    private double computeViewportOffset(double d2, int n2) {
        double d3;
        com.sun.javafx.util.Utils.clamp(0.0, d2, 1.0);
        double d4 = 0.0;
        double d5 = this.estimatedSize / (double)n2;
        double d6 = this.estimatedSize - this.getViewportLength();
        if (d3 > 0.0 && this.absoluteOffset > d6) {
            return d6 - this.absoluteOffset;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            double d7;
            double d8 = this.getCellSize(i2);
            if (d7 < 0.0) {
                d8 = d5;
            }
            if (d4 + d8 > this.absoluteOffset) {
                return this.absoluteOffset - d4;
            }
            d4 += d8;
        }
        return 0.0;
    }

    private void adjustPositionToIndex(int n2) {
        VirtualFlow virtualFlow;
        if (n2 > 0) {
            this.getOrCreateCellSize(n2 - 1);
        }
        this.getOrCreateCellSize(n2);
        this.recalculateEstimatedSize();
        int n3 = this.getCellCount();
        if (n3 <= 0) {
            this.setPosition(0.0);
            return;
        }
        double d2 = 0.0;
        double d3 = this.estimatedSize / (double)n3;
        for (n3 = 0; n3 < n2; ++n3) {
            double d4;
            double d5 = this.getCellSize(n3);
            if (d4 < 0.0) {
                d5 = d3;
            }
            d2 += d5;
        }
        this.absoluteOffset = virtualFlow.estimatedSize < this.viewportLength ? 0.0 : d2;
        this.adjustPosition();
    }

    private double adjustByPixelAmount(double d2) {
        if (d2 == 0.0) {
            return 0.0;
        }
        if (this.absoluteOffset <= 0.0 && d2 < 0.0) {
            return 0.0;
        }
        double d3 = this.absoluteOffset;
        this.absoluteOffset = Math.max(0.0, this.absoluteOffset + d2);
        double d4 = Math.min(1.0, this.absoluteOffset / (this.estimatedSize - this.viewportLength));
        if (d2 > 0.0 && d4 < this.getPosition()) {
            d4 = this.getPosition() * 1.01;
        }
        if (d2 < 0.0 && d4 > this.getPosition()) {
            d4 = this.getPosition() * 0.99;
        }
        if (d4 > 0.95) {
            for (int i2 = this.computeCurrentIndex(); i2 < this.getCellCount(); ++i2) {
                this.getOrCreateCellSize(i2);
            }
            this.recalculateEstimatedSize();
        }
        if (d4 >= 1.0) {
            this.absoluteOffset = this.estimatedSize - this.viewportLength;
        }
        this.setPosition(d4);
        return this.absoluteOffset - d3;
    }

    private double computeBaseOffset(int n2) {
        double d2 = 0.0;
        int n3 = this.getCellCount();
        double d3 = this.estimatedSize / (double)n3;
        for (n3 = 0; n3 < n2; ++n3) {
            double d4;
            double d5 = this.getCellSize(n3);
            if (d4 < 0.0) {
                d5 = d3;
            }
            d2 += d5;
        }
        return d2;
    }

    int computeCurrentIndex() {
        VirtualFlow virtualFlow = this;
        return virtualFlow.computeCurrentIndex(virtualFlow.getCellCount());
    }

    private int computeCurrentIndex(int n2) {
        double d2 = 0.0;
        double d3 = this.estimatedSize / (double)n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4;
            double d5;
            double d6 = this.getCellSize(i2);
            if (d5 < 0.0) {
                d6 = d3;
            }
            d2 += d6;
            if (!(d4 > this.absoluteOffset)) continue;
            return i2;
        }
        if (n2 == 0) {
            return 0;
        }
        return n2 - 1;
    }

    private double computeOffsetForCell(int n2) {
        double d2 = this.getCellCount();
        double d3 = com.sun.javafx.util.Utils.clamp(0.0, (double)n2, d2) / d2;
        return -(this.getViewportLength() * d3);
    }

    double getCellSize(int n2) {
        return this.getOrCreateCellSize(n2, false);
    }

    double getOrCreateCellSize(int n2) {
        return this.getOrCreateCellSize(n2, true);
    }

    private double getOrCreateCellSize(int n2, boolean bl2) {
        double d2;
        if (n2 < 0) {
            return -1.0;
        }
        if (this.itemSizeCache.size() > n2 && this.itemSizeCache.get(n2) != null) {
            return this.itemSizeCache.get(n2);
        }
        if (!bl2) {
            return -1.0;
        }
        bl2 = false;
        while (n2 >= this.itemSizeCache.size()) {
            this.itemSizeCache.add(this.itemSizeCache.size(), null);
        }
        if (this.getFixedCellSize() > 0.0) {
            d2 = this.getFixedCellSize();
            this.itemSizeCache.set(n2, d2);
        } else {
            T t2 = this.getVisibleCell(n2);
            if (t2 == null) {
                t2 = this.getCell(n2);
                bl2 = true;
            }
            d2 = this.getCellLength(t2);
            this.itemSizeCache.set(n2, d2);
            if (bl2) {
                this.releaseCell(t2);
            }
        }
        return d2;
    }

    void updateCellSize(T t2) {
        int n2 = ((IndexedCell)t2).getIndex();
        if (this.itemSizeCache.size() > n2) {
            Double d2 = this.itemSizeCache.get(n2);
            double d3 = this.getCellLength(t2);
            this.itemSizeCache.set(n2, d3);
            if (d2 != null && !d2.equals(d3)) {
                int n3 = this.computeCurrentIndex();
                VirtualFlow virtualFlow = this;
                double d4 = virtualFlow.computeViewportOffset(virtualFlow.getPosition());
                if (n2 == n3 && d4 != 0.0) {
                    d4 = d4 + d3 - d2;
                }
                this.recalculateAndImproveEstimatedSize(0, n3, d4);
            }
        }
    }

    private void recalculateEstimatedSize() {
        this.recalculateAndImproveEstimatedSize(2);
    }

    private void recalculateAndImproveEstimatedSize(int n2) {
        VirtualFlow virtualFlow = this;
        this.recalculateAndImproveEstimatedSize(n2, -1, virtualFlow.computeViewportOffset(virtualFlow.getPosition()));
    }

    private void recalculateAndImproveEstimatedSize(int n2, int n3, double d2) {
        if (this.recalculating) {
            return;
        }
        this.recalculating = true;
        try {
            boolean bl2;
            int n4 = this.getCellCount();
            int n5 = this.itemSizeCache.size();
            boolean bl3 = bl2 = n5 > 0 && !Double.isInfinite(this.absoluteOffset);
            if (n3 < 0) {
                n3 = this.computeCurrentIndex();
            }
            for (n5 = 0; n4 > this.itemSizeCache.size() && n5 < n2; ++n5) {
                VirtualFlow virtualFlow = this;
                virtualFlow.getOrCreateCellSize(virtualFlow.itemSizeCache.size());
            }
            n5 = this.itemSizeCache.size();
            n2 = 0;
            double d3 = 0.0;
            for (int i2 = 0; i2 < n4 && i2 < n5; ++i2) {
                Double d4 = this.itemSizeCache.get(i2);
                if (d4 == null) continue;
                d3 += d4.doubleValue();
                ++n2;
            }
            this.estimatedSize = n2 == 0 ? 1.0 : d3 * (double)n4 / (double)n2;
            double d5 = this.estimatedSize / (double)n4;
            if (bl2) {
                double d6 = 0.0;
                for (n2 = 0; n2 < n3; ++n2) {
                    double d7;
                    double d8 = this.getCellSize(n2);
                    if (d7 < 0.0) {
                        d8 = d5;
                    }
                    d6 += d8;
                }
                this.absoluteOffset = d6 + d2;
                this.adjustPosition();
            }
            return;
        }
        finally {
            this.recalculating = false;
        }
    }

    private void resetSizeEstimates() {
        this.itemSizeCache.clear();
        this.estimatedSize = 1.0;
    }

    private static /* synthetic */ Event lambda$new$2(EventDispatcher eventDispatcher, EventDispatcher eventDispatcher2, Event event, EventDispatchChain eventDispatchChain) {
        if (event.getEventType() == ScrollEvent.SCROLL && !((ScrollEvent)event).isDirect()) {
            eventDispatchChain = eventDispatchChain.prepend(eventDispatcher);
            eventDispatchChain = eventDispatchChain.prepend(eventDispatcher2);
            return eventDispatchChain.dispatchEvent(event);
        }
        return eventDispatcher2.dispatchEvent(event, eventDispatchChain);
    }

    private static /* synthetic */ Event lambda$new$1(EventDispatcher eventDispatcher, EventDispatcher eventDispatcher2, Event event, EventDispatchChain eventDispatchChain) {
        if (event.getEventType() == ScrollEvent.SCROLL && !((ScrollEvent)event).isDirect()) {
            eventDispatchChain = eventDispatchChain.prepend(eventDispatcher);
            eventDispatchChain = eventDispatchChain.prepend(eventDispatcher2);
            return eventDispatchChain.dispatchEvent(event);
        }
        return eventDispatcher2.dispatchEvent(event, eventDispatchChain);
    }

    static /* synthetic */ void access$000(VirtualFlow virtualFlow, boolean bl2) {
        virtualFlow.setNeedsLayout(bl2);
    }

    static /* synthetic */ void access$100(VirtualFlow virtualFlow, boolean bl2) {
        virtualFlow.setNeedsLayout(bl2);
    }
}

