/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.util.Utils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.effect.Bloom$1;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Effect$EffectInputProperty;

public class Bloom
extends Effect {
    private ObjectProperty<Effect> input;
    private DoubleProperty threshold;

    public Bloom() {
    }

    public Bloom(double d2) {
        this.setThreshold(d2);
    }

    @Override
    com.sun.scenario.effect.Bloom createPeer() {
        return new com.sun.scenario.effect.Bloom();
    }

    public final void setInput(Effect effect) {
        this.inputProperty().set(effect);
    }

    public final Effect getInput() {
        if (this.input == null) {
            return null;
        }
        return (Effect)this.input.get();
    }

    public final ObjectProperty<Effect> inputProperty() {
        if (this.input == null) {
            this.input = new Effect$EffectInputProperty(this, "input");
        }
        return this.input;
    }

    @Override
    boolean checkChainContains(Effect effect) {
        Effect effect2 = this.getInput();
        if (effect2 == null) {
            return false;
        }
        if (effect2 == effect) {
            return true;
        }
        return effect2.checkChainContains(effect);
    }

    public final void setThreshold(double d2) {
        this.thresholdProperty().set(d2);
    }

    public final double getThreshold() {
        if (this.threshold == null) {
            return 0.3;
        }
        return this.threshold.get();
    }

    public final DoubleProperty thresholdProperty() {
        if (this.threshold == null) {
            this.threshold = new Bloom$1(this, 0.3);
        }
        return this.threshold;
    }

    @Override
    void update() {
        Effect effect = this.getInput();
        if (effect != null) {
            effect.sync();
        }
        com.sun.scenario.effect.Bloom bloom = (com.sun.scenario.effect.Bloom)this.getPeer();
        bloom.setInput(effect == null ? null : effect.getPeer());
        bloom.setThreshold((float)Utils.clamp(0.0, this.getThreshold(), 1.0));
    }

    @Override
    BaseBounds getBounds(BaseBounds baseBounds, BaseTransform baseTransform, Node node, BoundsAccessor boundsAccessor) {
        return Bloom.getInputBounds(baseBounds, baseTransform, node, boundsAccessor, this.getInput());
    }

    @Override
    Effect copy() {
        Bloom bloom = new Bloom(this.getThreshold());
        bloom.setInput(this.getInput());
        return bloom;
    }
}

