/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow$1;
import javafx.scene.effect.DropShadow$2;
import javafx.scene.effect.DropShadow$3;
import javafx.scene.effect.DropShadow$4;
import javafx.scene.effect.DropShadow$5;
import javafx.scene.effect.DropShadow$6;
import javafx.scene.effect.DropShadow$7;
import javafx.scene.effect.DropShadow$8;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Effect$EffectInputProperty;
import javafx.scene.paint.Color;

public class DropShadow
extends Effect {
    private boolean changeIsLocal;
    private ObjectProperty<Effect> input;
    private DoubleProperty radius;
    private DoubleProperty width;
    private DoubleProperty height;
    private ObjectProperty<BlurType> blurType;
    private DoubleProperty spread;
    private ObjectProperty<Color> color;
    private DoubleProperty offsetX;
    private DoubleProperty offsetY;

    public DropShadow() {
    }

    public DropShadow(double d2, Color color) {
        this.setRadius(d2);
        this.setColor(color);
    }

    public DropShadow(double d2, double d3, double d4, Color color) {
        this.setRadius(d2);
        this.setOffsetX(d3);
        this.setOffsetY(d4);
        this.setColor(color);
    }

    public DropShadow(BlurType blurType, Color color, double d2, double d3, double d4, double d5) {
        this.setBlurType(blurType);
        this.setColor(color);
        this.setRadius(d2);
        this.setSpread(d3);
        this.setOffsetX(d4);
        this.setOffsetY(d5);
    }

    @Override
    com.sun.scenario.effect.DropShadow createPeer() {
        return new com.sun.scenario.effect.DropShadow();
    }

    public final void setInput(Effect effect) {
        this.inputProperty().set(effect);
    }

    public final Effect getInput() {
        if (this.input == null) {
            return null;
        }
        return (Effect)this.input.get();
    }

    public final ObjectProperty<Effect> inputProperty() {
        if (this.input == null) {
            this.input = new Effect$EffectInputProperty(this, "input");
        }
        return this.input;
    }

    @Override
    boolean checkChainContains(Effect effect) {
        Effect effect2 = this.getInput();
        if (effect2 == null) {
            return false;
        }
        if (effect2 == effect) {
            return true;
        }
        return effect2.checkChainContains(effect);
    }

    public final void setRadius(double d2) {
        this.radiusProperty().set(d2);
    }

    public final double getRadius() {
        if (this.radius == null) {
            return 10.0;
        }
        return this.radius.get();
    }

    public final DoubleProperty radiusProperty() {
        if (this.radius == null) {
            this.radius = new DropShadow$1(this, 10.0);
        }
        return this.radius;
    }

    private void updateRadius(double d2) {
        double d3 = d2 * 2.0 + 1.0;
        if (this.width != null && this.width.isBound()) {
            if (this.height == null || !this.height.isBound()) {
                this.setHeight(d3 * 2.0 - this.getWidth());
                return;
            }
        } else {
            if (this.height != null && this.height.isBound()) {
                this.setWidth(d3 * 2.0 - this.getHeight());
                return;
            }
            this.setWidth(d3);
            this.setHeight(d3);
        }
    }

    public final void setWidth(double d2) {
        this.widthProperty().set(d2);
    }

    public final double getWidth() {
        if (this.width == null) {
            return 21.0;
        }
        return this.width.get();
    }

    public final DoubleProperty widthProperty() {
        if (this.width == null) {
            this.width = new DropShadow$2(this, 21.0);
        }
        return this.width;
    }

    private void updateWidth(double d2) {
        if (this.radius == null || !this.radius.isBound()) {
            double d3;
            double d4 = (d2 + this.getHeight()) / 2.0;
            d4 = (d4 - 1.0) / 2.0;
            if (d3 < 0.0) {
                d4 = 0.0;
            }
            this.setRadius(d4);
            return;
        }
        if (this.height == null || !this.height.isBound()) {
            double d5 = this.getRadius() * 2.0 + 1.0;
            this.setHeight(d5 * 2.0 - d2);
        }
    }

    public final void setHeight(double d2) {
        this.heightProperty().set(d2);
    }

    public final double getHeight() {
        if (this.height == null) {
            return 21.0;
        }
        return this.height.get();
    }

    public final DoubleProperty heightProperty() {
        if (this.height == null) {
            this.height = new DropShadow$3(this, 21.0);
        }
        return this.height;
    }

    private void updateHeight(double d2) {
        if (this.radius == null || !this.radius.isBound()) {
            double d3;
            double d4 = (this.getWidth() + d2) / 2.0;
            d4 = (d4 - 1.0) / 2.0;
            if (d3 < 0.0) {
                d4 = 0.0;
            }
            this.setRadius(d4);
            return;
        }
        if (this.width == null || !this.width.isBound()) {
            double d5 = this.getRadius() * 2.0 + 1.0;
            this.setWidth(d5 * 2.0 - d2);
        }
    }

    public final void setBlurType(BlurType blurType) {
        this.blurTypeProperty().set(blurType);
    }

    public final BlurType getBlurType() {
        if (this.blurType == null) {
            return BlurType.THREE_PASS_BOX;
        }
        return (BlurType)((Object)this.blurType.get());
    }

    public final ObjectProperty<BlurType> blurTypeProperty() {
        if (this.blurType == null) {
            this.blurType = new DropShadow$4(this, BlurType.THREE_PASS_BOX);
        }
        return this.blurType;
    }

    public final void setSpread(double d2) {
        this.spreadProperty().set(d2);
    }

    public final double getSpread() {
        if (this.spread == null) {
            return 0.0;
        }
        return this.spread.get();
    }

    public final DoubleProperty spreadProperty() {
        if (this.spread == null) {
            this.spread = new DropShadow$5(this);
        }
        return this.spread;
    }

    public final void setColor(Color color) {
        this.colorProperty().set(color);
    }

    public final Color getColor() {
        if (this.color == null) {
            return Color.BLACK;
        }
        return (Color)this.color.get();
    }

    public final ObjectProperty<Color> colorProperty() {
        if (this.color == null) {
            this.color = new DropShadow$6(this, Color.BLACK);
        }
        return this.color;
    }

    public final void setOffsetX(double d2) {
        this.offsetXProperty().set(d2);
    }

    public final double getOffsetX() {
        if (this.offsetX == null) {
            return 0.0;
        }
        return this.offsetX.get();
    }

    public final DoubleProperty offsetXProperty() {
        if (this.offsetX == null) {
            this.offsetX = new DropShadow$7(this);
        }
        return this.offsetX;
    }

    public final void setOffsetY(double d2) {
        this.offsetYProperty().set(d2);
    }

    public final double getOffsetY() {
        if (this.offsetY == null) {
            return 0.0;
        }
        return this.offsetY.get();
    }

    public final DoubleProperty offsetYProperty() {
        if (this.offsetY == null) {
            this.offsetY = new DropShadow$8(this);
        }
        return this.offsetY;
    }

    private float getClampedWidth() {
        return (float)Utils.clamp(0.0, this.getWidth(), 255.0);
    }

    private float getClampedHeight() {
        return (float)Utils.clamp(0.0, this.getHeight(), 255.0);
    }

    private float getClampedSpread() {
        return (float)Utils.clamp(0.0, this.getSpread(), 1.0);
    }

    private Color getColorInternal() {
        Color color = this.getColor();
        if (color == null) {
            return Color.BLACK;
        }
        return color;
    }

    private BlurType getBlurTypeInternal() {
        BlurType blurType = this.getBlurType();
        if (blurType == null) {
            return BlurType.THREE_PASS_BOX;
        }
        return blurType;
    }

    @Override
    void update() {
        Effect effect = this.getInput();
        if (effect != null) {
            effect.sync();
        }
        com.sun.scenario.effect.DropShadow dropShadow = (com.sun.scenario.effect.DropShadow)this.getPeer();
        dropShadow.setShadowSourceInput(effect == null ? null : effect.getPeer());
        dropShadow.setContentInput(effect == null ? null : effect.getPeer());
        dropShadow.setGaussianWidth(this.getClampedWidth());
        dropShadow.setGaussianHeight(this.getClampedHeight());
        dropShadow.setSpread(this.getClampedSpread());
        dropShadow.setShadowMode(Toolkit.getToolkit().toShadowMode(this.getBlurTypeInternal()));
        dropShadow.setColor(Toolkit.getToolkit().toColor4f(this.getColorInternal()));
        dropShadow.setOffsetX((int)this.getOffsetX());
        dropShadow.setOffsetY((int)this.getOffsetY());
    }

    @Override
    BaseBounds getBounds(BaseBounds baseBounds, BaseTransform baseTransform, Node node, BoundsAccessor boundsAccessor) {
        baseBounds = DropShadow.getInputBounds(baseBounds, BaseTransform.IDENTITY_TRANSFORM, node, boundsAccessor, this.getInput());
        int n2 = (int)this.getOffsetX();
        int n3 = (int)this.getOffsetY();
        BaseBounds baseBounds2 = BaseBounds.getInstance(baseBounds.getMinX() + (float)n2, baseBounds.getMinY() + (float)n3, baseBounds.getMinZ(), baseBounds.getMaxX() + (float)n2, baseBounds.getMaxY() + (float)n3, baseBounds.getMaxZ());
        baseBounds2 = DropShadow.getShadowBounds(baseBounds2, baseTransform, this.getClampedWidth(), this.getClampedHeight(), this.getBlurTypeInternal());
        baseBounds = DropShadow.transformBounds(baseTransform, baseBounds);
        baseBounds = baseBounds.deriveWithUnion(baseBounds2);
        return baseBounds;
    }

    @Override
    Effect copy() {
        DropShadow dropShadow = new DropShadow(this.getBlurType(), this.getColor(), this.getRadius(), this.getSpread(), this.getOffsetX(), this.getOffsetY());
        dropShadow.setInput(this.getInput());
        dropShadow.setWidth(this.getWidth());
        dropShadow.setHeight(this.getHeight());
        return dropShadow;
    }
}

