/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.util.Utils;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.effect.FloatMap$1;
import javafx.scene.effect.FloatMap$2;

public class FloatMap {
    private com.sun.scenario.effect.FloatMap map;
    private float[] buf;
    private boolean mapBufferDirty = true;
    private BooleanProperty effectDirty;
    private IntegerProperty width;
    private IntegerProperty height;

    com.sun.scenario.effect.FloatMap getImpl() {
        return this.map;
    }

    private void updateBuffer() {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            int n2 = Utils.clampMax(this.getWidth(), 4096);
            int n3 = Utils.clampMax(this.getHeight(), 4096);
            n2 = n2 * n3 << 2;
            this.buf = new float[n2];
            this.mapBufferDirty = true;
        }
    }

    private void update() {
        if (this.mapBufferDirty) {
            this.map = new com.sun.scenario.effect.FloatMap(Utils.clamp(1, this.getWidth(), 4096), Utils.clamp(1, this.getHeight(), 4096));
            this.mapBufferDirty = false;
        }
        this.map.put(this.buf);
    }

    void sync() {
        if (this.isEffectDirty()) {
            this.update();
            this.clearDirty();
        }
    }

    private void setEffectDirty(boolean bl2) {
        this.effectDirtyProperty().set(bl2);
    }

    final BooleanProperty effectDirtyProperty() {
        if (this.effectDirty == null) {
            this.effectDirty = new SimpleBooleanProperty(this, "effectDirty");
        }
        return this.effectDirty;
    }

    boolean isEffectDirty() {
        if (this.effectDirty == null) {
            return false;
        }
        return this.effectDirty.get();
    }

    private void markDirty() {
        this.setEffectDirty(true);
    }

    private void clearDirty() {
        this.setEffectDirty(false);
    }

    public FloatMap() {
        this.updateBuffer();
        this.markDirty();
    }

    public FloatMap(int n2, int n3) {
        this.setWidth(n2);
        this.setHeight(n3);
        this.updateBuffer();
        this.markDirty();
    }

    public final void setWidth(int n2) {
        this.widthProperty().set(n2);
    }

    public final int getWidth() {
        if (this.width == null) {
            return 1;
        }
        return this.width.get();
    }

    public final IntegerProperty widthProperty() {
        if (this.width == null) {
            this.width = new FloatMap$1(this, 1);
        }
        return this.width;
    }

    public final void setHeight(int n2) {
        this.heightProperty().set(n2);
    }

    public final int getHeight() {
        if (this.height == null) {
            return 1;
        }
        return this.height.get();
    }

    public final IntegerProperty heightProperty() {
        if (this.height == null) {
            this.height = new FloatMap$2(this, 1);
        }
        return this.height;
    }

    public void setSample(int n2, int n3, int n4, float f2) {
        this.buf[(n2 + n3 * this.getWidth() << 2) + n4] = f2;
        this.markDirty();
    }

    public void setSamples(int n2, int n3, float f2) {
        n2 = n2 + n3 * this.getWidth() << 2;
        this.buf[n2] = f2;
        this.markDirty();
    }

    public void setSamples(int n2, int n3, float f2, float f3) {
        n2 = n2 + n3 * this.getWidth() << 2;
        this.buf[n2] = f2;
        this.buf[n2 + 1] = f3;
        this.markDirty();
    }

    public void setSamples(int n2, int n3, float f2, float f3, float f4) {
        n2 = n2 + n3 * this.getWidth() << 2;
        this.buf[n2] = f2;
        this.buf[n2 + 1] = f3;
        this.buf[n2 + 2] = f4;
        this.markDirty();
    }

    public void setSamples(int n2, int n3, float f2, float f3, float f4, float f5) {
        n2 = n2 + n3 * this.getWidth() << 2;
        this.buf[n2] = f2;
        this.buf[n2 + 1] = f3;
        this.buf[n2 + 2] = f4;
        this.buf[n2 + 3] = f5;
        this.markDirty();
    }

    FloatMap copy() {
        FloatMap floatMap = new FloatMap(this.getWidth(), this.getHeight());
        System.arraycopy(this.buf, 0, floatMap.buf, 0, this.buf.length);
        return floatMap;
    }
}

