/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Effect$EffectInputProperty;
import javafx.scene.effect.InnerShadow$1;
import javafx.scene.effect.InnerShadow$2;
import javafx.scene.effect.InnerShadow$3;
import javafx.scene.effect.InnerShadow$4;
import javafx.scene.effect.InnerShadow$5;
import javafx.scene.effect.InnerShadow$6;
import javafx.scene.effect.InnerShadow$7;
import javafx.scene.effect.InnerShadow$8;
import javafx.scene.paint.Color;

public class InnerShadow
extends Effect {
    private boolean changeIsLocal;
    private ObjectProperty<Effect> input;
    private DoubleProperty radius;
    private DoubleProperty width;
    private DoubleProperty height;
    private ObjectProperty<BlurType> blurType;
    private DoubleProperty choke;
    private ObjectProperty<Color> color;
    private DoubleProperty offsetX;
    private DoubleProperty offsetY;

    public InnerShadow() {
    }

    public InnerShadow(double d2, Color color) {
        this.setRadius(d2);
        this.setColor(color);
    }

    public InnerShadow(double d2, double d3, double d4, Color color) {
        this.setRadius(d2);
        this.setOffsetX(d3);
        this.setOffsetY(d4);
        this.setColor(color);
    }

    public InnerShadow(BlurType blurType, Color color, double d2, double d3, double d4, double d5) {
        this.setBlurType(blurType);
        this.setColor(color);
        this.setRadius(d2);
        this.setChoke(d3);
        this.setOffsetX(d4);
        this.setOffsetY(d5);
    }

    @Override
    com.sun.scenario.effect.InnerShadow createPeer() {
        return new com.sun.scenario.effect.InnerShadow();
    }

    public final void setInput(Effect effect) {
        this.inputProperty().set(effect);
    }

    public final Effect getInput() {
        if (this.input == null) {
            return null;
        }
        return (Effect)this.input.get();
    }

    public final ObjectProperty<Effect> inputProperty() {
        if (this.input == null) {
            this.input = new Effect$EffectInputProperty(this, "input");
        }
        return this.input;
    }

    @Override
    boolean checkChainContains(Effect effect) {
        Effect effect2 = this.getInput();
        if (effect2 == null) {
            return false;
        }
        if (effect2 == effect) {
            return true;
        }
        return effect2.checkChainContains(effect);
    }

    public final void setRadius(double d2) {
        this.radiusProperty().set(d2);
    }

    public final double getRadius() {
        if (this.radius == null) {
            return 10.0;
        }
        return this.radius.get();
    }

    public final DoubleProperty radiusProperty() {
        if (this.radius == null) {
            this.radius = new InnerShadow$1(this, 10.0);
        }
        return this.radius;
    }

    private void updateRadius(double d2) {
        double d3 = d2 * 2.0 + 1.0;
        if (this.width != null && this.width.isBound()) {
            if (this.height == null || !this.height.isBound()) {
                this.setHeight(d3 * 2.0 - this.getWidth());
                return;
            }
        } else {
            if (this.height != null && this.height.isBound()) {
                this.setWidth(d3 * 2.0 - this.getHeight());
                return;
            }
            this.setWidth(d3);
            this.setHeight(d3);
        }
    }

    public final void setWidth(double d2) {
        this.widthProperty().set(d2);
    }

    public final double getWidth() {
        if (this.width == null) {
            return 21.0;
        }
        return this.width.get();
    }

    public final DoubleProperty widthProperty() {
        if (this.width == null) {
            this.width = new InnerShadow$2(this, 21.0);
        }
        return this.width;
    }

    private void updateWidth(double d2) {
        if (this.radius == null || !this.radius.isBound()) {
            double d3;
            double d4 = (d2 + this.getHeight()) / 2.0;
            d4 = (d4 - 1.0) / 2.0;
            if (d3 < 0.0) {
                d4 = 0.0;
            }
            this.setRadius(d4);
            return;
        }
        if (this.height == null || !this.height.isBound()) {
            double d5 = this.getRadius() * 2.0 + 1.0;
            this.setHeight(d5 * 2.0 - d2);
        }
    }

    public final void setHeight(double d2) {
        this.heightProperty().set(d2);
    }

    public final double getHeight() {
        if (this.height == null) {
            return 21.0;
        }
        return this.height.get();
    }

    public final DoubleProperty heightProperty() {
        if (this.height == null) {
            this.height = new InnerShadow$3(this, 21.0);
        }
        return this.height;
    }

    private void updateHeight(double d2) {
        if (this.radius == null || !this.radius.isBound()) {
            double d3;
            double d4 = (this.getWidth() + d2) / 2.0;
            d4 = (d4 - 1.0) / 2.0;
            if (d3 < 0.0) {
                d4 = 0.0;
            }
            this.setRadius(d4);
            return;
        }
        if (this.width == null || !this.width.isBound()) {
            double d5 = this.getRadius() * 2.0 + 1.0;
            this.setWidth(d5 * 2.0 - d2);
        }
    }

    public final void setBlurType(BlurType blurType) {
        this.blurTypeProperty().set(blurType);
    }

    public final BlurType getBlurType() {
        if (this.blurType == null) {
            return BlurType.THREE_PASS_BOX;
        }
        return (BlurType)((Object)this.blurType.get());
    }

    public final ObjectProperty<BlurType> blurTypeProperty() {
        if (this.blurType == null) {
            this.blurType = new InnerShadow$4(this, BlurType.THREE_PASS_BOX);
        }
        return this.blurType;
    }

    public final void setChoke(double d2) {
        this.chokeProperty().set(d2);
    }

    public final double getChoke() {
        if (this.choke == null) {
            return 0.0;
        }
        return this.choke.get();
    }

    public final DoubleProperty chokeProperty() {
        if (this.choke == null) {
            this.choke = new InnerShadow$5(this);
        }
        return this.choke;
    }

    public final void setColor(Color color) {
        this.colorProperty().set(color);
    }

    public final Color getColor() {
        if (this.color == null) {
            return Color.BLACK;
        }
        return (Color)this.color.get();
    }

    public final ObjectProperty<Color> colorProperty() {
        if (this.color == null) {
            this.color = new InnerShadow$6(this, Color.BLACK);
        }
        return this.color;
    }

    public final void setOffsetX(double d2) {
        this.offsetXProperty().set(d2);
    }

    public final double getOffsetX() {
        if (this.offsetX == null) {
            return 0.0;
        }
        return this.offsetX.get();
    }

    public final DoubleProperty offsetXProperty() {
        if (this.offsetX == null) {
            this.offsetX = new InnerShadow$7(this);
        }
        return this.offsetX;
    }

    public final void setOffsetY(double d2) {
        this.offsetYProperty().set(d2);
    }

    public final double getOffsetY() {
        if (this.offsetY == null) {
            return 0.0;
        }
        return this.offsetY.get();
    }

    public final DoubleProperty offsetYProperty() {
        if (this.offsetY == null) {
            this.offsetY = new InnerShadow$8(this);
        }
        return this.offsetY;
    }

    private Color getColorInternal() {
        Color color = this.getColor();
        if (color == null) {
            return Color.BLACK;
        }
        return color;
    }

    private BlurType getBlurTypeInternal() {
        BlurType blurType = this.getBlurType();
        if (blurType == null) {
            return BlurType.THREE_PASS_BOX;
        }
        return blurType;
    }

    @Override
    void update() {
        Effect effect = this.getInput();
        if (effect != null) {
            effect.sync();
        }
        com.sun.scenario.effect.InnerShadow innerShadow = (com.sun.scenario.effect.InnerShadow)this.getPeer();
        innerShadow.setShadowSourceInput(effect == null ? null : effect.getPeer());
        innerShadow.setContentInput(effect == null ? null : effect.getPeer());
        innerShadow.setGaussianWidth((float)Utils.clamp(0.0, this.getWidth(), 255.0));
        innerShadow.setGaussianHeight((float)Utils.clamp(0.0, this.getHeight(), 255.0));
        innerShadow.setShadowMode(Toolkit.getToolkit().toShadowMode(this.getBlurTypeInternal()));
        innerShadow.setColor(Toolkit.getToolkit().toColor4f(this.getColorInternal()));
        innerShadow.setChoke((float)Utils.clamp(0.0, this.getChoke(), 1.0));
        innerShadow.setOffsetX((int)this.getOffsetX());
        innerShadow.setOffsetY((int)this.getOffsetY());
    }

    @Override
    BaseBounds getBounds(BaseBounds baseBounds, BaseTransform baseTransform, Node node, BoundsAccessor boundsAccessor) {
        return InnerShadow.getInputBounds(baseBounds, baseTransform, node, boundsAccessor, this.getInput());
    }

    @Override
    Effect copy() {
        InnerShadow innerShadow = new InnerShadow(this.getBlurType(), this.getColor(), this.getRadius(), this.getChoke(), this.getOffsetX(), this.getOffsetY());
        innerShadow.setInput(this.getInput());
        innerShadow.setWidth(this.getWidth());
        innerShadow.setHeight(this.getHeight());
        return innerShadow;
    }
}

