/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.tk.Toolkit;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.effect.Light$1;
import javafx.scene.paint.Color;

public abstract class Light {
    private com.sun.scenario.effect.light.Light peer;
    private ObjectProperty<Color> color;
    private BooleanProperty effectDirty;

    protected Light() {
        this.markDirty();
    }

    abstract com.sun.scenario.effect.light.Light createPeer();

    com.sun.scenario.effect.light.Light getPeer() {
        if (this.peer == null) {
            this.peer = this.createPeer();
        }
        return this.peer;
    }

    public final void setColor(Color color) {
        this.colorProperty().set(color);
    }

    public final Color getColor() {
        if (this.color == null) {
            return Color.WHITE;
        }
        return (Color)this.color.get();
    }

    public final ObjectProperty<Color> colorProperty() {
        if (this.color == null) {
            this.color = new Light$1(this, Color.WHITE);
        }
        return this.color;
    }

    void sync() {
        if (this.isEffectDirty()) {
            this.update();
            this.clearDirty();
        }
    }

    private Color getColorInternal() {
        Color color = this.getColor();
        if (color == null) {
            return Color.WHITE;
        }
        return color;
    }

    void update() {
        this.getPeer().setColor(Toolkit.getToolkit().toColor4f(this.getColorInternal()));
    }

    private void setEffectDirty(boolean bl2) {
        this.effectDirtyProperty().set(bl2);
    }

    final BooleanProperty effectDirtyProperty() {
        if (this.effectDirty == null) {
            this.effectDirty = new SimpleBooleanProperty(this, "effectDirty");
        }
        return this.effectDirty;
    }

    boolean isEffectDirty() {
        if (this.effectDirty == null) {
            return false;
        }
        return this.effectDirty.get();
    }

    final void markDirty() {
        this.setEffectDirty(true);
    }

    final void clearDirty() {
        this.setEffectDirty(false);
    }
}

