/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.util.Utils;
import com.sun.scenario.effect.PhongLighting;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Effect$EffectInputProperty;
import javafx.scene.effect.Light;
import javafx.scene.effect.Light$Distant;
import javafx.scene.effect.Lighting$1;
import javafx.scene.effect.Lighting$2;
import javafx.scene.effect.Lighting$3;
import javafx.scene.effect.Lighting$4;
import javafx.scene.effect.Lighting$5;
import javafx.scene.effect.Lighting$LightChangeListener;
import javafx.scene.effect.Shadow;

public class Lighting
extends Effect {
    private final Light defaultLight = new Light$Distant();
    private ObjectProperty<Light> light = new Lighting$1(this, new Light$Distant());
    private final Lighting$LightChangeListener lightChangeListener = new Lighting$LightChangeListener(this);
    private ObjectProperty<Effect> bumpInput;
    private ObjectProperty<Effect> contentInput;
    private DoubleProperty diffuseConstant;
    private DoubleProperty specularConstant;
    private DoubleProperty specularExponent;
    private DoubleProperty surfaceScale;

    @Override
    PhongLighting createPeer() {
        return new PhongLighting(this.getLightInternal().getPeer());
    }

    public Lighting() {
        Shadow shadow = new Shadow();
        shadow.setRadius(10.0);
        this.setBumpInput(shadow);
    }

    public Lighting(Light light) {
        Shadow shadow = new Shadow();
        shadow.setRadius(10.0);
        this.setBumpInput(shadow);
        this.setLight(light);
    }

    public final void setLight(Light light) {
        this.lightProperty().set(light);
    }

    public final Light getLight() {
        return (Light)this.light.get();
    }

    public final ObjectProperty<Light> lightProperty() {
        return this.light;
    }

    @Override
    Effect copy() {
        Lighting lighting = new Lighting(this.getLight());
        lighting.setBumpInput(this.getBumpInput());
        lighting.setContentInput(this.getContentInput());
        lighting.setDiffuseConstant(this.getDiffuseConstant());
        lighting.setSpecularConstant(this.getSpecularConstant());
        lighting.setSpecularExponent(this.getSpecularExponent());
        lighting.setSurfaceScale(this.getSurfaceScale());
        return lighting;
    }

    public final void setBumpInput(Effect effect) {
        this.bumpInputProperty().set(effect);
    }

    public final Effect getBumpInput() {
        if (this.bumpInput == null) {
            return null;
        }
        return (Effect)this.bumpInput.get();
    }

    public final ObjectProperty<Effect> bumpInputProperty() {
        if (this.bumpInput == null) {
            this.bumpInput = new Effect$EffectInputProperty(this, "bumpInput");
        }
        return this.bumpInput;
    }

    public final void setContentInput(Effect effect) {
        this.contentInputProperty().set(effect);
    }

    public final Effect getContentInput() {
        if (this.contentInput == null) {
            return null;
        }
        return (Effect)this.contentInput.get();
    }

    public final ObjectProperty<Effect> contentInputProperty() {
        if (this.contentInput == null) {
            this.contentInput = new Effect$EffectInputProperty(this, "contentInput");
        }
        return this.contentInput;
    }

    @Override
    boolean checkChainContains(Effect effect) {
        Effect effect2 = this.getBumpInput();
        Effect effect3 = this.getContentInput();
        if (effect3 == effect || effect2 == effect) {
            return true;
        }
        if (effect3 != null && effect3.checkChainContains(effect)) {
            return true;
        }
        return effect2 != null && effect2.checkChainContains(effect);
    }

    public final void setDiffuseConstant(double d2) {
        this.diffuseConstantProperty().set(d2);
    }

    public final double getDiffuseConstant() {
        if (this.diffuseConstant == null) {
            return 1.0;
        }
        return this.diffuseConstant.get();
    }

    public final DoubleProperty diffuseConstantProperty() {
        if (this.diffuseConstant == null) {
            this.diffuseConstant = new Lighting$2(this, 1.0);
        }
        return this.diffuseConstant;
    }

    public final void setSpecularConstant(double d2) {
        this.specularConstantProperty().set(d2);
    }

    public final double getSpecularConstant() {
        if (this.specularConstant == null) {
            return 0.3;
        }
        return this.specularConstant.get();
    }

    public final DoubleProperty specularConstantProperty() {
        if (this.specularConstant == null) {
            this.specularConstant = new Lighting$3(this, 0.3);
        }
        return this.specularConstant;
    }

    public final void setSpecularExponent(double d2) {
        this.specularExponentProperty().set(d2);
    }

    public final double getSpecularExponent() {
        if (this.specularExponent == null) {
            return 20.0;
        }
        return this.specularExponent.get();
    }

    public final DoubleProperty specularExponentProperty() {
        if (this.specularExponent == null) {
            this.specularExponent = new Lighting$4(this, 20.0);
        }
        return this.specularExponent;
    }

    public final void setSurfaceScale(double d2) {
        this.surfaceScaleProperty().set(d2);
    }

    public final double getSurfaceScale() {
        if (this.surfaceScale == null) {
            return 1.5;
        }
        return this.surfaceScale.get();
    }

    public final DoubleProperty surfaceScaleProperty() {
        if (this.surfaceScale == null) {
            this.surfaceScale = new Lighting$5(this, 1.5);
        }
        return this.surfaceScale;
    }

    private Light getLightInternal() {
        Light light = this.getLight();
        if (light == null) {
            return this.defaultLight;
        }
        return light;
    }

    @Override
    void update() {
        Effect effect;
        Effect effect2 = this.getBumpInput();
        if (effect2 != null) {
            effect2.sync();
        }
        if ((effect = this.getContentInput()) != null) {
            effect.sync();
        }
        PhongLighting phongLighting = (PhongLighting)this.getPeer();
        phongLighting.setBumpInput(effect2 == null ? null : effect2.getPeer());
        phongLighting.setContentInput(effect == null ? null : effect.getPeer());
        phongLighting.setDiffuseConstant((float)Utils.clamp(0.0, this.getDiffuseConstant(), 2.0));
        phongLighting.setSpecularConstant((float)Utils.clamp(0.0, this.getSpecularConstant(), 2.0));
        phongLighting.setSpecularExponent((float)Utils.clamp(0.0, this.getSpecularExponent(), 40.0));
        phongLighting.setSurfaceScale((float)Utils.clamp(0.0, this.getSurfaceScale(), 10.0));
        this.lightChangeListener.register(this.getLight());
        this.getLightInternal().sync();
        phongLighting.setLight(this.getLightInternal().getPeer());
    }

    @Override
    BaseBounds getBounds(BaseBounds baseBounds, BaseTransform baseTransform, Node node, BoundsAccessor boundsAccessor) {
        return Lighting.getInputBounds(baseBounds, baseTransform, node, boundsAccessor, this.getContentInput());
    }
}

