/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.scene.input.InputEventUtils;
import com.sun.javafx.tk.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point3D;
import javafx.scene.input.InputEvent;
import javafx.scene.input.PickResult;

public class GestureEvent
extends InputEvent {
    private static final long serialVersionUID = 20121107L;
    public static final EventType<GestureEvent> ANY = new EventType<InputEvent>(InputEvent.ANY, "GESTURE");
    private transient double x;
    private transient double y;
    private transient double z;
    private final double screenX;
    private final double screenY;
    private final double sceneX;
    private final double sceneY;
    private final boolean shiftDown;
    private final boolean controlDown;
    private final boolean altDown;
    private final boolean metaDown;
    private final boolean direct;
    private final boolean inertia;
    private PickResult pickResult;

    @Deprecated(since="8")
    protected GestureEvent(EventType<? extends GestureEvent> eventType) {
        this(eventType, 0.0, 0.0, 0.0, 0.0, false, false, false, false, false, false, null);
    }

    @Deprecated(since="8")
    protected GestureEvent(Object object, EventTarget eventTarget, EventType<? extends GestureEvent> eventType) {
        super(object, eventTarget, (EventType<? extends InputEvent>)eventType);
        GestureEvent gestureEvent = this;
        GestureEvent gestureEvent2 = this;
        GestureEvent gestureEvent3 = this;
        gestureEvent3.sceneY = 0.0;
        gestureEvent3.sceneX = 0.0;
        gestureEvent2.screenY = 0.0;
        gestureEvent2.screenX = 0.0;
        gestureEvent.y = 0.0;
        gestureEvent.x = 0.0;
        GestureEvent gestureEvent4 = this;
        GestureEvent gestureEvent5 = this;
        GestureEvent gestureEvent6 = this;
        gestureEvent6.inertia = false;
        gestureEvent6.direct = false;
        gestureEvent5.metaDown = false;
        gestureEvent5.altDown = false;
        gestureEvent4.controlDown = false;
        gestureEvent4.shiftDown = false;
    }

    protected GestureEvent(Object object, EventTarget eventTarget, EventType<? extends GestureEvent> eventType, double d2, double d3, double d4, double d5, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, PickResult pickResult) {
        super(object, eventTarget, (EventType<? extends InputEvent>)eventType);
        this.x = d2;
        this.y = d3;
        this.screenX = d4;
        this.screenY = d5;
        this.sceneX = d2;
        this.sceneY = d3;
        this.shiftDown = bl2;
        this.controlDown = bl3;
        this.altDown = bl4;
        this.metaDown = bl5;
        this.direct = bl6;
        this.inertia = bl7;
        this.pickResult = pickResult != null ? pickResult : new PickResult(eventTarget, d2, d3);
        object = InputEventUtils.recomputeCoordinates(this.pickResult, null);
        this.x = ((Point3D)object).getX();
        this.y = ((Point3D)object).getY();
        this.z = ((Point3D)object).getZ();
    }

    protected GestureEvent(EventType<? extends GestureEvent> eventType, double d2, double d3, double d4, double d5, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, PickResult pickResult) {
        this(null, null, eventType, d2, d3, d4, d5, bl2, bl3, bl4, bl5, bl6, bl7, pickResult);
    }

    private void recomputeCoordinatesToSource(GestureEvent gestureEvent, Object object) {
        object = InputEventUtils.recomputeCoordinates(this.pickResult, object);
        gestureEvent.x = ((Point3D)object).getX();
        gestureEvent.y = ((Point3D)object).getY();
        gestureEvent.z = ((Point3D)object).getZ();
    }

    @Override
    public GestureEvent copyFor(Object object, EventTarget object2) {
        object2 = (GestureEvent)super.copyFor(object, (EventTarget)object2);
        this.recomputeCoordinatesToSource((GestureEvent)object2, object);
        return object2;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getScreenX() {
        return this.screenX;
    }

    public final double getScreenY() {
        return this.screenY;
    }

    public final double getSceneX() {
        return this.sceneX;
    }

    public final double getSceneY() {
        return this.sceneY;
    }

    public final boolean isShiftDown() {
        return this.shiftDown;
    }

    public final boolean isControlDown() {
        return this.controlDown;
    }

    public final boolean isAltDown() {
        return this.altDown;
    }

    public final boolean isMetaDown() {
        return this.metaDown;
    }

    public final boolean isDirect() {
        return this.direct;
    }

    public boolean isInertia() {
        return this.inertia;
    }

    public final PickResult getPickResult() {
        return this.pickResult;
    }

    public final boolean isShortcutDown() {
        switch (Toolkit.getToolkit().getPlatformShortcutKey()) {
            case SHIFT: {
                return this.shiftDown;
            }
            case CONTROL: {
                return this.controlDown;
            }
            case ALT: {
                return this.altDown;
            }
            case META: {
                return this.metaDown;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("GestureEvent [");
        stringBuilder.append("source = ").append(this.getSource());
        stringBuilder.append(", target = ").append(this.getTarget());
        stringBuilder.append(", eventType = ").append(((Event)this).getEventType());
        stringBuilder.append(", consumed = ").append(this.isConsumed());
        stringBuilder.append(", x = ").append(this.getX()).append(", y = ").append(this.getY()).append(", z = ").append(this.getZ());
        stringBuilder.append(this.isDirect() ? ", direct" : ", indirect");
        if (this.isInertia()) {
            stringBuilder.append(", inertia");
        }
        if (this.isShiftDown()) {
            stringBuilder.append(", shiftDown");
        }
        if (this.isControlDown()) {
            stringBuilder.append(", controlDown");
        }
        if (this.isAltDown()) {
            stringBuilder.append(", altDown");
        }
        if (this.isMetaDown()) {
            stringBuilder.append(", metaDown");
        }
        if (this.isShortcutDown()) {
            stringBuilder.append(", shortcutDown");
        }
        stringBuilder.append(", pickResult = ").append(this.getPickResult());
        return stringBuilder.append("]").toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.x = this.sceneX;
        this.y = this.sceneY;
    }

    public EventType<? extends GestureEvent> getEventType() {
        return super.getEventType();
    }
}

