/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.scene.input.InputEventUtils;
import com.sun.javafx.scene.input.TouchPointHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javafx.beans.NamedArg;
import javafx.event.EventTarget;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.PickResult;
import javafx.scene.input.TouchPoint$1;
import javafx.scene.input.TouchPoint$State;

public final class TouchPoint
implements Serializable {
    private transient EventTarget target;
    private transient Object source;
    private EventTarget grabbed = null;
    private int id;
    private TouchPoint$State state;
    private transient double x;
    private transient double y;
    private transient double z;
    private double screenX;
    private double screenY;
    private double sceneX;
    private double sceneY;
    private PickResult pickResult;

    public TouchPoint(@NamedArg(value="id") int n2, @NamedArg(value="state") TouchPoint$State touchPoint$State, @NamedArg(value="x") double d2, @NamedArg(value="y") double d3, @NamedArg(value="screenX") double d4, @NamedArg(value="screenY") double d5, @NamedArg(value="target") EventTarget eventTarget, @NamedArg(value="pickResult") PickResult pickResult) {
        this.target = eventTarget;
        this.id = n2;
        this.state = touchPoint$State;
        this.x = d2;
        this.y = d3;
        this.sceneX = d2;
        this.sceneY = d3;
        this.screenX = d4;
        this.screenY = d5;
        this.pickResult = pickResult != null ? pickResult : new PickResult(eventTarget, d2, d3);
        Point3D point3D = InputEventUtils.recomputeCoordinates(this.pickResult, null);
        this.x = point3D.getX();
        this.y = point3D.getY();
        this.z = point3D.getZ();
    }

    final void recomputeToSource(Object object, Object object2) {
        object = InputEventUtils.recomputeCoordinates(this.pickResult, object2);
        this.x = ((Point3D)object).getX();
        this.y = ((Point3D)object).getY();
        this.z = ((Point3D)object).getZ();
        this.source = object2;
    }

    public final boolean belongsTo(EventTarget eventTarget) {
        if (this.target instanceof Node) {
            Node node;
            if (eventTarget instanceof Scene) {
                return node.getScene() == eventTarget;
            }
            for (node = (Node)this.target; node != null; node = node.getParent()) {
                if (node != eventTarget) continue;
                return true;
            }
        }
        return eventTarget == this.target;
    }

    final void reset() {
        Point3D point3D = InputEventUtils.recomputeCoordinates(this.pickResult, null);
        this.x = point3D.getX();
        this.y = point3D.getY();
        this.z = point3D.getZ();
    }

    public final EventTarget getGrabbed() {
        return this.grabbed;
    }

    public final void grab() {
        if (this.source instanceof EventTarget) {
            this.grabbed = (EventTarget)this.source;
            return;
        }
        throw new IllegalStateException("Cannot grab touch point, source is not an instance of EventTarget: " + String.valueOf(this.source));
    }

    public final void grab(EventTarget eventTarget) {
        this.grabbed = eventTarget;
    }

    public final void ungrab() {
        this.grabbed = null;
    }

    public final int getId() {
        return this.id;
    }

    public final TouchPoint$State getState() {
        return this.state;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getScreenX() {
        return this.screenX;
    }

    public final double getScreenY() {
        return this.screenY;
    }

    public final double getSceneX() {
        return this.sceneX;
    }

    public final double getSceneY() {
        return this.sceneY;
    }

    public final PickResult getPickResult() {
        return this.pickResult;
    }

    public final EventTarget getTarget() {
        return this.target;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("TouchPoint [");
        stringBuilder.append("state = ").append((Object)this.getState());
        stringBuilder.append(", id = ").append(this.getId());
        stringBuilder.append(", target = ").append(this.getTarget());
        stringBuilder.append(", x = ").append(this.getX()).append(", y = ").append(this.getY()).append(", z = ").append(this.getZ());
        stringBuilder.append(", pickResult = ").append(this.getPickResult());
        return stringBuilder.append("]").toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.x = this.sceneX;
        this.y = this.sceneY;
    }

    static {
        TouchPointHelper.setTouchPointAccessor(new TouchPoint$1());
    }
}

