/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.scene.layout.region.BorderImageSlices;
import com.sun.javafx.scene.layout.region.Margins;
import com.sun.javafx.scene.layout.region.RepeatStruct;
import java.util.Map;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.scene.image.Image;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderImage;
import javafx.scene.layout.BorderRepeat;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

class BorderConverter
extends StyleConverter<ParsedValue[], Border> {
    private static final BorderConverter BORDER_IMAGE_CONVERTER = new BorderConverter();

    public static BorderConverter getInstance() {
        return BORDER_IMAGE_CONVERTER;
    }

    private BorderConverter() {
    }

    @Override
    public Border convert(Map<CssMetaData<? extends Styleable, ?>, Object> object) {
        BorderWidths borderWidths;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n2;
        int n3;
        Insets[] insetsArray;
        int n4;
        Object[] objectArray;
        int n5;
        Object[] objectArray2;
        boolean bl2;
        Paint[][] paintArray = (Paint[][])object.get(Border.BORDER_COLOR);
        BorderStrokeStyle[][] borderStrokeStyleArray = (BorderStrokeStyle[][])object.get(Border.BORDER_STYLE);
        String[] stringArray = (String[])object.get(Border.BORDER_IMAGE_SOURCE);
        int n6 = paintArray != null && paintArray.length > 0 || borderStrokeStyleArray != null && borderStrokeStyleArray.length > 0 ? 1 : 0;
        boolean bl3 = bl2 = stringArray != null && stringArray.length > 0;
        if (n6 == 0 && !bl2) {
            return null;
        }
        BorderStroke[] borderStrokeArray = null;
        if (n6 != 0) {
            n6 = paintArray != null ? paintArray.length - 1 : -1;
            int n7 = borderStrokeStyleArray != null ? borderStrokeStyleArray.length - 1 : -1;
            int n8 = (n6 >= n7 ? n6 : n7) + 1;
            Object object6 = object.get(Border.BORDER_WIDTH);
            objectArray2 = object6 == null ? new Margins[]{} : (Margins[])object6;
            n5 = objectArray2.length - 1;
            object6 = object.get(Border.BORDER_RADIUS);
            objectArray = object6 == null ? new CornerRadii[]{} : (CornerRadii[])object6;
            n4 = objectArray.length - 1;
            object6 = object.get(Border.BORDER_INSETS);
            insetsArray = object6 == null ? new Insets[]{} : (Insets[])object6;
            n3 = insetsArray.length - 1;
            for (n2 = 0; n2 < n8; ++n2) {
                if (n7 < 0) {
                    BorderStrokeStyle[] borderStrokeStyleArray2 = new BorderStrokeStyle[4];
                    object5 = borderStrokeStyleArray2;
                    object5[2] = object5[3] = BorderStrokeStyle.SOLID;
                    object5[1] = object5[3];
                    borderStrokeStyleArray2[0] = object5[3];
                } else {
                    object5 = borderStrokeStyleArray[n2 <= n7 ? n2 : n7];
                }
                if (object5[0] == BorderStrokeStyle.NONE && object5[1] == BorderStrokeStyle.NONE && object5[2] == BorderStrokeStyle.NONE && object5[3] == BorderStrokeStyle.NONE) continue;
                if (n6 < 0) {
                    Paint[] paintArray2 = new Paint[4];
                    object4 = paintArray2;
                    object4[2] = object4[3] = Color.BLACK;
                    object4[1] = object4[3];
                    paintArray2[0] = object4[3];
                } else {
                    object4 = paintArray[n2 <= n6 ? n2 : n6];
                }
                if (borderStrokeArray == null) {
                    borderStrokeArray = new BorderStroke[n8];
                }
                Object object7 = objectArray2.length == 0 ? null : (object3 = objectArray2[n2 <= n5 ? n2 : n5]);
                Object object8 = objectArray.length == 0 ? CornerRadii.EMPTY : (object2 = objectArray[n2 <= n4 ? n2 : n4]);
                borderWidths = insetsArray.length == 0 ? null : insetsArray[n2 <= n3 ? n2 : n3];
                borderStrokeArray[n2] = new BorderStroke(object4[0], object4[1], object4[2], object4[3], object5[0], object5[1], object5[2], object5[3], (CornerRadii)object2, object3 == null ? BorderStroke.DEFAULT_WIDTHS : new BorderWidths(((Margins)object3).getTop(), ((Margins)object3).getRight(), ((Margins)object3).getBottom(), ((Margins)object3).getLeft()), (Insets)((Object)borderWidths));
            }
        }
        BorderImage[] borderImageArray = null;
        if (bl2) {
            borderImageArray = new BorderImage[stringArray.length];
            Object object9 = object.get(Border.BORDER_IMAGE_REPEAT);
            RepeatStruct[] repeatStructArray = object9 == null ? new RepeatStruct[]{} : (RepeatStruct[])object9;
            int n9 = repeatStructArray.length - 1;
            object9 = object.get(Border.BORDER_IMAGE_SLICE);
            objectArray2 = object9 == null ? new BorderImageSlices[]{} : (BorderImageSlices[])object9;
            n5 = objectArray2.length - 1;
            object9 = object.get(Border.BORDER_IMAGE_WIDTH);
            objectArray = object9 == null ? new BorderWidths[]{} : (BorderWidths[])object9;
            n4 = objectArray.length - 1;
            object9 = object.get(Border.BORDER_IMAGE_INSETS);
            insetsArray = object9 == null ? new Insets[]{} : (Insets[])object9;
            n3 = insetsArray.length - 1;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (stringArray[n2] == null) continue;
                object5 = BorderRepeat.STRETCH;
                object4 = BorderRepeat.STRETCH;
                if (repeatStructArray.length > 0) {
                    object3 = repeatStructArray[n2 <= n9 ? n2 : n9];
                    switch (((RepeatStruct)object3).repeatX) {
                        case SPACE: {
                            object5 = BorderRepeat.SPACE;
                            break;
                        }
                        case ROUND: {
                            object5 = BorderRepeat.ROUND;
                            break;
                        }
                        case REPEAT: {
                            object5 = BorderRepeat.REPEAT;
                            break;
                        }
                        case NO_REPEAT: {
                            object5 = BorderRepeat.STRETCH;
                        }
                    }
                    switch (((RepeatStruct)object3).repeatY) {
                        case SPACE: {
                            object4 = BorderRepeat.SPACE;
                            break;
                        }
                        case ROUND: {
                            object4 = BorderRepeat.ROUND;
                            break;
                        }
                        case REPEAT: {
                            object4 = BorderRepeat.REPEAT;
                            break;
                        }
                        case NO_REPEAT: {
                            object4 = BorderRepeat.STRETCH;
                        }
                    }
                }
                Object object10 = objectArray2.length > 0 ? objectArray2[n2 <= n5 ? n2 : n5] : (object3 = BorderImageSlices.DEFAULT);
                Object object11 = insetsArray.length > 0 ? insetsArray[n2 <= n3 ? n2 : n3] : (object2 = Insets.EMPTY);
                borderWidths = objectArray.length > 0 ? objectArray[n2 <= n4 ? n2 : n4] : BorderWidths.DEFAULT;
                object = StyleManager.getInstance().getCachedImage(stringArray[n2]);
                borderImageArray[n2] = new BorderImage((Image)object, borderWidths, (Insets)object2, ((BorderImageSlices)object3).widths, ((BorderImageSlices)object3).filled, (BorderRepeat)((Object)object5), (BorderRepeat)((Object)object4));
            }
        }
        if (borderStrokeArray == null && borderImageArray == null) {
            return null;
        }
        return new Border(borderStrokeArray, borderImageArray);
    }

    public String toString() {
        return "BorderConverter";
    }
}

