/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import javafx.beans.NamedArg;
import javafx.geometry.Insets;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeType;

public class BorderStroke {
    public static final BorderWidths THIN = new BorderWidths(1.0);
    public static final BorderWidths MEDIUM = new BorderWidths(3.0);
    public static final BorderWidths THICK = new BorderWidths(5.0);
    public static final BorderWidths DEFAULT_WIDTHS = THIN;
    final Paint topStroke;
    final Paint rightStroke;
    final Paint bottomStroke;
    final Paint leftStroke;
    final BorderStrokeStyle topStyle;
    final BorderStrokeStyle rightStyle;
    final BorderStrokeStyle bottomStyle;
    final BorderStrokeStyle leftStyle;
    final BorderWidths widths;
    final Insets insets;
    final Insets innerEdge;
    final Insets outerEdge;
    private final CornerRadii radii;
    private final boolean strokeUniform;
    private final int hash;

    public final Paint getTopStroke() {
        return this.topStroke;
    }

    public final Paint getRightStroke() {
        return this.rightStroke;
    }

    public final Paint getBottomStroke() {
        return this.bottomStroke;
    }

    public final Paint getLeftStroke() {
        return this.leftStroke;
    }

    public final BorderStrokeStyle getTopStyle() {
        return this.topStyle;
    }

    public final BorderStrokeStyle getRightStyle() {
        return this.rightStyle;
    }

    public final BorderStrokeStyle getBottomStyle() {
        return this.bottomStyle;
    }

    public final BorderStrokeStyle getLeftStyle() {
        return this.leftStyle;
    }

    public final BorderWidths getWidths() {
        return this.widths;
    }

    public final Insets getInsets() {
        return this.insets;
    }

    public final CornerRadii getRadii() {
        return this.radii;
    }

    public final boolean isStrokeUniform() {
        return this.strokeUniform;
    }

    public BorderStroke(@NamedArg(value="stroke") Paint paint, @NamedArg(value="style") BorderStrokeStyle borderStrokeStyle, @NamedArg(value="radii") CornerRadii cornerRadii, @NamedArg(value="widths") BorderWidths borderWidths) {
        BorderStroke borderStroke = this;
        BorderStroke borderStroke2 = this;
        borderStroke2.bottomStroke = paint == null ? Color.BLACK : paint;
        borderStroke2.rightStroke = borderStroke2.bottomStroke;
        borderStroke.topStroke = borderStroke2.bottomStroke;
        borderStroke.leftStroke = borderStroke2.bottomStroke;
        BorderStroke borderStroke3 = this;
        BorderStroke borderStroke4 = this;
        borderStroke4.leftStyle = borderStrokeStyle == null ? BorderStrokeStyle.NONE : borderStrokeStyle;
        borderStroke4.bottomStyle = borderStroke4.leftStyle;
        borderStroke3.rightStyle = borderStroke4.leftStyle;
        borderStroke3.topStyle = borderStroke4.leftStyle;
        this.radii = cornerRadii == null ? CornerRadii.EMPTY : cornerRadii;
        this.widths = borderWidths == null ? DEFAULT_WIDTHS : borderWidths;
        this.insets = Insets.EMPTY;
        this.strokeUniform = this.widths.left == this.widths.top && this.widths.left == this.widths.right && this.widths.left == this.widths.bottom;
        BorderStroke borderStroke5 = this;
        BorderStroke borderStroke6 = this;
        BorderStroke borderStroke7 = this;
        BorderStroke borderStroke8 = this;
        this.innerEdge = new Insets(borderStroke5.computeInside(borderStroke5.topStyle.getType(), this.widths.getTop()), borderStroke6.computeInside(borderStroke6.rightStyle.getType(), this.widths.getRight()), borderStroke7.computeInside(borderStroke7.bottomStyle.getType(), this.widths.getBottom()), borderStroke8.computeInside(borderStroke8.leftStyle.getType(), this.widths.getLeft()));
        BorderStroke borderStroke9 = this;
        BorderStroke borderStroke10 = this;
        BorderStroke borderStroke11 = this;
        BorderStroke borderStroke12 = this;
        this.outerEdge = new Insets(Math.max(0.0, borderStroke9.computeOutside(borderStroke9.topStyle.getType(), this.widths.getTop())), Math.max(0.0, borderStroke10.computeOutside(borderStroke10.rightStyle.getType(), this.widths.getRight())), Math.max(0.0, borderStroke11.computeOutside(borderStroke11.bottomStyle.getType(), this.widths.getBottom())), Math.max(0.0, borderStroke12.computeOutside(borderStroke12.leftStyle.getType(), this.widths.getLeft())));
        this.hash = this.preComputeHash();
    }

    public BorderStroke(@NamedArg(value="stroke") Paint paint, @NamedArg(value="style") BorderStrokeStyle borderStrokeStyle, @NamedArg(value="radii") CornerRadii cornerRadii, @NamedArg(value="widths") BorderWidths borderWidths, @NamedArg(value="insets") Insets insets) {
        Paint paint2 = paint;
        Paint paint3 = paint;
        BorderStrokeStyle borderStrokeStyle2 = borderStrokeStyle;
        BorderStrokeStyle borderStrokeStyle3 = borderStrokeStyle;
        this(paint2, paint2, paint3, paint3, borderStrokeStyle2, borderStrokeStyle2, borderStrokeStyle3, borderStrokeStyle3, cornerRadii, borderWidths, insets);
    }

    public BorderStroke(@NamedArg(value="topStroke") Paint paint, @NamedArg(value="rightStroke") Paint paint2, @NamedArg(value="bottomStroke") Paint paint3, @NamedArg(value="leftStroke") Paint paint4, @NamedArg(value="topStyle") BorderStrokeStyle borderStrokeStyle, @NamedArg(value="rightStyle") BorderStrokeStyle borderStrokeStyle2, @NamedArg(value="bottomStyle") BorderStrokeStyle borderStrokeStyle3, @NamedArg(value="leftStyle") BorderStrokeStyle borderStrokeStyle4, @NamedArg(value="radii") CornerRadii cornerRadii, @NamedArg(value="widths") BorderWidths borderWidths, @NamedArg(value="insets") Insets insets) {
        this.topStroke = paint == null ? Color.BLACK : paint;
        this.rightStroke = paint2 == null ? this.topStroke : paint2;
        this.bottomStroke = paint3 == null ? this.topStroke : paint3;
        this.leftStroke = paint4 == null ? this.rightStroke : paint4;
        this.topStyle = borderStrokeStyle == null ? BorderStrokeStyle.NONE : borderStrokeStyle;
        this.rightStyle = borderStrokeStyle2 == null ? this.topStyle : borderStrokeStyle2;
        this.bottomStyle = borderStrokeStyle3 == null ? this.topStyle : borderStrokeStyle3;
        this.leftStyle = borderStrokeStyle4 == null ? this.rightStyle : borderStrokeStyle4;
        this.radii = cornerRadii == null ? CornerRadii.EMPTY : cornerRadii;
        this.widths = borderWidths == null ? DEFAULT_WIDTHS : borderWidths;
        this.insets = insets == null ? Insets.EMPTY : insets;
        boolean bl2 = this.leftStroke.equals(this.topStroke) && this.leftStroke.equals(this.rightStroke) && this.leftStroke.equals(this.bottomStroke);
        boolean bl3 = this.widths.left == this.widths.top && this.widths.left == this.widths.right && this.widths.left == this.widths.bottom;
        boolean bl4 = this.leftStyle.equals(this.topStyle) && this.leftStyle.equals(this.rightStyle) && this.leftStyle.equals(this.bottomStyle);
        this.strokeUniform = bl2 && bl3 && bl4;
        BorderStroke borderStroke = this;
        BorderStroke borderStroke2 = this;
        BorderStroke borderStroke3 = this;
        BorderStroke borderStroke4 = this;
        this.innerEdge = new Insets(this.insets.getTop() + borderStroke.computeInside(borderStroke.topStyle.getType(), this.widths.getTop()), this.insets.getRight() + borderStroke2.computeInside(borderStroke2.rightStyle.getType(), this.widths.getRight()), this.insets.getBottom() + borderStroke3.computeInside(borderStroke3.bottomStyle.getType(), this.widths.getBottom()), this.insets.getLeft() + borderStroke4.computeInside(borderStroke4.leftStyle.getType(), this.widths.getLeft()));
        BorderStroke borderStroke5 = this;
        BorderStroke borderStroke6 = this;
        BorderStroke borderStroke7 = this;
        BorderStroke borderStroke8 = this;
        this.outerEdge = new Insets(Math.max(0.0, borderStroke5.computeOutside(borderStroke5.topStyle.getType(), this.widths.getTop()) - this.insets.getTop()), Math.max(0.0, borderStroke6.computeOutside(borderStroke6.rightStyle.getType(), this.widths.getRight()) - this.insets.getRight()), Math.max(0.0, borderStroke7.computeOutside(borderStroke7.bottomStyle.getType(), this.widths.getBottom()) - this.insets.getBottom()), Math.max(0.0, borderStroke8.computeOutside(borderStroke8.leftStyle.getType(), this.widths.getLeft()) - this.insets.getLeft()));
        this.hash = this.preComputeHash();
    }

    private int preComputeHash() {
        int n2 = this.topStroke.hashCode();
        n2 = n2 * 31 + this.rightStroke.hashCode();
        n2 = n2 * 31 + this.bottomStroke.hashCode();
        n2 = n2 * 31 + this.leftStroke.hashCode();
        n2 = n2 * 31 + this.topStyle.hashCode();
        n2 = n2 * 31 + this.rightStyle.hashCode();
        n2 = n2 * 31 + this.bottomStyle.hashCode();
        n2 = n2 * 31 + this.leftStyle.hashCode();
        n2 = n2 * 31 + this.widths.hashCode();
        n2 = n2 * 31 + this.radii.hashCode();
        n2 = n2 * 31 + this.insets.hashCode();
        return n2;
    }

    private double computeInside(StrokeType strokeType, double d2) {
        if (strokeType == StrokeType.OUTSIDE) {
            return 0.0;
        }
        if (strokeType == StrokeType.CENTERED) {
            return d2 / 2.0;
        }
        if (strokeType == StrokeType.INSIDE) {
            return d2;
        }
        throw new AssertionError((Object)"Unexpected Stroke Type");
    }

    private double computeOutside(StrokeType strokeType, double d2) {
        if (strokeType == StrokeType.OUTSIDE) {
            return d2;
        }
        if (strokeType == StrokeType.CENTERED) {
            return d2 / 2.0;
        }
        if (strokeType == StrokeType.INSIDE) {
            return 0.0;
        }
        throw new AssertionError((Object)"Unexpected Stroke Type");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (BorderStroke)object;
        if (this.hash != ((BorderStroke)object).hash) {
            return false;
        }
        if (!this.bottomStroke.equals(((BorderStroke)object).bottomStroke)) {
            return false;
        }
        if (!this.bottomStyle.equals(((BorderStroke)object).bottomStyle)) {
            return false;
        }
        if (!this.leftStroke.equals(((BorderStroke)object).leftStroke)) {
            return false;
        }
        if (!this.leftStyle.equals(((BorderStroke)object).leftStyle)) {
            return false;
        }
        if (!this.radii.equals(((BorderStroke)object).radii)) {
            return false;
        }
        if (!this.rightStroke.equals(((BorderStroke)object).rightStroke)) {
            return false;
        }
        if (!this.rightStyle.equals(((BorderStroke)object).rightStyle)) {
            return false;
        }
        if (!this.topStroke.equals(((BorderStroke)object).topStroke)) {
            return false;
        }
        if (!this.topStyle.equals(((BorderStroke)object).topStyle)) {
            return false;
        }
        if (!this.widths.equals(((BorderStroke)object).widths)) {
            return false;
        }
        return this.insets.equals(((BorderStroke)object).insets);
    }

    public int hashCode() {
        return this.hash;
    }
}

