/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public final class BorderStrokeStyle {
    private static final List<Double> DOTTED_LIST = Collections.unmodifiableList(BorderStrokeStyle.asList(0.0, 2.0));
    private static final List<Double> DASHED_LIST = Collections.unmodifiableList(BorderStrokeStyle.asList(2.0, 1.4));
    public static final BorderStrokeStyle NONE = new BorderStrokeStyle(StrokeType.INSIDE, StrokeLineJoin.MITER, StrokeLineCap.BUTT, 0.0, 0.0, null);
    public static final BorderStrokeStyle DOTTED = new BorderStrokeStyle(StrokeType.INSIDE, StrokeLineJoin.MITER, StrokeLineCap.ROUND, 10.0, 0.0, DOTTED_LIST);
    public static final BorderStrokeStyle DASHED = new BorderStrokeStyle(StrokeType.INSIDE, StrokeLineJoin.MITER, StrokeLineCap.BUTT, 10.0, 0.0, DASHED_LIST);
    public static final BorderStrokeStyle SOLID = new BorderStrokeStyle(StrokeType.INSIDE, StrokeLineJoin.MITER, StrokeLineCap.BUTT, 10.0, 0.0, null);
    private final StrokeType type;
    private final StrokeLineJoin lineJoin;
    private final StrokeLineCap lineCap;
    private final double miterLimit;
    private final double dashOffset;
    private final List<Double> dashArray;
    private final int hash;

    public final StrokeType getType() {
        return this.type;
    }

    public final StrokeLineJoin getLineJoin() {
        return this.lineJoin;
    }

    public final StrokeLineCap getLineCap() {
        return this.lineCap;
    }

    public final double getMiterLimit() {
        return this.miterLimit;
    }

    public final double getDashOffset() {
        return this.dashOffset;
    }

    public final List<Double> getDashArray() {
        return this.dashArray;
    }

    public BorderStrokeStyle(@NamedArg(value="type") StrokeType object, @NamedArg(value="lineJoin") StrokeLineJoin strokeLineJoin, @NamedArg(value="lineCap") StrokeLineCap strokeLineCap, @NamedArg(value="miterLimit") double d2, @NamedArg(value="dashOffset") double d3, @NamedArg(value="dashArray") List<Double> list) {
        long l2;
        this.type = object != null ? object : StrokeType.CENTERED;
        this.lineJoin = strokeLineJoin != null ? strokeLineJoin : StrokeLineJoin.MITER;
        this.lineCap = strokeLineCap != null ? strokeLineCap : StrokeLineCap.BUTT;
        this.miterLimit = d2;
        this.dashOffset = d3;
        if (list == null) {
            this.dashArray = Collections.emptyList();
        } else if (list == DASHED_LIST || list == DOTTED_LIST) {
            this.dashArray = list;
        } else {
            object = new ArrayList<Double>(list);
            this.dashArray = Collections.unmodifiableList(object);
        }
        int n2 = this.type.hashCode();
        n2 = n2 * 31 + this.lineJoin.hashCode();
        n2 = n2 * 31 + this.lineCap.hashCode();
        long l3 = l2 = this.miterLimit != 0.0 ? Double.doubleToLongBits(this.miterLimit) : 0L;
        n2 = n2 * 31 + (int)(l3 ^ l3 >>> 32);
        long l4 = l2 = this.dashOffset != 0.0 ? Double.doubleToLongBits(this.dashOffset) : 0L;
        n2 = n2 * 31 + (int)(l4 ^ l4 >>> 32);
        this.hash = n2 = n2 * 31 + this.dashArray.hashCode();
    }

    public final String toString() {
        if (this == NONE) {
            return "BorderStyle.NONE";
        }
        if (this == DASHED) {
            return "BorderStyle.DASHED";
        }
        if (this == DOTTED) {
            return "BorderStyle.DOTTED";
        }
        if (this == SOLID) {
            return "BorderStyle.SOLID";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BorderStyle: ");
        stringBuilder.append((Object)this.type);
        stringBuilder.append(", ");
        stringBuilder.append((Object)this.lineJoin);
        stringBuilder.append(", ");
        stringBuilder.append((Object)this.lineCap);
        stringBuilder.append(", ");
        stringBuilder.append(this.miterLimit);
        stringBuilder.append(", ");
        stringBuilder.append(this.dashOffset);
        stringBuilder.append(", [");
        if (this.dashArray != null) {
            stringBuilder.append(this.dashArray);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this == NONE && object != NONE || object == NONE && this != NONE) {
            return false;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (BorderStrokeStyle)object;
        if (this.hash != ((BorderStrokeStyle)object).hash) {
            return false;
        }
        if (Double.compare(((BorderStrokeStyle)object).dashOffset, this.dashOffset) != 0) {
            return false;
        }
        if (Double.compare(((BorderStrokeStyle)object).miterLimit, this.miterLimit) != 0) {
            return false;
        }
        if (!this.dashArray.equals(((BorderStrokeStyle)object).dashArray)) {
            return false;
        }
        if (this.lineCap != ((BorderStrokeStyle)object).lineCap) {
            return false;
        }
        if (this.lineJoin != ((BorderStrokeStyle)object).lineJoin) {
            return false;
        }
        return this.type == ((BorderStrokeStyle)object).type;
    }

    public final int hashCode() {
        return this.hash;
    }

    private static List<Double> asList(double ... dArray) {
        ArrayList<Double> arrayList = new ArrayList<Double>(dArray.length);
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            arrayList.add(dArray[i2]);
        }
        return arrayList;
    }
}

