/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javafx.scene.layout.GridPane$Interval;

final class GridPane$CompositeSize
implements Cloneable {
    double[] singleSizes;
    private SortedMap<GridPane$Interval, Double> multiSizes;
    private BitSet preset;
    private final double[] fixedPercent;
    private final double totalFixedPercent;
    private final double gap;

    public GridPane$CompositeSize(int n2, double[] dArray, double d2, double d3, double d4) {
        this.singleSizes = new double[n2];
        Arrays.fill(this.singleSizes, d4);
        this.fixedPercent = dArray;
        this.totalFixedPercent = d2;
        this.gap = d3;
    }

    private void setSize(int n2, double d2) {
        this.singleSizes[n2] = d2;
    }

    private void setPresetSize(int n2, double d2) {
        this.setSize(n2, d2);
        if (this.preset == null) {
            this.preset = new BitSet(this.singleSizes.length);
        }
        this.preset.set(n2);
    }

    private boolean isPreset(int n2) {
        if (this.preset == null) {
            return false;
        }
        return this.preset.get(n2);
    }

    private void addSize(int n2, double d2) {
        this.singleSizes[n2] = this.singleSizes[n2] + d2;
    }

    private double getSize(int n2) {
        return this.singleSizes[n2];
    }

    private void setMaxSize(int n2, double d2) {
        this.singleSizes[n2] = Math.max(this.singleSizes[n2], d2);
    }

    private void setMultiSize(int n2, int n3, double d2) {
        if (this.multiSizes == null) {
            this.multiSizes = new TreeMap<GridPane$Interval, Double>();
        }
        GridPane$Interval gridPane$Interval = new GridPane$Interval(n2, n3);
        this.multiSizes.put(gridPane$Interval, d2);
    }

    private Iterable<Map.Entry<GridPane$Interval, Double>> multiSizes() {
        if (this.multiSizes == null) {
            return Collections.EMPTY_LIST;
        }
        return this.multiSizes.entrySet();
    }

    private void setMaxMultiSize(int n2, int n3, double d2) {
        GridPane$Interval gridPane$Interval;
        Double d3;
        if (this.multiSizes == null) {
            this.multiSizes = new TreeMap<GridPane$Interval, Double>();
        }
        if ((d3 = (Double)this.multiSizes.get(gridPane$Interval = new GridPane$Interval(n2, n3))) == null) {
            this.multiSizes.put(gridPane$Interval, d2);
            return;
        }
        this.multiSizes.put(gridPane$Interval, Math.max(d2, d3));
    }

    private double getProportionalMinOrMaxSize(int n2, boolean bl2) {
        double d2 = this.singleSizes[n2];
        if (!this.isPreset(n2) && this.multiSizes != null) {
            for (GridPane$Interval gridPane$Interval : this.multiSizes.keySet()) {
                double d3;
                if (!gridPane$Interval.contains(n2)) continue;
                double d4 = d3 = (Double)this.multiSizes.get(gridPane$Interval) / (double)gridPane$Interval.size();
                for (int i2 = gridPane$Interval.begin; i2 < gridPane$Interval.end; ++i2) {
                    if (i2 == n2 || !(bl2 ? this.singleSizes[i2] > d3 : this.singleSizes[i2] < d3)) continue;
                    d4 += d3 - this.singleSizes[i2];
                }
                d2 = bl2 ? Math.max(d2, d4) : Math.min(d2, d4);
            }
        }
        return d2;
    }

    private double computeTotal(int n2, int n3) {
        double d2 = this.gap * (double)(n3 - n2 - 1);
        while (n2 < n3) {
            d2 += this.singleSizes[n2];
            ++n2;
        }
        return d2;
    }

    private double computeTotal() {
        return this.computeTotal(0, this.singleSizes.length);
    }

    private boolean allPreset(int n2, int n3) {
        if (this.preset == null) {
            return false;
        }
        while (n2 < n3) {
            if (!this.preset.get(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private double computeTotalWithMultiSize() {
        double d2 = this.computeTotal();
        if (this.multiSizes != null) {
            for (Map.Entry<GridPane$Interval, Double> entry : this.multiSizes.entrySet()) {
                GridPane$Interval gridPane$Interval = entry.getKey();
                if (this.allPreset(gridPane$Interval.begin, gridPane$Interval.end)) continue;
                double d3 = this.computeTotal(gridPane$Interval.begin, gridPane$Interval.end);
                if (!(entry.getValue() > d3)) continue;
                d2 += entry.getValue() - d3;
            }
        }
        if (this.totalFixedPercent > 0.0) {
            int n2;
            double d4 = 0.0;
            for (n2 = 0; n2 < this.fixedPercent.length; ++n2) {
                if (this.fixedPercent[n2] != 0.0) continue;
                d2 -= this.singleSizes[n2];
            }
            for (n2 = 0; n2 < this.fixedPercent.length; ++n2) {
                if (this.fixedPercent[n2] > 0.0) {
                    d2 = Math.max(d2, this.singleSizes[n2] * (100.0 / this.fixedPercent[n2]));
                    continue;
                }
                if (!(this.fixedPercent[n2] < 0.0)) continue;
                d4 += this.singleSizes[n2];
            }
            if (this.totalFixedPercent < 100.0) {
                d2 = Math.max(d2, d4 * 100.0 / (100.0 - this.totalFixedPercent));
            }
        }
        return d2;
    }

    private int getLength() {
        return this.singleSizes.length;
    }

    protected final Object clone() {
        try {
            GridPane$CompositeSize gridPane$CompositeSize = (GridPane$CompositeSize)super.clone();
            ((GridPane$CompositeSize)super.clone()).singleSizes = (double[])gridPane$CompositeSize.singleSizes.clone();
            if (this.multiSizes != null) {
                gridPane$CompositeSize.multiSizes = new TreeMap<GridPane$Interval, Double>(gridPane$CompositeSize.multiSizes);
            }
            return gridPane$CompositeSize;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    private double[] asArray() {
        return this.singleSizes;
    }
}

