/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane$1;
import javafx.scene.layout.GridPane$2;
import javafx.scene.layout.GridPane$3;
import javafx.scene.layout.GridPane$4;
import javafx.scene.layout.GridPane$5;
import javafx.scene.layout.GridPane$6;
import javafx.scene.layout.GridPane$CompositeSize;
import javafx.scene.layout.GridPane$Interval;
import javafx.scene.layout.GridPane$StyleableProperties;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.shape.Line;
import javafx.util.Callback;

public class GridPane
extends Pane {
    public static final int REMAINING = Integer.MAX_VALUE;
    private static final String MARGIN_CONSTRAINT = "gridpane-margin";
    private static final String HALIGNMENT_CONSTRAINT = "gridpane-halignment";
    private static final String VALIGNMENT_CONSTRAINT = "gridpane-valignment";
    private static final String HGROW_CONSTRAINT = "gridpane-hgrow";
    private static final String VGROW_CONSTRAINT = "gridpane-vgrow";
    private static final String ROW_INDEX_CONSTRAINT = "gridpane-row";
    private static final String COLUMN_INDEX_CONSTRAINT = "gridpane-column";
    private static final String ROW_SPAN_CONSTRAINT = "gridpane-row-span";
    private static final String COLUMN_SPAN_CONSTRAINT = "gridpane-column-span";
    private static final String FILL_WIDTH_CONSTRAINT = "gridpane-fill-width";
    private static final String FILL_HEIGHT_CONSTRAINT = "gridpane-fill-height";
    private static final Callback<Node, Insets> marginAccessor = node -> GridPane.getMargin(node);
    private static final Color GRID_LINE_COLOR = Color.rgb(30, 30, 30);
    private static final double GRID_LINE_DASH = 3.0;
    private DoubleProperty hgap;
    private DoubleProperty vgap;
    private ObjectProperty<Pos> alignment;
    private BooleanProperty gridLinesVisible;
    private final ObservableList<RowConstraints> rowConstraints = new GridPane$5(this);
    private final ObservableList<ColumnConstraints> columnConstraints = new GridPane$6(this);
    private Group gridLines;
    private Orientation bias;
    private double[] rowPercentHeight;
    private double rowPercentTotal = 0.0;
    private GridPane$CompositeSize rowMinHeight;
    private GridPane$CompositeSize rowPrefHeight;
    private GridPane$CompositeSize rowMaxHeight;
    private List<Node>[] rowBaseline;
    private double[] rowMinBaselineComplement;
    private double[] rowPrefBaselineComplement;
    private double[] rowMaxBaselineComplement;
    private Priority[] rowGrow;
    private double[] columnPercentWidth;
    private double columnPercentTotal = 0.0;
    private GridPane$CompositeSize columnMinWidth;
    private GridPane$CompositeSize columnPrefWidth;
    private GridPane$CompositeSize columnMaxWidth;
    private Priority[] columnGrow;
    private boolean metricsDirty = true;
    private boolean performingLayout = false;
    private int numRows;
    private int numColumns;
    private GridPane$CompositeSize currentHeights;
    private GridPane$CompositeSize currentWidths;

    public static void setRowIndex(Node node, Integer n2) {
        if (n2 != null && n2 < 0) {
            throw new IllegalArgumentException("rowIndex must be greater or equal to 0, but was " + n2);
        }
        GridPane.setConstraint(node, ROW_INDEX_CONSTRAINT, n2);
    }

    public static Integer getRowIndex(Node node) {
        return (Integer)GridPane.getConstraint(node, ROW_INDEX_CONSTRAINT);
    }

    public static void setColumnIndex(Node node, Integer n2) {
        if (n2 != null && n2 < 0) {
            throw new IllegalArgumentException("columnIndex must be greater or equal to 0, but was " + n2);
        }
        GridPane.setConstraint(node, COLUMN_INDEX_CONSTRAINT, n2);
    }

    public static Integer getColumnIndex(Node node) {
        return (Integer)GridPane.getConstraint(node, COLUMN_INDEX_CONSTRAINT);
    }

    public static void setRowSpan(Node node, Integer n2) {
        if (n2 != null && n2 <= 0) {
            throw new IllegalArgumentException("rowSpan must be greater or equal to 1, but was " + n2);
        }
        GridPane.setConstraint(node, ROW_SPAN_CONSTRAINT, n2);
    }

    public static Integer getRowSpan(Node node) {
        return (Integer)GridPane.getConstraint(node, ROW_SPAN_CONSTRAINT);
    }

    public static void setColumnSpan(Node node, Integer n2) {
        if (n2 != null && n2 <= 0) {
            throw new IllegalArgumentException("columnSpan must be greater or equal to 1, but was " + n2);
        }
        GridPane.setConstraint(node, COLUMN_SPAN_CONSTRAINT, n2);
    }

    public static Integer getColumnSpan(Node node) {
        return (Integer)GridPane.getConstraint(node, COLUMN_SPAN_CONSTRAINT);
    }

    public static void setMargin(Node node, Insets insets) {
        GridPane.setConstraint(node, MARGIN_CONSTRAINT, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)GridPane.getConstraint(node, MARGIN_CONSTRAINT);
    }

    private double getBaselineComplementForChild(Node node) {
        if (this.isNodePositionedByBaseline(node)) {
            return this.rowMinBaselineComplement[GridPane.getNodeRowIndex(node)];
        }
        return -1.0;
    }

    public static void setHalignment(Node node, HPos hPos) {
        GridPane.setConstraint(node, HALIGNMENT_CONSTRAINT, (Object)hPos);
    }

    public static HPos getHalignment(Node node) {
        return (HPos)((Object)GridPane.getConstraint(node, HALIGNMENT_CONSTRAINT));
    }

    public static void setValignment(Node node, VPos vPos) {
        GridPane.setConstraint(node, VALIGNMENT_CONSTRAINT, (Object)vPos);
    }

    public static VPos getValignment(Node node) {
        return (VPos)((Object)GridPane.getConstraint(node, VALIGNMENT_CONSTRAINT));
    }

    public static void setHgrow(Node node, Priority priority) {
        GridPane.setConstraint(node, HGROW_CONSTRAINT, (Object)priority);
    }

    public static Priority getHgrow(Node node) {
        return (Priority)((Object)GridPane.getConstraint(node, HGROW_CONSTRAINT));
    }

    public static void setVgrow(Node node, Priority priority) {
        GridPane.setConstraint(node, VGROW_CONSTRAINT, (Object)priority);
    }

    public static Priority getVgrow(Node node) {
        return (Priority)((Object)GridPane.getConstraint(node, VGROW_CONSTRAINT));
    }

    public static void setFillWidth(Node node, Boolean bl2) {
        GridPane.setConstraint(node, FILL_WIDTH_CONSTRAINT, bl2);
    }

    public static Boolean isFillWidth(Node node) {
        return (Boolean)GridPane.getConstraint(node, FILL_WIDTH_CONSTRAINT);
    }

    public static void setFillHeight(Node node, Boolean bl2) {
        GridPane.setConstraint(node, FILL_HEIGHT_CONSTRAINT, bl2);
    }

    public static Boolean isFillHeight(Node node) {
        return (Boolean)GridPane.getConstraint(node, FILL_HEIGHT_CONSTRAINT);
    }

    public static void setConstraints(Node node, int n2, int n3) {
        GridPane.setRowIndex(node, n3);
        GridPane.setColumnIndex(node, n2);
    }

    public static void setConstraints(Node node, int n2, int n3, int n4, int n5) {
        GridPane.setRowIndex(node, n3);
        GridPane.setColumnIndex(node, n2);
        GridPane.setRowSpan(node, n5);
        GridPane.setColumnSpan(node, n4);
    }

    public static void setConstraints(Node node, int n2, int n3, int n4, int n5, HPos hPos, VPos vPos) {
        GridPane.setRowIndex(node, n3);
        GridPane.setColumnIndex(node, n2);
        GridPane.setRowSpan(node, n5);
        GridPane.setColumnSpan(node, n4);
        GridPane.setHalignment(node, hPos);
        GridPane.setValignment(node, vPos);
    }

    public static void setConstraints(Node node, int n2, int n3, int n4, int n5, HPos hPos, VPos vPos, Priority priority, Priority priority2) {
        GridPane.setRowIndex(node, n3);
        GridPane.setColumnIndex(node, n2);
        GridPane.setRowSpan(node, n5);
        GridPane.setColumnSpan(node, n4);
        GridPane.setHalignment(node, hPos);
        GridPane.setValignment(node, vPos);
        GridPane.setHgrow(node, priority);
        GridPane.setVgrow(node, priority2);
    }

    public static void setConstraints(Node node, int n2, int n3, int n4, int n5, HPos hPos, VPos vPos, Priority priority, Priority priority2, Insets insets) {
        GridPane.setRowIndex(node, n3);
        GridPane.setColumnIndex(node, n2);
        GridPane.setRowSpan(node, n5);
        GridPane.setColumnSpan(node, n4);
        GridPane.setHalignment(node, hPos);
        GridPane.setValignment(node, vPos);
        GridPane.setHgrow(node, priority);
        GridPane.setVgrow(node, priority2);
        GridPane.setMargin(node, insets);
    }

    public static void clearConstraints(Node node) {
        GridPane.setRowIndex(node, null);
        GridPane.setColumnIndex(node, null);
        GridPane.setRowSpan(node, null);
        GridPane.setColumnSpan(node, null);
        GridPane.setHalignment(node, null);
        GridPane.setValignment(node, null);
        GridPane.setHgrow(node, null);
        GridPane.setVgrow(node, null);
        GridPane.setMargin(node, null);
    }

    static void createRow(int n2, int n3, Node ... nodeArray) {
        for (int i2 = 0; i2 < nodeArray.length; ++i2) {
            GridPane.setConstraints(nodeArray[i2], n3 + i2, n2);
        }
    }

    static void createColumn(int n2, int n3, Node ... nodeArray) {
        for (int i2 = 0; i2 < nodeArray.length; ++i2) {
            GridPane.setConstraints(nodeArray[i2], n2, n3 + i2);
        }
    }

    static int getNodeRowIndex(Node object) {
        if ((object = GridPane.getRowIndex((Node)object)) != null) {
            return (Integer)object;
        }
        return 0;
    }

    private static int getNodeRowSpan(Node object) {
        if ((object = GridPane.getRowSpan((Node)object)) != null) {
            return (Integer)object;
        }
        return 1;
    }

    static int getNodeRowEnd(Node node) {
        int n2 = GridPane.getNodeRowSpan(node);
        if (n2 != Integer.MAX_VALUE) {
            return GridPane.getNodeRowIndex(node) + n2 - 1;
        }
        return Integer.MAX_VALUE;
    }

    static int getNodeColumnIndex(Node object) {
        if ((object = GridPane.getColumnIndex((Node)object)) != null) {
            return (Integer)object;
        }
        return 0;
    }

    private static int getNodeColumnSpan(Node object) {
        if ((object = GridPane.getColumnSpan((Node)object)) != null) {
            return (Integer)object;
        }
        return 1;
    }

    static int getNodeColumnEnd(Node node) {
        int n2 = GridPane.getNodeColumnSpan(node);
        if (n2 != Integer.MAX_VALUE) {
            return GridPane.getNodeColumnIndex(node) + n2 - 1;
        }
        return Integer.MAX_VALUE;
    }

    private static Priority getNodeHgrow(Node object) {
        if ((object = GridPane.getHgrow(object)) != null) {
            return object;
        }
        return Priority.NEVER;
    }

    private static Priority getNodeVgrow(Node object) {
        if ((object = GridPane.getVgrow(object)) != null) {
            return object;
        }
        return Priority.NEVER;
    }

    private static Priority[] createPriorityArray(int n2, Priority priority) {
        Priority[] priorityArray = new Priority[n2];
        Arrays.fill((Object[])priorityArray, (Object)priority);
        return priorityArray;
    }

    public GridPane() {
        this.getChildren().addListener(observable -> ((Parent)this).requestLayout());
    }

    public GridPane(double d2, double d3) {
        this();
        this.setHgap(d2);
        this.setVgap(d3);
    }

    public final DoubleProperty hgapProperty() {
        if (this.hgap == null) {
            this.hgap = new GridPane$1(this, 0.0);
        }
        return this.hgap;
    }

    public final void setHgap(double d2) {
        this.hgapProperty().set(d2);
    }

    public final double getHgap() {
        if (this.hgap == null) {
            return 0.0;
        }
        return this.hgap.get();
    }

    public final DoubleProperty vgapProperty() {
        if (this.vgap == null) {
            this.vgap = new GridPane$2(this, 0.0);
        }
        return this.vgap;
    }

    public final void setVgap(double d2) {
        this.vgapProperty().set(d2);
    }

    public final double getVgap() {
        if (this.vgap == null) {
            return 0.0;
        }
        return this.vgap.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new GridPane$3(this, Pos.TOP_LEFT);
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        if (this.alignment == null) {
            return Pos.TOP_LEFT;
        }
        return (Pos)((Object)this.alignment.get());
    }

    private Pos getAlignmentInternal() {
        Pos pos = this.getAlignment();
        if (pos == null) {
            return Pos.TOP_LEFT;
        }
        return pos;
    }

    public final BooleanProperty gridLinesVisibleProperty() {
        if (this.gridLinesVisible == null) {
            this.gridLinesVisible = new GridPane$4(this);
        }
        return this.gridLinesVisible;
    }

    public final void setGridLinesVisible(boolean bl2) {
        this.gridLinesVisibleProperty().set(bl2);
    }

    public final boolean isGridLinesVisible() {
        if (this.gridLinesVisible == null) {
            return false;
        }
        return this.gridLinesVisible.get();
    }

    public final ObservableList<RowConstraints> getRowConstraints() {
        return this.rowConstraints;
    }

    public final ObservableList<ColumnConstraints> getColumnConstraints() {
        return this.columnConstraints;
    }

    public void add(Node node, int n2, int n3) {
        GridPane.setConstraints(node, n2, n3);
        this.getChildren().add(node);
    }

    public void add(Node node, int n2, int n3, int n4, int n5) {
        GridPane.setConstraints(node, n2, n3, n4, n5);
        this.getChildren().add(node);
    }

    public void addRow(int n2, Node ... nodeArray) {
        int n3 = 0;
        List list = this.getManagedChildren();
        int n4 = list.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            Node node = (Node)list.get(i2);
            int n5 = GridPane.getNodeRowIndex(node);
            int n6 = GridPane.getNodeRowEnd(node);
            if (n2 < n5 || n2 > n6 && n6 != Integer.MAX_VALUE) continue;
            n5 = GridPane.getNodeColumnIndex(node);
            int n7 = GridPane.getNodeColumnEnd(node);
            n3 = Math.max(n3, (n7 != Integer.MAX_VALUE ? n7 : n5) + 1);
        }
        GridPane.createRow(n2, n3, nodeArray);
        this.getChildren().addAll((Node[])nodeArray);
    }

    public void addColumn(int n2, Node ... nodeArray) {
        int n3 = 0;
        List list = this.getManagedChildren();
        int n4 = list.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            Node node = (Node)list.get(i2);
            int n5 = GridPane.getNodeColumnIndex(node);
            int n6 = GridPane.getNodeColumnEnd(node);
            if (n2 < n5 || n2 > n6 && n6 != Integer.MAX_VALUE) continue;
            n5 = GridPane.getNodeRowIndex(node);
            int n7 = GridPane.getNodeRowEnd(node);
            n3 = Math.max(n3, (n7 != Integer.MAX_VALUE ? n7 : n5) + 1);
        }
        GridPane.createColumn(n2, n3, nodeArray);
        this.getChildren().addAll((Node[])nodeArray);
    }

    private int getNumberOfRows() {
        this.computeGridMetrics();
        return this.numRows;
    }

    private int getNumberOfColumns() {
        this.computeGridMetrics();
        return this.numColumns;
    }

    private boolean isNodePositionedByBaseline(Node node) {
        return this.getRowValignment(GridPane.getNodeRowIndex(node)) == VPos.BASELINE && GridPane.getValignment(node) == null || GridPane.getValignment(node) == VPos.BASELINE;
    }

    private void computeGridMetrics() {
        if (this.metricsDirty) {
            int n2;
            int n3;
            int n4;
            this.numRows = this.rowConstraints.size();
            this.numColumns = this.columnConstraints.size();
            List list = this.getManagedChildren();
            int n5 = list.size();
            for (n4 = 0; n4 < n5; ++n4) {
                Node node = (Node)list.get(n4);
                n3 = GridPane.getNodeRowIndex(node);
                n2 = GridPane.getNodeColumnIndex(node);
                int n6 = GridPane.getNodeRowEnd(node);
                int n7 = GridPane.getNodeColumnEnd(node);
                this.numRows = Math.max(this.numRows, (n6 != Integer.MAX_VALUE ? n6 : n3) + 1);
                this.numColumns = Math.max(this.numColumns, (n7 != Integer.MAX_VALUE ? n7 : n2) + 1);
            }
            this.rowPercentHeight = GridPane.createDoubleArray(this.numRows, -1.0);
            this.rowPercentTotal = 0.0;
            this.columnPercentWidth = GridPane.createDoubleArray(this.numColumns, -1.0);
            this.columnPercentTotal = 0.0;
            this.columnGrow = GridPane.createPriorityArray(this.numColumns, Priority.NEVER);
            this.rowGrow = GridPane.createPriorityArray(this.numRows, Priority.NEVER);
            this.rowMinBaselineComplement = GridPane.createDoubleArray(this.numRows, -1.0);
            this.rowPrefBaselineComplement = GridPane.createDoubleArray(this.numRows, -1.0);
            this.rowMaxBaselineComplement = GridPane.createDoubleArray(this.numRows, -1.0);
            this.rowBaseline = new List[this.numRows];
            n5 = this.numRows;
            for (n4 = 0; n4 < n5; ++n4) {
                Object object;
                Object object2;
                if (n4 < this.rowConstraints.size()) {
                    object2 = (RowConstraints)this.rowConstraints.get(n4);
                    double d2 = ((RowConstraints)object2).getPercentHeight();
                    object = ((RowConstraints)object2).getVgrow();
                    if (d2 >= 0.0) {
                        this.rowPercentHeight[n4] = d2;
                    }
                    if (object != null) {
                        this.rowGrow[n4] = object;
                    }
                }
                object2 = new ArrayList(this.numColumns);
                n2 = list.size();
                for (n3 = 0; n3 < n2; ++n3) {
                    object = (Node)list.get(n3);
                    if (GridPane.getNodeRowIndex((Node)object) != n4 || !this.isNodePositionedByBaseline((Node)object)) continue;
                    object2.add(object);
                }
                this.rowMinBaselineComplement[n4] = GridPane.getMinBaselineComplement((List<Node>)object2);
                this.rowPrefBaselineComplement[n4] = GridPane.getPrefBaselineComplement((List<Node>)object2);
                this.rowMaxBaselineComplement[n4] = GridPane.getMaxBaselineComplement((List<Node>)object2);
                this.rowBaseline[n4] = object2;
            }
            n5 = Math.min(this.numColumns, this.columnConstraints.size());
            for (n4 = 0; n4 < n5; ++n4) {
                ColumnConstraints columnConstraints = (ColumnConstraints)this.columnConstraints.get(n4);
                double d3 = columnConstraints.getPercentWidth();
                Priority priority = columnConstraints.getHgrow();
                if (d3 >= 0.0) {
                    this.columnPercentWidth[n4] = d3;
                }
                if (priority == null) continue;
                this.columnGrow[n4] = priority;
            }
            n5 = list.size();
            for (n4 = 0; n4 < n5; ++n4) {
                Priority priority;
                Node node = (Node)list.get(n4);
                if (GridPane.getNodeColumnSpan(node) == 1) {
                    priority = GridPane.getNodeHgrow(node);
                    n2 = GridPane.getNodeColumnIndex(node);
                    this.columnGrow[n2] = Priority.max(this.columnGrow[n2], priority);
                }
                if (GridPane.getNodeRowSpan(node) != 1) continue;
                priority = GridPane.getNodeVgrow(node);
                n2 = GridPane.getNodeRowIndex(node);
                this.rowGrow[n2] = Priority.max(this.rowGrow[n2], priority);
            }
            for (n4 = 0; n4 < this.rowPercentHeight.length; ++n4) {
                if (!(this.rowPercentHeight[n4] > 0.0)) continue;
                this.rowPercentTotal += this.rowPercentHeight[n4];
            }
            if (this.rowPercentTotal > 100.0) {
                double d4 = 100.0 / this.rowPercentTotal;
                for (int i2 = 0; i2 < this.rowPercentHeight.length; ++i2) {
                    if (!(this.rowPercentHeight[i2] > 0.0)) continue;
                    int n8 = i2;
                    this.rowPercentHeight[n8] = this.rowPercentHeight[n8] * d4;
                }
                this.rowPercentTotal = 100.0;
            }
            for (int i3 = 0; i3 < this.columnPercentWidth.length; ++i3) {
                if (!(this.columnPercentWidth[i3] > 0.0)) continue;
                this.columnPercentTotal += this.columnPercentWidth[i3];
            }
            if (this.columnPercentTotal > 100.0) {
                double d5 = 100.0 / this.columnPercentTotal;
                for (int i4 = 0; i4 < this.columnPercentWidth.length; ++i4) {
                    if (!(this.columnPercentWidth[i4] > 0.0)) continue;
                    int n9 = i4;
                    this.columnPercentWidth[n9] = this.columnPercentWidth[n9] * d5;
                }
                this.columnPercentTotal = 100.0;
            }
            this.bias = null;
            for (int i5 = 0; i5 < list.size(); ++i5) {
                Orientation orientation = ((Node)list.get(i5)).getContentBias();
                if (orientation == null) continue;
                this.bias = orientation;
                if (orientation == Orientation.HORIZONTAL) break;
            }
            this.metricsDirty = false;
        }
    }

    @Override
    protected double computeMinWidth(double d2) {
        this.computeGridMetrics();
        this.performingLayout = true;
        try {
            double[] dArray = d2 == -1.0 ? null : this.computeHeightsToFit(d2).asArray();
            GridPane gridPane = this;
            GridPane gridPane2 = this;
            double d3 = gridPane.snapSpaceX(gridPane.getInsets().getLeft()) + this.computeMinWidths(dArray).computeTotalWithMultiSize() + gridPane2.snapSpaceX(gridPane2.getInsets().getRight());
            return d3;
        }
        finally {
            this.performingLayout = false;
        }
    }

    @Override
    protected double computeMinHeight(double d2) {
        this.computeGridMetrics();
        this.performingLayout = true;
        try {
            double[] dArray = d2 == -1.0 ? null : this.computeWidthsToFit(d2).asArray();
            GridPane gridPane = this;
            GridPane gridPane2 = this;
            double d3 = gridPane.snapSpaceY(gridPane.getInsets().getTop()) + this.computeMinHeights(dArray).computeTotalWithMultiSize() + gridPane2.snapSpaceY(gridPane2.getInsets().getBottom());
            return d3;
        }
        finally {
            this.performingLayout = false;
        }
    }

    @Override
    protected double computePrefWidth(double d2) {
        this.computeGridMetrics();
        this.performingLayout = true;
        try {
            double[] dArray = d2 == -1.0 ? null : this.computeHeightsToFit(d2).asArray();
            GridPane gridPane = this;
            GridPane gridPane2 = this;
            double d3 = gridPane.snapSpaceX(gridPane.getInsets().getLeft()) + this.computePrefWidths(dArray).computeTotalWithMultiSize() + gridPane2.snapSpaceX(gridPane2.getInsets().getRight());
            return d3;
        }
        finally {
            this.performingLayout = false;
        }
    }

    @Override
    protected double computePrefHeight(double d2) {
        this.computeGridMetrics();
        this.performingLayout = true;
        try {
            double[] dArray = d2 == -1.0 ? null : this.computeWidthsToFit(d2).asArray();
            GridPane gridPane = this;
            GridPane gridPane2 = this;
            double d3 = gridPane.snapSpaceY(gridPane.getInsets().getTop()) + this.computePrefHeights(dArray).computeTotalWithMultiSize() + gridPane2.snapSpaceY(gridPane2.getInsets().getBottom());
            return d3;
        }
        finally {
            this.performingLayout = false;
        }
    }

    private VPos getRowValignment(int n2) {
        RowConstraints rowConstraints;
        if (n2 < this.getRowConstraints().size() && (rowConstraints = (RowConstraints)this.getRowConstraints().get(n2)).getValignment() != null) {
            return rowConstraints.getValignment();
        }
        return VPos.CENTER;
    }

    private HPos getColumnHalignment(int n2) {
        ColumnConstraints columnConstraints;
        if (n2 < this.getColumnConstraints().size() && (columnConstraints = (ColumnConstraints)this.getColumnConstraints().get(n2)).getHalignment() != null) {
            return columnConstraints.getHalignment();
        }
        return HPos.LEFT;
    }

    private double getColumnMinWidth(int n2) {
        if (n2 < this.getColumnConstraints().size()) {
            ColumnConstraints columnConstraints = (ColumnConstraints)this.getColumnConstraints().get(n2);
            return columnConstraints.getMinWidth();
        }
        return -1.0;
    }

    private double getRowMinHeight(int n2) {
        if (n2 < this.getRowConstraints().size()) {
            RowConstraints rowConstraints = (RowConstraints)this.getRowConstraints().get(n2);
            return rowConstraints.getMinHeight();
        }
        return -1.0;
    }

    private double getColumnMaxWidth(int n2) {
        if (n2 < this.getColumnConstraints().size()) {
            ColumnConstraints columnConstraints = (ColumnConstraints)this.getColumnConstraints().get(n2);
            return columnConstraints.getMaxWidth();
        }
        return -1.0;
    }

    private double getColumnPrefWidth(int n2) {
        if (n2 < this.getColumnConstraints().size()) {
            ColumnConstraints columnConstraints = (ColumnConstraints)this.getColumnConstraints().get(n2);
            return columnConstraints.getPrefWidth();
        }
        return -1.0;
    }

    private double getRowPrefHeight(int n2) {
        if (n2 < this.getRowConstraints().size()) {
            RowConstraints rowConstraints = (RowConstraints)this.getRowConstraints().get(n2);
            return rowConstraints.getPrefHeight();
        }
        return -1.0;
    }

    private double getRowMaxHeight(int n2) {
        if (n2 < this.getRowConstraints().size()) {
            RowConstraints rowConstraints = (RowConstraints)this.getRowConstraints().get(n2);
            return rowConstraints.getMaxHeight();
        }
        return -1.0;
    }

    private boolean shouldRowFillHeight(int n2) {
        if (n2 < this.getRowConstraints().size()) {
            return ((RowConstraints)this.getRowConstraints().get(n2)).isFillHeight();
        }
        return true;
    }

    private boolean shouldColumnFillWidth(int n2) {
        if (n2 < this.getColumnConstraints().size()) {
            return ((ColumnConstraints)this.getColumnConstraints().get(n2)).isFillWidth();
        }
        return true;
    }

    private double getTotalWidthOfNodeColumns(Node node, double[] dArray) {
        if (GridPane.getNodeColumnSpan(node) == 1) {
            return dArray[GridPane.getNodeColumnIndex(node)];
        }
        double d2 = 0.0;
        int n2 = this.getNodeColumnEndConvertRemaining(node);
        for (int i2 = GridPane.getNodeColumnIndex(node); i2 <= n2; ++i2) {
            d2 += dArray[i2];
        }
        return d2;
    }

    private GridPane$CompositeSize computeMaxHeights() {
        if (this.rowMaxHeight == null) {
            this.rowMaxHeight = this.createCompositeRows(Double.MAX_VALUE);
            ObservableList<RowConstraints> observableList = this.getRowConstraints();
            GridPane$CompositeSize gridPane$CompositeSize = null;
            for (int i2 = 0; i2 < observableList.size(); ++i2) {
                double d2;
                RowConstraints rowConstraints = (RowConstraints)observableList.get(i2);
                double d3 = rowConstraints.getMaxHeight();
                if (d3 == Double.NEGATIVE_INFINITY) {
                    if (gridPane$CompositeSize == null) {
                        gridPane$CompositeSize = this.computePrefHeights(null);
                    }
                    this.rowMaxHeight.setPresetSize(i2, gridPane$CompositeSize.getSize(i2));
                    continue;
                }
                if (d3 == -1.0) continue;
                double d4 = this.snapSizeY(d3);
                double d5 = rowConstraints.getMinHeight();
                if (d2 >= 0.0) {
                    double d6 = this.snapSizeY(rowConstraints.getMinHeight());
                    double d7 = d4;
                    this.rowMaxHeight.setPresetSize(i2, GridPane.boundedSize(d6, d7, d7));
                    continue;
                }
                this.rowMaxHeight.setPresetSize(i2, d4);
            }
        }
        return this.rowMaxHeight;
    }

    private GridPane$CompositeSize computePrefHeights(double[] dArray) {
        double d2;
        double d3;
        double d4;
        GridPane$CompositeSize gridPane$CompositeSize;
        if (dArray == null) {
            if (this.rowPrefHeight != null) {
                return this.rowPrefHeight;
            }
            gridPane$CompositeSize = this.rowPrefHeight = this.createCompositeRows(0.0);
        } else {
            gridPane$CompositeSize = this.createCompositeRows(0.0);
        }
        ObservableList<RowConstraints> observableList = this.getRowConstraints();
        for (int i2 = 0; i2 < observableList.size(); ++i2) {
            RowConstraints rowConstraints = (RowConstraints)observableList.get(i2);
            double d5 = rowConstraints.getMinHeight();
            double d6 = rowConstraints.getPrefHeight();
            if (d6 != -1.0) {
                d4 = this.snapSizeY(d6);
                d3 = rowConstraints.getMaxHeight();
                if (d5 >= 0.0 || d3 >= 0.0) {
                    d2 = d5 < 0.0 ? 0.0 : this.snapSizeY(d5);
                    double d7 = d3 < 0.0 ? Double.POSITIVE_INFINITY : this.snapSizeY(d3);
                    gridPane$CompositeSize.setPresetSize(i2, GridPane.boundedSize(d2, d4, d7));
                    continue;
                }
                gridPane$CompositeSize.setPresetSize(i2, d4);
                continue;
            }
            if (!(d5 > 0.0)) continue;
            gridPane$CompositeSize.setSize(i2, this.snapSizeY(d5));
        }
        List list = this.getManagedChildren();
        int n2 = list.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            Node node = (Node)list.get(i3);
            int n3 = GridPane.getNodeRowIndex(node);
            int n4 = this.getNodeRowEndConvertRemaining(node);
            d4 = this.computeChildPrefAreaHeight(node, this.isNodePositionedByBaseline(node) ? this.rowPrefBaselineComplement[n3] : -1.0, GridPane.getMargin(node), dArray == null ? -1.0 : this.getTotalWidthOfNodeColumns(node, dArray));
            if (n3 == n4 && !gridPane$CompositeSize.isPreset(n3)) {
                d3 = this.getRowMinHeight(n3);
                d2 = this.getRowMaxHeight(n3);
                gridPane$CompositeSize.setMaxSize(n3, GridPane.boundedSize(d3 < 0.0 ? 0.0 : d3, d4, d2 < 0.0 ? Double.MAX_VALUE : d2));
                continue;
            }
            if (n3 == n4) continue;
            gridPane$CompositeSize.setMaxMultiSize(n3, n4 + 1, d4);
        }
        return gridPane$CompositeSize;
    }

    private GridPane$CompositeSize computeMinHeights(double[] dArray) {
        GridPane$CompositeSize gridPane$CompositeSize;
        if (dArray == null) {
            if (this.rowMinHeight != null) {
                return this.rowMinHeight;
            }
            gridPane$CompositeSize = this.rowMinHeight = this.createCompositeRows(0.0);
        } else {
            gridPane$CompositeSize = this.createCompositeRows(0.0);
        }
        Object object = this.getRowConstraints();
        GridPane$CompositeSize gridPane$CompositeSize2 = null;
        for (int i2 = 0; i2 < object.size(); ++i2) {
            double d2 = ((RowConstraints)object.get(i2)).getMinHeight();
            if (d2 == Double.NEGATIVE_INFINITY) {
                if (gridPane$CompositeSize2 == null) {
                    gridPane$CompositeSize2 = this.computePrefHeights(dArray);
                }
                gridPane$CompositeSize.setPresetSize(i2, gridPane$CompositeSize2.getSize(i2));
                continue;
            }
            if (d2 == -1.0) continue;
            gridPane$CompositeSize.setPresetSize(i2, this.snapSizeY(d2));
        }
        List list = this.getManagedChildren();
        int n2 = list.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            object = (Node)list.get(i3);
            int n3 = GridPane.getNodeRowIndex((Node)object);
            int n4 = this.getNodeRowEndConvertRemaining((Node)object);
            double d3 = this.computeChildMinAreaHeight((Node)object, this.isNodePositionedByBaseline((Node)object) ? this.rowMinBaselineComplement[n3] : -1.0, GridPane.getMargin((Node)object), dArray == null ? -1.0 : this.getTotalWidthOfNodeColumns((Node)object, dArray));
            if (n3 == n4 && !gridPane$CompositeSize.isPreset(n3)) {
                gridPane$CompositeSize.setMaxSize(n3, d3);
                continue;
            }
            if (n3 == n4) continue;
            gridPane$CompositeSize.setMaxMultiSize(n3, n4 + 1, d3);
        }
        return gridPane$CompositeSize;
    }

    private double getTotalHeightOfNodeRows(Node node, double[] dArray) {
        if (GridPane.getNodeRowSpan(node) == 1) {
            return dArray[GridPane.getNodeRowIndex(node)];
        }
        double d2 = 0.0;
        int n2 = this.getNodeRowEndConvertRemaining(node);
        for (int i2 = GridPane.getNodeRowIndex(node); i2 <= n2; ++i2) {
            d2 += dArray[i2];
        }
        return d2;
    }

    private GridPane$CompositeSize computeMaxWidths() {
        if (this.columnMaxWidth == null) {
            this.columnMaxWidth = this.createCompositeColumns(Double.MAX_VALUE);
            ObservableList<ColumnConstraints> observableList = this.getColumnConstraints();
            GridPane$CompositeSize gridPane$CompositeSize = null;
            for (int i2 = 0; i2 < observableList.size(); ++i2) {
                double d2;
                ColumnConstraints columnConstraints = (ColumnConstraints)observableList.get(i2);
                double d3 = columnConstraints.getMaxWidth();
                if (d3 == Double.NEGATIVE_INFINITY) {
                    if (gridPane$CompositeSize == null) {
                        gridPane$CompositeSize = this.computePrefWidths(null);
                    }
                    this.columnMaxWidth.setPresetSize(i2, gridPane$CompositeSize.getSize(i2));
                    continue;
                }
                if (d3 == -1.0) continue;
                double d4 = this.snapSizeX(d3);
                double d5 = columnConstraints.getMinWidth();
                if (d2 >= 0.0) {
                    double d6 = this.snapSizeX(d5);
                    double d7 = d4;
                    this.columnMaxWidth.setPresetSize(i2, GridPane.boundedSize(d6, d7, d7));
                    continue;
                }
                this.columnMaxWidth.setPresetSize(i2, d4);
            }
        }
        return this.columnMaxWidth;
    }

    private GridPane$CompositeSize computePrefWidths(double[] dArray) {
        double d2;
        double d3;
        GridPane$CompositeSize gridPane$CompositeSize;
        if (dArray == null) {
            if (this.columnPrefWidth != null) {
                return this.columnPrefWidth;
            }
            gridPane$CompositeSize = this.columnPrefWidth = this.createCompositeColumns(0.0);
        } else {
            gridPane$CompositeSize = this.createCompositeColumns(0.0);
        }
        ObservableList<ColumnConstraints> observableList = this.getColumnConstraints();
        for (int i2 = 0; i2 < observableList.size(); ++i2) {
            ColumnConstraints columnConstraints = (ColumnConstraints)observableList.get(i2);
            double d4 = columnConstraints.getPrefWidth();
            double d5 = columnConstraints.getMinWidth();
            if (d4 != -1.0) {
                d3 = this.snapSizeX(d4);
                d2 = columnConstraints.getMaxWidth();
                if (d5 >= 0.0 || d2 >= 0.0) {
                    double d6 = d5 < 0.0 ? 0.0 : this.snapSizeX(d5);
                    double d7 = d2 < 0.0 ? Double.POSITIVE_INFINITY : this.snapSizeX(d2);
                    gridPane$CompositeSize.setPresetSize(i2, GridPane.boundedSize(d6 < 0.0 ? 0.0 : d6, d3, d7 < 0.0 ? Double.POSITIVE_INFINITY : d7));
                    continue;
                }
                gridPane$CompositeSize.setPresetSize(i2, d3);
                continue;
            }
            if (!(d5 > 0.0)) continue;
            gridPane$CompositeSize.setSize(i2, this.snapSizeX(d5));
        }
        List list = this.getManagedChildren();
        int n2 = list.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            int n3;
            Node node = (Node)list.get(i3);
            int n4 = GridPane.getNodeColumnIndex(node);
            if (n4 == (n3 = this.getNodeColumnEndConvertRemaining(node)) && !gridPane$CompositeSize.isPreset(n4)) {
                d3 = this.getColumnMinWidth(n4);
                d2 = this.getColumnMaxWidth(n4);
                gridPane$CompositeSize.setMaxSize(n4, GridPane.boundedSize(d3 < 0.0 ? 0.0 : d3, this.computeChildPrefAreaWidth(node, this.getBaselineComplementForChild(node), GridPane.getMargin(node), dArray == null ? -1.0 : this.getTotalHeightOfNodeRows(node, dArray), false), d2 < 0.0 ? Double.MAX_VALUE : d2));
                continue;
            }
            if (n4 == n3) continue;
            gridPane$CompositeSize.setMaxMultiSize(n4, n3 + 1, this.computeChildPrefAreaWidth(node, this.getBaselineComplementForChild(node), GridPane.getMargin(node), dArray == null ? -1.0 : this.getTotalHeightOfNodeRows(node, dArray), false));
        }
        return gridPane$CompositeSize;
    }

    private GridPane$CompositeSize computeMinWidths(double[] dArray) {
        GridPane$CompositeSize gridPane$CompositeSize;
        if (dArray == null) {
            if (this.columnMinWidth != null) {
                return this.columnMinWidth;
            }
            gridPane$CompositeSize = this.columnMinWidth = this.createCompositeColumns(0.0);
        } else {
            gridPane$CompositeSize = this.createCompositeColumns(0.0);
        }
        Object object = this.getColumnConstraints();
        GridPane$CompositeSize gridPane$CompositeSize2 = null;
        for (int i2 = 0; i2 < object.size(); ++i2) {
            double d2 = ((ColumnConstraints)object.get(i2)).getMinWidth();
            if (d2 == Double.NEGATIVE_INFINITY) {
                if (gridPane$CompositeSize2 == null) {
                    gridPane$CompositeSize2 = this.computePrefWidths(dArray);
                }
                gridPane$CompositeSize.setPresetSize(i2, gridPane$CompositeSize2.getSize(i2));
                continue;
            }
            if (d2 == -1.0) continue;
            gridPane$CompositeSize.setPresetSize(i2, this.snapSizeX(d2));
        }
        List list = this.getManagedChildren();
        int n2 = list.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            int n3;
            object = (Node)list.get(i3);
            int n4 = GridPane.getNodeColumnIndex((Node)object);
            if (n4 == (n3 = this.getNodeColumnEndConvertRemaining((Node)object)) && !gridPane$CompositeSize.isPreset(n4)) {
                gridPane$CompositeSize.setMaxSize(n4, this.computeChildMinAreaWidth((Node)object, this.getBaselineComplementForChild((Node)object), GridPane.getMargin((Node)object), dArray == null ? -1.0 : this.getTotalHeightOfNodeRows((Node)object, dArray), false));
                continue;
            }
            if (n4 == n3) continue;
            gridPane$CompositeSize.setMaxMultiSize(n4, n3 + 1, this.computeChildMinAreaWidth((Node)object, this.getBaselineComplementForChild((Node)object), GridPane.getMargin((Node)object), dArray == null ? -1.0 : this.getTotalHeightOfNodeRows((Node)object, dArray), false));
        }
        return gridPane$CompositeSize;
    }

    private GridPane$CompositeSize computeHeightsToFit(double d2) {
        assert (d2 != -1.0);
        GridPane$CompositeSize gridPane$CompositeSize = this.rowPercentTotal == 100.0 ? this.createCompositeRows(0.0) : (GridPane$CompositeSize)this.computePrefHeights(null).clone();
        this.adjustRowHeights(gridPane$CompositeSize, d2);
        return gridPane$CompositeSize;
    }

    private GridPane$CompositeSize computeWidthsToFit(double d2) {
        assert (d2 != -1.0);
        GridPane$CompositeSize gridPane$CompositeSize = this.columnPercentTotal == 100.0 ? this.createCompositeColumns(0.0) : (GridPane$CompositeSize)this.computePrefWidths(null).clone();
        this.adjustColumnWidths(gridPane$CompositeSize, d2);
        return gridPane$CompositeSize;
    }

    @Override
    public Orientation getContentBias() {
        this.computeGridMetrics();
        return this.bias;
    }

    @Override
    public void requestLayout() {
        if (this.performingLayout) {
            return;
        }
        if (this.metricsDirty) {
            super.requestLayout();
            return;
        }
        this.metricsDirty = true;
        this.bias = null;
        this.rowGrow = null;
        GridPane gridPane = this;
        this.rowMaxHeight = null;
        gridPane.rowPrefHeight = null;
        gridPane.rowMinHeight = null;
        this.columnGrow = null;
        GridPane gridPane2 = this;
        this.columnMaxWidth = null;
        gridPane2.columnPrefWidth = null;
        gridPane2.columnMinWidth = null;
        GridPane gridPane3 = this;
        this.rowMaxBaselineComplement = null;
        gridPane3.rowPrefBaselineComplement = null;
        gridPane3.rowMinBaselineComplement = null;
        super.requestLayout();
    }

    @Override
    protected void layoutChildren() {
        this.performingLayout = true;
        try {
            double d2;
            double d3;
            GridPane$CompositeSize gridPane$CompositeSize;
            GridPane gridPane = this;
            double d4 = gridPane.snapSpaceX(gridPane.getHgap());
            GridPane gridPane2 = this;
            double d5 = gridPane2.snapSpaceY(gridPane2.getVgap());
            GridPane gridPane3 = this;
            double d6 = gridPane3.snapSpaceY(gridPane3.getInsets().getTop());
            GridPane gridPane4 = this;
            double d7 = gridPane4.snapSpaceY(gridPane4.getInsets().getBottom());
            GridPane gridPane5 = this;
            double d8 = gridPane5.snapSpaceX(gridPane5.getInsets().getLeft());
            GridPane gridPane6 = this;
            double d9 = gridPane6.snapSpaceX(gridPane6.getInsets().getRight());
            double d10 = this.getWidth();
            double d11 = this.getHeight();
            double d12 = d11 - d6 - d7;
            double d13 = d10 - d8 - d9;
            this.computeGridMetrics();
            Object object = ((Node)this).getContentBias();
            if (object == null) {
                object = (GridPane$CompositeSize)this.computePrefHeights(null).clone();
                gridPane$CompositeSize = (GridPane$CompositeSize)this.computePrefWidths(null).clone();
                d3 = this.adjustRowHeights((GridPane$CompositeSize)object, d11);
                d2 = this.adjustColumnWidths(gridPane$CompositeSize, d10);
            } else if (object == Orientation.HORIZONTAL) {
                gridPane$CompositeSize = (GridPane$CompositeSize)this.computePrefWidths(null).clone();
                d2 = this.adjustColumnWidths(gridPane$CompositeSize, d10);
                object = this.computePrefHeights(gridPane$CompositeSize.asArray());
                d3 = this.adjustRowHeights((GridPane$CompositeSize)object, d11);
            } else {
                object = (GridPane$CompositeSize)this.computePrefHeights(null).clone();
                d3 = this.adjustRowHeights((GridPane$CompositeSize)object, d11);
                gridPane$CompositeSize = this.computePrefWidths(((GridPane$CompositeSize)object).asArray());
                d2 = this.adjustColumnWidths(gridPane$CompositeSize, d10);
            }
            double d14 = d8 + GridPane.computeXOffset(d13, d2, this.getAlignmentInternal().getHpos());
            double d15 = d6 + GridPane.computeYOffset(d12, d3, this.getAlignmentInternal().getVpos());
            List list = this.getManagedChildren();
            double[] dArray = GridPane.createDoubleArray(this.numRows, -1.0);
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4;
                Node node = (Node)list.get(i2);
                int n5 = GridPane.getNodeRowIndex(node);
                int n6 = GridPane.getNodeColumnIndex(node);
                int n7 = GridPane.getNodeColumnSpan(node);
                if (n7 == Integer.MAX_VALUE) {
                    n7 = gridPane$CompositeSize.getLength() - n6;
                }
                if ((n4 = GridPane.getNodeRowSpan(node)) == Integer.MAX_VALUE) {
                    n4 = ((GridPane$CompositeSize)object).getLength() - n5;
                }
                double d16 = d14;
                for (int i3 = 0; i3 < n6; ++i3) {
                    d16 += gridPane$CompositeSize.getSize(i3) + d4;
                }
                double d17 = d15;
                for (int i4 = 0; i4 < n5; ++i4) {
                    d17 += ((GridPane$CompositeSize)object).getSize(i4) + d5;
                }
                double d18 = gridPane$CompositeSize.getSize(n6);
                for (int i5 = 2; i5 <= n7; ++i5) {
                    d18 += gridPane$CompositeSize.getSize(n6 + i5 - 1) + d4;
                }
                double d19 = ((GridPane$CompositeSize)object).getSize(n5);
                for (n7 = 2; n7 <= n4; ++n7) {
                    d19 += ((GridPane$CompositeSize)object).getSize(n5 + n7 - 1) + d5;
                }
                HPos hPos = GridPane.getHalignment(node);
                VPos vPos = GridPane.getValignment(node);
                Boolean bl2 = GridPane.isFillWidth(node);
                Boolean bl3 = GridPane.isFillHeight(node);
                if (hPos == null) {
                    hPos = this.getColumnHalignment(n6);
                }
                if (vPos == null) {
                    vPos = this.getRowValignment(n5);
                }
                if (bl2 == null) {
                    bl2 = this.shouldColumnFillWidth(n6);
                }
                if (bl3 == null) {
                    bl3 = this.shouldRowFillHeight(n5);
                }
                double d20 = 0.0;
                if (vPos == VPos.BASELINE) {
                    if (dArray[n5] == -1.0) {
                        GridPane gridPane7 = this;
                        dArray[n5] = gridPane7.getAreaBaselineOffset(gridPane7.rowBaseline[n5], marginAccessor, (Integer n3) -> {
                            Node node = this.rowBaseline[n5].get((int)n3);
                            int n4 = GridPane.getNodeColumnIndex(node);
                            int n5 = GridPane.getNodeColumnSpan(node);
                            if (n5 == Integer.MAX_VALUE) {
                                n5 = gridPane$CompositeSize.getLength() - n4;
                            }
                            double d3 = gridPane$CompositeSize.getSize(n4);
                            for (int i2 = 2; i2 <= n5; ++i2) {
                                d3 += gridPane$CompositeSize.getSize(n4 + i2 - 1) + d4;
                            }
                            return d3;
                        }, d19, constable -> {
                            constable = GridPane.isFillHeight(node);
                            if (constable != null) {
                                return constable;
                            }
                            return this.shouldRowFillHeight(GridPane.getNodeRowIndex(node));
                        }, this.rowMinBaselineComplement[n5]);
                    }
                    d20 = dArray[n5];
                }
                Insets insets = GridPane.getMargin(node);
                this.layoutInArea(node, d16, d17, d18, d19, d20, insets, bl2, bl3, hPos, vPos);
            }
            this.layoutGridLines(gridPane$CompositeSize, (GridPane$CompositeSize)object, d14, d15, d3, d2);
            this.currentHeights = object;
            this.currentWidths = gridPane$CompositeSize;
            return;
        }
        finally {
            this.performingLayout = false;
        }
    }

    private double adjustRowHeights(GridPane$CompositeSize gridPane$CompositeSize, double d2) {
        double d3;
        double d4;
        assert (d2 != -1.0);
        GridPane gridPane = this;
        double d5 = gridPane.snapSpaceY(gridPane.getVgap());
        GridPane gridPane2 = this;
        double d6 = gridPane2.snapSpaceY(gridPane2.getInsets().getTop());
        GridPane gridPane3 = this;
        double d7 = gridPane3.snapSpaceY(gridPane3.getInsets().getBottom());
        double d8 = d5 * (double)(this.getNumberOfRows() - 1);
        double d9 = d2 - d6 - d7;
        if (this.rowPercentTotal > 0.0) {
            d4 = 0.0;
            for (int i2 = 0; i2 < this.rowPercentHeight.length; ++i2) {
                if (!(this.rowPercentHeight[i2] >= 0.0)) continue;
                double d10 = (d9 - d8) * (this.rowPercentHeight[i2] / 100.0);
                double d11 = Math.floor(d10);
                d4 += d10 - d11;
                d10 = d11;
                if (d4 >= 0.5) {
                    d10 += 1.0;
                    d4 += -1.0;
                }
                gridPane$CompositeSize.setSize(i2, d10);
            }
        }
        d4 = gridPane$CompositeSize.computeTotal();
        if (this.rowPercentTotal < 100.0 && (d3 = d2 - d6 - d7 - d4) != 0.0) {
            double d12 = this.growToMultiSpanPreferredHeights(gridPane$CompositeSize, d3);
            d12 = this.growOrShrinkRowHeights(gridPane$CompositeSize, Priority.ALWAYS, d12);
            d12 = this.growOrShrinkRowHeights(gridPane$CompositeSize, Priority.SOMETIMES, d12);
            d4 += d3 - d12;
        }
        return d4;
    }

    private double growToMultiSpanPreferredHeights(GridPane$CompositeSize gridPane$CompositeSize, double d2) {
        double d3;
        double d4;
        double d5;
        int n2;
        double d6;
        double d7;
        double d8;
        int n3;
        if (d2 <= 0.0) {
            return d2;
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
        TreeSet<Integer> treeSet3 = new TreeSet<Integer>();
        for (Map.Entry<GridPane$Interval, Double> entry : gridPane$CompositeSize.multiSizes()) {
            GridPane$Interval gridPane$Interval = entry.getKey();
            block5: for (int i2 = gridPane$Interval.begin; i2 < gridPane$Interval.end; ++i2) {
                if (!(this.rowPercentHeight[i2] < 0.0)) continue;
                switch (this.rowGrow[i2]) {
                    case ALWAYS: {
                        treeSet.add(i2);
                        continue block5;
                    }
                    case SOMETIMES: {
                        treeSet2.add(i2);
                    }
                }
            }
            if (!(this.rowPercentHeight[gridPane$Interval.end - 1] < 0.0)) continue;
            treeSet3.add(gridPane$Interval.end - 1);
        }
        double d9 = d2;
        while (treeSet.size() > 0 && d9 > (double)treeSet.size()) {
            double d10 = Math.floor(d9 / (double)treeSet.size());
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                n3 = (Integer)iterator.next();
                d8 = this.getRowMaxHeight(n3);
                d7 = this.getRowPrefHeight(n3);
                d6 = d10;
                for (Map.Entry<GridPane$Interval, Double> entry : gridPane$CompositeSize.multiSizes()) {
                    GridPane$Interval gridPane$Interval = entry.getKey();
                    if (!gridPane$Interval.contains(n3)) continue;
                    n2 = 0;
                    for (int i3 = gridPane$Interval.begin; i3 < gridPane$Interval.end; ++i3) {
                        if (!treeSet.contains(i3)) continue;
                        ++n2;
                    }
                    d5 = gridPane$CompositeSize.computeTotal(gridPane$Interval.begin, gridPane$Interval.end);
                    d6 = Math.min(Math.floor(Math.max(0.0, (entry.getValue() - d5) / (double)n2)), d6);
                }
                d4 = gridPane$CompositeSize.getSize(n3);
                d3 = d8 >= 0.0 ? GridPane.boundedSize(0.0, d4 + d6, d8) : (d8 == Double.NEGATIVE_INFINITY && d7 > 0.0 ? GridPane.boundedSize(0.0, d4 + d6, d7) : d4 + d6);
                d5 = d3 - d4;
                d9 -= d5;
                if (d5 != d6 || d5 == 0.0) {
                    iterator.remove();
                }
                gridPane$CompositeSize.setSize(n3, d3);
            }
        }
        while (treeSet2.size() > 0 && d9 > (double)treeSet2.size()) {
            double d11 = Math.floor(d9 / (double)treeSet2.size());
            Iterator iterator = treeSet2.iterator();
            while (iterator.hasNext()) {
                n3 = (Integer)iterator.next();
                d8 = this.getRowMaxHeight(n3);
                d7 = this.getRowPrefHeight(n3);
                d6 = d11;
                for (Map.Entry<GridPane$Interval, Double> entry : gridPane$CompositeSize.multiSizes()) {
                    GridPane$Interval gridPane$Interval = entry.getKey();
                    if (!gridPane$Interval.contains(n3)) continue;
                    n2 = 0;
                    for (int i4 = gridPane$Interval.begin; i4 < gridPane$Interval.end; ++i4) {
                        if (!treeSet2.contains(i4)) continue;
                        ++n2;
                    }
                    d5 = gridPane$CompositeSize.computeTotal(gridPane$Interval.begin, gridPane$Interval.end);
                    d6 = Math.min(Math.floor(Math.max(0.0, (entry.getValue() - d5) / (double)n2)), d6);
                }
                d4 = gridPane$CompositeSize.getSize(n3);
                d3 = d8 >= 0.0 ? GridPane.boundedSize(0.0, d4 + d6, d8) : (d8 == Double.NEGATIVE_INFINITY && d7 > 0.0 ? GridPane.boundedSize(0.0, d4 + d6, d7) : d4 + d6);
                d5 = d3 - d4;
                d9 -= d5;
                if (d5 != d6 || d5 == 0.0) {
                    iterator.remove();
                }
                gridPane$CompositeSize.setSize(n3, d3);
            }
        }
        while (treeSet3.size() > 0 && d9 > (double)treeSet3.size()) {
            double d12 = Math.floor(d9 / (double)treeSet3.size());
            Iterator iterator = treeSet3.iterator();
            while (iterator.hasNext()) {
                n3 = (Integer)iterator.next();
                d8 = this.getRowMaxHeight(n3);
                d7 = this.getRowPrefHeight(n3);
                d6 = d12;
                for (Map.Entry<GridPane$Interval, Double> entry : gridPane$CompositeSize.multiSizes()) {
                    GridPane$Interval gridPane$Interval = entry.getKey();
                    if (gridPane$Interval.end - 1 != n3) continue;
                    double d13 = gridPane$CompositeSize.computeTotal(gridPane$Interval.begin, gridPane$Interval.end);
                    d6 = Math.min(Math.max(0.0, entry.getValue() - d13), d6);
                }
                d4 = gridPane$CompositeSize.getSize(n3);
                d3 = d8 >= 0.0 ? GridPane.boundedSize(0.0, d4 + d6, d8) : (d8 == Double.NEGATIVE_INFINITY && d7 > 0.0 ? GridPane.boundedSize(0.0, d4 + d6, d7) : d4 + d6);
                d5 = d3 - d4;
                d9 -= d5;
                if (d5 != d6 || d5 == 0.0) {
                    iterator.remove();
                }
                gridPane$CompositeSize.setSize(n3, d3);
            }
        }
        return d9;
    }

    private double growOrShrinkRowHeights(GridPane$CompositeSize gridPane$CompositeSize, Priority priority, double d2) {
        GridPane$CompositeSize gridPane$CompositeSize2;
        boolean bl2 = d2 < 0.0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.rowGrow.length; ++i2) {
            if (!(this.rowPercentHeight[i2] < 0.0) || !bl2 && this.rowGrow[i2] != priority) continue;
            arrayList.add(i2);
        }
        double d3 = d2;
        boolean bl3 = false;
        double d4 = 0.0;
        int n2 = d3 >= 0.0 ? 1 : 0;
        int n3 = n2;
        GridPane$CompositeSize gridPane$CompositeSize3 = gridPane$CompositeSize2 = bl2 ? this.computeMinHeights(null) : this.computeMaxHeights();
        block1: while (d3 != 0.0 && n2 == n3 && arrayList.size() > 0) {
            if (!bl3) {
                double d5 = d4 = d3 > 0.0 ? Math.floor(d3 / (double)arrayList.size()) : Math.ceil(d3 / (double)arrayList.size());
            }
            if (d4 != 0.0) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    double d6;
                    n3 = (Integer)iterator.next();
                    double d7 = this.snapSpaceY(gridPane$CompositeSize2.getProportionalMinOrMaxSize(n3, bl2)) - gridPane$CompositeSize.getSize(n3);
                    if (bl2 && d7 > 0.0 || !bl2 && d7 < 0.0) {
                        d7 = 0.0;
                    }
                    double d8 = Math.abs(d7) <= Math.abs(d4) ? d7 : d4;
                    gridPane$CompositeSize.addSize(n3, d8);
                    d3 -= d8;
                    int n4 = n3 = d6 >= 0.0 ? 1 : 0;
                    if (Math.abs(d8) < Math.abs(d4)) {
                        iterator.remove();
                    }
                    if (d3 == 0.0) continue block1;
                }
                continue;
            }
            d4 = (int)d3 % arrayList.size();
            if (d4 == 0.0) break;
            d4 = bl2 ? -1.0 : 1.0;
            bl3 = true;
        }
        return d3;
    }

    private double adjustColumnWidths(GridPane$CompositeSize gridPane$CompositeSize, double d2) {
        double d3;
        double d4;
        assert (d2 != -1.0);
        GridPane gridPane = this;
        double d5 = gridPane.snapSpaceX(gridPane.getHgap());
        GridPane gridPane2 = this;
        double d6 = gridPane2.snapSpaceX(gridPane2.getInsets().getLeft());
        GridPane gridPane3 = this;
        double d7 = gridPane3.snapSpaceX(gridPane3.getInsets().getRight());
        double d8 = d5 * (double)(this.getNumberOfColumns() - 1);
        double d9 = d2 - d6 - d7;
        if (this.columnPercentTotal > 0.0) {
            d4 = 0.0;
            for (int i2 = 0; i2 < this.columnPercentWidth.length; ++i2) {
                if (!(this.columnPercentWidth[i2] >= 0.0)) continue;
                double d10 = (d9 - d8) * (this.columnPercentWidth[i2] / 100.0);
                double d11 = Math.floor(d10);
                d4 += d10 - d11;
                d10 = d11;
                if (d4 >= 0.5) {
                    d10 += 1.0;
                    d4 += -1.0;
                }
                gridPane$CompositeSize.setSize(i2, d10);
            }
        }
        d4 = gridPane$CompositeSize.computeTotal();
        if (this.columnPercentTotal < 100.0 && (d3 = d2 - d6 - d7 - d4) != 0.0) {
            double d12 = this.growToMultiSpanPreferredWidths(gridPane$CompositeSize, d3);
            d12 = this.growOrShrinkColumnWidths(gridPane$CompositeSize, Priority.ALWAYS, d12);
            d12 = this.growOrShrinkColumnWidths(gridPane$CompositeSize, Priority.SOMETIMES, d12);
            d4 += d3 - d12;
        }
        return d4;
    }

    private double growToMultiSpanPreferredWidths(GridPane$CompositeSize gridPane$CompositeSize, double d2) {
        double d3;
        double d4;
        double d5;
        int n2;
        double d6;
        double d7;
        double d8;
        int n3;
        if (d2 <= 0.0) {
            return d2;
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
        TreeSet<Integer> treeSet3 = new TreeSet<Integer>();
        for (Map.Entry<GridPane$Interval, Double> entry : gridPane$CompositeSize.multiSizes()) {
            GridPane$Interval gridPane$Interval = entry.getKey();
            block5: for (int i2 = gridPane$Interval.begin; i2 < gridPane$Interval.end; ++i2) {
                if (!(this.columnPercentWidth[i2] < 0.0)) continue;
                switch (this.columnGrow[i2]) {
                    case ALWAYS: {
                        treeSet.add(i2);
                        continue block5;
                    }
                    case SOMETIMES: {
                        treeSet2.add(i2);
                    }
                }
            }
            if (!(this.columnPercentWidth[gridPane$Interval.end - 1] < 0.0)) continue;
            treeSet3.add(gridPane$Interval.end - 1);
        }
        double d9 = d2;
        while (treeSet.size() > 0 && d9 > (double)treeSet.size()) {
            double d10 = Math.floor(d9 / (double)treeSet.size());
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                n3 = (Integer)iterator.next();
                d8 = this.getColumnMaxWidth(n3);
                d7 = this.getColumnPrefWidth(n3);
                d6 = d10;
                for (Map.Entry<GridPane$Interval, Double> entry : gridPane$CompositeSize.multiSizes()) {
                    GridPane$Interval gridPane$Interval = entry.getKey();
                    if (!gridPane$Interval.contains(n3)) continue;
                    n2 = 0;
                    for (int i3 = gridPane$Interval.begin; i3 < gridPane$Interval.end; ++i3) {
                        if (!treeSet.contains(i3)) continue;
                        ++n2;
                    }
                    d5 = gridPane$CompositeSize.computeTotal(gridPane$Interval.begin, gridPane$Interval.end);
                    d6 = Math.min(Math.floor(Math.max(0.0, (entry.getValue() - d5) / (double)n2)), d6);
                }
                d4 = gridPane$CompositeSize.getSize(n3);
                d3 = d8 >= 0.0 ? GridPane.boundedSize(0.0, d4 + d6, d8) : (d8 == Double.NEGATIVE_INFINITY && d7 > 0.0 ? GridPane.boundedSize(0.0, d4 + d6, d7) : d4 + d6);
                d5 = d3 - d4;
                d9 -= d5;
                if (d5 != d6 || d5 == 0.0) {
                    iterator.remove();
                }
                gridPane$CompositeSize.setSize(n3, d3);
            }
        }
        while (treeSet2.size() > 0 && d9 > (double)treeSet2.size()) {
            double d11 = Math.floor(d9 / (double)treeSet2.size());
            Iterator iterator = treeSet2.iterator();
            while (iterator.hasNext()) {
                n3 = (Integer)iterator.next();
                d8 = this.getColumnMaxWidth(n3);
                d7 = this.getColumnPrefWidth(n3);
                d6 = d11;
                for (Map.Entry<GridPane$Interval, Double> entry : gridPane$CompositeSize.multiSizes()) {
                    GridPane$Interval gridPane$Interval = entry.getKey();
                    if (!gridPane$Interval.contains(n3)) continue;
                    n2 = 0;
                    for (int i4 = gridPane$Interval.begin; i4 < gridPane$Interval.end; ++i4) {
                        if (!treeSet2.contains(i4)) continue;
                        ++n2;
                    }
                    d5 = gridPane$CompositeSize.computeTotal(gridPane$Interval.begin, gridPane$Interval.end);
                    d6 = Math.min(Math.floor(Math.max(0.0, (entry.getValue() - d5) / (double)n2)), d6);
                }
                d4 = gridPane$CompositeSize.getSize(n3);
                d3 = d8 >= 0.0 ? GridPane.boundedSize(0.0, d4 + d6, d8) : (d8 == Double.NEGATIVE_INFINITY && d7 > 0.0 ? GridPane.boundedSize(0.0, d4 + d6, d7) : d4 + d6);
                d5 = d3 - d4;
                d9 -= d5;
                if (d5 != d6 || d5 == 0.0) {
                    iterator.remove();
                }
                gridPane$CompositeSize.setSize(n3, d3);
            }
        }
        while (treeSet3.size() > 0 && d9 > (double)treeSet3.size()) {
            double d12 = Math.floor(d9 / (double)treeSet3.size());
            Iterator iterator = treeSet3.iterator();
            while (iterator.hasNext()) {
                n3 = (Integer)iterator.next();
                d8 = this.getColumnMaxWidth(n3);
                d7 = this.getColumnPrefWidth(n3);
                d6 = d12;
                for (Map.Entry<GridPane$Interval, Double> entry : gridPane$CompositeSize.multiSizes()) {
                    GridPane$Interval gridPane$Interval = entry.getKey();
                    if (gridPane$Interval.end - 1 != n3) continue;
                    double d13 = gridPane$CompositeSize.computeTotal(gridPane$Interval.begin, gridPane$Interval.end);
                    d6 = Math.min(Math.max(0.0, entry.getValue() - d13), d6);
                }
                d4 = gridPane$CompositeSize.getSize(n3);
                d3 = d8 >= 0.0 ? GridPane.boundedSize(0.0, d4 + d6, d8) : (d8 == Double.NEGATIVE_INFINITY && d7 > 0.0 ? GridPane.boundedSize(0.0, d4 + d6, d7) : d4 + d6);
                d5 = d3 - d4;
                d9 -= d5;
                if (d5 != d6 || d5 == 0.0) {
                    iterator.remove();
                }
                gridPane$CompositeSize.setSize(n3, d3);
            }
        }
        return d9;
    }

    private double growOrShrinkColumnWidths(GridPane$CompositeSize gridPane$CompositeSize, Priority priority, double d2) {
        GridPane$CompositeSize gridPane$CompositeSize2;
        if (d2 == 0.0) {
            return 0.0;
        }
        boolean bl2 = d2 < 0.0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.columnGrow.length; ++i2) {
            if (!(this.columnPercentWidth[i2] < 0.0) || !bl2 && this.columnGrow[i2] != priority) continue;
            arrayList.add(i2);
        }
        double d3 = d2;
        boolean bl3 = false;
        double d4 = 0.0;
        int n2 = d3 >= 0.0 ? 1 : 0;
        int n3 = n2;
        GridPane$CompositeSize gridPane$CompositeSize3 = gridPane$CompositeSize2 = bl2 ? this.computeMinWidths(null) : this.computeMaxWidths();
        block1: while (d3 != 0.0 && n2 == n3 && arrayList.size() > 0) {
            if (!bl3) {
                double d5 = d4 = d3 > 0.0 ? Math.floor(d3 / (double)arrayList.size()) : Math.ceil(d3 / (double)arrayList.size());
            }
            if (d4 != 0.0) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    double d6;
                    n3 = (Integer)iterator.next();
                    double d7 = this.snapSpaceX(gridPane$CompositeSize2.getProportionalMinOrMaxSize(n3, bl2)) - gridPane$CompositeSize.getSize(n3);
                    if (bl2 && d7 > 0.0 || !bl2 && d7 < 0.0) {
                        d7 = 0.0;
                    }
                    double d8 = Math.abs(d7) <= Math.abs(d4) ? d7 : d4;
                    gridPane$CompositeSize.addSize(n3, d8);
                    d3 -= d8;
                    int n4 = n3 = d6 >= 0.0 ? 1 : 0;
                    if (Math.abs(d8) < Math.abs(d4)) {
                        iterator.remove();
                    }
                    if (d3 == 0.0) continue block1;
                }
                continue;
            }
            d4 = (int)d3 % arrayList.size();
            if (d4 == 0.0) break;
            d4 = bl2 ? -1.0 : 1.0;
            bl3 = true;
        }
        return d3;
    }

    private void layoutGridLines(GridPane$CompositeSize gridPane$CompositeSize, GridPane$CompositeSize gridPane$CompositeSize2, double d2, double d3, double d4, double d5) {
        int n2;
        if (!this.isGridLinesVisible()) {
            return;
        }
        if (!this.gridLines.getChildren().isEmpty()) {
            this.gridLines.getChildren().clear();
        }
        GridPane gridPane = this;
        double d6 = gridPane.snapSpaceX(gridPane.getHgap());
        GridPane gridPane2 = this;
        double d7 = gridPane2.snapSpaceY(gridPane2.getVgap());
        double d8 = d2;
        double d9 = d3;
        for (n2 = 0; n2 <= gridPane$CompositeSize.getLength(); ++n2) {
            this.gridLines.getChildren().add(this.createGridLine(d8, d9, d8, d9 + d4));
            if (n2 > 0 && n2 < gridPane$CompositeSize.getLength() && d6 != 0.0) {
                this.gridLines.getChildren().add(this.createGridLine(d8 += d6, d9, d8, d9 + d4));
            }
            if (n2 >= gridPane$CompositeSize.getLength()) continue;
            d8 += gridPane$CompositeSize.getSize(n2);
        }
        d8 = d2;
        for (n2 = 0; n2 <= gridPane$CompositeSize2.getLength(); ++n2) {
            this.gridLines.getChildren().add(this.createGridLine(d8, d9, d8 + d5, d9));
            if (n2 > 0 && n2 < gridPane$CompositeSize2.getLength() && d7 != 0.0) {
                this.gridLines.getChildren().add(this.createGridLine(d8, d9 += d7, d8 + d5, d9));
            }
            if (n2 >= gridPane$CompositeSize2.getLength()) continue;
            d9 += gridPane$CompositeSize2.getSize(n2);
        }
    }

    private Line createGridLine(double d2, double d3, double d4, double d5) {
        Line line = new Line();
        line.setStartX(d2);
        line.setStartY(d3);
        line.setEndX(d4);
        line.setEndY(d5);
        line.setStroke(GRID_LINE_COLOR);
        line.setStrokeDashOffset(3.0);
        return line;
    }

    @Override
    public String toString() {
        return "Grid hgap=" + this.getHgap() + ", vgap=" + this.getVgap() + ", alignment=" + String.valueOf((Object)this.getAlignment());
    }

    private GridPane$CompositeSize createCompositeRows(double d2) {
        GridPane gridPane = this;
        return new GridPane$CompositeSize(this.getNumberOfRows(), this.rowPercentHeight, this.rowPercentTotal, gridPane.snapSpaceY(gridPane.getVgap()), d2);
    }

    private GridPane$CompositeSize createCompositeColumns(double d2) {
        GridPane gridPane = this;
        return new GridPane$CompositeSize(this.getNumberOfColumns(), this.columnPercentWidth, this.columnPercentTotal, gridPane.snapSpaceX(gridPane.getHgap()), d2);
    }

    private int getNodeRowEndConvertRemaining(Node node) {
        int n2 = GridPane.getNodeRowSpan(node);
        if (n2 != Integer.MAX_VALUE) {
            return GridPane.getNodeRowIndex(node) + n2 - 1;
        }
        return this.getNumberOfRows() - 1;
    }

    private int getNodeColumnEndConvertRemaining(Node node) {
        int n2 = GridPane.getNodeColumnSpan(node);
        if (n2 != Integer.MAX_VALUE) {
            return GridPane.getNodeColumnIndex(node) + n2 - 1;
        }
        return this.getNumberOfColumns() - 1;
    }

    double[][] getGrid() {
        if (this.currentHeights == null || this.currentWidths == null) {
            return null;
        }
        return new double[][]{this.currentWidths.asArray(), this.currentHeights.asArray()};
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return GridPane$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return GridPane.getClassCssMetaData();
    }

    public final int getRowCount() {
        int n2 = this.getRowConstraints().size();
        for (int i2 = 0; i2 < this.getChildren().size(); ++i2) {
            Node node = (Node)this.getChildren().get(i2);
            if (!node.isManaged()) continue;
            int n3 = GridPane.getNodeRowIndex(node);
            int n4 = GridPane.getNodeRowEnd(node);
            n2 = Math.max(n2, (n4 != Integer.MAX_VALUE ? n4 : n3) + 1);
        }
        return n2;
    }

    public final int getColumnCount() {
        int n2 = this.getColumnConstraints().size();
        for (int i2 = 0; i2 < this.getChildren().size(); ++i2) {
            Node node = (Node)this.getChildren().get(i2);
            if (!node.isManaged()) continue;
            int n3 = GridPane.getNodeColumnIndex(node);
            int n4 = GridPane.getNodeColumnEnd(node);
            n2 = Math.max(n2, (n4 != Integer.MAX_VALUE ? n4 : n3) + 1);
        }
        return n2;
    }

    public final Bounds getCellBounds(int n2, int n3) {
        double[] dArray;
        GridPane gridPane = this;
        double d2 = gridPane.snapSpaceX(gridPane.getHgap());
        GridPane gridPane2 = this;
        double d3 = gridPane2.snapSpaceY(gridPane2.getVgap());
        GridPane gridPane3 = this;
        double d4 = gridPane3.snapSpaceY(gridPane3.getInsets().getTop());
        GridPane gridPane4 = this;
        double d5 = gridPane4.snapSpaceX(gridPane4.getInsets().getRight());
        GridPane gridPane5 = this;
        double d6 = gridPane5.snapSpaceY(gridPane5.getInsets().getBottom());
        GridPane gridPane6 = this;
        double d7 = gridPane6.snapSpaceX(gridPane6.getInsets().getLeft());
        GridPane gridPane7 = this;
        double d8 = gridPane7.snapSizeY(gridPane7.getHeight()) - (d4 + d6);
        GridPane gridPane8 = this;
        double d9 = gridPane8.snapSizeX(gridPane8.getWidth()) - (d7 + d5);
        Object object = this.getGrid();
        if (object == null) {
            object = new double[]{0.0};
            n3 = 0;
            dArray = new double[]{0.0};
            n2 = 0;
        } else {
            dArray = object[0];
            object = object[1];
        }
        double d10 = 0.0;
        for (int i2 = 0; i2 < ((double[][])object).length; ++i2) {
            d10 += object[i2];
        }
        double d11 = d4 + Region.computeYOffset(d8, d10 += (double)(((double[][])object).length - 1) * d3, this.getAlignment().getVpos());
        double[] dArray2 = object[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            d11 += object[i3] + d3;
        }
        double d12 = 0.0;
        for (int i4 = 0; i4 < dArray.length; ++i4) {
            d12 += dArray[i4];
        }
        double d13 = d7 + Region.computeXOffset(d9, d12 += (double)(dArray.length - 1) * d2, this.getAlignment().getHpos());
        double d14 = dArray[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            d13 += dArray[n3] + d2;
        }
        return new BoundingBox(d13, d11, d14, (double)dArray2);
    }
}

