/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.HBox$1;
import javafx.scene.layout.HBox$2;
import javafx.scene.layout.HBox$3;
import javafx.scene.layout.HBox$StyleableProperties;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.util.Callback;

public class HBox
extends Pane {
    private boolean biasDirty = true;
    private double minBaselineComplement = Double.NaN;
    private double prefBaselineComplement = Double.NaN;
    private Orientation bias;
    private double[][] tempArray;
    private static final String MARGIN_CONSTRAINT = "hbox-margin";
    private static final String HGROW_CONSTRAINT = "hbox-hgrow";
    private static final Callback<Node, Insets> marginAccessor = node -> HBox.getMargin(node);
    private DoubleProperty spacing;
    private ObjectProperty<Pos> alignment;
    private BooleanProperty fillHeight;
    private double baselineOffset = Double.NaN;

    public static void setHgrow(Node node, Priority priority) {
        HBox.setConstraint(node, HGROW_CONSTRAINT, (Object)priority);
    }

    public static Priority getHgrow(Node node) {
        return (Priority)((Object)HBox.getConstraint(node, HGROW_CONSTRAINT));
    }

    public static void setMargin(Node node, Insets insets) {
        HBox.setConstraint(node, MARGIN_CONSTRAINT, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)HBox.getConstraint(node, MARGIN_CONSTRAINT);
    }

    public static void clearConstraints(Node node) {
        HBox.setHgrow(node, null);
        HBox.setMargin(node, null);
    }

    public HBox() {
    }

    public HBox(double d2) {
        this();
        this.setSpacing(d2);
    }

    public HBox(Node ... nodeArray) {
        this.getChildren().addAll((Node[])nodeArray);
    }

    public HBox(double d2, Node ... nodeArray) {
        this();
        this.setSpacing(d2);
        this.getChildren().addAll((Node[])nodeArray);
    }

    public final DoubleProperty spacingProperty() {
        if (this.spacing == null) {
            this.spacing = new HBox$1(this);
        }
        return this.spacing;
    }

    public final void setSpacing(double d2) {
        this.spacingProperty().set(d2);
    }

    public final double getSpacing() {
        if (this.spacing == null) {
            return 0.0;
        }
        return this.spacing.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new HBox$2(this, Pos.TOP_LEFT);
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        if (this.alignment == null) {
            return Pos.TOP_LEFT;
        }
        return (Pos)((Object)this.alignment.get());
    }

    private Pos getAlignmentInternal() {
        Pos pos = this.getAlignment();
        if (pos == null) {
            return Pos.TOP_LEFT;
        }
        return pos;
    }

    public final BooleanProperty fillHeightProperty() {
        if (this.fillHeight == null) {
            this.fillHeight = new HBox$3(this, true);
        }
        return this.fillHeight;
    }

    public final void setFillHeight(boolean bl2) {
        this.fillHeightProperty().set(bl2);
    }

    public final boolean isFillHeight() {
        if (this.fillHeight == null) {
            return true;
        }
        return this.fillHeight.get();
    }

    private boolean shouldFillHeight() {
        return this.isFillHeight() && this.getAlignmentInternal().getVpos() != VPos.BASELINE;
    }

    @Override
    public Orientation getContentBias() {
        if (this.biasDirty) {
            this.bias = null;
            Object object = this.getManagedChildren();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (Node)object.next();
                if ((object2 = object2.getContentBias()) == null) continue;
                this.bias = object2;
                if (object2 != Orientation.HORIZONTAL) continue;
            }
            this.biasDirty = false;
        }
        return this.bias;
    }

    @Override
    protected double computeMinWidth(double d2) {
        Insets insets = this.getInsets();
        HBox hBox = this;
        return this.snapSpaceX(insets.getLeft()) + hBox.computeContentWidth(hBox.getManagedChildren(), d2, true) + this.snapSpaceX(insets.getRight());
    }

    @Override
    protected double computeMinHeight(double d2) {
        double d3;
        Insets insets = this.getInsets();
        List<Node> list = this.getManagedChildren();
        if (d2 != -1.0 && ((Node)this).getContentBias() != null) {
            double[][] dArray = this.getAreaWidths(list, -1.0, false);
            this.adjustAreaWidths(list, dArray, d2, -1.0);
            d3 = this.computeMaxMinAreaHeight(list, marginAccessor, dArray[0], this.getAlignmentInternal().getVpos());
        } else {
            d3 = this.computeMaxMinAreaHeight(list, marginAccessor, this.getAlignmentInternal().getVpos());
        }
        return this.snapSpaceY(insets.getTop()) + d3 + this.snapSpaceY(insets.getBottom());
    }

    @Override
    protected double computePrefWidth(double d2) {
        Insets insets = this.getInsets();
        HBox hBox = this;
        return this.snapSpaceX(insets.getLeft()) + hBox.computeContentWidth(hBox.getManagedChildren(), d2, false) + this.snapSpaceX(insets.getRight());
    }

    @Override
    protected double computePrefHeight(double d2) {
        double d3;
        Insets insets = this.getInsets();
        List<Node> list = this.getManagedChildren();
        if (d2 != -1.0 && ((Node)this).getContentBias() != null) {
            double[][] dArray = this.getAreaWidths(list, -1.0, false);
            this.adjustAreaWidths(list, dArray, d2, -1.0);
            d3 = this.computeMaxPrefAreaHeight(list, marginAccessor, dArray[0], this.getAlignmentInternal().getVpos());
        } else {
            d3 = this.computeMaxPrefAreaHeight(list, marginAccessor, this.getAlignmentInternal().getVpos());
        }
        return this.snapSpaceY(insets.getTop()) + d3 + this.snapSpaceY(insets.getBottom());
    }

    private double[][] getAreaWidths(List<Node> list, double d2, boolean bl2) {
        double d3;
        double[][] dArray = this.getTempArray(list.size());
        if (d2 == -1.0) {
            d3 = -1.0;
        } else {
            HBox hBox = this;
            HBox hBox2 = this;
            d3 = d2 - hBox.snapSpaceY(hBox.getInsets().getTop()) - hBox2.snapSpaceY(hBox2.getInsets().getBottom());
        }
        double d4 = d3;
        boolean bl3 = this.shouldFillHeight();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = list.get(i2);
            Insets insets = HBox.getMargin(node);
            dArray[0][i2] = bl2 ? this.computeChildMinAreaWidth(node, this.getMinBaselineComplement(), insets, d4, bl3) : this.computeChildPrefAreaWidth(node, this.getPrefBaselineComplement(), insets, d4, bl3);
        }
        return dArray;
    }

    private double adjustAreaWidths(List<Node> list, double[][] dArray, double d2, double d3) {
        Insets insets = this.getInsets();
        double d4 = this.snapSpaceY(insets.getTop());
        double d5 = this.snapSpaceY(insets.getBottom());
        HBox hBox = this;
        double d6 = HBox.sum(dArray[0], list.size()) + (double)(list.size() - 1) * hBox.snapSpaceX(hBox.getSpacing());
        double d7 = d2 - this.snapSpaceX(insets.getLeft()) - this.snapSpaceX(insets.getRight()) - d6;
        if (d7 != 0.0) {
            double d8 = this.shouldFillHeight() && d3 != -1.0 ? d3 - d4 - d5 : -1.0;
            double d9 = this.growOrShrinkAreaWidths(list, dArray, Priority.ALWAYS, d7, d8);
            d9 = this.growOrShrinkAreaWidths(list, dArray, Priority.SOMETIMES, d9, d8);
            d6 += d7 - d9;
        }
        return d6;
    }

    private double growOrShrinkAreaWidths(List<Node> list, double[][] object, Priority priority, double d2, double d3) {
        boolean bl2 = d2 < 0.0;
        int n2 = 0;
        Object dArray = object[0];
        object = object[1];
        boolean bl3 = this.shouldFillHeight();
        if (bl2) {
            n2 = list.size();
            var14_14 = list.size();
            for (var13_12 = 0; var13_12 < var14_14; ++var13_12) {
                var15_15 = list.get(var13_12);
                object[var13_12] = this.computeChildMinAreaWidth(var15_15, this.getMinBaselineComplement(), HBox.getMargin(var15_15), d3, bl3);
            }
        } else {
            var14_14 = list.size();
            for (var13_12 = 0; var13_12 < var14_14; ++var13_12) {
                var15_15 = list.get(var13_12);
                if (HBox.getHgrow(var15_15) == priority) {
                    object[var13_12] = this.computeChildMaxAreaWidth(var15_15, this.getMinBaselineComplement(), HBox.getMargin(var15_15), d3, bl3);
                    ++n2;
                    continue;
                }
                object[var13_12] = -1.0;
            }
        }
        double d4 = this.isSnapToPixel() ? 1.0 / Region.getSnapScaleX(this) : 0.0;
        double d5 = d2;
        block2: while (Math.abs(d5) >= d4 && n2 > 0) {
            double d6 = this.snapPortionX(d5 / (double)n2);
            if (d6 == 0.0) {
                if (d4 == 0.0) break;
                d6 = d4 * Math.signum(d5);
            }
            int n3 = list.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                reference v0;
                if (object[i2] == -1.0) continue;
                reference var21_18 = object[i2] - dArray[i2];
                reference var23_19 = Math.abs((double)v0) <= Math.abs(d6) ? var21_18 : (reference)d6;
                Object object2 = dArray;
                int n4 = i2;
                object2[n4] = object2[n4] + var23_19;
                if (Math.abs(d5 -= var23_19) < d4) break block2;
                if (!(Math.abs((double)var23_19) < Math.abs(d6))) continue;
                object[i2] = -1.0;
                --n2;
            }
        }
        return d5;
    }

    private double computeContentWidth(List<Node> list, double d2, boolean bl2) {
        HBox hBox = this;
        return HBox.sum(this.getAreaWidths(list, d2, bl2)[0], list.size()) + (double)(list.size() - 1) * hBox.snapSpaceX(hBox.getSpacing());
    }

    private static double sum(double[] dArray, int n2) {
        int n3 = 0;
        double d2 = 0.0;
        while (n3 != n2) {
            d2 += dArray[n3++];
        }
        return d2;
    }

    @Override
    public void requestLayout() {
        this.biasDirty = true;
        this.bias = null;
        this.minBaselineComplement = Double.NaN;
        this.prefBaselineComplement = Double.NaN;
        this.baselineOffset = Double.NaN;
        super.requestLayout();
    }

    private double getMinBaselineComplement() {
        if (Double.isNaN(this.minBaselineComplement)) {
            this.minBaselineComplement = this.getAlignmentInternal().getVpos() == VPos.BASELINE ? HBox.getMinBaselineComplement(this.getManagedChildren()) : -1.0;
        }
        return this.minBaselineComplement;
    }

    private double getPrefBaselineComplement() {
        if (Double.isNaN(this.prefBaselineComplement)) {
            this.prefBaselineComplement = this.getAlignmentInternal().getVpos() == VPos.BASELINE ? HBox.getPrefBaselineComplement(this.getManagedChildren()) : -1.0;
        }
        return this.prefBaselineComplement;
    }

    @Override
    public double getBaselineOffset() {
        List list = this.getManagedChildren();
        if (list.isEmpty()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (Double.isNaN(this.baselineOffset)) {
            VPos vPos = this.getAlignmentInternal().getVpos();
            if (vPos == VPos.BASELINE) {
                double d2 = 0.0;
                int n2 = list.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Node node = (Node)list.get(i2);
                    double d3 = node.getBaselineOffset();
                    if (d3 == Double.NEGATIVE_INFINITY) {
                        this.baselineOffset = Double.NEGATIVE_INFINITY;
                        break;
                    }
                    Insets insets = HBox.getMargin(node);
                    double d4 = insets != null ? insets.getTop() : 0.0;
                    d2 = Math.max(d2, d4 + node.getLayoutBounds().getMinY() + d3);
                }
                this.baselineOffset = d2 + this.snappedTopInset();
            } else {
                this.baselineOffset = Double.NEGATIVE_INFINITY;
            }
        }
        return this.baselineOffset;
    }

    @Override
    protected void layoutChildren() {
        List<Node> list = this.getManagedChildren();
        Insets insets = this.getInsets();
        Object object = this.getAlignmentInternal();
        HPos hPos = object.getHpos();
        VPos vPos = object.getVpos();
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        double d4 = this.snapSpaceY(insets.getTop());
        double d5 = this.snapSpaceX(insets.getLeft());
        double d6 = this.snapSpaceY(insets.getBottom());
        double d7 = this.snapSpaceX(insets.getRight());
        HBox hBox = this;
        double d8 = hBox.snapSpaceX(hBox.getSpacing());
        boolean bl2 = this.shouldFillHeight();
        double[][] dArray = this.getAreaWidths(list, d3, false);
        double d9 = this.adjustAreaWidths(list, dArray, d2, d3);
        double d10 = d3 - d4 - d6;
        double d11 = d5 + HBox.computeXOffset(d2 - d5 - d7, d9, object.getHpos());
        double d12 = d4;
        double d13 = -1.0;
        if (vPos == VPos.BASELINE) {
            double d14 = this.getMinBaselineComplement();
            d13 = this.getAreaBaselineOffset(list, marginAccessor, (Integer n2) -> dArray[0][n2], d10, bl2, d14);
        }
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            object = list.get(i2);
            Insets insets2 = HBox.getMargin((Node)object);
            this.layoutInArea((Node)object, d11, d12, dArray[0][i2], d10, d13, insets2, true, bl2, hPos, vPos);
            d11 += dArray[0][i2] + d8;
        }
    }

    private double[][] getTempArray(int n2) {
        if (this.tempArray == null) {
            this.tempArray = new double[2][n2];
        } else if (this.tempArray[0].length < n2) {
            this.tempArray = new double[2][Math.max(this.tempArray.length * 3, n2)];
        }
        return this.tempArray;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return HBox$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return HBox.getClassCssMetaData();
    }
}

