/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane$1;
import javafx.scene.layout.StackPane$StyleableProperties;
import javafx.util.Callback;

public class StackPane
extends Pane {
    private boolean biasDirty = true;
    private Orientation bias;
    private static final String MARGIN_CONSTRAINT = "stackpane-margin";
    private static final String ALIGNMENT_CONSTRAINT = "stackpane-alignment";
    private static final Callback<Node, Insets> marginAccessor = node -> StackPane.getMargin(node);
    private ObjectProperty<Pos> alignment;

    public static void setAlignment(Node node, Pos pos) {
        StackPane.setConstraint(node, ALIGNMENT_CONSTRAINT, (Object)pos);
    }

    public static Pos getAlignment(Node node) {
        return (Pos)((Object)StackPane.getConstraint(node, ALIGNMENT_CONSTRAINT));
    }

    public static void setMargin(Node node, Insets insets) {
        StackPane.setConstraint(node, MARGIN_CONSTRAINT, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)StackPane.getConstraint(node, MARGIN_CONSTRAINT);
    }

    public static void clearConstraints(Node node) {
        StackPane.setAlignment(node, null);
        StackPane.setMargin(node, null);
    }

    public StackPane() {
    }

    public StackPane(Node ... nodeArray) {
        this.getChildren().addAll((Node[])nodeArray);
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new StackPane$1(this, Pos.CENTER);
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        if (this.alignment == null) {
            return Pos.CENTER;
        }
        return (Pos)((Object)this.alignment.get());
    }

    private Pos getAlignmentInternal() {
        Pos pos = this.getAlignment();
        if (pos == null) {
            return Pos.CENTER;
        }
        return pos;
    }

    @Override
    public Orientation getContentBias() {
        if (this.biasDirty) {
            this.bias = null;
            Object object = this.getManagedChildren();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (Node)object.next();
                if ((object2 = object2.getContentBias()) == null) continue;
                this.bias = object2;
                if (object2 != Orientation.HORIZONTAL) continue;
            }
            this.biasDirty = false;
        }
        return this.bias;
    }

    @Override
    protected double computeMinWidth(double d2) {
        List<Node> list = this.getManagedChildren();
        return this.getInsets().getLeft() + this.computeMaxMinAreaWidth(list, marginAccessor, d2, true) + this.getInsets().getRight();
    }

    @Override
    protected double computeMinHeight(double d2) {
        List<Node> list = this.getManagedChildren();
        return this.getInsets().getTop() + this.computeMaxMinAreaHeight(list, marginAccessor, this.getAlignmentInternal().getVpos(), d2) + this.getInsets().getBottom();
    }

    @Override
    protected double computePrefWidth(double d2) {
        List<Node> list = this.getManagedChildren();
        Insets insets = this.getInsets();
        return insets.getLeft() + this.computeMaxPrefAreaWidth(list, marginAccessor, d2 == -1.0 ? -1.0 : d2 - insets.getTop() - insets.getBottom(), true) + insets.getRight();
    }

    @Override
    protected double computePrefHeight(double d2) {
        List<Node> list = this.getManagedChildren();
        Insets insets = this.getInsets();
        return insets.getTop() + this.computeMaxPrefAreaHeight(list, marginAccessor, d2 == -1.0 ? -1.0 : d2 - insets.getLeft() - insets.getRight(), this.getAlignmentInternal().getVpos()) + insets.getBottom();
    }

    @Override
    public void requestLayout() {
        this.biasDirty = true;
        this.bias = null;
        super.requestLayout();
    }

    @Override
    protected void layoutChildren() {
        List<Node> list = this.getManagedChildren();
        Enum enum_ = this.getAlignmentInternal();
        HPos hPos = ((Pos)enum_).getHpos();
        enum_ = ((Pos)enum_).getVpos();
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        double d4 = this.getInsets().getTop();
        double d5 = this.getInsets().getRight();
        double d6 = this.getInsets().getLeft();
        double d7 = this.getInsets().getBottom();
        double d8 = d2 - d6 - d5;
        double d9 = d3 - d4 - d7;
        double d10 = enum_ == VPos.BASELINE ? this.getAreaBaselineOffset(list, marginAccessor, n2 -> d2, d9, true) : 0.0;
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Node node = list.get(i2);
            Pos pos = StackPane.getAlignment(node);
            this.layoutInArea(node, d6, d4, d8, d9, d10, StackPane.getMargin(node), pos != null ? pos.getHpos() : hPos, (VPos)(pos != null ? pos.getVpos() : enum_));
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StackPane$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return StackPane.getClassCssMetaData();
    }
}

