/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.paint;

import com.sun.javafx.scene.paint.GradientUtils;
import com.sun.javafx.scene.paint.GradientUtils$Parser;
import com.sun.javafx.scene.paint.GradientUtils$Point;
import com.sun.javafx.tk.Toolkit;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;

public final class LinearGradient
extends Paint {
    private double startX;
    private double startY;
    private double endX;
    private double endY;
    private boolean proportional;
    private CycleMethod cycleMethod;
    private List<Stop> stops;
    private final boolean opaque;
    private Object platformPaint;
    private int hash;

    public final double getStartX() {
        return this.startX;
    }

    public final double getStartY() {
        return this.startY;
    }

    public final double getEndX() {
        return this.endX;
    }

    public final double getEndY() {
        return this.endY;
    }

    public final boolean isProportional() {
        return this.proportional;
    }

    public final CycleMethod getCycleMethod() {
        return this.cycleMethod;
    }

    public final List<Stop> getStops() {
        return this.stops;
    }

    @Override
    public final boolean isOpaque() {
        return this.opaque;
    }

    public LinearGradient(@NamedArg(value="startX") double d2, @NamedArg(value="startY") double d3, @NamedArg(value="endX", defaultValue="1") double d4, @NamedArg(value="endY", defaultValue="1") double d5, @NamedArg(value="proportional", defaultValue="true") boolean bl2, @NamedArg(value="cycleMethod") CycleMethod cycleMethod, Stop ... stopArray) {
        this.startX = d2;
        this.startY = d3;
        this.endX = d4;
        this.endY = d5;
        this.proportional = bl2;
        this.cycleMethod = cycleMethod == null ? CycleMethod.NO_CYCLE : cycleMethod;
        this.stops = Stop.normalize(stopArray);
        this.opaque = this.determineOpacity();
    }

    public LinearGradient(@NamedArg(value="startX") double d2, @NamedArg(value="startY") double d3, @NamedArg(value="endX", defaultValue="1") double d4, @NamedArg(value="endY", defaultValue="1") double d5, @NamedArg(value="proportional", defaultValue="true") boolean bl2, @NamedArg(value="cycleMethod") CycleMethod cycleMethod, @NamedArg(value="stops") List<Stop> list) {
        this.startX = d2;
        this.startY = d3;
        this.endX = d4;
        this.endY = d5;
        this.proportional = bl2;
        this.cycleMethod = cycleMethod == null ? CycleMethod.NO_CYCLE : cycleMethod;
        this.stops = Stop.normalize(list);
        this.opaque = this.determineOpacity();
    }

    private boolean determineOpacity() {
        int n2 = this.stops.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (((Paint)this.stops.get(i2).getColor()).isOpaque()) continue;
            return false;
        }
        return true;
    }

    @Override
    final Object acc_getPlatformPaint() {
        if (this.platformPaint == null) {
            this.platformPaint = Toolkit.getToolkit().getPaint((Paint)this);
        }
        return this.platformPaint;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof LinearGradient) {
            object = (LinearGradient)object;
            if (this.startX != ((LinearGradient)object).startX || this.startY != ((LinearGradient)object).startY || this.endX != ((LinearGradient)object).endX || this.endY != ((LinearGradient)object).endY || this.proportional != ((LinearGradient)object).proportional || this.cycleMethod != ((LinearGradient)object).cycleMethod) {
                return false;
            }
            return this.stops.equals(((LinearGradient)object).stops);
        }
        return false;
    }

    public final int hashCode() {
        if (this.hash == 0) {
            long l2 = 629L + Double.doubleToLongBits(this.startX);
            l2 = 37L * l2 + Double.doubleToLongBits(this.startY);
            l2 = 37L * l2 + Double.doubleToLongBits(this.endX);
            l2 = 37L * l2 + Double.doubleToLongBits(this.endY);
            l2 = 37L * l2 + (this.proportional ? 1231L : 1237L);
            l2 = 37L * l2 + (long)this.cycleMethod.hashCode();
            for (Stop stop : this.stops) {
                l2 = 37L * l2 + (long)stop.hashCode();
            }
            long l3 = l2;
            this.hash = (int)(l3 ^ l3 >> 32);
        }
        return this.hash;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("linear-gradient(from ").append(GradientUtils.lengthToString(this.startX, this.proportional)).append(" ").append(GradientUtils.lengthToString(this.startY, this.proportional)).append(" to ").append(GradientUtils.lengthToString(this.endX, this.proportional)).append(" ").append(GradientUtils.lengthToString(this.endY, this.proportional)).append(", ");
        switch (this.cycleMethod) {
            case REFLECT: {
                stringBuilder.append("reflect, ");
                break;
            }
            case REPEAT: {
                stringBuilder.append("repeat, ");
            }
        }
        for (Stop stop : this.stops) {
            stringBuilder.append(stop).append(", ");
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.delete(stringBuilder2.length() - 2, stringBuilder.length());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static LinearGradient valueOf(String object) {
        if (object == null) {
            throw new NullPointerException("gradient must be specified");
        }
        Object object2 = "linear-gradient(";
        Object object3 = ")";
        if (((String)object).startsWith((String)object2)) {
            if (!((String)object).endsWith((String)object3)) {
                throw new IllegalArgumentException("Invalid gradient specification, must end with \"" + (String)object3 + "\"");
            }
            object = ((String)object).substring(((String)object2).length(), ((String)object).length() - ((String)object3).length());
        }
        if (((GradientUtils$Parser)(object = new GradientUtils$Parser((String)object))).getSize() < 2) {
            throw new IllegalArgumentException("Invalid gradient specification");
        }
        object2 = GradientUtils$Point.MIN;
        object3 = GradientUtils$Point.MIN;
        GradientUtils$Point gradientUtils$Point = GradientUtils$Point.MIN;
        GradientUtils$Point gradientUtils$Point2 = GradientUtils$Point.MIN;
        String[] stringArray = ((GradientUtils$Parser)object).splitCurrentToken();
        if ("from".equals(stringArray[0])) {
            GradientUtils$Parser.checkNumberOfArguments(stringArray, 5);
            object2 = ((GradientUtils$Parser)object).parsePoint(stringArray[1]);
            object3 = ((GradientUtils$Parser)object).parsePoint(stringArray[2]);
            if (!"to".equals(stringArray[3])) {
                throw new IllegalArgumentException("Invalid gradient specification, \"to\" expected");
            }
            gradientUtils$Point = ((GradientUtils$Parser)object).parsePoint(stringArray[4]);
            gradientUtils$Point2 = ((GradientUtils$Parser)object).parsePoint(stringArray[5]);
            ((GradientUtils$Parser)object).shift();
        } else if ("to".equals(stringArray[0])) {
            int n2 = 0;
            int n3 = 0;
            for (int i2 = 1; i2 < 3 && i2 < stringArray.length; ++i2) {
                if ("left".equals(stringArray[i2])) {
                    object2 = GradientUtils$Point.MAX;
                    gradientUtils$Point = GradientUtils$Point.MIN;
                    ++n2;
                    continue;
                }
                if ("right".equals(stringArray[i2])) {
                    object2 = GradientUtils$Point.MIN;
                    gradientUtils$Point = GradientUtils$Point.MAX;
                    ++n2;
                    continue;
                }
                if ("top".equals(stringArray[i2])) {
                    object3 = GradientUtils$Point.MAX;
                    gradientUtils$Point2 = GradientUtils$Point.MIN;
                    ++n3;
                    continue;
                }
                if ("bottom".equals(stringArray[i2])) {
                    object3 = GradientUtils$Point.MIN;
                    gradientUtils$Point2 = GradientUtils$Point.MAX;
                    ++n3;
                    continue;
                }
                throw new IllegalArgumentException("Invalid gradient specification, unknown value after 'to'");
            }
            if (n3 > 1) {
                throw new IllegalArgumentException("Invalid gradient specification, vertical direction set twice after 'to'");
            }
            if (n2 > 1) {
                throw new IllegalArgumentException("Invalid gradient specification, horizontal direction set twice after 'to'");
            }
            ((GradientUtils$Parser)object).shift();
        } else {
            object3 = GradientUtils$Point.MIN;
            gradientUtils$Point2 = GradientUtils$Point.MAX;
        }
        CycleMethod cycleMethod = CycleMethod.NO_CYCLE;
        String string = ((GradientUtils$Parser)object).getCurrentToken();
        if ("repeat".equals(string)) {
            cycleMethod = CycleMethod.REPEAT;
            ((GradientUtils$Parser)object).shift();
        } else if ("reflect".equals(string)) {
            cycleMethod = CycleMethod.REFLECT;
            ((GradientUtils$Parser)object).shift();
        }
        double d2 = 0.0;
        if (!((GradientUtils$Point)object2).proportional) {
            double d3 = gradientUtils$Point.value - ((GradientUtils$Point)object2).value;
            double d4 = gradientUtils$Point2.value - ((GradientUtils$Point)object3).value;
            double d5 = d3;
            double d6 = d4;
            d2 = Math.sqrt(d5 * d5 + d6 * d6);
        }
        Stop[] stopArray = ((GradientUtils$Parser)object).parseStops(((GradientUtils$Point)object2).proportional, d2);
        return new LinearGradient(((GradientUtils$Point)object2).value, ((GradientUtils$Point)object3).value, gradientUtils$Point.value, gradientUtils$Point2.value, ((GradientUtils$Point)object2).proportional, cycleMethod, stopArray);
    }
}

