/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.paint;

import com.sun.javafx.scene.paint.GradientUtils;
import com.sun.javafx.scene.paint.GradientUtils$Parser;
import com.sun.javafx.scene.paint.GradientUtils$Point;
import com.sun.javafx.tk.Toolkit;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;

public final class RadialGradient
extends Paint {
    private double focusAngle;
    private double focusDistance;
    private double centerX;
    private double centerY;
    private double radius;
    private boolean proportional;
    private CycleMethod cycleMethod;
    private List<Stop> stops;
    private final boolean opaque;
    private Object platformPaint;
    private int hash;

    public final double getFocusAngle() {
        return this.focusAngle;
    }

    public final double getFocusDistance() {
        return this.focusDistance;
    }

    public final double getCenterX() {
        return this.centerX;
    }

    public final double getCenterY() {
        return this.centerY;
    }

    public final double getRadius() {
        return this.radius;
    }

    public final boolean isProportional() {
        return this.proportional;
    }

    public final CycleMethod getCycleMethod() {
        return this.cycleMethod;
    }

    public final List<Stop> getStops() {
        return this.stops;
    }

    @Override
    public final boolean isOpaque() {
        return this.opaque;
    }

    public RadialGradient(@NamedArg(value="focusAngle") double d2, @NamedArg(value="focusDistance") double d3, @NamedArg(value="centerX") double d4, @NamedArg(value="centerY") double d5, @NamedArg(value="radius", defaultValue="1") double d6, @NamedArg(value="proportional", defaultValue="true") boolean bl2, @NamedArg(value="cycleMethod") CycleMethod cycleMethod, Stop ... stopArray) {
        this.focusAngle = d2;
        this.focusDistance = d3;
        this.centerX = d4;
        this.centerY = d5;
        this.radius = d6;
        this.proportional = bl2;
        this.cycleMethod = cycleMethod == null ? CycleMethod.NO_CYCLE : cycleMethod;
        this.stops = Stop.normalize(stopArray);
        this.opaque = this.determineOpacity();
    }

    public RadialGradient(@NamedArg(value="focusAngle") double d2, @NamedArg(value="focusDistance") double d3, @NamedArg(value="centerX") double d4, @NamedArg(value="centerY") double d5, @NamedArg(value="radius", defaultValue="1") double d6, @NamedArg(value="proportional", defaultValue="true") boolean bl2, @NamedArg(value="cycleMethod") CycleMethod cycleMethod, @NamedArg(value="stops") List<Stop> list) {
        this.focusAngle = d2;
        this.focusDistance = d3;
        this.centerX = d4;
        this.centerY = d5;
        this.radius = d6;
        this.proportional = bl2;
        this.cycleMethod = cycleMethod == null ? CycleMethod.NO_CYCLE : cycleMethod;
        this.stops = Stop.normalize(list);
        this.opaque = this.determineOpacity();
    }

    private boolean determineOpacity() {
        int n2 = this.stops.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (((Paint)this.stops.get(i2).getColor()).isOpaque()) continue;
            return false;
        }
        return true;
    }

    @Override
    final Object acc_getPlatformPaint() {
        if (this.platformPaint == null) {
            this.platformPaint = Toolkit.getToolkit().getPaint((Paint)this);
        }
        return this.platformPaint;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RadialGradient) {
            object = (RadialGradient)object;
            if (this.focusAngle != ((RadialGradient)object).focusAngle || this.focusDistance != ((RadialGradient)object).focusDistance || this.centerX != ((RadialGradient)object).centerX || this.centerY != ((RadialGradient)object).centerY || this.radius != ((RadialGradient)object).radius || this.proportional != ((RadialGradient)object).proportional || this.cycleMethod != ((RadialGradient)object).cycleMethod) {
                return false;
            }
            return this.stops.equals(((RadialGradient)object).stops);
        }
        return false;
    }

    public final int hashCode() {
        if (this.hash == 0) {
            long l2 = 629L + Double.doubleToLongBits(this.focusAngle);
            l2 = 37L * l2 + Double.doubleToLongBits(this.focusDistance);
            l2 = 37L * l2 + Double.doubleToLongBits(this.centerX);
            l2 = 37L * l2 + Double.doubleToLongBits(this.centerY);
            l2 = 37L * l2 + Double.doubleToLongBits(this.radius);
            l2 = 37L * l2 + (long)(this.proportional ? 1231 : 1237);
            l2 = 37L * l2 + (long)this.cycleMethod.hashCode();
            for (Stop stop : this.stops) {
                l2 = 37L * l2 + (long)stop.hashCode();
            }
            long l3 = l2;
            this.hash = (int)(l3 ^ l3 >> 32);
        }
        return this.hash;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("radial-gradient(focus-angle ").append(this.focusAngle).append("deg, focus-distance ").append(this.focusDistance * 100.0).append("% , center ").append(GradientUtils.lengthToString(this.centerX, this.proportional)).append(" ").append(GradientUtils.lengthToString(this.centerY, this.proportional)).append(", radius ").append(GradientUtils.lengthToString(this.radius, this.proportional)).append(", ");
        switch (this.cycleMethod) {
            case REFLECT: {
                stringBuilder.append("reflect, ");
                break;
            }
            case REPEAT: {
                stringBuilder.append("repeat, ");
            }
        }
        for (Stop stop : this.stops) {
            stringBuilder.append(stop).append(", ");
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.delete(stringBuilder2.length() - 2, stringBuilder.length());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static RadialGradient valueOf(String stopArray) {
        if (stopArray == null) {
            throw new NullPointerException("gradient must be specified");
        }
        Object object = "radial-gradient(";
        Object object2 = ")";
        if (stopArray.startsWith((String)object)) {
            if (!stopArray.endsWith((String)object2)) {
                throw new IllegalArgumentException("Invalid gradient specification, must end with \"" + (String)object2 + "\"");
            }
            stopArray = stopArray.substring(((String)object).length(), stopArray.length() - ((String)object2).length());
        }
        if ((stopArray = new GradientUtils$Parser((String)stopArray)).getSize() < 2) {
            throw new IllegalArgumentException("Invalid gradient specification");
        }
        double d2 = 0.0;
        double d3 = 0.0;
        Object object3 = stopArray.splitCurrentToken();
        if ("focus-angle".equals(object3[0])) {
            GradientUtils$Parser.checkNumberOfArguments(object3, 1);
            d2 = GradientUtils$Parser.parseAngle(object3[1]);
            stopArray.shift();
        }
        if ("focus-distance".equals((object3 = stopArray.splitCurrentToken())[0])) {
            GradientUtils$Parser.checkNumberOfArguments(object3, 1);
            d3 = GradientUtils$Parser.parsePercentage(object3[1]);
            stopArray.shift();
        }
        if ("center".equals((object3 = stopArray.splitCurrentToken())[0])) {
            GradientUtils$Parser.checkNumberOfArguments(object3, 2);
            object = stopArray.parsePoint(object3[1]);
            object2 = stopArray.parsePoint(object3[2]);
            stopArray.shift();
        } else {
            object = GradientUtils$Point.MIN;
            object2 = GradientUtils$Point.MIN;
        }
        object3 = stopArray.splitCurrentToken();
        if (!"radius".equals(object3[0])) {
            throw new IllegalArgumentException("Invalid gradient specification: radius must be specified");
        }
        GradientUtils$Parser.checkNumberOfArguments(object3, 1);
        object3 = stopArray.parsePoint(object3[1]);
        stopArray.shift();
        CycleMethod cycleMethod = CycleMethod.NO_CYCLE;
        String string = stopArray.getCurrentToken();
        if ("repeat".equals(string)) {
            cycleMethod = CycleMethod.REPEAT;
            stopArray.shift();
        } else if ("reflect".equals(string)) {
            cycleMethod = CycleMethod.REFLECT;
            stopArray.shift();
        }
        stopArray = stopArray.parseStops(object3.proportional, object3.value);
        return new RadialGradient(d2, d3, ((GradientUtils$Point)object).value, ((GradientUtils$Point)object2).value, object3.value, object3.proportional, cycleMethod, stopArray);
    }
}

