/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.shape.CylinderHelper;
import com.sun.javafx.scene.shape.MeshHelper;
import com.sun.javafx.sg.prism.NGCylinder;
import com.sun.javafx.sg.prism.NGNode;
import javafx.beans.property.DoubleProperty;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.Cylinder$1;
import javafx.scene.shape.Cylinder$2;
import javafx.scene.shape.Cylinder$3;
import javafx.scene.shape.Cylinder$CylinderKey;
import javafx.scene.shape.Shape3D;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Rotate;

public class Cylinder
extends Shape3D {
    static final int DEFAULT_DIVISIONS = 64;
    static final double DEFAULT_RADIUS = 1.0;
    static final double DEFAULT_HEIGHT = 2.0;
    private int divisions = 64;
    private TriangleMesh mesh;
    private DoubleProperty height;
    private DoubleProperty radius;

    public Cylinder() {
        this(1.0, 2.0, 64);
    }

    public Cylinder(double d2, double d3) {
        this(d2, d3, 64);
    }

    public Cylinder(double d2, double d3, int n2) {
        CylinderHelper.initHelper(this);
        this.divisions = n2 < 3 ? 3 : n2;
        this.setRadius(d2);
        this.setHeight(d3);
    }

    public final void setHeight(double d2) {
        this.heightProperty().set(d2);
    }

    public final double getHeight() {
        if (this.height == null) {
            return 2.0;
        }
        return this.height.get();
    }

    public final DoubleProperty heightProperty() {
        if (this.height == null) {
            Cylinder cylinder = this;
            this.height = new Cylinder$2(cylinder, cylinder, "height", 2.0);
        }
        return this.height;
    }

    public final void setRadius(double d2) {
        this.radiusProperty().set(d2);
    }

    public final double getRadius() {
        if (this.radius == null) {
            return 1.0;
        }
        return this.radius.get();
    }

    public final DoubleProperty radiusProperty() {
        if (this.radius == null) {
            Cylinder cylinder = this;
            this.radius = new Cylinder$3(cylinder, cylinder, "radius", 1.0);
        }
        return this.radius;
    }

    public int getDivisions() {
        return this.divisions;
    }

    private void doUpdatePeer() {
        if (NodeHelper.isDirty(this, DirtyBits.MESH_GEOM)) {
            NGCylinder nGCylinder = (NGCylinder)NodeHelper.getPeer(this);
            float f2 = (float)this.getHeight();
            float f3 = (float)this.getRadius();
            if (f2 < 0.0f || f3 < 0.0f) {
                nGCylinder.updateMesh(null);
                return;
            }
            if (this.key == null) {
                this.key = new Cylinder$CylinderKey(f2, f3, this.divisions);
            }
            this.mesh = this.manager.getCylinderMesh(f2, f3, this.divisions, this.key);
            this.mesh.updatePG();
            nGCylinder.updateMesh(this.mesh.getPGTriangleMesh());
        }
    }

    private NGNode doCreatePeer() {
        return new NGCylinder();
    }

    private BaseBounds doComputeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        float f2 = (float)this.getHeight();
        float f3 = (float)this.getRadius();
        if (f3 < 0.0f || f2 < 0.0f) {
            return baseBounds.makeEmpty();
        }
        BaseBounds baseBounds2 = baseBounds = baseBounds.deriveWithNewBounds(-f3, -(f2 *= 0.5f), -f3, f3, f2, f3);
        baseBounds = baseTransform.transform(baseBounds2, baseBounds2);
        return baseBounds;
    }

    private boolean doComputeContains(double d2, double d3) {
        double d4 = this.getRadius();
        double d5 = this.getHeight() * 0.5;
        return -d4 <= d2 && d2 <= d4 && -d5 <= d3 && d3 <= d5;
    }

    private boolean doComputeIntersects(PickRay pickRay, PickResultChooser pickResultChooser) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        boolean bl2 = this.divisions < 64 && this.mesh != null;
        double d7 = this.getRadius();
        Object object = pickRay.getDirectionNoClone();
        double d8 = object.x;
        double d9 = object.y;
        double d10 = object.z;
        object = pickRay.getOriginNoClone();
        double d11 = object.x;
        double d12 = object.y;
        double d13 = object.z;
        double d14 = this.getHeight();
        double d15 = d14 / 2.0;
        object = this.getCullFace();
        double d16 = d8;
        double d17 = d10;
        double d18 = d16 * d16 + d17 * d17;
        double d19 = 2.0 * (d8 * d11 + d10 * d13);
        double d20 = d11;
        double d21 = d13;
        double d22 = d7;
        double d23 = d20 * d20 + d21 * d21 - d22 * d22;
        double d24 = d19;
        double d25 = d24 * d24 - d18 * 4.0 * d23;
        double d26 = Double.POSITIVE_INFINITY;
        double d27 = pickRay.getNearClip();
        double d28 = pickRay.getFarClip();
        if (d25 >= 0.0 && (d8 != 0.0 || d10 != 0.0)) {
            double d29 = Math.sqrt(d25);
            d6 = d19 < 0.0 ? (-d19 - d29) / 2.0 : (-d19 + d29) / 2.0;
            d5 = d6 / d18;
            if (d5 > (d4 = d23 / d6)) {
                d3 = d5;
                d5 = d4;
                d4 = d3;
            }
            d3 = d12 + d5 * d9;
            if (d5 < d27 || d3 < -d15 || d3 > d15 || object == CullFace.FRONT) {
                d2 = d12 + d4 * d9;
                if (d4 >= d27 && d4 <= d28 && d2 >= -d15 && d2 <= d15 && (object != CullFace.BACK || bl2)) {
                    d26 = d4;
                }
            } else if (d5 <= d28) {
                d26 = d5;
            }
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (d26 == Double.POSITIVE_INFINITY || !bl2) {
            double d30;
            double d31;
            d6 = (-d15 - d12) / d9;
            d3 = (d15 - d12) / d9;
            boolean bl5 = false;
            if (d6 < d3) {
                d5 = d6;
                d4 = d3;
                bl5 = true;
            } else {
                d5 = d3;
                d4 = d6;
            }
            if (d5 >= d27 && d5 <= d28 && d5 < d26 && object != CullFace.FRONT) {
                d31 = d11 + d8 * d5;
                d30 = d13 + d10 * d5;
                double d32 = d31;
                double d33 = d30;
                double d34 = d7;
                if (d32 * d32 + d33 * d33 <= d34 * d34) {
                    bl4 = bl5;
                    bl3 = !bl5;
                    d26 = d5;
                }
            }
            if (d4 >= d27 && d4 <= d28 && d4 < d26 && (object != CullFace.BACK || bl2)) {
                d31 = d11 + d8 * d4;
                d30 = d13 + d10 * d4;
                double d35 = d31;
                double d36 = d30;
                double d37 = d7;
                if (d35 * d35 + d36 * d36 <= d37 * d37) {
                    bl3 = bl5;
                    bl4 = !bl5;
                    d26 = d4;
                }
            }
        }
        if (Double.isInfinite(d26) || Double.isNaN(d26)) {
            return false;
        }
        if (bl2) {
            return MeshHelper.computeIntersects(this.mesh, pickRay, pickResultChooser, this, (CullFace)((Object)object), false);
        }
        if (pickResultChooser != null && pickResultChooser.isCloser(d26)) {
            Point2D point2D;
            Point3D point3D = PickResultChooser.computePoint(pickRay, d26);
            if (bl3) {
                point2D = new Point2D(0.5 + point3D.getX() / (d7 * 2.0), 0.5 + point3D.getZ() / (d7 * 2.0));
            } else if (bl4) {
                point2D = new Point2D(0.5 + point3D.getX() / (d7 * 2.0), 0.5 - point3D.getZ() / (d7 * 2.0));
            } else {
                Point3D point3D2 = new Point3D(point3D.getX(), 0.0, point3D.getZ());
                Point3D point3D3 = point3D2.crossProduct(Rotate.Z_AXIS);
                d2 = point3D2.angle(Rotate.Z_AXIS);
                if (point3D3.getY() > 0.0) {
                    d2 = 360.0 - d2;
                }
                point2D = new Point2D(1.0 - d2 / 360.0, 0.5 + point3D.getY() / d14);
            }
            pickResultChooser.offer(this, d26, -1, point3D, point2D);
        }
        return true;
    }

    static TriangleMesh createMesh(int n2, float f2, float f3) {
        int n3;
        int n4;
        int n5;
        double d2;
        int n6;
        int n7 = (n2 << 1) + 2;
        int n8 = (n2 + 1 << 2) + 1;
        int n9 = n2 << 2;
        float f4 = 1.0f / (float)n2;
        f2 *= 0.5f;
        float[] fArray = new float[n7 * 3];
        float[] fArray2 = new float[n8 << 1];
        int[] nArray = new int[n9 * 6];
        int[] nArray2 = new int[n9];
        int n10 = 0;
        int n11 = 0;
        for (n6 = 0; n6 < n2; ++n6) {
            d2 = (double)(f4 * (float)n6 * 2.0f) * Math.PI;
            fArray[n10] = (float)(Math.sin(d2) * (double)f3);
            fArray[n10 + 2] = (float)(Math.cos(d2) * (double)f3);
            fArray[n10 + 1] = f2;
            fArray2[n11] = 1.0f - f4 * (float)n6;
            fArray2[n11 + 1] = 0.99609375f;
            n10 += 3;
            n11 += 2;
        }
        fArray2[n11] = 0.0f;
        fArray2[n11 + 1] = 0.99609375f;
        n11 += 2;
        for (n6 = 0; n6 < n2; ++n6) {
            d2 = (double)(f4 * (float)n6 * 2.0f) * Math.PI;
            fArray[n10] = (float)(Math.sin(d2) * (double)f3);
            fArray[n10 + 2] = (float)(Math.cos(d2) * (double)f3);
            fArray[n10 + 1] = -f2;
            fArray2[n11] = 1.0f - f4 * (float)n6;
            fArray2[n11 + 1] = 0.00390625f;
            n10 += 3;
            n11 += 2;
        }
        fArray2[n11] = 0.0f;
        fArray2[n11 + 1] = 0.00390625f;
        n11 += 2;
        fArray[n10] = 0.0f;
        fArray[n10 + 1] = f2;
        fArray[n10 + 2] = 0.0f;
        fArray[n10 + 3] = 0.0f;
        fArray[n10 + 4] = -f2;
        fArray[n10 + 5] = 0.0f;
        for (n6 = 0; n6 <= n2; ++n6) {
            d2 = n6 < n2 ? (double)(f4 * (float)n6 * 2.0f) * Math.PI : 0.0;
            fArray2[n11] = (float)(Math.sin(d2) * 0.5) + 0.5f;
            fArray2[n11 + 1] = (float)(Math.cos(d2) * 0.5) + 0.5f;
            n11 += 2;
        }
        for (n6 = 0; n6 <= n2; ++n6) {
            d2 = n6 < n2 ? (double)(f4 * (float)n6 * 2.0f) * Math.PI : 0.0;
            fArray2[n11] = 0.5f + (float)(Math.sin(d2) * 0.5);
            fArray2[n11 + 1] = 0.5f - (float)(Math.cos(d2) * 0.5);
            n11 += 2;
        }
        fArray2[n11] = 0.5f;
        fArray2[n11 + 1] = 0.5f;
        n6 = 0;
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = n5 + 1;
            int n12 = n5 + n2;
            int n13 = n4 + n2;
            nArray[n6] = n5;
            nArray[n6 + 1] = n5;
            nArray[n6 + 2] = n12;
            nArray[n6 + 3] = n12 + 1;
            nArray[n6 + 4] = n4 == n2 ? 0 : n4;
            nArray[n6 + 5] = n4;
            nArray[n6 += 6] = n13 % n2 == 0 ? n13 - n2 : n13;
            nArray[n6 + 1] = n13 + 1;
            nArray[n6 + 2] = n4 == n2 ? 0 : n4;
            nArray[n6 + 3] = n4;
            nArray[n6 + 4] = n12;
            nArray[n6 + 5] = n12 + 1;
            n6 += 6;
        }
        n5 = n2 + 1 << 1;
        n4 = n2 + 1 << 2;
        int n14 = n2 << 1;
        for (n3 = 0; n3 < n2; ++n3) {
            int n15 = n3 + 1;
            n10 = n5 + n3;
            n11 = n10 + 1;
            nArray[n6] = n3;
            nArray[n6 + 1] = n10;
            nArray[n6 + 2] = n15 == n2 ? 0 : n15;
            nArray[n6 + 3] = n11;
            nArray[n6 + 4] = n14;
            nArray[n6 + 5] = n4;
            n6 += 6;
        }
        n14 = (n2 << 1) + 1;
        n5 = (n2 + 1) * 3;
        for (n3 = 0; n3 < n2; ++n3) {
            int n16 = n3 + 1 + n2;
            n10 = n5 + n3;
            n11 = n10 + 1;
            nArray[n6] = n3 + n2;
            nArray[n6 + 1] = n10;
            nArray[n6 + 2] = n14;
            nArray[n6 + 3] = n4;
            nArray[n6 + 4] = n16 % n2 == 0 ? n16 - n2 : n16;
            nArray[n6 + 5] = n11;
            n6 += 6;
        }
        for (n3 = 0; n3 < n2 << 1; ++n3) {
            nArray2[n3] = 1;
        }
        for (n3 = n2 << 1; n3 < n2 << 2; ++n3) {
            nArray2[n3] = 2;
        }
        TriangleMesh triangleMesh = new TriangleMesh(true);
        triangleMesh.getPoints().setAll(fArray);
        triangleMesh.getTexCoords().setAll(fArray2);
        triangleMesh.getFaces().setAll(nArray);
        triangleMesh.getFaceSmoothingGroups().setAll(nArray2);
        return triangleMesh;
    }

    static {
        CylinderHelper.setCylinderAccessor(new Cylinder$1());
    }
}

