/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.shape.PolygonHelper;
import com.sun.javafx.scene.shape.ShapeHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGPolygon;
import com.sun.javafx.sg.prism.NGShape$Mode;
import javafx.collections.ObservableList;
import javafx.scene.shape.Polygon$1;
import javafx.scene.shape.Polygon$2;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeType;

public class Polygon
extends Shape {
    private final Path2D shape = new Path2D();
    private final ObservableList<Double> points;

    public Polygon() {
        PolygonHelper.initHelper(this);
        this.points = new Polygon$2(this);
    }

    public Polygon(double ... dArray) {
        PolygonHelper.initHelper(this);
        this.points = new Polygon$2(this);
        if (dArray != null) {
            for (double d2 : dArray) {
                this.getPoints().add(d2);
            }
        }
    }

    public final ObservableList<Double> getPoints() {
        return this.points;
    }

    private NGNode doCreatePeer() {
        return new NGPolygon();
    }

    private BaseBounds doComputeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        if (this.getMode() == NGShape$Mode.EMPTY || this.getPoints().size() <= 1) {
            return baseBounds.makeEmpty();
        }
        if (this.getPoints().size() == 2) {
            if (this.getMode() == NGShape$Mode.FILL || this.getStrokeType() == StrokeType.INSIDE) {
                return baseBounds.makeEmpty();
            }
            double d2 = this.getStrokeWidth();
            if (this.getStrokeType() == StrokeType.CENTERED) {
                d2 /= 2.0;
            }
            return this.computeBounds(baseBounds, baseTransform, d2, 0.5, (Double)this.getPoints().get(0), (Double)this.getPoints().get(1), 0.0, 0.0);
        }
        return this.computeShapeBounds(baseBounds, baseTransform, ShapeHelper.configShape(this));
    }

    private Path2D doConfigShape() {
        double d2 = (Double)this.getPoints().get(0);
        double d3 = (Double)this.getPoints().get(1);
        this.shape.reset();
        this.shape.moveTo((float)d2, (float)d3);
        int n2 = this.getPoints().size() & 0xFFFFFFFE;
        for (int i2 = 2; i2 < n2; i2 += 2) {
            d2 = (Double)this.getPoints().get(i2);
            d3 = (Double)this.getPoints().get(i2 + 1);
            this.shape.lineTo((float)d2, (float)d3);
        }
        this.shape.closePath();
        return this.shape;
    }

    private void doUpdatePeer() {
        if (NodeHelper.isDirty(this, DirtyBits.NODE_GEOMETRY)) {
            int n2 = this.getPoints().size() & 0xFFFFFFFE;
            float[] fArray = new float[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                fArray[i2] = (float)((Double)this.getPoints().get(i2)).doubleValue();
            }
            NGPolygon nGPolygon = (NGPolygon)NodeHelper.getPeer(this);
            nGPolygon.updatePolygon(fArray);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Polygon[");
        Object object = this.getId();
        if (object != null) {
            stringBuilder.append("id=").append((String)object).append(", ");
        }
        stringBuilder.append("points=").append(this.getPoints());
        stringBuilder.append(", fill=").append(this.getFill());
        object = this.getStroke();
        if (object != null) {
            stringBuilder.append(", stroke=").append(object);
            stringBuilder.append(", strokeWidth=").append(this.getStrokeWidth());
        }
        return stringBuilder.append("]").toString();
    }

    static {
        PolygonHelper.setPolygonAccessor(new Polygon$1());
    }
}

