/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.shape.Shape3D$Key;
import javafx.scene.shape.TriangleMesh;

class PredefinedMeshManager$TriangleMeshCache {
    Map<Shape3D$Key, SoftReference<TriangleMesh>> cache = new HashMap<Shape3D$Key, SoftReference<TriangleMesh>>(17, 0.75f);

    private PredefinedMeshManager$TriangleMeshCache() {
    }

    private TriangleMesh get(Shape3D$Key shape3D$Key) {
        this.cleanCache();
        if (this.cache.containsKey(shape3D$Key)) {
            return this.cache.get(shape3D$Key).get();
        }
        return null;
    }

    private void put(Shape3D$Key shape3D$Key, TriangleMesh triangleMesh) {
        this.cleanCache();
        if (triangleMesh != null) {
            this.cache.put(shape3D$Key, new SoftReference<TriangleMesh>(triangleMesh));
        }
    }

    private void cleanCache() {
        this.cache.values().removeIf(softReference -> softReference.get() == null);
    }

    private void clear() {
        this.cache.clear();
    }

    private int size() {
        this.cleanCache();
        return this.cache.size();
    }

    private void printStats(String string) {
        System.out.println(string + " size:    " + this.size());
    }

    private void invalidateMesh(Shape3D$Key shape3D$Key) {
        if (this.cache.containsKey(shape3D$Key)) {
            TriangleMesh triangleMesh = this.cache.get(shape3D$Key).get();
            if (triangleMesh != null) {
                triangleMesh.decRef();
                int n2 = triangleMesh.getRefCount();
                if (n2 == 0) {
                    this.cache.remove(shape3D$Key);
                }
                return;
            }
            this.cache.remove(shape3D$Key);
        }
    }
}

