/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import javafx.scene.shape.Box;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.PredefinedMeshManager$BoxCacheLoader;
import javafx.scene.shape.PredefinedMeshManager$CylinderCacheLoader;
import javafx.scene.shape.PredefinedMeshManager$SphereCacheLoader;
import javafx.scene.shape.PredefinedMeshManager$TriangleMeshCache;
import javafx.scene.shape.Shape3D$Key;
import javafx.scene.shape.Sphere;
import javafx.scene.shape.TriangleMesh;

final class PredefinedMeshManager {
    private static final int INITAL_CAPACITY = 17;
    private static final float LOAD_FACTOR = 0.75f;
    private static final PredefinedMeshManager INSTANCE = new PredefinedMeshManager();
    private PredefinedMeshManager$TriangleMeshCache boxCache = null;
    private PredefinedMeshManager$TriangleMeshCache sphereCache = null;
    private PredefinedMeshManager$TriangleMeshCache cylinderCache = null;

    private PredefinedMeshManager() {
    }

    static PredefinedMeshManager getInstance() {
        return INSTANCE;
    }

    final synchronized TriangleMesh getBoxMesh(float f2, float f3, float f4, Shape3D$Key shape3D$Key) {
        TriangleMesh triangleMesh;
        if (this.boxCache == null) {
            this.boxCache = PredefinedMeshManager$BoxCacheLoader.INSTANCE;
        }
        if ((triangleMesh = this.boxCache.get(shape3D$Key)) == null) {
            triangleMesh = Box.createMesh(f2, f3, f4);
            this.boxCache.put(shape3D$Key, triangleMesh);
        } else {
            triangleMesh.incRef();
        }
        return triangleMesh;
    }

    final synchronized TriangleMesh getSphereMesh(float f2, int n2, Shape3D$Key shape3D$Key) {
        TriangleMesh triangleMesh;
        if (this.sphereCache == null) {
            this.sphereCache = PredefinedMeshManager$SphereCacheLoader.INSTANCE;
        }
        if ((triangleMesh = this.sphereCache.get(shape3D$Key)) == null) {
            triangleMesh = Sphere.createMesh(n2, f2);
            this.sphereCache.put(shape3D$Key, triangleMesh);
        } else {
            triangleMesh.incRef();
        }
        return triangleMesh;
    }

    final synchronized TriangleMesh getCylinderMesh(float f2, float f3, int n2, Shape3D$Key shape3D$Key) {
        TriangleMesh triangleMesh;
        if (this.cylinderCache == null) {
            this.cylinderCache = PredefinedMeshManager$CylinderCacheLoader.INSTANCE;
        }
        if ((triangleMesh = this.cylinderCache.get(shape3D$Key)) == null) {
            triangleMesh = Cylinder.createMesh(n2, f2, f3);
            this.cylinderCache.put(shape3D$Key, triangleMesh);
        } else {
            triangleMesh.incRef();
        }
        return triangleMesh;
    }

    final synchronized void invalidateBoxMesh(Shape3D$Key shape3D$Key) {
        if (this.boxCache != null) {
            this.boxCache.invalidateMesh(shape3D$Key);
        }
    }

    final synchronized void invalidateSphereMesh(Shape3D$Key shape3D$Key) {
        if (this.sphereCache != null) {
            this.sphereCache.invalidateMesh(shape3D$Key);
        }
    }

    final synchronized void invalidateCylinderMesh(Shape3D$Key shape3D$Key) {
        if (this.cylinderCache != null) {
            this.cylinderCache.invalidateMesh(shape3D$Key);
        }
    }

    final synchronized void dispose() {
        if (this.boxCache != null) {
            this.boxCache.clear();
        }
        if (this.sphereCache != null) {
            this.sphereCache.clear();
        }
        if (this.cylinderCache != null) {
            this.cylinderCache.clear();
        }
    }

    final synchronized void printStats() {
        if (this.boxCache != null) {
            this.boxCache.printStats("BoxCache");
        }
        if (this.sphereCache != null) {
            this.sphereCache.printStats("SphereCache");
        }
        if (this.cylinderCache != null) {
            this.cylinderCache.printStats("CylinderCache");
        }
    }

    final void test_clearCaches() {
        INSTANCE.dispose();
    }

    final int test_getBoxCacheSize() {
        return PredefinedMeshManager.INSTANCE.boxCache.size();
    }

    final int test_getSphereCacheSize() {
        return PredefinedMeshManager.INSTANCE.sphereCache.size();
    }

    final int test_getCylinderCacheSize() {
        return PredefinedMeshManager.INSTANCE.cylinderCache.size();
    }
}

