/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.beans.event.AbstractNotifyListener;
import com.sun.javafx.geom.Area;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.shape.ShapeHelper;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.javafx.sg.prism.NGShape$Mode;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.Shape$1;
import javafx.scene.shape.Shape$2;
import javafx.scene.shape.Shape$3;
import javafx.scene.shape.Shape$4;
import javafx.scene.shape.Shape$5;
import javafx.scene.shape.Shape$StrokeAttributes;
import javafx.scene.shape.Shape$StyleableProperties;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public abstract class Shape
extends Node {
    private NGShape$Mode mode = NGShape$Mode.FILL;
    private ObjectProperty<Paint> fill;
    Paint old_fill;
    private ObjectProperty<Paint> stroke;
    private final AbstractNotifyListener platformImageChangeListener = new Shape$3(this);
    Paint old_stroke;
    private BooleanProperty smooth;
    private static final double MIN_STROKE_WIDTH = 0.0;
    private static final double MIN_STROKE_MITER_LIMIT = 1.0;
    private Reference<Runnable> shapeChangeListener;
    private boolean strokeAttributesDirty = true;
    private Shape$StrokeAttributes strokeAttributes;
    private static final StrokeType DEFAULT_STROKE_TYPE;
    private static final double DEFAULT_STROKE_WIDTH = 1.0;
    private static final StrokeLineJoin DEFAULT_STROKE_LINE_JOIN;
    private static final StrokeLineCap DEFAULT_STROKE_LINE_CAP;
    private static final double DEFAULT_STROKE_MITER_LIMIT = 10.0;
    private static final double DEFAULT_STROKE_DASH_OFFSET = 0.0;
    private static final float[] DEFAULT_PG_STROKE_DASH_ARRAY;

    StrokeLineJoin convertLineJoin(StrokeLineJoin strokeLineJoin) {
        return strokeLineJoin;
    }

    public final void setStrokeType(StrokeType strokeType) {
        this.strokeTypeProperty().set(strokeType);
    }

    public final StrokeType getStrokeType() {
        if (this.strokeAttributes == null) {
            return DEFAULT_STROKE_TYPE;
        }
        return this.strokeAttributes.getType();
    }

    public final ObjectProperty<StrokeType> strokeTypeProperty() {
        return this.getStrokeAttributes().typeProperty();
    }

    public final void setStrokeWidth(double d2) {
        this.strokeWidthProperty().set(d2);
    }

    public final double getStrokeWidth() {
        if (this.strokeAttributes == null) {
            return 1.0;
        }
        return this.strokeAttributes.getWidth();
    }

    public final DoubleProperty strokeWidthProperty() {
        return this.getStrokeAttributes().widthProperty();
    }

    public final void setStrokeLineJoin(StrokeLineJoin strokeLineJoin) {
        this.strokeLineJoinProperty().set(strokeLineJoin);
    }

    public final StrokeLineJoin getStrokeLineJoin() {
        if (this.strokeAttributes == null) {
            return DEFAULT_STROKE_LINE_JOIN;
        }
        return this.strokeAttributes.getLineJoin();
    }

    public final ObjectProperty<StrokeLineJoin> strokeLineJoinProperty() {
        return this.getStrokeAttributes().lineJoinProperty();
    }

    public final void setStrokeLineCap(StrokeLineCap strokeLineCap) {
        this.strokeLineCapProperty().set(strokeLineCap);
    }

    public final StrokeLineCap getStrokeLineCap() {
        if (this.strokeAttributes == null) {
            return DEFAULT_STROKE_LINE_CAP;
        }
        return this.strokeAttributes.getLineCap();
    }

    public final ObjectProperty<StrokeLineCap> strokeLineCapProperty() {
        return this.getStrokeAttributes().lineCapProperty();
    }

    public final void setStrokeMiterLimit(double d2) {
        this.strokeMiterLimitProperty().set(d2);
    }

    public final double getStrokeMiterLimit() {
        if (this.strokeAttributes == null) {
            return 10.0;
        }
        return this.strokeAttributes.getMiterLimit();
    }

    public final DoubleProperty strokeMiterLimitProperty() {
        return this.getStrokeAttributes().miterLimitProperty();
    }

    public final void setStrokeDashOffset(double d2) {
        this.strokeDashOffsetProperty().set(d2);
    }

    public final double getStrokeDashOffset() {
        if (this.strokeAttributes == null) {
            return 0.0;
        }
        return this.strokeAttributes.getDashOffset();
    }

    public final DoubleProperty strokeDashOffsetProperty() {
        return this.getStrokeAttributes().dashOffsetProperty();
    }

    public final ObservableList<Double> getStrokeDashArray() {
        return this.getStrokeAttributes().dashArrayProperty();
    }

    private NGShape$Mode computeMode() {
        if (this.getFill() != null && this.getStroke() != null) {
            return NGShape$Mode.STROKE_FILL;
        }
        if (this.getFill() != null) {
            return NGShape$Mode.FILL;
        }
        if (this.getStroke() != null) {
            return NGShape$Mode.STROKE;
        }
        return NGShape$Mode.EMPTY;
    }

    NGShape$Mode getMode() {
        return this.mode;
    }

    private void checkModeChanged() {
        NGShape$Mode nGShape$Mode = this.computeMode();
        if (this.mode != nGShape$Mode) {
            this.mode = nGShape$Mode;
            NodeHelper.markDirty(this, DirtyBits.SHAPE_MODE);
            NodeHelper.geomChanged(this);
        }
    }

    public final void setFill(Paint paint) {
        this.fillProperty().set(paint);
    }

    public final Paint getFill() {
        if (this.fill == null) {
            return Color.BLACK;
        }
        return (Paint)this.fill.get();
    }

    public final ObjectProperty<Paint> fillProperty() {
        if (this.fill == null) {
            this.fill = new Shape$2(this, Color.BLACK);
        }
        return this.fill;
    }

    public final void setStroke(Paint paint) {
        this.strokeProperty().set(paint);
    }

    public final Paint getStroke() {
        if (this.stroke == null) {
            return null;
        }
        return (Paint)this.stroke.get();
    }

    public final ObjectProperty<Paint> strokeProperty() {
        if (this.stroke == null) {
            this.stroke = new Shape$4(this);
        }
        return this.stroke;
    }

    public final void setSmooth(boolean bl2) {
        this.smoothProperty().set(bl2);
    }

    public final boolean isSmooth() {
        if (this.smooth == null) {
            return true;
        }
        return this.smooth.get();
    }

    public final BooleanProperty smoothProperty() {
        if (this.smooth == null) {
            this.smooth = new Shape$5(this, true);
        }
        return this.smooth;
    }

    private Paint doCssGetFillInitialValue() {
        return Color.BLACK;
    }

    private Paint doCssGetStrokeInitialValue() {
        return null;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Shape$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Shape.getClassCssMetaData();
    }

    private BaseBounds doComputeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        return this.computeShapeBounds(baseBounds, baseTransform, ShapeHelper.configShape(this));
    }

    private boolean doComputeContains(double d2, double d3) {
        return this.computeShapeContains(d2, d3, ShapeHelper.configShape(this));
    }

    private void updatePGShape() {
        Object object;
        NGShape nGShape = (NGShape)NodeHelper.getPeer(this);
        if (this.strokeAttributesDirty && this.getStroke() != null) {
            object = this.hasStrokeDashArray() ? Shape.toPGDashArray(this.getStrokeDashArray()) : DEFAULT_PG_STROKE_DASH_ARRAY;
            Shape shape = this;
            nGShape.setDrawStroke((float)Utils.clampMin(this.getStrokeWidth(), 0.0), this.getStrokeType(), this.getStrokeLineCap(), shape.convertLineJoin(shape.getStrokeLineJoin()), (float)Utils.clampMin(this.getStrokeMiterLimit(), 1.0), (float[])object, (float)this.getStrokeDashOffset());
            this.strokeAttributesDirty = false;
        }
        if (NodeHelper.isDirty(this, DirtyBits.SHAPE_MODE)) {
            nGShape.setMode(this.mode);
        }
        if (NodeHelper.isDirty(this, DirtyBits.SHAPE_FILL)) {
            object = this.getFill();
            nGShape.setFillPaint(object == null ? null : Toolkit.getPaintAccessor().getPlatformPaint((Paint)object));
        }
        if (NodeHelper.isDirty(this, DirtyBits.SHAPE_STROKE)) {
            object = this.getStroke();
            nGShape.setDrawPaint(object == null ? null : Toolkit.getPaintAccessor().getPlatformPaint((Paint)object));
        }
        if (NodeHelper.isDirty(this, DirtyBits.NODE_SMOOTH)) {
            nGShape.setSmooth(this.isSmooth());
        }
    }

    private void doMarkDirty(DirtyBits object) {
        object = this.shapeChangeListener != null ? this.shapeChangeListener.get() : null;
        if (object != null && NodeHelper.isDirtyEmpty(this)) {
            object.run();
        }
    }

    void setShapeChangeListener(Runnable runnable) {
        if (this.shapeChangeListener != null) {
            this.shapeChangeListener.clear();
        }
        this.shapeChangeListener = runnable != null ? new WeakReference<Runnable>(runnable) : null;
    }

    private void doUpdatePeer() {
        this.updatePGShape();
    }

    BaseBounds computeBounds(BaseBounds baseBounds, BaseTransform baseTransform, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d6 < 0.0 || d7 < 0.0) {
            return baseBounds.makeEmpty();
        }
        double d8 = d4;
        double d9 = d5;
        double d10 = d6;
        double d11 = d7;
        double d12 = d3;
        if (baseTransform.isTranslateOrIdentity()) {
            d10 += d8;
            d11 += d9;
            if (baseTransform.getType() == 1) {
                double d13 = baseTransform.getMxt();
                double d14 = baseTransform.getMyt();
                d8 += d13;
                d9 += d14;
                d10 += d13;
                d11 += d14;
            }
            d12 += d2;
        } else {
            d8 -= d2;
            d9 -= d2;
            d10 += d2 * 2.0;
            d11 += d2 * 2.0;
            double d15 = baseTransform.getMxx();
            double d16 = baseTransform.getMxy();
            double d17 = baseTransform.getMyx();
            double d18 = baseTransform.getMyy();
            double d19 = d8 * d15 + d9 * d16 + baseTransform.getMxt();
            double d20 = d8 * d17 + d9 * d18 + baseTransform.getMyt();
            d8 = Math.min(Math.min(0.0, d15 *= d10), Math.min(d16 *= d11, d15 + d16)) + d19;
            d9 = Math.min(Math.min(0.0, d17 *= d10), Math.min(d18 *= d11, d17 + d18)) + d20;
            d10 = Math.max(Math.max(0.0, d15), Math.max(d16, d15 + d16)) + d19;
            d11 = Math.max(Math.max(0.0, d17), Math.max(d18, d17 + d18)) + d20;
        }
        baseBounds = baseBounds.deriveWithNewBounds((float)(d8 -= d12), (float)(d9 -= d12), 0.0f, (float)(d10 += d12), (float)(d11 += d12), 0.0f);
        return baseBounds;
    }

    BaseBounds computeShapeBounds(BaseBounds baseBounds, BaseTransform baseTransform, com.sun.javafx.geom.Shape shape) {
        if (this.mode == NGShape$Mode.EMPTY) {
            return baseBounds.makeEmpty();
        }
        float[] fArray = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
        boolean bl2 = this.mode != NGShape$Mode.STROKE;
        boolean bl3 = this.mode != NGShape$Mode.FILL;
        if (bl3 && this.getStrokeType() == StrokeType.INSIDE) {
            bl2 = true;
            bl3 = false;
        }
        if (bl3) {
            StrokeType strokeType = this.getStrokeType();
            double d2 = Utils.clampMin(this.getStrokeWidth(), 0.0);
            StrokeLineCap strokeLineCap = this.getStrokeLineCap();
            Shape shape2 = this;
            StrokeLineJoin strokeLineJoin = shape2.convertLineJoin(shape2.getStrokeLineJoin());
            float f2 = (float)Utils.clampMin(this.getStrokeMiterLimit(), 1.0);
            Toolkit.getToolkit().accumulateStrokeBounds(shape, fArray, strokeType, d2, strokeLineCap, strokeLineJoin, f2, baseTransform);
            fArray[0] = (float)((double)fArray[0] - 0.5);
            fArray[1] = (float)((double)fArray[1] - 0.5);
            fArray[2] = (float)((double)fArray[2] + 0.5);
            fArray[3] = (float)((double)fArray[3] + 0.5);
        } else if (bl2) {
            com.sun.javafx.geom.Shape.accumulate(fArray, shape, baseTransform);
        }
        if (fArray[2] < fArray[0] || fArray[3] < fArray[1]) {
            return baseBounds.makeEmpty();
        }
        baseBounds = baseBounds.deriveWithNewBounds(fArray[0], fArray[1], 0.0f, fArray[2], fArray[3], 0.0f);
        return baseBounds;
    }

    boolean computeShapeContains(double d2, double d3, com.sun.javafx.geom.Shape shape) {
        if (this.mode == NGShape$Mode.EMPTY) {
            return false;
        }
        boolean bl2 = this.mode != NGShape$Mode.STROKE;
        boolean bl3 = this.mode != NGShape$Mode.FILL;
        if (bl3 && bl2 && this.getStrokeType() == StrokeType.INSIDE) {
            bl3 = false;
        }
        if (bl2 && shape.contains((float)d2, (float)d3)) {
            return true;
        }
        if (bl3) {
            StrokeType strokeType = this.getStrokeType();
            double d4 = Utils.clampMin(this.getStrokeWidth(), 0.0);
            StrokeLineCap strokeLineCap = this.getStrokeLineCap();
            Shape shape2 = this;
            StrokeLineJoin strokeLineJoin = shape2.convertLineJoin(shape2.getStrokeLineJoin());
            float f2 = (float)Utils.clampMin(this.getStrokeMiterLimit(), 1.0);
            return Toolkit.getToolkit().strokeContains(shape, d2, d3, strokeType, d4, strokeLineCap, strokeLineJoin, f2);
        }
        return false;
    }

    private Shape$StrokeAttributes getStrokeAttributes() {
        if (this.strokeAttributes == null) {
            this.strokeAttributes = new Shape$StrokeAttributes(this);
        }
        return this.strokeAttributes;
    }

    private boolean hasStrokeDashArray() {
        return this.strokeAttributes != null && this.strokeAttributes.hasDashArray();
    }

    private static float[] toPGDashArray(List<Double> list) {
        int n2 = list.size();
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = list.get(i2).floatValue();
        }
        return fArray;
    }

    public static Shape union(Shape object, Shape shape) {
        object = ((Shape)object).getTransformedArea();
        ((Area)object).add(shape.getTransformedArea());
        return Shape.createFromGeomShape((com.sun.javafx.geom.Shape)object);
    }

    public static Shape subtract(Shape object, Shape shape) {
        object = ((Shape)object).getTransformedArea();
        ((Area)object).subtract(shape.getTransformedArea());
        return Shape.createFromGeomShape((com.sun.javafx.geom.Shape)object);
    }

    public static Shape intersect(Shape object, Shape shape) {
        object = ((Shape)object).getTransformedArea();
        ((Area)object).intersect(shape.getTransformedArea());
        return Shape.createFromGeomShape((com.sun.javafx.geom.Shape)object);
    }

    private Area getTransformedArea() {
        Shape shape = this;
        return shape.getTransformedArea(Shape.calculateNodeToSceneTransform(shape));
    }

    private Area getTransformedArea(BaseTransform baseTransform) {
        if (this.mode == NGShape$Mode.EMPTY) {
            return new Area();
        }
        com.sun.javafx.geom.Shape shape = ShapeHelper.configShape(this);
        if (this.mode == NGShape$Mode.FILL || this.mode == NGShape$Mode.STROKE_FILL && this.getStrokeType() == StrokeType.INSIDE) {
            return Shape.createTransformedArea(shape, baseTransform);
        }
        Object object = this.getStrokeType();
        double d2 = Utils.clampMin(this.getStrokeWidth(), 0.0);
        StrokeLineCap strokeLineCap = this.getStrokeLineCap();
        Shape shape2 = this;
        StrokeLineJoin strokeLineJoin = shape2.convertLineJoin(shape2.getStrokeLineJoin());
        float f2 = (float)Utils.clampMin(this.getStrokeMiterLimit(), 1.0);
        float[] fArray = this.hasStrokeDashArray() ? Shape.toPGDashArray(this.getStrokeDashArray()) : DEFAULT_PG_STROKE_DASH_ARRAY;
        object = Toolkit.getToolkit().createStrokedShape(shape, (StrokeType)((Object)object), d2, strokeLineCap, strokeLineJoin, f2, fArray, (float)this.getStrokeDashOffset());
        if (this.mode == NGShape$Mode.STROKE) {
            return Shape.createTransformedArea((com.sun.javafx.geom.Shape)object, baseTransform);
        }
        shape = new Area(shape);
        ((Area)shape).add(new Area((com.sun.javafx.geom.Shape)object));
        return Shape.createTransformedArea(shape, baseTransform);
    }

    private static BaseTransform calculateNodeToSceneTransform(Node node) {
        Affine3D affine3D = new Affine3D();
        do {
            affine3D.preConcatenate(NodeHelper.getLeafTransform(node));
        } while ((node = node.getParent()) != null);
        return affine3D;
    }

    private static Area createTransformedArea(com.sun.javafx.geom.Shape shape, BaseTransform baseTransform) {
        if (baseTransform.isIdentity()) {
            return new Area(shape);
        }
        return new Area(shape.getPathIterator(baseTransform));
    }

    private static Path createFromGeomShape(com.sun.javafx.geom.Shape object) {
        Path path = new Path();
        ObservableList<PathElement> observableList = path.getElements();
        object = ((com.sun.javafx.geom.Shape)object).getPathIterator(null);
        float[] fArray = new float[6];
        while (!object.isDone()) {
            int n2 = object.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    observableList.add(new MoveTo(fArray[0], fArray[1]));
                    break;
                }
                case 1: {
                    observableList.add(new LineTo(fArray[0], fArray[1]));
                    break;
                }
                case 2: {
                    observableList.add(new QuadCurveTo(fArray[0], fArray[1], fArray[2], fArray[3]));
                    break;
                }
                case 3: {
                    observableList.add(new CubicCurveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]));
                    break;
                }
                case 4: {
                    observableList.add(new ClosePath());
                }
            }
            object.next();
        }
        path.setFillRule(object.getWindingRule() == 0 ? FillRule.EVEN_ODD : FillRule.NON_ZERO);
        path.setFill(Color.BLACK);
        path.setStroke(null);
        return path;
    }

    static {
        ShapeHelper.setShapeAccessor(new Shape$1());
        DEFAULT_STROKE_TYPE = StrokeType.CENTERED;
        DEFAULT_STROKE_LINE_JOIN = StrokeLineJoin.MITER;
        DEFAULT_STROKE_LINE_CAP = StrokeLineCap.SQUARE;
        DEFAULT_PG_STROKE_DASH_ARRAY = new float[0];
    }
}

