/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.text;

import com.sun.javafx.scene.text.FontHelper;
import com.sun.javafx.tk.Toolkit;
import java.io.File;
import java.io.FilePermission;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.scene.text.Font$1;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public final class Font {
    private static final String DEFAULT_FAMILY = "System";
    private static final String DEFAULT_FULLNAME = "System Regular";
    private static float defaultSystemFontSize;
    private static Font DEFAULT;
    private String name;
    private String family;
    private String style;
    private double size;
    private int hash = 0;
    private Object nativeFont;

    private static float getDefaultSystemFontSize() {
        if (defaultSystemFontSize == -1.0f) {
            defaultSystemFontSize = Toolkit.getToolkit().getFontLoader().getSystemFontSize();
        }
        return defaultSystemFontSize;
    }

    public static synchronized Font getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new Font(DEFAULT_FULLNAME, Font.getDefaultSystemFontSize());
        }
        return DEFAULT;
    }

    public static List<String> getFamilies() {
        return Toolkit.getToolkit().getFontLoader().getFamilies();
    }

    public static List<String> getFontNames() {
        return Toolkit.getToolkit().getFontLoader().getFontNames();
    }

    public static List<String> getFontNames(String string) {
        return Toolkit.getToolkit().getFontLoader().getFontNames(string);
    }

    public static Font font(String string, FontWeight fontWeight, FontPosture fontPosture, double d2) {
        string = string == null || "".equals(string) ? DEFAULT_FAMILY : string;
        double d3 = d2 < 0.0 ? (double)Font.getDefaultSystemFontSize() : d2;
        return Toolkit.getToolkit().getFontLoader().font(string, fontWeight, fontPosture, (float)d3);
    }

    public static Font font(String string, FontWeight fontWeight, double d2) {
        return Font.font(string, fontWeight, null, d2);
    }

    public static Font font(String string, FontPosture fontPosture, double d2) {
        return Font.font(string, null, fontPosture, d2);
    }

    public static Font font(String string, double d2) {
        return Font.font(string, null, null, d2);
    }

    public static Font font(String string) {
        return Font.font(string, null, null, -1.0);
    }

    public static Font font(double d2) {
        return Font.font(null, null, null, d2);
    }

    public final String getName() {
        return this.name;
    }

    public final String getFamily() {
        return this.family;
    }

    public final String getStyle() {
        return this.style;
    }

    public final double getSize() {
        return this.size;
    }

    public Font(@NamedArg(value="size") double d2) {
        this(null, d2);
    }

    public Font(@NamedArg(value="name") String string, @NamedArg(value="size") double d2) {
        this.name = string;
        this.size = d2;
        if (string == null || "".equals(string)) {
            this.name = DEFAULT_FULLNAME;
        }
        if (d2 < 0.0) {
            this.size = Font.getDefaultSystemFontSize();
        }
        Toolkit.getToolkit().getFontLoader().loadFont(this);
    }

    private Font(Object object, String string, String string2, String string3, double d2) {
        this.nativeFont = object;
        this.family = string;
        this.name = string2;
        this.style = string3;
        this.size = d2;
    }

    public static Font loadFont(String fontArray, double d2) {
        if ((fontArray = Font.loadFontInternal((String)fontArray, d2, false)) == null) {
            return null;
        }
        return fontArray[0];
    }

    public static Font[] loadFonts(String string, double d2) {
        return Font.loadFontInternal(string, d2, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Font[] loadFontInternal(String fontArray, double d2, boolean bl2) {
        try {
            fontArray = new URL((String)fontArray);
        }
        catch (Exception exception) {
            return null;
        }
        if (d2 <= 0.0) {
            d2 = Font.getDefaultSystemFontSize();
        }
        if (((URL)fontArray).getProtocol().equals("file")) {
            fontArray = ((URL)fontArray).getFile();
            fontArray = new File((String)fontArray).getPath();
            try {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager == null) return Toolkit.getToolkit().getFontLoader().loadFont((String)fontArray, d2, bl2);
                FilePermission filePermission = new FilePermission((String)fontArray, "read");
                securityManager.checkPermission(filePermission);
                return Toolkit.getToolkit().getFontLoader().loadFont((String)fontArray, d2, bl2);
            }
            catch (Exception exception) {
                return null;
            }
        }
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = ((URL)fontArray).openConnection();
            inputStream = uRLConnection.getInputStream();
            fontArray = Toolkit.getToolkit().getFontLoader().loadFont(inputStream, d2, bl2);
        }
        catch (Exception exception) {
            try {
                if (inputStream == null) return null;
                inputStream.close();
                return null;
            }
            catch (Exception exception2) {}
            return null;
        }
        catch (Throwable throwable) {
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (inputStream == null) return fontArray;
            inputStream.close();
            return fontArray;
        }
        catch (Exception exception) {
            return fontArray;
        }
    }

    public static Font loadFont(InputStream fontArray, double d2) {
        if (d2 <= 0.0) {
            d2 = Font.getDefaultSystemFontSize();
        }
        if ((fontArray = Toolkit.getToolkit().getFontLoader().loadFont((InputStream)fontArray, d2, false)) == null) {
            return null;
        }
        return fontArray[0];
    }

    public static Font[] loadFonts(InputStream fontArray, double d2) {
        if (d2 <= 0.0) {
            d2 = Font.getDefaultSystemFontSize();
        }
        if ((fontArray = Toolkit.getToolkit().getFontLoader().loadFont((InputStream)fontArray, d2, true)) == null) {
            return null;
        }
        return fontArray;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("Font[name=");
        stringBuilder = stringBuilder.append(this.name);
        stringBuilder = stringBuilder.append(", family=").append(this.family);
        stringBuilder = stringBuilder.append(", style=").append(this.style);
        stringBuilder = stringBuilder.append(", size=").append(this.size);
        stringBuilder = stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Font) {
            object = (Font)object;
            return (this.name == null ? ((Font)object).name == null : this.name.equals(((Font)object).name)) && this.size == ((Font)object).size;
        }
        return false;
    }

    public final int hashCode() {
        if (this.hash == 0) {
            long l2 = 629L + (long)this.name.hashCode();
            long l3 = l2 = 37L * l2 + Double.doubleToLongBits(this.size);
            this.hash = (int)(l3 ^ l3 >> 32);
        }
        return this.hash;
    }

    final Object getNativeFont() {
        return this.nativeFont;
    }

    final void setNativeFont(Object object, String string, String string2, String string3) {
        this.nativeFont = object;
        this.name = string;
        this.family = string2;
        this.style = string3;
    }

    static Font nativeFont(Object object, String string, String string2, String string3, double d2) {
        object = new Font(object, string2, string, string3, d2);
        return object;
    }

    static {
        FontHelper.setFontAccessor(new Font$1());
        defaultSystemFontSize = -1.0f;
    }
}

